/*
 * Decompiled with CFR 0.152.
 */
package com.github.clans.fab;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Handler;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.ContextThemeWrapper;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AnimationUtils;
import android.view.animation.AnticipateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.OvershootInterpolator;
import com.github.clans.fab.FloatingActionButton;
import com.github.clans.fab.Label;
import com.github.clans.fab.R;
import com.github.clans.fab.Util;

public class FloatingActionMenu
extends ViewGroup {
    private static final int ANIMATION_DURATION = 300;
    private static final float CLOSED_PLUS_ROTATION = 0.0f;
    private static final float OPENED_PLUS_ROTATION = -135.0f;
    private AnimatorSet mOpenAnimatorSet = new AnimatorSet().setDuration(300L);
    private AnimatorSet mCloseAnimatorSet = new AnimatorSet().setDuration(300L);
    private int mButtonSpacing = Util.dpToPx(this.getContext(), 0.0f);
    private FloatingActionButton mMenuButton;
    private int mMaxButtonWidth;
    private int mLabelsMargin = Util.dpToPx(this.getContext(), 0.0f);
    private int mLabelsVerticalOffset = Util.dpToPx(this.getContext(), 0.0f);
    private int mButtonsCount;
    private boolean mMenuOpened;
    private Handler mUiHandler = new Handler();
    private int mLabelsShowAnimation;
    private int mLabelsHideAnimation;
    private int mLabelsPaddingTop = Util.dpToPx(this.getContext(), 4.0f);
    private int mLabelsPaddingRight = Util.dpToPx(this.getContext(), 8.0f);
    private int mLabelsPaddingBottom = Util.dpToPx(this.getContext(), 4.0f);
    private int mLabelsPaddingLeft = Util.dpToPx(this.getContext(), 8.0f);
    private int mLabelsTextColor;
    private float mLabelsTextSize;
    private int mLabelsCornerRadius = Util.dpToPx(this.getContext(), 3.0f);
    private boolean mLabelsShowShadow;
    private int mLabelsColorNormal;
    private int mLabelsColorPressed;
    private int mLabelsColorRipple;
    private boolean mMenuShowShadow;
    private int mMenuShadowColor;
    private float mMenuShadowRadius = 4.0f;
    private float mMenuShadowXOffset = 1.0f;
    private float mMenuShadowYOffset = 3.0f;
    private int mMenuColorNormal;
    private int mMenuColorPressed;
    private int mMenuColorRipple;
    private Drawable mIcon;
    private int mAnimationDelayPerItem;
    private Interpolator mOpenInterpolator;
    private Interpolator mCloseInterpolator;
    private boolean mIsAnimated = true;
    private boolean mLabelsSingleLine;
    private int mLabelsEllipsize;
    private int mLabelsMaxLines;
    private int mMenuFabSize;
    private int mLabelsStyle;
    private OnMenuToggleListener mToggleListener;

    public FloatingActionMenu(Context context) {
        this(context, null);
    }

    public FloatingActionMenu(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public FloatingActionMenu(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        TypedArray attr2 = context.obtainStyledAttributes(attrs, R.styleable.FloatingActionMenu, 0, 0);
        this.mButtonSpacing = attr2.getDimensionPixelSize(R.styleable.FloatingActionMenu_menu_buttonSpacing, this.mButtonSpacing);
        this.mLabelsMargin = attr2.getDimensionPixelSize(R.styleable.FloatingActionMenu_menu_labels_margin, this.mLabelsMargin);
        this.mLabelsShowAnimation = attr2.getResourceId(R.styleable.FloatingActionMenu_menu_labels_showAnimation, R.anim.fab_slide_in_from_right);
        this.mLabelsHideAnimation = attr2.getResourceId(R.styleable.FloatingActionMenu_menu_labels_hideAnimation, R.anim.fab_slide_out_to_right);
        this.mLabelsPaddingTop = attr2.getDimensionPixelSize(R.styleable.FloatingActionMenu_menu_labels_paddingTop, this.mLabelsPaddingTop);
        this.mLabelsPaddingRight = attr2.getDimensionPixelSize(R.styleable.FloatingActionMenu_menu_labels_paddingRight, this.mLabelsPaddingRight);
        this.mLabelsPaddingBottom = attr2.getDimensionPixelSize(R.styleable.FloatingActionMenu_menu_labels_paddingBottom, this.mLabelsPaddingBottom);
        this.mLabelsPaddingLeft = attr2.getDimensionPixelSize(R.styleable.FloatingActionMenu_menu_labels_paddingLeft, this.mLabelsPaddingLeft);
        this.mLabelsTextColor = attr2.getColor(R.styleable.FloatingActionMenu_menu_labels_textColor, -1);
        this.mLabelsTextSize = attr2.getDimension(R.styleable.FloatingActionMenu_menu_labels_textSize, this.getResources().getDimension(R.dimen.labels_text_size));
        this.mLabelsCornerRadius = attr2.getDimensionPixelSize(R.styleable.FloatingActionMenu_menu_labels_cornerRadius, this.mLabelsCornerRadius);
        this.mLabelsShowShadow = attr2.getBoolean(R.styleable.FloatingActionMenu_menu_labels_showShadow, true);
        this.mLabelsColorNormal = attr2.getColor(R.styleable.FloatingActionMenu_menu_labels_colorNormal, -13421773);
        this.mLabelsColorPressed = attr2.getColor(R.styleable.FloatingActionMenu_menu_labels_colorPressed, -12303292);
        this.mLabelsColorRipple = attr2.getColor(R.styleable.FloatingActionMenu_menu_labels_colorRipple, 0x66FFFFFF);
        this.mMenuShowShadow = attr2.getBoolean(R.styleable.FloatingActionMenu_menu_showShadow, true);
        this.mMenuShadowColor = attr2.getColor(R.styleable.FloatingActionMenu_menu_shadowColor, 0x66000000);
        this.mMenuShadowRadius = attr2.getDimension(R.styleable.FloatingActionMenu_menu_shadowRadius, this.mMenuShadowRadius);
        this.mMenuShadowXOffset = attr2.getDimension(R.styleable.FloatingActionMenu_menu_shadowXOffset, this.mMenuShadowXOffset);
        this.mMenuShadowYOffset = attr2.getDimension(R.styleable.FloatingActionMenu_menu_shadowYOffset, this.mMenuShadowYOffset);
        this.mMenuColorNormal = attr2.getColor(R.styleable.FloatingActionMenu_menu_colorNormal, -2473162);
        this.mMenuColorPressed = attr2.getColor(R.styleable.FloatingActionMenu_menu_colorPressed, -1617853);
        this.mMenuColorRipple = attr2.getColor(R.styleable.FloatingActionMenu_menu_colorRipple, -1711276033);
        this.mAnimationDelayPerItem = attr2.getInt(R.styleable.FloatingActionMenu_menu_animationDelayPerItem, 50);
        this.mIcon = attr2.getDrawable(R.styleable.FloatingActionMenu_menu_icon);
        if (this.mIcon == null) {
            this.mIcon = this.getResources().getDrawable(R.drawable.fab_add);
        }
        this.mLabelsSingleLine = attr2.getBoolean(R.styleable.FloatingActionMenu_menu_labels_singleLine, false);
        this.mLabelsEllipsize = attr2.getInt(R.styleable.FloatingActionMenu_menu_labels_ellipsize, 0);
        this.mLabelsMaxLines = attr2.getInt(R.styleable.FloatingActionMenu_menu_labels_maxLines, -1);
        this.mMenuFabSize = attr2.getInt(R.styleable.FloatingActionMenu_menu_fab_size, 0);
        this.mLabelsStyle = attr2.getResourceId(R.styleable.FloatingActionMenu_menu_labels_style, 0);
        if (attr2.hasValue(R.styleable.FloatingActionMenu_menu_labels_padding)) {
            int padding = attr2.getDimensionPixelSize(R.styleable.FloatingActionMenu_menu_labels_padding, 0);
            this.initPadding(padding);
        }
        attr2.recycle();
        this.mOpenInterpolator = new OvershootInterpolator();
        this.mCloseInterpolator = new AnticipateInterpolator();
        this.createMenuButton();
    }

    private void initPadding(int padding) {
        this.mLabelsPaddingTop = padding;
        this.mLabelsPaddingRight = padding;
        this.mLabelsPaddingBottom = padding;
        this.mLabelsPaddingLeft = padding;
    }

    private void createMenuButton() {
        this.mMenuButton = new FloatingActionButton(this.getContext()){

            @Override
            protected Drawable getIconDrawable() {
                RotatingDrawable rotatingDrawable = new RotatingDrawable(FloatingActionMenu.this.mIcon);
                ObjectAnimator collapseAnimator = ObjectAnimator.ofFloat((Object)((Object)rotatingDrawable), (String)"rotation", (float[])new float[]{-135.0f, 0.0f});
                ObjectAnimator expandAnimator = ObjectAnimator.ofFloat((Object)((Object)rotatingDrawable), (String)"rotation", (float[])new float[]{0.0f, -135.0f});
                FloatingActionMenu.this.mOpenAnimatorSet.play((Animator)expandAnimator);
                FloatingActionMenu.this.mCloseAnimatorSet.play((Animator)collapseAnimator);
                FloatingActionMenu.this.mOpenAnimatorSet.setInterpolator((TimeInterpolator)FloatingActionMenu.this.mOpenInterpolator);
                FloatingActionMenu.this.mCloseAnimatorSet.setInterpolator((TimeInterpolator)FloatingActionMenu.this.mCloseInterpolator);
                return rotatingDrawable;
            }
        };
        this.mMenuButton.setShowShadow(this.mMenuShowShadow);
        if (this.mMenuShowShadow) {
            this.mMenuButton.setShadowRadius(this.mMenuShadowRadius);
            this.mMenuButton.setShadowXOffset(this.mMenuShadowXOffset);
            this.mMenuButton.setShadowYOffset(this.mMenuShadowYOffset);
        }
        this.mMenuButton.setColors(this.mMenuColorNormal, this.mMenuColorPressed, this.mMenuColorRipple);
        this.mMenuButton.setShadowColor(this.mMenuShadowColor);
        this.mMenuButton.setButtonSize(this.mMenuFabSize);
        this.mMenuButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FloatingActionMenu.this.toggle(FloatingActionMenu.this.mIsAnimated);
            }
        });
        this.addView((View)this.mMenuButton, super.generateDefaultLayoutParams());
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int i;
        int width = 0;
        int height = 0;
        this.mMaxButtonWidth = 0;
        int maxLabelWidth = 0;
        for (i = 0; i < this.mButtonsCount; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            this.measureChildWithMargins(child, widthMeasureSpec, 0, heightMeasureSpec, 0);
            this.mMaxButtonWidth = Math.max(this.mMaxButtonWidth, child.getMeasuredWidth());
        }
        for (i = 0; i < this.mButtonsCount; ++i) {
            int usedWidth = 0;
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            usedWidth += child.getMeasuredWidth();
            height += child.getMeasuredHeight();
            Label label = (Label)((Object)child.getTag(R.id.fab_label));
            if (label == null) continue;
            int labelOffset = (this.mMaxButtonWidth - child.getMeasuredWidth()) / 2;
            int labelUsedWidth = child.getMeasuredWidth() + label.calculateShadowWidth() + this.mLabelsMargin + labelOffset;
            this.measureChildWithMargins((View)label, widthMeasureSpec, labelUsedWidth, heightMeasureSpec, 0);
            maxLabelWidth = Math.max(maxLabelWidth, (usedWidth += label.getMeasuredWidth()) + labelOffset);
        }
        width = Math.max(this.mMaxButtonWidth, maxLabelWidth + this.mLabelsMargin);
        height += this.mButtonSpacing * (this.getChildCount() - 1);
        height = this.adjustForOvershoot(height);
        this.setMeasuredDimension(width, height);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int buttonsHorizontalCenter = r - l - this.mMaxButtonWidth / 2;
        int menuButtonTop = b - t - this.mMenuButton.getMeasuredHeight() - this.getPaddingBottom();
        int menuButtonLeft = buttonsHorizontalCenter - this.mMenuButton.getMeasuredWidth() / 2;
        this.mMenuButton.layout(menuButtonLeft, menuButtonTop, menuButtonLeft + this.mMenuButton.getMeasuredWidth(), menuButtonTop + this.mMenuButton.getMeasuredHeight());
        int nextY = menuButtonTop - this.mButtonSpacing;
        for (int i = this.mButtonsCount - 1; i >= 0; --i) {
            View label;
            FloatingActionButton child = (FloatingActionButton)this.getChildAt(i);
            if (child == this.mMenuButton || child.getVisibility() == 8) continue;
            int childX = buttonsHorizontalCenter - child.getMeasuredWidth() / 2;
            int childY = nextY - child.getMeasuredHeight();
            child.layout(childX, childY, childX + child.getMeasuredWidth(), childY + child.getMeasuredHeight());
            if (!this.mMenuOpened) {
                child.hide(false);
            }
            if ((label = (View)child.getTag(R.id.fab_label)) != null) {
                int labelsOffset = child.getMeasuredWidth() / 2 + this.mLabelsMargin;
                int labelXNearButton = buttonsHorizontalCenter - labelsOffset;
                int labelXAwayFromButton = labelXNearButton - label.getMeasuredWidth();
                int labelTop = childY - this.mLabelsVerticalOffset + (child.getMeasuredHeight() - label.getMeasuredHeight()) / 2;
                label.layout(labelXAwayFromButton, labelTop, labelXNearButton, labelTop + label.getMeasuredHeight());
                label.setVisibility(4);
            }
            nextY = childY - this.mButtonSpacing;
        }
    }

    private int adjustForOvershoot(int dimension) {
        return dimension * 12 / 10;
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.bringChildToFront((View)this.mMenuButton);
        this.mButtonsCount = this.getChildCount();
        this.createLabels();
    }

    private void createLabels() {
        ContextThemeWrapper context = new ContextThemeWrapper(this.getContext(), this.mLabelsStyle);
        for (int i = 0; i < this.mButtonsCount; ++i) {
            FloatingActionButton fab = (FloatingActionButton)this.getChildAt(i);
            String text = fab.getLabelText();
            if (fab == this.mMenuButton || TextUtils.isEmpty((CharSequence)text) || fab.getTag(R.id.fab_label) != null) continue;
            Label label = new Label((Context)context);
            label.setFab(fab);
            label.setShowAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)this.mLabelsShowAnimation));
            label.setHideAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)this.mLabelsHideAnimation));
            if (this.mLabelsStyle > 0) {
                label.setTextAppearance(this.getContext(), this.mLabelsStyle);
                label.setShowShadow(false);
                label.setUsingStyle(true);
            } else {
                label.setColors(this.mLabelsColorNormal, this.mLabelsColorPressed, this.mLabelsColorRipple);
                label.setShowShadow(this.mLabelsShowShadow);
                label.setCornerRadius(this.mLabelsCornerRadius);
                if (this.mLabelsEllipsize > 0) {
                    this.setLabelEllipsize(label);
                }
                label.setMaxLines(this.mLabelsMaxLines);
                label.updateBackground();
                label.setTextSize(0, this.mLabelsTextSize);
                label.setTextColor(this.mLabelsTextColor);
                int left = this.mLabelsPaddingLeft;
                int top = this.mLabelsPaddingTop;
                if (this.mLabelsShowShadow) {
                    left += fab.getShadowRadius() + Math.abs(fab.getShadowXOffset());
                    top += fab.getShadowRadius() + Math.abs(fab.getShadowYOffset());
                }
                label.setPadding(left, top, this.mLabelsPaddingLeft, this.mLabelsPaddingTop);
                if (this.mLabelsMaxLines < 0 || this.mLabelsSingleLine) {
                    label.setSingleLine(this.mLabelsSingleLine);
                }
            }
            label.setText(text);
            this.addView((View)label);
            fab.setTag(R.id.fab_label, (Object)label);
        }
    }

    private void setLabelEllipsize(Label label) {
        switch (this.mLabelsEllipsize) {
            case 1: {
                label.setEllipsize(TextUtils.TruncateAt.START);
                break;
            }
            case 2: {
                label.setEllipsize(TextUtils.TruncateAt.MIDDLE);
                break;
            }
            case 3: {
                label.setEllipsize(TextUtils.TruncateAt.END);
                break;
            }
            case 4: {
                label.setEllipsize(TextUtils.TruncateAt.MARQUEE);
            }
        }
    }

    public ViewGroup.MarginLayoutParams generateLayoutParams(AttributeSet attrs) {
        return new ViewGroup.MarginLayoutParams(this.getContext(), attrs);
    }

    protected ViewGroup.MarginLayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new ViewGroup.MarginLayoutParams(p);
    }

    protected ViewGroup.MarginLayoutParams generateDefaultLayoutParams() {
        return new ViewGroup.MarginLayoutParams(-2, -2);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof ViewGroup.MarginLayoutParams;
    }

    public boolean isOpened() {
        return this.mMenuOpened;
    }

    public void toggle(boolean animate) {
        if (this.isOpened()) {
            this.close(animate);
        } else {
            this.open(animate);
        }
    }

    public void open(final boolean animate) {
        if (!this.isOpened()) {
            this.mCloseAnimatorSet.cancel();
            this.mOpenAnimatorSet.start();
            this.mMenuOpened = true;
            int delay = 0;
            for (int i = this.getChildCount() - 1; i >= 0; --i) {
                View child = this.getChildAt(i);
                if (!(child instanceof FloatingActionButton) || child == this.mMenuButton || child.getVisibility() == 8) continue;
                final FloatingActionButton fab = (FloatingActionButton)child;
                this.mUiHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        fab.show(animate);
                        Label label = (Label)((Object)fab.getTag(R.id.fab_label));
                        if (label != null) {
                            label.show(animate);
                        }
                    }
                }, (long)delay);
                delay += this.mAnimationDelayPerItem;
            }
            if (this.mToggleListener != null) {
                this.mToggleListener.onMenuToggle(true);
            }
        }
    }

    public void close(final boolean animate) {
        if (this.isOpened()) {
            this.mCloseAnimatorSet.start();
            this.mOpenAnimatorSet.cancel();
            this.mMenuOpened = false;
            int delay = 0;
            for (int i = 0; i < this.getChildCount(); ++i) {
                View child = this.getChildAt(i);
                if (!(child instanceof FloatingActionButton) || child == this.mMenuButton || child.getVisibility() == 8) continue;
                final FloatingActionButton fab = (FloatingActionButton)child;
                this.mUiHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        fab.hide(animate);
                        Label label = (Label)((Object)fab.getTag(R.id.fab_label));
                        if (label != null) {
                            label.hide(animate);
                        }
                    }
                }, (long)delay);
                delay += this.mAnimationDelayPerItem;
            }
            if (this.mToggleListener != null) {
                this.mToggleListener.onMenuToggle(false);
            }
        }
    }

    public void setIconAnimationInterpolator(Interpolator interpolator) {
        this.mOpenAnimatorSet.setInterpolator((TimeInterpolator)interpolator);
        this.mCloseAnimatorSet.setInterpolator((TimeInterpolator)interpolator);
    }

    public void setIconAnimationOpenInterpolator(Interpolator openInterpolator) {
        this.mOpenAnimatorSet.setInterpolator((TimeInterpolator)openInterpolator);
    }

    public void setIconAnimationCloseInterpolator(Interpolator closeInterpolator) {
        this.mCloseAnimatorSet.setInterpolator((TimeInterpolator)closeInterpolator);
    }

    public void setAnimated(boolean animated) {
        this.mIsAnimated = animated;
        this.mOpenAnimatorSet.setDuration(animated ? 300L : 0L);
        this.mCloseAnimatorSet.setDuration(animated ? 300L : 0L);
    }

    public boolean isAnimated() {
        return this.mIsAnimated;
    }

    public void setAnimationDelayPerItem(int animationDelayPerItem) {
        this.mAnimationDelayPerItem = animationDelayPerItem;
    }

    public int getAnimationDelayPerItem() {
        return this.mAnimationDelayPerItem;
    }

    public void setOnMenuToggleListener(OnMenuToggleListener listener) {
        this.mToggleListener = listener;
    }

    private static class RotatingDrawable
    extends LayerDrawable {
        private float mRotation;

        public RotatingDrawable(Drawable drawable2) {
            super(new Drawable[]{drawable2});
        }

        public float getRotation() {
            return this.mRotation;
        }

        public void setRotation(float rotation) {
            this.mRotation = rotation;
            this.invalidateSelf();
        }

        public void draw(Canvas canvas) {
            canvas.save();
            canvas.rotate(this.mRotation, (float)this.getBounds().centerX(), (float)this.getBounds().centerY());
            super.draw(canvas);
            canvas.restore();
        }
    }

    public static interface OnMenuToggleListener {
        public void onMenuToggle(boolean var1);
    }
}

