/*
 * Decompiled with CFR 0.152.
 */
package com.github.clans.fab;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.RippleDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.StateListDrawable;
import android.graphics.drawable.shapes.OvalShape;
import android.graphics.drawable.shapes.Shape;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewOutlineProvider;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.ImageButton;
import android.widget.TextView;
import com.github.clans.fab.Label;
import com.github.clans.fab.R;
import com.github.clans.fab.Util;

public class FloatingActionButton
extends ImageButton {
    public static final int SIZE_NORMAL = 0;
    public static final int SIZE_MINI = 1;
    private int mFabSize;
    private int mColorNormal;
    private int mColorPressed;
    private int mColorRipple;
    private boolean mShowShadow;
    private int mShadowColor;
    private int mShadowRadius = Util.dpToPx(this.getContext(), 4.0f);
    private int mShadowXOffset = Util.dpToPx(this.getContext(), 1.0f);
    private int mShadowYOffset = Util.dpToPx(this.getContext(), 3.0f);
    private Drawable mIcon;
    private int mIconSize = Util.dpToPx(this.getContext(), 24.0f);
    private Animation mShowAnimation;
    private Animation mHideAnimation;
    private String mLabelText;
    private View.OnClickListener mClickListener;
    private Drawable mBackgroundDrawable;
    GestureDetector mGestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

        public boolean onDown(MotionEvent e) {
            Label label = (Label)((Object)FloatingActionButton.this.getTag(R.id.fab_label));
            if (label != null) {
                label.onActionDown();
            }
            FloatingActionButton.this.onActionDown();
            return super.onDown(e);
        }

        public boolean onSingleTapUp(MotionEvent e) {
            Label label = (Label)((Object)FloatingActionButton.this.getTag(R.id.fab_label));
            if (label != null) {
                label.onActionUp();
            }
            FloatingActionButton.this.onActionUp();
            return super.onSingleTapUp(e);
        }
    });

    public FloatingActionButton(Context context) {
        this(context, null);
    }

    public FloatingActionButton(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public FloatingActionButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    @TargetApi(value=21)
    public FloatingActionButton(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        TypedArray attr2 = context.obtainStyledAttributes(attrs, R.styleable.FloatingActionButton, 0, 0);
        this.mColorNormal = attr2.getColor(R.styleable.FloatingActionButton_fab_colorNormal, -2473162);
        this.mColorPressed = attr2.getColor(R.styleable.FloatingActionButton_fab_colorPressed, -1617853);
        this.mColorRipple = attr2.getColor(R.styleable.FloatingActionButton_fab_colorRipple, -1711276033);
        this.mShowShadow = attr2.getBoolean(R.styleable.FloatingActionButton_fab_showShadow, true);
        this.mShadowColor = attr2.getColor(R.styleable.FloatingActionButton_fab_shadowColor, 0x66000000);
        this.mShadowRadius = attr2.getDimensionPixelSize(R.styleable.FloatingActionButton_fab_shadowRadius, this.mShadowRadius);
        this.mShadowXOffset = attr2.getDimensionPixelSize(R.styleable.FloatingActionButton_fab_shadowXOffset, this.mShadowXOffset);
        this.mShadowYOffset = attr2.getDimensionPixelSize(R.styleable.FloatingActionButton_fab_shadowYOffset, this.mShadowYOffset);
        this.mFabSize = attr2.getInt(R.styleable.FloatingActionButton_fab_size, 0);
        this.mLabelText = attr2.getString(R.styleable.FloatingActionButton_fab_label);
        this.initShowAnimation(attr2);
        this.initHideAnimation(attr2);
        attr2.recycle();
        this.updateBackground();
    }

    private void initShowAnimation(TypedArray attr2) {
        int resourceId = attr2.getResourceId(R.styleable.FloatingActionButton_fab_showAnimation, R.anim.fab_scale_up);
        this.mShowAnimation = AnimationUtils.loadAnimation((Context)this.getContext(), (int)resourceId);
    }

    private void initHideAnimation(TypedArray attr2) {
        int resourceId = attr2.getResourceId(R.styleable.FloatingActionButton_fab_hideAnimation, R.anim.fab_scale_down);
        this.mHideAnimation = AnimationUtils.loadAnimation((Context)this.getContext(), (int)resourceId);
    }

    public void setElevation(float elevation) {
    }

    private int getCircleSize() {
        return this.getResources().getDimensionPixelSize(this.mFabSize == 0 ? R.dimen.fab_size_normal : R.dimen.fab_size_mini);
    }

    private int calculateMeasuredWidth() {
        return this.getCircleSize() + this.calculateShadowWidth();
    }

    private int calculateMeasuredHeight() {
        return this.getCircleSize() + this.calculateShadowHeight();
    }

    int calculateShadowWidth() {
        return this.hasShadow() ? (this.mShadowRadius + Math.abs(this.mShadowXOffset)) * 2 : 0;
    }

    int calculateShadowHeight() {
        return this.hasShadow() ? (this.mShadowRadius + Math.abs(this.mShadowYOffset)) * 2 : 0;
    }

    private float calculateCenterX() {
        return this.getMeasuredWidth() / 2;
    }

    private float calculateCenterY() {
        return this.getMeasuredHeight() / 2;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension(this.calculateMeasuredWidth(), this.calculateMeasuredHeight());
    }

    void updateBackground() {
        LayerDrawable layerDrawable = this.mShowShadow ? new LayerDrawable(new Drawable[]{new Shadow(), this.createFillDrawable(), this.getIconDrawable()}) : new LayerDrawable(new Drawable[]{this.createFillDrawable(), this.getIconDrawable()});
        int iconSize = -1;
        if (this.getIconDrawable() != null) {
            iconSize = Math.max(this.getIconDrawable().getIntrinsicWidth(), this.getIconDrawable().getIntrinsicHeight());
        }
        int iconOffset = (this.getCircleSize() - (iconSize > 0 ? iconSize : this.mIconSize)) / 2;
        int circleInsetHorizontal = this.mShowShadow ? this.mShadowRadius + Math.abs(this.mShadowXOffset) : 0;
        int circleInsetVertical = this.mShowShadow ? this.mShadowRadius + Math.abs(this.mShadowYOffset) : 0;
        layerDrawable.setLayerInset(this.mShowShadow ? 1 : 0, circleInsetHorizontal, circleInsetVertical, circleInsetHorizontal, circleInsetVertical);
        layerDrawable.setLayerInset(this.mShowShadow ? 2 : 1, circleInsetHorizontal + iconOffset, circleInsetVertical + iconOffset, circleInsetHorizontal + iconOffset, circleInsetVertical + iconOffset);
        this.setBackgroundCompat((Drawable)layerDrawable);
    }

    protected Drawable getIconDrawable() {
        if (this.mIcon != null) {
            return this.mIcon;
        }
        return new ColorDrawable(0);
    }

    @TargetApi(value=21)
    private Drawable createFillDrawable() {
        StateListDrawable drawable = new StateListDrawable();
        drawable.addState(new int[]{16842919}, this.createCircleDrawable(this.mColorPressed));
        drawable.addState(new int[0], this.createCircleDrawable(this.mColorNormal));
        if (Util.hasLollipop()) {
            RippleDrawable ripple = new RippleDrawable(new ColorStateList((int[][])new int[][]{new int[0]}, new int[]{this.mColorRipple}), (Drawable)drawable, null);
            this.setOutlineProvider(new ViewOutlineProvider(){

                public void getOutline(View view, Outline outline) {
                    outline.setOval(0, 0, view.getWidth(), view.getHeight());
                }
            });
            this.setClipToOutline(true);
            this.mBackgroundDrawable = ripple;
            return ripple;
        }
        this.mBackgroundDrawable = drawable;
        return drawable;
    }

    private Drawable createCircleDrawable(int color) {
        ShapeDrawable shapeDrawable = new ShapeDrawable((Shape)new OvalShape());
        shapeDrawable.getPaint().setColor(color);
        return shapeDrawable;
    }

    @TargetApi(value=21)
    private void setBackgroundCompat(Drawable drawable) {
        if (Util.hasJellyBean()) {
            this.setBackground(drawable);
        } else {
            this.setBackgroundDrawable(drawable);
        }
    }

    Animation getShowAnimation() {
        return this.mShowAnimation;
    }

    Animation getHideAnimation() {
        return this.mHideAnimation;
    }

    void playShowAnimation() {
        this.startAnimation(this.mShowAnimation);
    }

    void playHideAnimation() {
        this.startAnimation(this.mHideAnimation);
    }

    View.OnClickListener getOnClickListener() {
        return this.mClickListener;
    }

    TextView getLabelView() {
        return (TextView)this.getTag(R.id.fab_label);
    }

    void setColors(int colorNormal, int colorPressed, int colorRipple) {
        this.mColorNormal = colorNormal;
        this.mColorPressed = colorPressed;
        this.mColorRipple = colorRipple;
        this.updateBackground();
    }

    @TargetApi(value=21)
    void onActionDown() {
        if (this.mBackgroundDrawable instanceof StateListDrawable) {
            StateListDrawable drawable = (StateListDrawable)this.mBackgroundDrawable;
            drawable.setState(new int[]{16842919});
        } else if (Util.hasLollipop()) {
            RippleDrawable ripple = (RippleDrawable)this.mBackgroundDrawable;
            ripple.setState(new int[]{16842910, 16842919});
            ripple.setHotspot(this.calculateCenterX(), this.calculateCenterY());
            ripple.setVisible(true, true);
        }
    }

    @TargetApi(value=21)
    void onActionUp() {
        if (this.mBackgroundDrawable instanceof StateListDrawable) {
            StateListDrawable drawable = (StateListDrawable)this.mBackgroundDrawable;
            drawable.setState(new int[0]);
        } else if (Util.hasLollipop()) {
            RippleDrawable ripple = (RippleDrawable)this.mBackgroundDrawable;
            ripple.setState(new int[0]);
            ripple.setHotspot(this.calculateCenterX(), this.calculateCenterY());
            ripple.setVisible(true, true);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mClickListener == null) {
            return false;
        }
        Label label = (Label)((Object)this.getTag(R.id.fab_label));
        int action = event.getAction();
        switch (action) {
            case 1: {
                if (label == null) break;
                label.onActionUp();
            }
        }
        this.mGestureDetector.onTouchEvent(event);
        return super.onTouchEvent(event);
    }

    public void setImageDrawable(Drawable drawable) {
        if (this.mIcon != drawable) {
            this.mIcon = drawable;
            this.updateBackground();
        }
    }

    public void setImageResource(int resId) {
        Drawable drawable = this.getResources().getDrawable(resId);
        if (this.mIcon != drawable) {
            this.mIcon = drawable;
            this.updateBackground();
        }
    }

    public void setOnClickListener(View.OnClickListener l) {
        super.setOnClickListener(l);
        this.mClickListener = l;
        View label = (View)this.getTag(R.id.fab_label);
        if (label != null) {
            label.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (FloatingActionButton.this.mClickListener != null) {
                        FloatingActionButton.this.mClickListener.onClick((View)FloatingActionButton.this);
                    }
                }
            });
        }
    }

    public void setButtonSize(int size) {
        if (size != 0 && size != 1) {
            throw new IllegalArgumentException("Use @FabSize constants only!");
        }
        if (this.mFabSize != size) {
            this.mFabSize = size;
            this.updateBackground();
        }
    }

    public int getButtonSize() {
        return this.mFabSize;
    }

    public void setColorNormal(int color) {
        if (this.mColorNormal != color) {
            this.mColorNormal = color;
            this.updateBackground();
        }
    }

    public void setColorNormalResId(int colorResId) {
        this.setColorNormal(this.getResources().getColor(colorResId));
    }

    public int getColorNormal() {
        return this.mColorNormal;
    }

    public void setColorPressed(int color) {
        if (color != this.mColorPressed) {
            this.mColorPressed = color;
            this.updateBackground();
        }
    }

    public void setColorPressedResId(int colorResId) {
        this.setColorPressed(this.getResources().getColor(colorResId));
    }

    public int getColorPressed() {
        return this.mColorPressed;
    }

    public void setColorRipple(int color) {
        if (color != this.mColorRipple) {
            this.mColorRipple = color;
            this.updateBackground();
        }
    }

    public void setColorRippleResId(int colorResId) {
        this.setColorRipple(this.getResources().getColor(colorResId));
    }

    public int getColorRipple() {
        return this.mColorRipple;
    }

    public void setShowShadow(boolean show) {
        if (this.mShowShadow != show) {
            this.mShowShadow = show;
            this.updateBackground();
        }
    }

    public boolean hasShadow() {
        return this.mShowShadow;
    }

    public void setShadowRadius(int dimenResId) {
        int shadowRadius = this.getResources().getDimensionPixelSize(dimenResId);
        if (this.mShadowRadius != shadowRadius) {
            this.mShadowRadius = shadowRadius;
            this.requestLayout();
            this.updateBackground();
        }
    }

    public void setShadowRadius(float shadowRadiusDp) {
        this.mShadowRadius = Util.dpToPx(this.getContext(), shadowRadiusDp);
        this.requestLayout();
        this.updateBackground();
    }

    public int getShadowRadius() {
        return this.mShadowRadius;
    }

    public void setShadowXOffset(int dimenResId) {
        int shadowXOffset = this.getResources().getDimensionPixelSize(dimenResId);
        if (this.mShadowXOffset != shadowXOffset) {
            this.mShadowXOffset = shadowXOffset;
            this.requestLayout();
            this.updateBackground();
        }
    }

    public void setShadowXOffset(float shadowXOffsetDp) {
        this.mShadowXOffset = Util.dpToPx(this.getContext(), shadowXOffsetDp);
        this.requestLayout();
        this.updateBackground();
    }

    public int getShadowXOffset() {
        return this.mShadowXOffset;
    }

    public void setShadowYOffset(int dimenResId) {
        int shadowYOffset = this.getResources().getDimensionPixelSize(dimenResId);
        if (this.mShadowYOffset != shadowYOffset) {
            this.mShadowYOffset = shadowYOffset;
            this.requestLayout();
            this.updateBackground();
        }
    }

    public void setShadowYOffset(float shadowYOffsetDp) {
        this.mShadowYOffset = Util.dpToPx(this.getContext(), shadowYOffsetDp);
        this.requestLayout();
        this.updateBackground();
    }

    public int getShadowYOffset() {
        return this.mShadowYOffset;
    }

    public void setShadowColorResource(int colorResId) {
        int shadowColor = this.getResources().getColor(colorResId);
        if (this.mShadowColor != shadowColor) {
            this.mShadowColor = shadowColor;
            this.updateBackground();
        }
    }

    public void setShadowColor(int color) {
        if (this.mShadowColor != color) {
            this.mShadowColor = color;
            this.updateBackground();
        }
    }

    public int getShadowColor() {
        return this.mShadowColor;
    }

    public boolean isHidden() {
        return this.getVisibility() == 4;
    }

    public void show(boolean animate) {
        if (this.isHidden()) {
            if (animate) {
                this.playShowAnimation();
            }
            this.setVisibility(0);
        }
    }

    public void hide(boolean animate) {
        if (!this.isHidden()) {
            if (animate) {
                this.playHideAnimation();
            }
            this.setVisibility(4);
        }
    }

    public void toggle(boolean animate) {
        if (this.isHidden()) {
            this.show(animate);
        } else {
            this.hide(animate);
        }
    }

    public void setLabelText(String text) {
        this.mLabelText = text;
        TextView labelView = this.getLabelView();
        if (labelView != null) {
            labelView.setText((CharSequence)text);
        }
    }

    public String getLabelText() {
        return this.mLabelText;
    }

    public void setShowAnimation(Animation showAnimation) {
        this.mShowAnimation = showAnimation;
    }

    public void setHideAnimation(Animation hideAnimation) {
        this.mHideAnimation = hideAnimation;
    }

    public void setLabelVisibility(int visibility) {
        TextView labelView = this.getLabelView();
        if (labelView != null) {
            labelView.setVisibility(visibility);
        }
    }

    public int getLabelVisibility() {
        TextView labelView = this.getLabelView();
        if (labelView != null) {
            return labelView.getVisibility();
        }
        return -1;
    }

    private class Shadow
    extends Drawable {
        private Paint mPaint = new Paint(1);
        private float mRadius;

        private Shadow() {
            this.init();
        }

        private void init() {
            FloatingActionButton.this.setLayerType(1, null);
            this.mPaint.setStyle(Paint.Style.FILL);
            this.mPaint.setColor(FloatingActionButton.this.mColorNormal);
            if (!FloatingActionButton.this.isInEditMode()) {
                this.mPaint.setShadowLayer((float)FloatingActionButton.this.mShadowRadius, (float)FloatingActionButton.this.mShadowXOffset, (float)FloatingActionButton.this.mShadowYOffset, FloatingActionButton.this.mShadowColor);
            }
            this.mRadius = FloatingActionButton.this.getCircleSize() / 2 - Util.dpToPx(FloatingActionButton.this.getContext(), 1.0f);
        }

        public void draw(Canvas canvas) {
            canvas.drawCircle(FloatingActionButton.this.calculateCenterX(), FloatingActionButton.this.calculateCenterY(), this.mRadius, this.mPaint);
        }

        public void setAlpha(int alpha) {
        }

        public void setColorFilter(ColorFilter cf) {
        }

        public int getOpacity() {
            return 0;
        }
    }
}

