/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.util;

import au.com.bytecode.opencsv.CSVReader;
import com.google.common.collect.Lists;
import com.google.visualization.datasource.base.DataSourceException;
import com.google.visualization.datasource.base.ReasonType;
import com.google.visualization.datasource.base.TypeMismatchException;
import com.google.visualization.datasource.datatable.ColumnDescription;
import com.google.visualization.datasource.datatable.DataTable;
import com.google.visualization.datasource.datatable.TableRow;
import com.google.visualization.datasource.datatable.ValueFormatter;
import com.google.visualization.datasource.datatable.value.Value;
import com.google.visualization.datasource.datatable.value.ValueType;
import com.google.visualization.datasource.util.CsvDataSourceException;
import com.ibm.icu.util.ULocale;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CsvDataSourceHelper {
    private CsvDataSourceHelper() {
    }

    public static DataTable read(Reader reader, List<ColumnDescription> columnDescriptions, Boolean headerRow) throws IOException, CsvDataSourceException {
        return CsvDataSourceHelper.read(reader, columnDescriptions, headerRow, null);
    }

    public static DataTable read(Reader reader, List<ColumnDescription> columnDescriptions, Boolean headerRow, ULocale locale) throws IOException, CsvDataSourceException {
        String[] line;
        DataTable dataTable = new DataTable();
        if (reader == null) {
            return dataTable;
        }
        CSVReader csvReader = new CSVReader(reader);
        Map<ValueType, ValueFormatter> defaultFormatters = ValueFormatter.createDefaultFormatters(locale);
        boolean firstLine = true;
        while ((line = csvReader.readNext()) != null) {
            int i;
            if (line.length == 1 && line[0].equals("")) continue;
            if (columnDescriptions != null && line.length != columnDescriptions.size()) {
                throw new CsvDataSourceException(ReasonType.INTERNAL_ERROR, "Wrong number of columns in the data.");
            }
            if (firstLine) {
                if (columnDescriptions == null) {
                    columnDescriptions = Lists.newArrayList();
                }
                ArrayList<ColumnDescription> tempColumnDescriptions = new ArrayList<ColumnDescription>();
                for (i = 0; i < line.length; ++i) {
                    ColumnDescription tempColumnDescription = columnDescriptions.isEmpty() || columnDescriptions.get(i) == null ? null : (ColumnDescription)columnDescriptions.get(i);
                    String id = tempColumnDescription == null || tempColumnDescription.getId() == null ? "Col" + i : tempColumnDescription.getId();
                    ValueType type = tempColumnDescription == null || tempColumnDescription.getType() == null ? ValueType.TEXT : tempColumnDescription.getType();
                    String label = tempColumnDescription == null || tempColumnDescription.getLabel() == null ? "Column" + i : tempColumnDescription.getLabel();
                    String pattern = tempColumnDescription == null || tempColumnDescription.getPattern() == null ? "" : tempColumnDescription.getPattern();
                    tempColumnDescription = new ColumnDescription(id, type, label);
                    tempColumnDescription.setPattern(pattern);
                    tempColumnDescriptions.add(tempColumnDescription);
                }
                if (headerRow.booleanValue()) {
                    for (i = 0; i < line.length; ++i) {
                        String string = line[i];
                        if (string == null) {
                            ((ColumnDescription)tempColumnDescriptions.get(i)).setLabel("");
                            continue;
                        }
                        ((ColumnDescription)tempColumnDescriptions.get(i)).setLabel(line[i].trim());
                    }
                }
                columnDescriptions = tempColumnDescriptions;
                dataTable = new DataTable();
                dataTable.addColumns(columnDescriptions);
            }
            if (!firstLine || !headerRow.booleanValue()) {
                TableRow tableRow = new TableRow();
                for (i = 0; i < line.length; ++i) {
                    String pattern;
                    ColumnDescription columnDescription = (ColumnDescription)columnDescriptions.get(i);
                    ValueType valueType = columnDescription.getType();
                    String string = line[i];
                    if (string != null) {
                        string = string.trim();
                    }
                    ValueFormatter valueFormatter = (pattern = columnDescription.getPattern()) == null || pattern.equals("") ? defaultFormatters.get((Object)valueType) : ValueFormatter.createFromPattern(valueType, pattern, locale);
                    Value value = valueFormatter.parse(string);
                    tableRow.addCell(value);
                }
                try {
                    dataTable.addRow(tableRow);
                }
                catch (TypeMismatchException typeMismatchException) {
                    // empty catch block
                }
            }
            firstLine = false;
        }
        return dataTable;
    }

    public static Reader getCsvUrlReader(String url) throws DataSourceException {
        BufferedReader reader;
        try {
            reader = new BufferedReader(new InputStreamReader(new URL(url).openStream(), "UTF-8"));
        }
        catch (MalformedURLException e) {
            throw new DataSourceException(ReasonType.INVALID_REQUEST, "url is malformed: " + url);
        }
        catch (IOException e) {
            throw new DataSourceException(ReasonType.INVALID_REQUEST, "Couldn't read csv file from url: " + url);
        }
        return reader;
    }

    public static Reader getCsvFileReader(String file) throws DataSourceException {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
        }
        catch (FileNotFoundException e) {
            throw new DataSourceException(ReasonType.INVALID_REQUEST, "Couldn't read csv file from: " + file);
        }
        return reader;
    }
}

