/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.render;

import com.google.visualization.datasource.base.ReasonType;
import com.google.visualization.datasource.base.ResponseStatus;
import com.google.visualization.datasource.base.StatusType;
import com.google.visualization.datasource.base.Warning;
import com.google.visualization.datasource.datatable.ColumnDescription;
import com.google.visualization.datasource.datatable.DataTable;
import com.google.visualization.datasource.datatable.TableCell;
import com.google.visualization.datasource.datatable.TableRow;
import com.google.visualization.datasource.datatable.ValueFormatter;
import com.google.visualization.datasource.datatable.value.BooleanValue;
import com.google.visualization.datasource.datatable.value.ValueType;
import com.google.visualization.datasource.render.EscapeUtil;
import com.ibm.icu.util.ULocale;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class HtmlRenderer {
    private static final Log log = LogFactory.getLog((String)"HtmlRenderer");
    private static final Pattern DETAILED_MESSAGE_A_TAG_REGEXP = Pattern.compile("([^<]*<a(( )*target=\"_blank\")*(( )*target='_blank')*(( )*href=\"[^\"]*\")*(( )*href='[^']*')*>[^<]*</a>)+[^<]*");
    private static final Pattern BAD_JAVASCRIPT_REGEXP = Pattern.compile("javascript(( )*):");

    private HtmlRenderer() {
    }

    public static CharSequence renderDataTable(DataTable dataTable, ULocale locale) {
        Document document = HtmlRenderer.createDocument();
        Element bodyElement = HtmlRenderer.appendHeadAndBody(document);
        Element tableElement = document.createElement("table");
        bodyElement.appendChild(tableElement);
        tableElement.setAttribute("border", "1");
        tableElement.setAttribute("cellpadding", "2");
        tableElement.setAttribute("cellspacing", "0");
        List<ColumnDescription> columnDescriptions = dataTable.getColumnDescriptions();
        Element trElement = document.createElement("tr");
        trElement.setAttribute("style", "font-weight: bold; background-color: #aaa;");
        for (ColumnDescription columnDescription : columnDescriptions) {
            Element tdElement = document.createElement("td");
            tdElement.setTextContent(columnDescription.getLabel());
            trElement.appendChild(tdElement);
        }
        tableElement.appendChild(trElement);
        Map<ValueType, ValueFormatter> formatters = ValueFormatter.createDefaultFormatters(locale);
        int rowCount = 0;
        for (TableRow row : dataTable.getRows()) {
            trElement = document.createElement("tr");
            String backgroundColor = ++rowCount % 2 != 0 ? "#f0f0f0" : "#ffffff";
            trElement.setAttribute("style", "background-color: " + backgroundColor);
            List<TableCell> cells = row.getCells();
            for (int c = 0; c < cells.size(); ++c) {
                ValueType valueType = columnDescriptions.get(c).getType();
                TableCell cell = cells.get(c);
                String cellFormattedText = cell.getFormattedValue();
                if (cellFormattedText == null) {
                    cellFormattedText = formatters.get((Object)cell.getType()).format(cell.getValue());
                }
                Element tdElement = document.createElement("td");
                if (cell.isNull()) {
                    tdElement.setTextContent("\u00a0");
                } else {
                    switch (valueType) {
                        case NUMBER: {
                            tdElement.setAttribute("align", "right");
                            tdElement.setTextContent(cellFormattedText);
                            break;
                        }
                        case BOOLEAN: {
                            BooleanValue booleanValue = (BooleanValue)cell.getValue();
                            tdElement.setAttribute("align", "center");
                            if (booleanValue.getValue()) {
                                tdElement.setTextContent("\u2714");
                                break;
                            }
                            tdElement.setTextContent("\u2717");
                            break;
                        }
                        default: {
                            if (StringUtils.isEmpty((String)cellFormattedText)) {
                                tdElement.setTextContent("\u00a0");
                                break;
                            }
                            tdElement.setTextContent(cellFormattedText);
                        }
                    }
                }
                trElement.appendChild(tdElement);
            }
            tableElement.appendChild(trElement);
        }
        bodyElement.appendChild(tableElement);
        for (Warning warning : dataTable.getWarnings()) {
            bodyElement.appendChild(document.createElement("br"));
            bodyElement.appendChild(document.createElement("br"));
            Element messageElement = document.createElement("div");
            messageElement.setTextContent(warning.getReasonType().getMessageForReasonType() + ". " + warning.getMessage());
            bodyElement.appendChild(messageElement);
        }
        return HtmlRenderer.transformDocumentToHtmlString(document);
    }

    private static String transformDocumentToHtmlString(Document document) {
        Transformer transformer = null;
        try {
            transformer = TransformerFactory.newInstance().newTransformer();
        }
        catch (TransformerConfigurationException e) {
            log.error((Object)"Couldn't create a transformer", (Throwable)e);
            throw new RuntimeException("Couldn't create a transformer. This should never happen.", e);
        }
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("doctype-public", "-//W3C//DTD HTML 4.01//EN");
        transformer.setOutputProperty("method", "html");
        transformer.setOutputProperty("version", "4.01");
        DOMSource source = new DOMSource(document);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        try {
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            log.error((Object)"Couldn't transform", (Throwable)e);
            throw new RuntimeException("Couldn't transform. This should never happen.", e);
        }
        return ((Object)writer).toString();
    }

    static String sanitizeDetailedMessage(String detailedMessage) {
        if (StringUtils.isEmpty((String)detailedMessage)) {
            return "";
        }
        if (DETAILED_MESSAGE_A_TAG_REGEXP.matcher(detailedMessage).matches() && !BAD_JAVASCRIPT_REGEXP.matcher(detailedMessage).find()) {
            return detailedMessage;
        }
        return EscapeUtil.htmlEscape(detailedMessage);
    }

    public static CharSequence renderHtmlError(ResponseStatus responseStatus) {
        String text;
        StatusType status = responseStatus.getStatusType();
        ReasonType reason = responseStatus.getReasonType();
        String detailedMessage = responseStatus.getDescription();
        Document document = HtmlRenderer.createDocument();
        Element bodyElement = HtmlRenderer.appendHeadAndBody(document);
        Element oopsElement = document.createElement("h3");
        oopsElement.setTextContent("Oops, an error occured.");
        bodyElement.appendChild(oopsElement);
        if (status != null) {
            text = "Status: " + status.lowerCaseString();
            HtmlRenderer.appendSimpleText(document, bodyElement, text);
        }
        if (reason != null) {
            text = "Reason: " + reason.getMessageForReasonType(null);
            HtmlRenderer.appendSimpleText(document, bodyElement, text);
        }
        if (detailedMessage != null) {
            text = "Description: " + HtmlRenderer.sanitizeDetailedMessage(detailedMessage);
            HtmlRenderer.appendSimpleText(document, bodyElement, text);
        }
        return HtmlRenderer.transformDocumentToHtmlString(document);
    }

    private static Document createDocument() {
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            log.error((Object)"Couldn't create a document builder", (Throwable)e);
            throw new RuntimeException("Couldn't create a document builder. This should never happen.", e);
        }
        Document document = documentBuilder.newDocument();
        return document;
    }

    private static Element appendHeadAndBody(Document document) {
        Element htmlElement = document.createElement("html");
        document.appendChild(htmlElement);
        Element headElement = document.createElement("head");
        htmlElement.appendChild(headElement);
        Element titleElement = document.createElement("title");
        titleElement.setTextContent("Google Visualization");
        headElement.appendChild(titleElement);
        Element bodyElement = document.createElement("body");
        htmlElement.appendChild(bodyElement);
        return bodyElement;
    }

    private static void appendSimpleText(Document document, Element bodyElement, String text) {
        Element statusElement = document.createElement("div");
        statusElement.setTextContent(text);
        bodyElement.appendChild(statusElement);
    }
}

