/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.query.parser;

import com.google.visualization.datasource.base.InvalidQueryException;
import com.google.visualization.datasource.datatable.value.BooleanValue;
import com.google.visualization.datasource.datatable.value.NumberValue;
import com.google.visualization.datasource.datatable.value.TextValue;
import com.google.visualization.datasource.datatable.value.Value;
import com.google.visualization.datasource.query.AbstractColumn;
import com.google.visualization.datasource.query.AggregationColumn;
import com.google.visualization.datasource.query.AggregationType;
import com.google.visualization.datasource.query.ColumnColumnFilter;
import com.google.visualization.datasource.query.ColumnIsNullFilter;
import com.google.visualization.datasource.query.ColumnValueFilter;
import com.google.visualization.datasource.query.ComparisonFilter;
import com.google.visualization.datasource.query.CompoundFilter;
import com.google.visualization.datasource.query.NegationFilter;
import com.google.visualization.datasource.query.Query;
import com.google.visualization.datasource.query.QueryFilter;
import com.google.visualization.datasource.query.QueryFormat;
import com.google.visualization.datasource.query.QueryGroup;
import com.google.visualization.datasource.query.QueryLabels;
import com.google.visualization.datasource.query.QueryOptions;
import com.google.visualization.datasource.query.QueryPivot;
import com.google.visualization.datasource.query.QuerySelection;
import com.google.visualization.datasource.query.QuerySort;
import com.google.visualization.datasource.query.ScalarFunctionColumn;
import com.google.visualization.datasource.query.SimpleColumn;
import com.google.visualization.datasource.query.SortOrder;
import com.google.visualization.datasource.query.parser.GenericsHelper;
import com.google.visualization.datasource.query.parser.JavaCharStream;
import com.google.visualization.datasource.query.parser.ParseException;
import com.google.visualization.datasource.query.parser.ParserUtils;
import com.google.visualization.datasource.query.parser.QueryOptionEnum;
import com.google.visualization.datasource.query.parser.QueryParserConstants;
import com.google.visualization.datasource.query.parser.QueryParserTokenManager;
import com.google.visualization.datasource.query.parser.Token;
import com.google.visualization.datasource.query.scalarfunction.Constant;
import com.google.visualization.datasource.query.scalarfunction.CurrentDateTime;
import com.google.visualization.datasource.query.scalarfunction.DateDiff;
import com.google.visualization.datasource.query.scalarfunction.Difference;
import com.google.visualization.datasource.query.scalarfunction.Lower;
import com.google.visualization.datasource.query.scalarfunction.Modulo;
import com.google.visualization.datasource.query.scalarfunction.Product;
import com.google.visualization.datasource.query.scalarfunction.Quotient;
import com.google.visualization.datasource.query.scalarfunction.ScalarFunction;
import com.google.visualization.datasource.query.scalarfunction.Sum;
import com.google.visualization.datasource.query.scalarfunction.TimeComponentExtractor;
import com.google.visualization.datasource.query.scalarfunction.ToDate;
import com.google.visualization.datasource.query.scalarfunction.Upper;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class QueryParser
implements QueryParserConstants {
    public QueryParserTokenManager token_source;
    JavaCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[48];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private final JJCalls[] jj_2_rtns = new JJCalls[6];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public static Query parseString(String queryString) throws ParseException, InvalidQueryException {
        BufferedReader r = new BufferedReader(new StringReader(queryString));
        QueryParser parser = new QueryParser(r);
        Query query = parser.queryStatement();
        return query;
    }

    public final Query queryStatement() throws ParseException, InvalidQueryException {
        Query query = new Query();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: {
                this.selectClause(query);
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: {
                this.whereClause(query);
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: {
                this.groupByClause(query);
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: {
                this.pivotClause(query);
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 9: {
                this.orderByClause(query);
                break;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 11: {
                this.skippingClause(query);
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 12: {
                this.limitClause(query);
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 13: {
                this.offsetClause(query);
                break;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: {
                this.labelClause(query);
                break;
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 15: {
                this.formatClause(query);
                break;
            }
            default: {
                this.jj_la1[9] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 16: {
                this.optionsClause(query);
                break;
            }
            default: {
                this.jj_la1[10] = this.jj_gen;
            }
        }
        this.jj_consume_token(0);
        return query;
    }

    public final void selectClause(Query query) throws ParseException, InvalidQueryException {
        QuerySelection selection = new QuerySelection();
        this.jj_consume_token(5);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 19: 
            case 20: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 63: 
            case 64: 
            case 66: 
            case 76: {
                AbstractColumn column = this.abstractColumnDescriptor();
                selection.addColumn(column);
                block7: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 65: {
                            break;
                        }
                        default: {
                            this.jj_la1[11] = this.jj_gen;
                            break block7;
                        }
                    }
                    this.jj_consume_token(65);
                    column = this.abstractColumnDescriptor();
                    selection.addColumn(column);
                }
                query.setSelection(selection);
                break;
            }
            case 74: {
                this.jj_consume_token(74);
                break;
            }
            default: {
                this.jj_la1[12] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void whereClause(Query query) throws ParseException, InvalidQueryException {
        this.jj_consume_token(6);
        QueryFilter filter = this.logicalExpression();
        query.setFilter(filter);
    }

    public final void groupByClause(Query query) throws ParseException, InvalidQueryException {
        QueryGroup group = new QueryGroup();
        this.jj_consume_token(7);
        this.jj_consume_token(10);
        AbstractColumn column = this.abstractColumnDescriptor();
        group.addColumn(column);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 65: {
                    break;
                }
                default: {
                    this.jj_la1[13] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(65);
            column = this.abstractColumnDescriptor();
            group.addColumn(column);
        }
        query.setGroup(group);
    }

    public final void pivotClause(Query query) throws ParseException, InvalidQueryException {
        QueryPivot pivot = new QueryPivot();
        this.jj_consume_token(8);
        AbstractColumn column = this.abstractColumnDescriptor();
        pivot.addColumn(column);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 65: {
                    break;
                }
                default: {
                    this.jj_la1[14] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(65);
            column = this.abstractColumnDescriptor();
            pivot.addColumn(column);
        }
        query.setPivot(pivot);
    }

    public final void orderByClause(Query query) throws ParseException, InvalidQueryException {
        QuerySort sort = new QuerySort();
        this.jj_consume_token(9);
        this.jj_consume_token(10);
        AbstractColumn column = this.abstractColumnDescriptor();
        SortOrder order = this.sortOrder();
        sort.addSort(column, order);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 65: {
                    break;
                }
                default: {
                    this.jj_la1[15] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(65);
            column = this.abstractColumnDescriptor();
            order = this.sortOrder();
            sort.addSort(column, order);
        }
        query.setSort(sort);
    }

    public final void skippingClause(Query query) throws ParseException, InvalidQueryException {
        this.jj_consume_token(11);
        int skipping = this.integerLiteral();
        query.setRowSkipping(skipping);
    }

    public final void limitClause(Query query) throws ParseException, InvalidQueryException {
        this.jj_consume_token(12);
        int limit = this.integerLiteral();
        query.setRowLimit(limit);
    }

    public final void offsetClause(Query query) throws ParseException, InvalidQueryException {
        this.jj_consume_token(13);
        int offset = this.integerLiteral();
        query.setRowOffset(offset);
    }

    public final void labelClause(Query query) throws ParseException, InvalidQueryException {
        QueryLabels labels = new QueryLabels();
        this.jj_consume_token(14);
        AbstractColumn column = this.abstractColumnDescriptor();
        String label = this.stringLiteral();
        labels.addLabel(column, label);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 65: {
                    break;
                }
                default: {
                    this.jj_la1[16] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(65);
            column = this.abstractColumnDescriptor();
            label = this.stringLiteral();
            labels.addLabel(column, label);
        }
        query.setLabels(labels);
    }

    public final void formatClause(Query query) throws ParseException, InvalidQueryException {
        QueryFormat formats = new QueryFormat();
        this.jj_consume_token(15);
        AbstractColumn column = this.abstractColumnDescriptor();
        String pattern = this.stringLiteral();
        formats.addPattern(column, pattern);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 65: {
                    break;
                }
                default: {
                    this.jj_la1[17] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(65);
            column = this.abstractColumnDescriptor();
            pattern = this.stringLiteral();
            formats.addPattern(column, pattern);
        }
        query.setUserFormatOptions(formats);
    }

    public final void optionsClause(Query query) throws ParseException {
        QueryOptions queryOptions = new QueryOptions();
        this.jj_consume_token(16);
        block3: while (true) {
            QueryOptionEnum optionEnum = this.queryOption();
            optionEnum.setInQueryOptions(queryOptions);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 33: 
                case 34: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[18] = this.jj_gen;
        query.setOptions(queryOptions);
    }

    public final QueryFilter logicalExpression() throws ParseException, InvalidQueryException {
        QueryFilter filter = this.possibleOrExpression();
        return filter;
    }

    public final QueryFilter possibleOrExpression() throws ParseException, InvalidQueryException {
        ArrayList<QueryFilter> subFilters = new ArrayList<QueryFilter>();
        QueryFilter filter = this.possibleAndExpression();
        subFilters.add(filter);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 22: {
                    break;
                }
                default: {
                    this.jj_la1[19] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(22);
            filter = this.possibleAndExpression();
            subFilters.add(filter);
        }
        if (subFilters.size() == 1) {
            return (QueryFilter)subFilters.get(0);
        }
        return new CompoundFilter(CompoundFilter.LogicalOperator.OR, GenericsHelper.makeTypedList(subFilters));
    }

    public final QueryFilter possibleAndExpression() throws ParseException, InvalidQueryException {
        ArrayList<QueryFilter> subFilters = new ArrayList<QueryFilter>();
        QueryFilter filter = this.possibleNotExpression();
        subFilters.add(filter);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[20] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(21);
            filter = this.possibleNotExpression();
            subFilters.add(filter);
        }
        if (subFilters.size() == 1) {
            return (QueryFilter)subFilters.get(0);
        }
        return new CompoundFilter(CompoundFilter.LogicalOperator.AND, GenericsHelper.makeTypedList(subFilters));
    }

    public final QueryFilter possibleNotExpression() throws ParseException, InvalidQueryException {
        QueryFilter filter;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 23: {
                this.jj_consume_token(23);
                QueryFilter subFilter = this.primaryExpression();
                filter = new NegationFilter(subFilter);
                break;
            }
            case 19: 
            case 20: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 63: 
            case 64: 
            case 66: 
            case 76: {
                QueryFilter subFilter;
                filter = subFilter = this.primaryExpression();
                break;
            }
            default: {
                this.jj_la1[21] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return filter;
    }

    public final QueryFilter primaryExpression() throws ParseException, InvalidQueryException {
        QueryFilter filter;
        if (this.jj_2_1(Integer.MAX_VALUE)) {
            filter = this.primitiveFilter();
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 66: {
                    this.jj_consume_token(66);
                    filter = this.logicalExpression();
                    this.jj_consume_token(67);
                    break;
                }
                default: {
                    this.jj_la1[22] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return filter;
    }

    public final QueryFilter primitiveFilter() throws ParseException, InvalidQueryException {
        QueryFilter filter;
        if (this.jj_2_3(Integer.MAX_VALUE)) {
            Value val = this.literal();
            ComparisonFilter.Operator op = this.comparisonOperator();
            AbstractColumn col1 = this.abstractColumnDescriptor();
            filter = new ColumnValueFilter(col1, val, op, true);
        } else {
            block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 19: 
                case 20: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 63: 
                case 64: 
                case 66: 
                case 76: {
                    AbstractColumn col1 = this.abstractColumnDescriptor();
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 35: {
                            this.jj_consume_token(35);
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 36: {
                                    this.jj_consume_token(36);
                                    filter = new ColumnIsNullFilter(col1);
                                    break block0;
                                }
                                case 23: {
                                    this.jj_consume_token(23);
                                    this.jj_consume_token(36);
                                    filter = new NegationFilter(new ColumnIsNullFilter(col1));
                                    break block0;
                                }
                            }
                            this.jj_la1[23] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                        case 45: 
                        case 46: 
                        case 47: 
                        case 48: 
                        case 49: 
                        case 68: 
                        case 69: 
                        case 70: 
                        case 71: 
                        case 72: 
                        case 73: {
                            ComparisonFilter.Operator op = this.comparisonOperator();
                            if (this.jj_2_2(Integer.MAX_VALUE)) {
                                Value val = this.literal();
                                filter = new ColumnValueFilter(col1, val, op, false);
                                break block0;
                            }
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 19: 
                                case 20: 
                                case 24: 
                                case 25: 
                                case 26: 
                                case 27: 
                                case 28: 
                                case 29: 
                                case 30: 
                                case 31: 
                                case 32: 
                                case 33: 
                                case 34: 
                                case 35: 
                                case 36: 
                                case 37: 
                                case 38: 
                                case 39: 
                                case 40: 
                                case 41: 
                                case 42: 
                                case 43: 
                                case 44: 
                                case 45: 
                                case 46: 
                                case 47: 
                                case 48: 
                                case 49: 
                                case 50: 
                                case 51: 
                                case 52: 
                                case 53: 
                                case 54: 
                                case 55: 
                                case 56: 
                                case 57: 
                                case 58: 
                                case 59: 
                                case 63: 
                                case 64: 
                                case 66: 
                                case 76: {
                                    AbstractColumn col2 = this.abstractColumnDescriptor();
                                    filter = new ColumnColumnFilter(col1, col2, op);
                                    break block0;
                                }
                            }
                            this.jj_la1[24] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    this.jj_la1[25] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                default: {
                    this.jj_la1[26] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return filter;
    }

    public final ComparisonFilter.Operator comparisonOperator() throws ParseException {
        ComparisonFilter.Operator op;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 68: {
                this.jj_consume_token(68);
                op = ComparisonFilter.Operator.EQ;
                break;
            }
            case 69: {
                this.jj_consume_token(69);
                op = ComparisonFilter.Operator.NE;
                break;
            }
            case 70: {
                this.jj_consume_token(70);
                op = ComparisonFilter.Operator.LT;
                break;
            }
            case 71: {
                this.jj_consume_token(71);
                op = ComparisonFilter.Operator.LE;
                break;
            }
            case 72: {
                this.jj_consume_token(72);
                op = ComparisonFilter.Operator.GT;
                break;
            }
            case 73: {
                this.jj_consume_token(73);
                op = ComparisonFilter.Operator.GE;
                break;
            }
            case 45: {
                this.jj_consume_token(45);
                op = ComparisonFilter.Operator.CONTAINS;
                break;
            }
            case 46: {
                this.jj_consume_token(46);
                this.jj_consume_token(44);
                op = ComparisonFilter.Operator.STARTS_WITH;
                break;
            }
            case 47: {
                this.jj_consume_token(47);
                this.jj_consume_token(44);
                op = ComparisonFilter.Operator.ENDS_WITH;
                break;
            }
            case 48: {
                this.jj_consume_token(48);
                op = ComparisonFilter.Operator.MATCHES;
                break;
            }
            case 49: {
                this.jj_consume_token(49);
                op = ComparisonFilter.Operator.LIKE;
                break;
            }
            default: {
                this.jj_la1[27] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return op;
    }

    public final Value literal() throws ParseException, InvalidQueryException {
        Value val;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 63: {
                String str = this.stringLiteral();
                val = new TextValue(str);
                break;
            }
            case 58: 
            case 59: 
            case 76: {
                double num = this.decimalLiteral();
                val = new NumberValue(num);
                break;
            }
            case 19: 
            case 20: {
                boolean bool = this.booleanLiteral();
                val = BooleanValue.getInstance(bool);
                break;
            }
            case 24: {
                this.jj_consume_token(24);
                String dateStr = this.stringLiteral();
                val = ParserUtils.stringToDate(dateStr);
                break;
            }
            case 25: {
                this.jj_consume_token(25);
                String dateStr = this.stringLiteral();
                val = ParserUtils.stringToTimeOfDay(dateStr);
                break;
            }
            case 26: 
            case 27: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 26: {
                        this.jj_consume_token(26);
                        break;
                    }
                    case 27: {
                        this.jj_consume_token(27);
                        break;
                    }
                    default: {
                        this.jj_la1[28] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                String dateStr = this.stringLiteral();
                val = ParserUtils.stringToDatetime(dateStr);
                break;
            }
            default: {
                this.jj_la1[29] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return val;
    }

    public final QueryOptionEnum queryOption() throws ParseException {
        QueryOptionEnum result = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 33: {
                this.jj_consume_token(33);
                result = QueryOptionEnum.NO_VALUES;
                break;
            }
            case 34: {
                this.jj_consume_token(34);
                result = QueryOptionEnum.NO_FORMAT;
                break;
            }
            default: {
                this.jj_la1[30] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return result;
    }

    public final AbstractColumn abstractColumnDescriptor() throws ParseException, InvalidQueryException {
        AbstractColumn result = null;
        if (this.jj_2_4(2)) {
            AbstractColumn column;
            result = column = this.arithmeticExpression();
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 19: 
                case 20: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 63: 
                case 64: 
                case 66: 
                case 76: {
                    AbstractColumn column;
                    result = column = this.atomicAbstractColumnDescriptor();
                    break;
                }
                default: {
                    this.jj_la1[31] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return result;
    }

    public final AbstractColumn atomicAbstractColumnDescriptor() throws ParseException, InvalidQueryException {
        ArrayList<AbstractColumn> columns = new ArrayList<AbstractColumn>();
        AbstractColumn result = null;
        if (this.jj_2_5(2)) {
            AggregationType aggregationType = this.aggregationFunction();
            this.jj_consume_token(66);
            String columnId = this.columnId();
            this.jj_consume_token(67);
            result = new AggregationColumn(new SimpleColumn(columnId), aggregationType);
        } else if (this.jj_2_6(2)) {
            AbstractColumn column;
            ScalarFunction scalarFunction = this.scalarFunction();
            this.jj_consume_token(66);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 19: 
                case 20: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 63: 
                case 64: 
                case 66: 
                case 76: {
                    column = this.abstractColumnDescriptor();
                    columns.add(column);
                    break;
                }
                default: {
                    this.jj_la1[32] = this.jj_gen;
                }
            }
            block11: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 65: {
                        break;
                    }
                    default: {
                        this.jj_la1[33] = this.jj_gen;
                        break block11;
                    }
                }
                this.jj_consume_token(65);
                column = this.abstractColumnDescriptor();
                columns.add(column);
            }
            this.jj_consume_token(67);
            result = new ScalarFunctionColumn(GenericsHelper.makeTypedList(columns), scalarFunction);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 66: {
                    this.jj_consume_token(66);
                    AbstractColumn column = this.abstractColumnDescriptor();
                    this.jj_consume_token(67);
                    result = column;
                    break;
                }
                case 19: 
                case 20: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 58: 
                case 59: 
                case 63: 
                case 76: {
                    Value value = this.literal();
                    result = new ScalarFunctionColumn(new ArrayList<AbstractColumn>(), new Constant(value));
                    break;
                }
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 64: {
                    String columnId = this.columnId();
                    result = new SimpleColumn(columnId);
                    break;
                }
                default: {
                    this.jj_la1[34] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return result;
    }

    public final AbstractColumn arithmeticExpression() throws ParseException, InvalidQueryException {
        AbstractColumn column = this.possibleSecondOrderArithmeticExpression();
        return column;
    }

    public final AbstractColumn possibleSecondOrderArithmeticExpression() throws ParseException, InvalidQueryException {
        AbstractColumn column;
        block8: {
            column = this.possibleFirstOrderArithmeticExpression();
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 75: 
                    case 76: {
                        break;
                    }
                    default: {
                        this.jj_la1[35] = this.jj_gen;
                        break block8;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 75: {
                        this.jj_consume_token(75);
                        AbstractColumn column1 = this.possibleFirstOrderArithmeticExpression();
                        column = new ScalarFunctionColumn(GenericsHelper.makeAbstractColumnList(new AbstractColumn[]{column, column1}), Sum.getInstance());
                        continue block7;
                    }
                    case 76: {
                        this.jj_consume_token(76);
                        AbstractColumn column1 = this.possibleFirstOrderArithmeticExpression();
                        column = new ScalarFunctionColumn(GenericsHelper.makeAbstractColumnList(new AbstractColumn[]{column, column1}), Difference.getInstance());
                        continue block7;
                    }
                }
                break;
            }
            this.jj_la1[36] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return column;
    }

    public final AbstractColumn possibleFirstOrderArithmeticExpression() throws ParseException, InvalidQueryException {
        AbstractColumn column;
        block9: {
            column = this.atomicAbstractColumnDescriptor();
            block8: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 74: 
                    case 77: 
                    case 78: {
                        break;
                    }
                    default: {
                        this.jj_la1[37] = this.jj_gen;
                        break block9;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 74: {
                        this.jj_consume_token(74);
                        AbstractColumn column1 = this.atomicAbstractColumnDescriptor();
                        column = new ScalarFunctionColumn(GenericsHelper.makeAbstractColumnList(new AbstractColumn[]{column, column1}), Product.getInstance());
                        continue block8;
                    }
                    case 77: {
                        this.jj_consume_token(77);
                        AbstractColumn column1 = this.atomicAbstractColumnDescriptor();
                        column = new ScalarFunctionColumn(GenericsHelper.makeAbstractColumnList(new AbstractColumn[]{column, column1}), Quotient.getInstance());
                        continue block8;
                    }
                    case 78: {
                        this.jj_consume_token(78);
                        AbstractColumn column1 = this.atomicAbstractColumnDescriptor();
                        column = new ScalarFunctionColumn(GenericsHelper.makeAbstractColumnList(new AbstractColumn[]{column, column1}), Modulo.getInstance());
                        continue block8;
                    }
                }
                break;
            }
            this.jj_la1[38] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return column;
    }

    public final AggregationType aggregationFunction() throws ParseException {
        AggregationType result = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 28: {
                this.jj_consume_token(28);
                result = AggregationType.MIN;
                break;
            }
            case 29: {
                this.jj_consume_token(29);
                result = AggregationType.MAX;
                break;
            }
            case 31: {
                this.jj_consume_token(31);
                result = AggregationType.COUNT;
                break;
            }
            case 30: {
                this.jj_consume_token(30);
                result = AggregationType.AVG;
                break;
            }
            case 32: {
                this.jj_consume_token(32);
                result = AggregationType.SUM;
                break;
            }
            default: {
                this.jj_la1[39] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return result;
    }

    public final ScalarFunction scalarFunction() throws ParseException {
        ScalarFunction result = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 37: {
                this.jj_consume_token(37);
                result = TimeComponentExtractor.getInstance(TimeComponentExtractor.TimeComponent.YEAR);
                break;
            }
            case 38: {
                this.jj_consume_token(38);
                result = TimeComponentExtractor.getInstance(TimeComponentExtractor.TimeComponent.MONTH);
                break;
            }
            case 39: {
                this.jj_consume_token(39);
                result = TimeComponentExtractor.getInstance(TimeComponentExtractor.TimeComponent.DAY);
                break;
            }
            case 40: {
                this.jj_consume_token(40);
                result = TimeComponentExtractor.getInstance(TimeComponentExtractor.TimeComponent.HOUR);
                break;
            }
            case 41: {
                this.jj_consume_token(41);
                result = TimeComponentExtractor.getInstance(TimeComponentExtractor.TimeComponent.MINUTE);
                break;
            }
            case 42: {
                this.jj_consume_token(42);
                result = TimeComponentExtractor.getInstance(TimeComponentExtractor.TimeComponent.SECOND);
                break;
            }
            case 43: {
                this.jj_consume_token(43);
                result = TimeComponentExtractor.getInstance(TimeComponentExtractor.TimeComponent.MILLISECOND);
                break;
            }
            case 50: {
                this.jj_consume_token(50);
                result = CurrentDateTime.getInstance();
                break;
            }
            case 51: {
                this.jj_consume_token(51);
                result = DateDiff.getInstance();
                break;
            }
            case 53: {
                this.jj_consume_token(53);
                result = Lower.getInstance();
                break;
            }
            case 54: {
                this.jj_consume_token(54);
                result = Upper.getInstance();
                break;
            }
            case 52: {
                this.jj_consume_token(52);
                result = TimeComponentExtractor.getInstance(TimeComponentExtractor.TimeComponent.QUARTER);
                break;
            }
            case 55: {
                this.jj_consume_token(55);
                result = TimeComponentExtractor.getInstance(TimeComponentExtractor.TimeComponent.DAY_OF_WEEK);
                break;
            }
            case 56: {
                this.jj_consume_token(56);
                result = ToDate.getInstance();
                break;
            }
            default: {
                this.jj_la1[40] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return result;
    }

    public final String columnId() throws ParseException {
        String result = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 57: {
                Token t = this.jj_consume_token(57);
                result = t.image;
                break;
            }
            case 64: {
                Token t = this.jj_consume_token(64);
                result = ParserUtils.stripQuotes(t.image);
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                result = this.nonReservedKeyword();
                break;
            }
            default: {
                this.jj_la1[41] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return result;
    }

    public final String nonReservedKeyword() throws ParseException {
        Token t;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 28: {
                t = this.jj_consume_token(28);
                break;
            }
            case 29: {
                t = this.jj_consume_token(29);
                break;
            }
            case 30: {
                t = this.jj_consume_token(30);
                break;
            }
            case 31: {
                t = this.jj_consume_token(31);
                break;
            }
            case 32: {
                t = this.jj_consume_token(32);
                break;
            }
            case 33: {
                t = this.jj_consume_token(33);
                break;
            }
            case 34: {
                t = this.jj_consume_token(34);
                break;
            }
            case 35: {
                t = this.jj_consume_token(35);
                break;
            }
            case 36: {
                t = this.jj_consume_token(36);
                break;
            }
            case 37: {
                t = this.jj_consume_token(37);
                break;
            }
            case 38: {
                t = this.jj_consume_token(38);
                break;
            }
            case 39: {
                t = this.jj_consume_token(39);
                break;
            }
            case 40: {
                t = this.jj_consume_token(40);
                break;
            }
            case 41: {
                t = this.jj_consume_token(41);
                break;
            }
            case 42: {
                t = this.jj_consume_token(42);
                break;
            }
            case 43: {
                t = this.jj_consume_token(43);
                break;
            }
            case 44: {
                t = this.jj_consume_token(44);
                break;
            }
            case 45: {
                t = this.jj_consume_token(45);
                break;
            }
            case 46: {
                t = this.jj_consume_token(46);
                break;
            }
            case 47: {
                t = this.jj_consume_token(47);
                break;
            }
            case 48: {
                t = this.jj_consume_token(48);
                break;
            }
            case 49: {
                t = this.jj_consume_token(49);
                break;
            }
            case 50: {
                t = this.jj_consume_token(50);
                break;
            }
            case 51: {
                t = this.jj_consume_token(51);
                break;
            }
            case 52: {
                t = this.jj_consume_token(52);
                break;
            }
            case 53: {
                t = this.jj_consume_token(53);
                break;
            }
            case 54: {
                t = this.jj_consume_token(54);
                break;
            }
            case 55: {
                t = this.jj_consume_token(55);
                break;
            }
            case 56: {
                t = this.jj_consume_token(56);
                break;
            }
            default: {
                this.jj_la1[42] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return t.image;
    }

    public final SortOrder sortOrder() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 17: {
                this.jj_consume_token(17);
                return SortOrder.ASCENDING;
            }
            case 18: {
                this.jj_consume_token(18);
                return SortOrder.DESCENDING;
            }
        }
        this.jj_la1[43] = this.jj_gen;
        return SortOrder.ASCENDING;
    }

    public final int integerLiteral() throws ParseException {
        String s;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 58: {
                Token t1 = this.jj_consume_token(58);
                s = t1.image;
                break;
            }
            case 76: {
                Token t1 = this.jj_consume_token(76);
                Token t2 = this.jj_consume_token(58);
                s = t1.image + t2.image;
                break;
            }
            default: {
                this.jj_la1[44] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return Integer.parseInt(s);
    }

    public final String stringLiteral() throws ParseException {
        Token t = this.jj_consume_token(63);
        return ParserUtils.stripQuotes(t.image);
    }

    public final double decimalLiteral() throws ParseException {
        String s;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 59: {
                Token t1 = this.jj_consume_token(59);
                s = t1.image;
                break;
            }
            case 58: {
                Token t1 = this.jj_consume_token(58);
                s = t1.image;
                break;
            }
            case 76: {
                Token t2;
                Token t1 = this.jj_consume_token(76);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 59: {
                        t2 = this.jj_consume_token(59);
                        break;
                    }
                    case 58: {
                        t2 = this.jj_consume_token(58);
                        break;
                    }
                    default: {
                        this.jj_la1[45] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                s = t1.image + t2.image;
                break;
            }
            default: {
                this.jj_la1[46] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return Double.parseDouble(s);
    }

    public final boolean booleanLiteral() throws ParseException {
        boolean b;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 19: {
                this.jj_consume_token(19);
                b = true;
                break;
            }
            case 20: {
                this.jj_consume_token(20);
                b = false;
                break;
            }
            default: {
                this.jj_la1[47] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    private boolean jj_3R_66() {
        return this.jj_3R_76();
    }

    private boolean jj_3_4() {
        return this.jj_3R_15();
    }

    private boolean jj_3R_47() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_4()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_66()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_25() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(26)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(27)) {
                return true;
            }
        }
        return this.jj_3R_50();
    }

    private boolean jj_3R_92() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(28)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(29)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(30)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(31)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(32)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(33)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(34)) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_scan_token(35)) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_scan_token(36)) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_scan_token(37)) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_scan_token(38)) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_scan_token(39)) {
                                                        this.jj_scanpos = xsp;
                                                        if (this.jj_scan_token(40)) {
                                                            this.jj_scanpos = xsp;
                                                            if (this.jj_scan_token(41)) {
                                                                this.jj_scanpos = xsp;
                                                                if (this.jj_scan_token(42)) {
                                                                    this.jj_scanpos = xsp;
                                                                    if (this.jj_scan_token(43)) {
                                                                        this.jj_scanpos = xsp;
                                                                        if (this.jj_scan_token(44)) {
                                                                            this.jj_scanpos = xsp;
                                                                            if (this.jj_scan_token(45)) {
                                                                                this.jj_scanpos = xsp;
                                                                                if (this.jj_scan_token(46)) {
                                                                                    this.jj_scanpos = xsp;
                                                                                    if (this.jj_scan_token(47)) {
                                                                                        this.jj_scanpos = xsp;
                                                                                        if (this.jj_scan_token(48)) {
                                                                                            this.jj_scanpos = xsp;
                                                                                            if (this.jj_scan_token(49)) {
                                                                                                this.jj_scanpos = xsp;
                                                                                                if (this.jj_scan_token(50)) {
                                                                                                    this.jj_scanpos = xsp;
                                                                                                    if (this.jj_scan_token(51)) {
                                                                                                        this.jj_scanpos = xsp;
                                                                                                        if (this.jj_scan_token(52)) {
                                                                                                            this.jj_scanpos = xsp;
                                                                                                            if (this.jj_scan_token(53)) {
                                                                                                                this.jj_scanpos = xsp;
                                                                                                                if (this.jj_scan_token(54)) {
                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                    if (this.jj_scan_token(55)) {
                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                        if (this.jj_scan_token(56)) {
                                                                                                                            return true;
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_24() {
        if (this.jj_scan_token(25)) {
            return true;
        }
        return this.jj_3R_50();
    }

    private boolean jj_3R_23() {
        if (this.jj_scan_token(24)) {
            return true;
        }
        return this.jj_3R_50();
    }

    private boolean jj_3R_22() {
        return this.jj_3R_52();
    }

    private boolean jj_3R_21() {
        return this.jj_3R_51();
    }

    private boolean jj_3R_20() {
        return this.jj_3R_50();
    }

    private boolean jj_3R_14() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_20()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_21()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_22()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_23()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_24()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_25()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_91() {
        return this.jj_3R_92();
    }

    private boolean jj_3R_90() {
        return this.jj_scan_token(64);
    }

    private boolean jj_3R_89() {
        return this.jj_scan_token(57);
    }

    private boolean jj_3R_86() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_89()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_90()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_91()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_65() {
        return this.jj_scan_token(49);
    }

    private boolean jj_3R_64() {
        return this.jj_scan_token(48);
    }

    private boolean jj_3R_63() {
        if (this.jj_scan_token(47)) {
            return true;
        }
        return this.jj_scan_token(44);
    }

    private boolean jj_3R_45() {
        return this.jj_scan_token(56);
    }

    private boolean jj_3R_62() {
        if (this.jj_scan_token(46)) {
            return true;
        }
        return this.jj_scan_token(44);
    }

    private boolean jj_3R_61() {
        return this.jj_scan_token(45);
    }

    private boolean jj_3R_44() {
        return this.jj_scan_token(55);
    }

    private boolean jj_3R_60() {
        return this.jj_scan_token(73);
    }

    private boolean jj_3R_59() {
        return this.jj_scan_token(72);
    }

    private boolean jj_3R_43() {
        return this.jj_scan_token(52);
    }

    private boolean jj_3R_58() {
        return this.jj_scan_token(71);
    }

    private boolean jj_3R_42() {
        return this.jj_scan_token(54);
    }

    private boolean jj_3R_57() {
        return this.jj_scan_token(70);
    }

    private boolean jj_3R_41() {
        return this.jj_scan_token(53);
    }

    private boolean jj_3R_56() {
        return this.jj_scan_token(69);
    }

    private boolean jj_3R_40() {
        return this.jj_scan_token(51);
    }

    private boolean jj_3R_55() {
        return this.jj_scan_token(68);
    }

    private boolean jj_3R_39() {
        return this.jj_scan_token(50);
    }

    private boolean jj_3_2() {
        return this.jj_3R_14();
    }

    private boolean jj_3R_46() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_55()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_56()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_57()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_58()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_59()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_60()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_61()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_62()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3R_63()) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_3R_64()) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_3R_65()) {
                                                    return true;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_38() {
        return this.jj_scan_token(43);
    }

    private boolean jj_3R_37() {
        return this.jj_scan_token(42);
    }

    private boolean jj_3R_36() {
        return this.jj_scan_token(41);
    }

    private boolean jj_3R_35() {
        return this.jj_scan_token(40);
    }

    private boolean jj_3R_70() {
        return this.jj_3R_47();
    }

    private boolean jj_3R_34() {
        return this.jj_scan_token(39);
    }

    private boolean jj_3R_69() {
        return this.jj_3R_14();
    }

    private boolean jj_3R_33() {
        return this.jj_scan_token(38);
    }

    private boolean jj_3R_32() {
        return this.jj_scan_token(37);
    }

    private boolean jj_3R_49() {
        if (this.jj_3R_46()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_69()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_70()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_17() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_32()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_33()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_34()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_35()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_36()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_37()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_38()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_39()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3R_40()) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_3R_41()) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_3R_42()) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_3R_43()) {
                                                        this.jj_scanpos = xsp;
                                                        if (this.jj_3R_44()) {
                                                            this.jj_scanpos = xsp;
                                                            if (this.jj_3R_45()) {
                                                                return true;
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_68() {
        if (this.jj_scan_token(23)) {
            return true;
        }
        return this.jj_scan_token(36);
    }

    private boolean jj_3R_67() {
        return this.jj_scan_token(36);
    }

    private boolean jj_3_3() {
        return this.jj_3R_14();
    }

    private boolean jj_3R_48() {
        if (this.jj_scan_token(35)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_67()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_68()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_31() {
        return this.jj_scan_token(32);
    }

    private boolean jj_3R_30() {
        return this.jj_scan_token(30);
    }

    private boolean jj_3R_29() {
        return this.jj_scan_token(31);
    }

    private boolean jj_3R_28() {
        return this.jj_scan_token(29);
    }

    private boolean jj_3R_27() {
        return this.jj_scan_token(28);
    }

    private boolean jj_3R_19() {
        if (this.jj_3R_47()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_48()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_49()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_16() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_27()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_28()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_29()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_30()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_31()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_18() {
        if (this.jj_3R_14()) {
            return true;
        }
        if (this.jj_3R_46()) {
            return true;
        }
        return this.jj_3R_47();
    }

    private boolean jj_3R_13() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_18()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_19()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_1() {
        return this.jj_3R_13();
    }

    private boolean jj_3R_85() {
        if (this.jj_scan_token(78)) {
            return true;
        }
        return this.jj_3R_76();
    }

    private boolean jj_3R_84() {
        if (this.jj_scan_token(77)) {
            return true;
        }
        return this.jj_3R_76();
    }

    private boolean jj_3R_83() {
        if (this.jj_scan_token(74)) {
            return true;
        }
        return this.jj_3R_76();
    }

    private boolean jj_3R_77() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_83()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_84()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_85()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_53() {
        Token xsp;
        if (this.jj_3R_76()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_77());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_79() {
        if (this.jj_scan_token(76)) {
            return true;
        }
        return this.jj_3R_53();
    }

    private boolean jj_3R_75() {
        return this.jj_scan_token(20);
    }

    private boolean jj_3R_78() {
        if (this.jj_scan_token(75)) {
            return true;
        }
        return this.jj_3R_53();
    }

    private boolean jj_3R_74() {
        return this.jj_scan_token(19);
    }

    private boolean jj_3R_54() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_78()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_79()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_52() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_74()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_75()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_26() {
        Token xsp;
        if (this.jj_3R_53()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_54());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_73() {
        if (this.jj_scan_token(76)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(59)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(58)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_72() {
        return this.jj_scan_token(58);
    }

    private boolean jj_3R_71() {
        return this.jj_scan_token(59);
    }

    private boolean jj_3R_51() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_71()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_72()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_73()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_15() {
        return this.jj_3R_26();
    }

    private boolean jj_3R_82() {
        return this.jj_3R_86();
    }

    private boolean jj_3R_50() {
        return this.jj_scan_token(63);
    }

    private boolean jj_3R_81() {
        return this.jj_3R_14();
    }

    private boolean jj_3R_80() {
        if (this.jj_scan_token(66)) {
            return true;
        }
        if (this.jj_3R_47()) {
            return true;
        }
        return this.jj_scan_token(67);
    }

    private boolean jj_3R_88() {
        if (this.jj_scan_token(65)) {
            return true;
        }
        return this.jj_3R_47();
    }

    private boolean jj_3R_87() {
        return this.jj_3R_47();
    }

    private boolean jj_3_6() {
        if (this.jj_3R_17()) {
            return true;
        }
        if (this.jj_scan_token(66)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_87()) {
            this.jj_scanpos = xsp;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_88());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(67);
    }

    private boolean jj_3_5() {
        if (this.jj_3R_16()) {
            return true;
        }
        if (this.jj_scan_token(66)) {
            return true;
        }
        if (this.jj_3R_86()) {
            return true;
        }
        return this.jj_scan_token(67);
    }

    private boolean jj_3R_76() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_5()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_6()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_80()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_81()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_82()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{32, 64, 128, 256, 512, 2048, 4096, 8192, 16384, 32768, 65536, 0, -15204352, 0, 0, 0, 0, 0, 0, 0x400000, 0x200000, -6815744, 0, 0x800000, -15204352, 0, -15204352, 0, 0xC000000, 253231104, 0, -15204352, -15204352, 0, -15204352, 0, 0, 0, 0, -268435456, 0, -268435456, -268435456, 393216, 0, 0, 0, 0x180000};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1879048193, 0, 0, 0, 0, 0, 6, 0, 0, -1879048193, 0, 16, -1879048193, 253960, -1879048193, 253952, 0, -1946157056, 6, -1879048193, -1879048193, 0, -1879048193, 0, 0, 0, 0, 1, 33296352, 0x3FFFFFF, 0x1FFFFFF, 0, 0x4000000, 0xC000000, 0xC000000, 0};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 5125, 2, 2, 2, 2, 2, 0, 0, 0, 4101, 4, 0, 4101, 1008, 4101, 1008, 0, 4096, 0, 4101, 4101, 2, 4101, 6144, 6144, 25600, 25600, 0, 0, 1, 0, 0, 4096, 0, 4096, 0};
    }

    public QueryParser(InputStream stream) {
        this(stream, null);
    }

    public QueryParser(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new JavaCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new QueryParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 48; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 48; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public QueryParser(Reader stream) {
        int i;
        this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        this.token_source = new QueryParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 48; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 48; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public QueryParser(QueryParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 48; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(QueryParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 48; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            block1: for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] != this.jj_expentry[i]) continue block1;
                }
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[80];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 48; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) == 0) continue;
                la1tokens[64 + j] = true;
            }
        }
        for (i = 0; i < 80; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 6; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        QueryParser.jj_la1_init_0();
        QueryParser.jj_la1_init_1();
        QueryParser.jj_la1_init_2();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

