/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.query.engine;

import com.google.common.collect.Maps;
import com.google.visualization.datasource.datatable.DataTable;
import com.google.visualization.datasource.datatable.TableRow;
import com.google.visualization.datasource.datatable.value.Value;
import com.google.visualization.datasource.query.AggregationType;
import com.google.visualization.datasource.query.engine.AggregationPath;
import com.google.visualization.datasource.query.engine.AggregationTree;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TableAggregator {
    private List<String> groupByColumns;
    private Set<String> aggregateColumns;
    private AggregationTree tree;

    public TableAggregator(List<String> groupByColumns, Set<String> aggregateColumns, DataTable table) {
        this.groupByColumns = groupByColumns;
        this.aggregateColumns = aggregateColumns;
        this.tree = new AggregationTree(aggregateColumns, table);
        for (TableRow row : table.getRows()) {
            this.tree.aggregate(this.getRowPath(row, table, groupByColumns.size() - 1), this.getValuesToAggregate(row, table));
        }
    }

    public AggregationPath getRowPath(TableRow row, DataTable table, int depth) {
        AggregationPath result = new AggregationPath();
        for (int i = 0; i <= depth; ++i) {
            String columnId = this.groupByColumns.get(i);
            Value curValue = row.getCell(table.getColumnIndex(columnId)).getValue();
            result.add(curValue);
        }
        return result;
    }

    public Set<AggregationPath> getPathsToLeaves() {
        return this.tree.getPathsToLeaves();
    }

    private Map<String, Value> getValuesToAggregate(TableRow row, DataTable table) {
        HashMap result = Maps.newHashMap();
        for (String columnId : this.aggregateColumns) {
            Value curValue = row.getCell(table.getColumnIndex(columnId)).getValue();
            result.put(columnId, curValue);
        }
        return result;
    }

    public Value getAggregationValue(AggregationPath path, String columnId, AggregationType type) {
        return this.tree.getNode(path).getAggregationValue(columnId, type);
    }
}

