/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.query.engine;

import com.google.visualization.datasource.datatable.ColumnDescription;
import com.google.visualization.datasource.datatable.DataTable;
import com.google.visualization.datasource.datatable.value.Value;
import com.google.visualization.datasource.datatable.value.ValueType;
import com.google.visualization.datasource.query.AbstractColumn;
import com.google.visualization.datasource.query.AggregationColumn;
import com.google.visualization.datasource.query.ScalarFunctionColumn;
import java.util.List;
import org.apache.commons.lang.text.StrBuilder;

class ScalarFunctionColumnTitle {
    private List<Value> values;
    public ScalarFunctionColumn scalarFunctionColumn;
    public static final String PIVOT_COLUMNS_SEPARATOR = ",";
    public static final String PIVOT_SCALAR_FUNCTION_SEPARATOR = " ";

    public ScalarFunctionColumnTitle(List<Value> values, ScalarFunctionColumn column) {
        this.values = values;
        this.scalarFunctionColumn = column;
    }

    public List<Value> getValues() {
        return this.values;
    }

    public ColumnDescription createColumnDescription(DataTable originalTable) {
        String columnId = this.createIdPivotPrefix() + this.scalarFunctionColumn.getId();
        ValueType type = this.scalarFunctionColumn.getValueType(originalTable);
        String label = this.createLabelPivotPart() + PIVOT_SCALAR_FUNCTION_SEPARATOR + ScalarFunctionColumnTitle.getColumnDescriptionLabel(originalTable, this.scalarFunctionColumn);
        ColumnDescription result = new ColumnDescription(columnId, type, label);
        return result;
    }

    private String createIdPivotPrefix() {
        if (!this.isPivot()) {
            return "";
        }
        return new StrBuilder().appendWithSeparators(this.values, PIVOT_COLUMNS_SEPARATOR).append(PIVOT_SCALAR_FUNCTION_SEPARATOR).toString();
    }

    private String createLabelPivotPart() {
        if (!this.isPivot()) {
            return "";
        }
        return new StrBuilder().appendWithSeparators(this.values, PIVOT_COLUMNS_SEPARATOR).toString();
    }

    private boolean isPivot() {
        return !this.values.isEmpty();
    }

    public static String getColumnDescriptionLabel(DataTable originalTable, AbstractColumn column) {
        StringBuilder label = new StringBuilder();
        if (originalTable.containsColumn(column.getId())) {
            label.append(originalTable.getColumnDescription(column.getId()).getLabel());
        } else if (column instanceof AggregationColumn) {
            AggregationColumn aggColumn = (AggregationColumn)column;
            label.append(aggColumn.getAggregationType().getCode()).append(PIVOT_SCALAR_FUNCTION_SEPARATOR).append(originalTable.getColumnDescription(aggColumn.getAggregatedColumn().getId()).getLabel());
        } else {
            ScalarFunctionColumn scalarFunctionColumn = (ScalarFunctionColumn)column;
            List<AbstractColumn> columns = scalarFunctionColumn.getColumns();
            label.append(scalarFunctionColumn.getFunction().getFunctionName()).append("(");
            for (AbstractColumn abstractColumn : columns) {
                label.append(ScalarFunctionColumnTitle.getColumnDescriptionLabel(originalTable, abstractColumn));
            }
            label.append(")");
        }
        return label.toString();
    }

    public boolean equals(Object o) {
        if (o instanceof ScalarFunctionColumnTitle) {
            ScalarFunctionColumnTitle other = (ScalarFunctionColumnTitle)o;
            return this.values.equals(other.values) && this.scalarFunctionColumn.equals(other.scalarFunctionColumn);
        }
        return false;
    }

    public int hashCode() {
        int result = 31;
        if (this.scalarFunctionColumn != null) {
            result += this.scalarFunctionColumn.hashCode();
        }
        result *= 31;
        if (this.values != null) {
            result += this.values.hashCode();
        }
        return result;
    }
}

