/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.query.engine;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.visualization.datasource.base.ReasonType;
import com.google.visualization.datasource.base.TypeMismatchException;
import com.google.visualization.datasource.base.Warning;
import com.google.visualization.datasource.datatable.ColumnDescription;
import com.google.visualization.datasource.datatable.DataTable;
import com.google.visualization.datasource.datatable.TableCell;
import com.google.visualization.datasource.datatable.TableRow;
import com.google.visualization.datasource.datatable.ValueFormatter;
import com.google.visualization.datasource.datatable.value.Value;
import com.google.visualization.datasource.query.AbstractColumn;
import com.google.visualization.datasource.query.AggregationColumn;
import com.google.visualization.datasource.query.ColumnLookup;
import com.google.visualization.datasource.query.DataTableColumnLookup;
import com.google.visualization.datasource.query.GenericColumnLookup;
import com.google.visualization.datasource.query.Query;
import com.google.visualization.datasource.query.QueryFilter;
import com.google.visualization.datasource.query.QueryFormat;
import com.google.visualization.datasource.query.QueryGroup;
import com.google.visualization.datasource.query.QueryLabels;
import com.google.visualization.datasource.query.QueryPivot;
import com.google.visualization.datasource.query.QuerySelection;
import com.google.visualization.datasource.query.QuerySort;
import com.google.visualization.datasource.query.ScalarFunctionColumn;
import com.google.visualization.datasource.query.SimpleColumn;
import com.google.visualization.datasource.query.engine.AggregationPath;
import com.google.visualization.datasource.query.engine.ColumnIndices;
import com.google.visualization.datasource.query.engine.ColumnTitle;
import com.google.visualization.datasource.query.engine.GroupingComparators;
import com.google.visualization.datasource.query.engine.MetaTable;
import com.google.visualization.datasource.query.engine.RowTitle;
import com.google.visualization.datasource.query.engine.ScalarFunctionColumnTitle;
import com.google.visualization.datasource.query.engine.TableAggregator;
import com.google.visualization.datasource.query.engine.TableRowComparator;
import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;

public final class QueryEngine {
    private QueryEngine() {
    }

    private static DataTable createDataTable(List<String> groupByColumnIds, SortedSet<ColumnTitle> columnTitles, DataTable original, List<ScalarFunctionColumnTitle> scalarFunctionColumnTitles) {
        DataTable result = new DataTable();
        for (String groupById : groupByColumnIds) {
            result.addColumn(original.getColumnDescription(groupById));
        }
        for (ColumnTitle colTitle : columnTitles) {
            result.addColumn(colTitle.createColumnDescription(original));
        }
        for (ScalarFunctionColumnTitle scalarFunctionColumnTitle : scalarFunctionColumnTitles) {
            result.addColumn(scalarFunctionColumnTitle.createColumnDescription(original));
        }
        return result;
    }

    public static DataTable executeQuery(Query query, DataTable table, ULocale locale) {
        ColumnIndices columnIndices = new ColumnIndices();
        List<ColumnDescription> columnsDescription = table.getColumnDescriptions();
        for (int i = 0; i < columnsDescription.size(); ++i) {
            columnIndices.put(new SimpleColumn(columnsDescription.get(i).getId()), i);
        }
        TreeMap<List<Value>, ColumnLookup> columnLookups = new TreeMap<List<Value>, ColumnLookup>(GroupingComparators.VALUE_LIST_COMPARATOR);
        try {
            table = QueryEngine.performFilter(table, query);
            table = QueryEngine.performGroupingAndPivoting(table, query, columnIndices, columnLookups);
            table = QueryEngine.performSort(table, query, locale);
            table = QueryEngine.performSkipping(table, query);
            table = QueryEngine.performPagination(table, query);
            AtomicReference<ColumnIndices> columnIndicesReference = new AtomicReference<ColumnIndices>(columnIndices);
            table = QueryEngine.performSelection(table, query, columnIndicesReference, columnLookups);
            columnIndices = columnIndicesReference.get();
            table = QueryEngine.performLabels(table, query, columnIndices);
            table = QueryEngine.performFormatting(table, query, columnIndices, locale);
        }
        catch (TypeMismatchException typeMismatchException) {
            // empty catch block
        }
        return table;
    }

    private static DataTable performSkipping(DataTable table, Query query) throws TypeMismatchException {
        int rowSkipping = query.getRowSkipping();
        if (rowSkipping <= 1) {
            return table;
        }
        int numRows = table.getNumberOfRows();
        ArrayList<TableRow> relevantRows = new ArrayList<TableRow>();
        for (int rowIndex = 0; rowIndex < numRows; rowIndex += rowSkipping) {
            relevantRows.add(table.getRows().get(rowIndex));
        }
        DataTable newTable = new DataTable();
        newTable.addColumns(table.getColumnDescriptions());
        newTable.addRows(relevantRows);
        return newTable;
    }

    private static DataTable performPagination(DataTable table, Query query) throws TypeMismatchException {
        int rowOffset = query.getRowOffset();
        int rowLimit = query.getRowLimit();
        if ((rowLimit == -1 || table.getRows().size() <= rowLimit) && rowOffset == 0) {
            return table;
        }
        int numRows = table.getNumberOfRows();
        int fromIndex = Math.max(0, rowOffset);
        int toIndex = rowLimit == -1 ? numRows : Math.min(numRows, rowOffset + rowLimit);
        List<TableRow> relevantRows = table.getRows().subList(fromIndex, toIndex);
        DataTable newTable = new DataTable();
        newTable.addColumns(table.getColumnDescriptions());
        newTable.addRows(relevantRows);
        if (toIndex < numRows) {
            Warning warning = new Warning(ReasonType.DATA_TRUNCATED, "Data has been truncated due to userrequest (LIMIT in query)");
            newTable.addWarning(warning);
        }
        return newTable;
    }

    private static DataTable performSort(DataTable table, Query query, ULocale locale) {
        if (!query.hasSort()) {
            return table;
        }
        QuerySort sortBy = query.getSort();
        DataTableColumnLookup columnLookup = new DataTableColumnLookup(table);
        TableRowComparator comparator = new TableRowComparator(sortBy, locale, columnLookup);
        Collections.sort(table.getRows(), comparator);
        return table;
    }

    private static DataTable performFilter(DataTable table, Query query) throws TypeMismatchException {
        if (!query.hasFilter()) {
            return table;
        }
        ArrayList newRowList = Lists.newArrayList();
        QueryFilter filter = query.getFilter();
        for (TableRow inputRow : table.getRows()) {
            if (!filter.isMatch(table, inputRow)) continue;
            newRowList.add(inputRow);
        }
        table.setRows(newRowList);
        return table;
    }

    private static DataTable performSelection(DataTable table, Query query, AtomicReference<ColumnIndices> columnIndicesReference, Map<List<Value>, ColumnLookup> columnLookups) throws TypeMismatchException {
        if (!query.hasSelection()) {
            return table;
        }
        ColumnIndices columnIndices = columnIndicesReference.get();
        List<AbstractColumn> selectedColumns = query.getSelection().getColumns();
        ArrayList selectedIndices = Lists.newArrayList();
        List<ColumnDescription> oldColumnDescriptions = table.getColumnDescriptions();
        ArrayList newColumnDescriptions = Lists.newArrayList();
        ColumnIndices newColumnIndices = new ColumnIndices();
        int currIndex = 0;
        for (AbstractColumn col : selectedColumns) {
            List<Integer> colIndices = columnIndices.getColumnIndices(col);
            selectedIndices.addAll(colIndices);
            if (colIndices.size() == 0) {
                newColumnDescriptions.add(new ColumnDescription(col.getId(), col.getValueType(table), ScalarFunctionColumnTitle.getColumnDescriptionLabel(table, col)));
                newColumnIndices.put(col, currIndex++);
                continue;
            }
            for (int colIndex : colIndices) {
                newColumnDescriptions.add(oldColumnDescriptions.get(colIndex));
                newColumnIndices.put(col, currIndex++);
            }
        }
        columnIndices = newColumnIndices;
        columnIndicesReference.set(columnIndices);
        DataTable result = new DataTable();
        result.addColumns(newColumnDescriptions);
        for (TableRow sourceRow : table.getRows()) {
            TableRow newRow = new TableRow();
            for (AbstractColumn col : selectedColumns) {
                boolean wasFound = false;
                Set<List<Value>> pivotValuesSet = columnLookups.keySet();
                for (List<Value> values : pivotValuesSet) {
                    if (!columnLookups.get(values).containsColumn(col) || col.getAllAggregationColumns().size() == 0 && wasFound) continue;
                    wasFound = true;
                    newRow.addCell(sourceRow.getCell(columnLookups.get(values).getColumnIndex(col)));
                }
                if (wasFound) continue;
                DataTableColumnLookup lookup = new DataTableColumnLookup(table);
                newRow.addCell(col.getCell(lookup, sourceRow));
            }
            result.addRow(newRow);
        }
        return result;
    }

    private static boolean queryHasAggregation(Query query) {
        return query.hasSelection() && !query.getSelection().getAggregationColumns().isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    private static DataTable performGroupingAndPivoting(DataTable table, Query query, ColumnIndices columnIndices, TreeMap<List<Value>, ColumnLookup> columnLookups) throws TypeMismatchException {
        List<Value> values;
        if (!QueryEngine.queryHasAggregation(query) || table.getNumberOfRows() == 0) {
            return table;
        }
        QueryGroup group = query.getGroup();
        QueryPivot pivot = query.getPivot();
        QuerySelection selection = query.getSelection();
        List<Object> groupByIds = Lists.newArrayList();
        if (group != null) {
            groupByIds = group.getColumnIds();
        }
        List<Object> pivotByIds = Lists.newArrayList();
        if (pivot != null) {
            pivotByIds = pivot.getColumnIds();
        }
        ArrayList groupAndPivotIds = Lists.newArrayList((Iterable)groupByIds);
        groupAndPivotIds.addAll(pivotByIds);
        List<AggregationColumn> tmpColumnAggregations = selection.getAggregationColumns();
        List<ScalarFunctionColumn> selectedScalarFunctionColumns = selection.getScalarFunctionColumns();
        ArrayList columnAggregations = Lists.newArrayListWithExpectedSize((int)tmpColumnAggregations.size());
        for (AggregationColumn aggregationColumn : tmpColumnAggregations) {
            if (columnAggregations.contains(aggregationColumn)) continue;
            columnAggregations.add(aggregationColumn);
        }
        ArrayList aggregationIds = Lists.newArrayList();
        for (AggregationColumn col : columnAggregations) {
            aggregationIds.add(col.getAggregatedColumn().getId());
        }
        ArrayList arrayList = Lists.newArrayList();
        if (group != null) {
            arrayList.addAll(group.getScalarFunctionColumns());
        }
        if (pivot != null) {
            arrayList.addAll(pivot.getScalarFunctionColumns());
        }
        ArrayList newColumnDescriptions = Lists.newArrayList();
        newColumnDescriptions.addAll(table.getColumnDescriptions());
        for (ScalarFunctionColumn column : arrayList) {
            newColumnDescriptions.add(new ColumnDescription(column.getId(), column.getValueType(table), ScalarFunctionColumnTitle.getColumnDescriptionLabel(table, column)));
        }
        DataTable tempTable = new DataTable();
        tempTable.addColumns(newColumnDescriptions);
        DataTableColumnLookup lookup = new DataTableColumnLookup(table);
        for (TableRow sourceRow : table.getRows()) {
            TableRow newRow = new TableRow();
            for (TableCell sourceCell : sourceRow.getCells()) {
                newRow.addCell(sourceCell);
            }
            for (ScalarFunctionColumn column : arrayList) {
                newRow.addCell(new TableCell(column.getValue(lookup, sourceRow)));
            }
            try {
                tempTable.addRow(newRow);
            }
            catch (TypeMismatchException typeMismatchException) {}
        }
        table = tempTable;
        TableAggregator aggregator = new TableAggregator(groupAndPivotIds, Sets.newHashSet((Iterable)aggregationIds), table);
        Set<AggregationPath> paths = aggregator.getPathsToLeaves();
        TreeSet rowTitles = Sets.newTreeSet(GroupingComparators.ROW_TITLE_COMPARATOR);
        TreeSet columnTitles = Sets.newTreeSet(GroupingComparators.getColumnTitleDynamicComparator(columnAggregations));
        TreeSet pivotValuesSet = Sets.newTreeSet(GroupingComparators.VALUE_LIST_COMPARATOR);
        MetaTable metaTable = new MetaTable();
        for (Object columnAggregation : columnAggregations) {
            for (AggregationPath aggregationPath : paths) {
                List<Value> originalValues = aggregationPath.getValues();
                List<Value> rowValues = originalValues.subList(0, groupByIds.size());
                RowTitle rowTitle = new RowTitle(rowValues);
                rowTitles.add(rowTitle);
                Iterator columnValues = originalValues.subList(groupByIds.size(), originalValues.size());
                pivotValuesSet.add(columnValues);
                ColumnTitle columnTitle = new ColumnTitle((List<Value>)((Object)columnValues), (AggregationColumn)columnAggregation, columnAggregations.size() > 1);
                columnTitles.add(columnTitle);
                metaTable.put(rowTitle, columnTitle, new TableCell(aggregator.getAggregationValue(aggregationPath, ((AggregationColumn)columnAggregation).getAggregatedColumn().getId(), ((AggregationColumn)columnAggregation).getAggregationType())));
            }
        }
        ArrayList scalarFunctionColumnTitles = Lists.newArrayList();
        for (ScalarFunctionColumn scalarFunctionColumn : selectedScalarFunctionColumns) {
            if (scalarFunctionColumn.getAllAggregationColumns().size() == 0) continue;
            for (List columnValues : pivotValuesSet) {
                scalarFunctionColumnTitles.add(new ScalarFunctionColumnTitle(columnValues, scalarFunctionColumn));
            }
        }
        DataTable result = QueryEngine.createDataTable((List<String>)groupByIds, columnTitles, table, scalarFunctionColumnTitles);
        List<ColumnDescription> colDescs = result.getColumnDescriptions();
        columnIndices.clear();
        boolean bl = false;
        if (group != null) {
            ArrayList empytListOfValues = Lists.newArrayList();
            columnLookups.put(empytListOfValues, new GenericColumnLookup());
            for (AbstractColumn column : group.getColumns()) {
                void var27_34;
                columnIndices.put(column, (int)var27_34);
                if (!(column instanceof ScalarFunctionColumn)) {
                    ((GenericColumnLookup)columnLookups.get(empytListOfValues)).put(column, (int)var27_34);
                    for (List columnValues : pivotValuesSet) {
                        if (!columnLookups.containsKey(columnValues)) {
                            columnLookups.put(columnValues, new GenericColumnLookup());
                        }
                        ((GenericColumnLookup)columnLookups.get(columnValues)).put(column, (int)var27_34);
                    }
                }
                ++var27_34;
            }
        }
        for (ColumnTitle title : columnTitles) {
            void var27_35;
            columnIndices.put(title.aggregation, (int)var27_35);
            values = title.getValues();
            if (!columnLookups.containsKey(values)) {
                columnLookups.put(values, new GenericColumnLookup());
            }
            ((GenericColumnLookup)columnLookups.get(values)).put(title.aggregation, (int)var27_35);
            ++var27_35;
        }
        for (RowTitle rowTitle : rowTitles) {
            TableRow curRow = new TableRow();
            for (Value v : rowTitle.values) {
                curRow.addCell(new TableCell(v));
            }
            Map<ColumnTitle, TableCell> rowData = metaTable.getRow(rowTitle);
            int i = 0;
            for (ColumnTitle colTitle : columnTitles) {
                TableCell cell = rowData.get(colTitle);
                curRow.addCell(cell != null ? cell : new TableCell(Value.getNullValueFromValueType(colDescs.get(i + rowTitle.values.size()).getType())));
                ++i;
            }
            for (ScalarFunctionColumnTitle columnTitle : scalarFunctionColumnTitles) {
                curRow.addCell(new TableCell(columnTitle.scalarFunctionColumn.getValue(columnLookups.get(columnTitle.getValues()), curRow)));
            }
            result.addRow(curRow);
        }
        for (ScalarFunctionColumnTitle scalarFunctionColumnTitle : scalarFunctionColumnTitles) {
            void var27_36;
            columnIndices.put(scalarFunctionColumnTitle.scalarFunctionColumn, (int)var27_36);
            values = scalarFunctionColumnTitle.getValues();
            if (!columnLookups.containsKey(values)) {
                columnLookups.put(values, new GenericColumnLookup());
            }
            ((GenericColumnLookup)columnLookups.get(values)).put(scalarFunctionColumnTitle.scalarFunctionColumn, (int)var27_36);
            ++var27_36;
        }
        return result;
    }

    private static DataTable performLabels(DataTable table, Query query, ColumnIndices columnIndices) {
        if (!query.hasLabels()) {
            return table;
        }
        QueryLabels labels = query.getLabels();
        List<ColumnDescription> columnDescriptions = table.getColumnDescriptions();
        for (AbstractColumn column : labels.getColumns()) {
            String label = labels.getLabel(column);
            List<Integer> indices = columnIndices.getColumnIndices(column);
            if (indices.size() == 1) {
                columnDescriptions.get(indices.get(0)).setLabel(label);
                continue;
            }
            String columnId = column.getId();
            for (int i : indices) {
                ColumnDescription colDesc = columnDescriptions.get(i);
                String colDescId = colDesc.getId();
                String specificLabel = colDescId.substring(0, colDescId.length() - columnId.length()) + label;
                columnDescriptions.get(i).setLabel(specificLabel);
            }
        }
        return table;
    }

    private static DataTable performFormatting(DataTable table, Query query, ColumnIndices columnIndices, ULocale locale) {
        if (!query.hasUserFormatOptions()) {
            return table;
        }
        QueryFormat queryFormat = query.getUserFormatOptions();
        List<ColumnDescription> columnDescriptions = table.getColumnDescriptions();
        HashMap indexToFormatter = Maps.newHashMap();
        for (AbstractColumn col : queryFormat.getColumns()) {
            String pattern = queryFormat.getPattern(col);
            List<Integer> indices = columnIndices.getColumnIndices(col);
            boolean allSucceeded = true;
            for (int i : indices) {
                ColumnDescription colDesc = columnDescriptions.get(i);
                ValueFormatter f = ValueFormatter.createFromPattern(colDesc.getType(), pattern, locale);
                if (f == null) {
                    allSucceeded = false;
                    continue;
                }
                indexToFormatter.put(i, f);
                table.getColumnDescription(i).setPattern(pattern);
            }
            if (allSucceeded) continue;
            Warning warning = new Warning(ReasonType.ILLEGAL_FORMATTING_PATTERNS, "Illegal formatting pattern: " + pattern + " requested on column: " + col.getId());
            table.addWarning(warning);
        }
        for (TableRow row : table.getRows()) {
            Iterator iterator = indexToFormatter.keySet().iterator();
            while (iterator.hasNext()) {
                int col = (Integer)iterator.next();
                TableCell cell = row.getCell(col);
                Value value = cell.getValue();
                ValueFormatter formatter = (ValueFormatter)indexToFormatter.get(col);
                String formattedValue = formatter.format(value);
                cell.setFormattedValue(formattedValue);
            }
        }
        return table;
    }
}

