/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.query.engine;

import com.google.common.collect.Ordering;
import com.google.visualization.datasource.datatable.value.Value;
import com.google.visualization.datasource.query.AggregationColumn;
import com.google.visualization.datasource.query.engine.ColumnTitle;
import com.google.visualization.datasource.query.engine.RowTitle;
import java.util.Comparator;
import java.util.List;

class GroupingComparators {
    public static final Comparator<List<Value>> VALUE_LIST_COMPARATOR = new Comparator<List<Value>>(){

        @Override
        public int compare(List<Value> l1, List<Value> l2) {
            int localCompare;
            int i;
            for (i = 0; i < Math.min(l1.size(), l2.size()); ++i) {
                localCompare = l1.get(i).compareTo(l2.get(i));
                if (localCompare == 0) continue;
                return localCompare;
            }
            localCompare = i < l1.size() ? 1 : (i < l2.size() ? -1 : 0);
            return localCompare;
        }
    };
    public static final Comparator<RowTitle> ROW_TITLE_COMPARATOR = new Comparator<RowTitle>(){

        @Override
        public int compare(RowTitle col1, RowTitle col2) {
            return VALUE_LIST_COMPARATOR.compare(col1.values, col2.values);
        }
    };

    public static Comparator<ColumnTitle> getColumnTitleDynamicComparator(List<AggregationColumn> columnAggregations) {
        return new ColumnTitleDynamicComparator(columnAggregations);
    }

    private GroupingComparators() {
    }

    private static class ColumnTitleDynamicComparator
    implements Comparator<ColumnTitle> {
        private Comparator<AggregationColumn> aggregationsComparator;

        public ColumnTitleDynamicComparator(List<AggregationColumn> aggregations) {
            this.aggregationsComparator = Ordering.explicit(aggregations);
        }

        @Override
        public int compare(ColumnTitle col1, ColumnTitle col2) {
            int listCompare = VALUE_LIST_COMPARATOR.compare(col1.getValues(), col2.getValues());
            if (listCompare != 0) {
                return listCompare;
            }
            return this.aggregationsComparator.compare(col1.aggregation, col2.aggregation);
        }
    }
}

