/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.query;

import com.google.common.collect.Lists;
import com.google.visualization.datasource.base.InvalidQueryException;
import com.google.visualization.datasource.datatable.DataTable;
import com.google.visualization.datasource.datatable.TableCell;
import com.google.visualization.datasource.datatable.TableRow;
import com.google.visualization.datasource.datatable.value.ValueType;
import com.google.visualization.datasource.query.AbstractColumn;
import com.google.visualization.datasource.query.AggregationColumn;
import com.google.visualization.datasource.query.ColumnLookup;
import com.google.visualization.datasource.query.SimpleColumn;
import com.google.visualization.datasource.query.scalarfunction.ScalarFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.text.StrBuilder;

public class ScalarFunctionColumn
extends AbstractColumn {
    public static final String COLUMN_FUNCTION_TYPE_SEPARATOR = "_";
    public static final String COLUMN_COLUMN_SEPARATOR = ",";
    private List<AbstractColumn> columns;
    private ScalarFunction scalarFunction;

    public ScalarFunctionColumn(List<AbstractColumn> columns, ScalarFunction scalarFunction) {
        this.columns = columns;
        this.scalarFunction = scalarFunction;
    }

    @Override
    public String getId() {
        ArrayList colIds = Lists.newArrayList();
        for (AbstractColumn col : this.columns) {
            colIds.add(col.getId());
        }
        return new StrBuilder(this.scalarFunction.getFunctionName()).append(COLUMN_FUNCTION_TYPE_SEPARATOR).appendWithSeparators((Collection)colIds, COLUMN_COLUMN_SEPARATOR).toString();
    }

    @Override
    public List<String> getAllSimpleColumnIds() {
        ArrayList columnIds = Lists.newArrayList();
        for (AbstractColumn column : this.columns) {
            columnIds.addAll(column.getAllSimpleColumnIds());
        }
        return columnIds;
    }

    public ScalarFunction getFunction() {
        return this.scalarFunction;
    }

    public List<AbstractColumn> getColumns() {
        return this.columns;
    }

    @Override
    public TableCell getCell(ColumnLookup lookup, TableRow row) {
        if (lookup.containsColumn(this)) {
            int columnIndex = lookup.getColumnIndex(this);
            return row.getCells().get(columnIndex);
        }
        ArrayList functionParameters = Lists.newArrayListWithCapacity((int)this.columns.size());
        for (AbstractColumn column : this.columns) {
            functionParameters.add(column.getValue(lookup, row));
        }
        return new TableCell(this.scalarFunction.evaluate(functionParameters));
    }

    @Override
    public List<SimpleColumn> getAllSimpleColumns() {
        ArrayList simpleColumns = Lists.newArrayListWithCapacity((int)this.columns.size());
        for (AbstractColumn column : this.columns) {
            simpleColumns.addAll(column.getAllSimpleColumns());
        }
        return simpleColumns;
    }

    @Override
    public List<AggregationColumn> getAllAggregationColumns() {
        ArrayList aggregationColumns = Lists.newArrayListWithCapacity((int)this.columns.size());
        for (AbstractColumn column : this.columns) {
            aggregationColumns.addAll(column.getAllAggregationColumns());
        }
        return aggregationColumns;
    }

    @Override
    public List<ScalarFunctionColumn> getAllScalarFunctionColumns() {
        ArrayList scalarFunctionColumns = Lists.newArrayList((Object[])new ScalarFunctionColumn[]{this});
        for (AbstractColumn column : this.columns) {
            scalarFunctionColumns.addAll(column.getAllScalarFunctionColumns());
        }
        return scalarFunctionColumns;
    }

    @Override
    public void validateColumn(DataTable dataTable) throws InvalidQueryException {
        ArrayList types = Lists.newArrayListWithCapacity((int)this.columns.size());
        for (AbstractColumn column : this.columns) {
            column.validateColumn(dataTable);
            types.add(column.getValueType(dataTable));
        }
        this.scalarFunction.validateParameters(types);
    }

    @Override
    public ValueType getValueType(DataTable dataTable) {
        if (dataTable.containsColumn(this.getId())) {
            return dataTable.getColumnDescription(this.getId()).getType();
        }
        ArrayList types = Lists.newArrayListWithCapacity((int)this.columns.size());
        for (AbstractColumn column : this.columns) {
            types.add(column.getValueType(dataTable));
        }
        return this.scalarFunction.getReturnType(types);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof ScalarFunctionColumn) {
            ScalarFunctionColumn other = (ScalarFunctionColumn)o;
            return this.columns.equals(other.columns) && this.scalarFunction.equals(other.scalarFunction);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 1279;
        for (AbstractColumn column : this.columns) {
            hash = hash * 17 + column.hashCode();
        }
        hash = hash * 17 + this.scalarFunction.hashCode();
        return hash;
    }

    @Override
    public String toQueryString() {
        ArrayList columnQueryStrings = Lists.newArrayList();
        for (AbstractColumn column : this.columns) {
            columnQueryStrings.add(column.toQueryString());
        }
        return this.scalarFunction.toQueryString(columnQueryStrings);
    }

    public String toString() {
        ArrayList colNames = Lists.newArrayList();
        for (AbstractColumn col : this.columns) {
            colNames.add(col.toString());
        }
        return new StrBuilder(this.scalarFunction.getFunctionName()).append("(").appendWithSeparators((Collection)colNames, COLUMN_COLUMN_SEPARATOR).append(")").toString();
    }
}

