/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.query;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.visualization.datasource.query.AbstractColumn;
import com.google.visualization.datasource.query.AggregationColumn;
import com.google.visualization.datasource.query.ColumnSort;
import com.google.visualization.datasource.query.ScalarFunctionColumn;
import com.google.visualization.datasource.query.SortOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.text.StrBuilder;

public class QuerySort {
    private List<ColumnSort> sortColumns = Lists.newArrayList();

    public boolean isEmpty() {
        return this.sortColumns.isEmpty();
    }

    public void addSort(ColumnSort columnSort) {
        this.sortColumns.add(columnSort);
    }

    public void addSort(AbstractColumn column, SortOrder order) {
        this.addSort(new ColumnSort(column, order));
    }

    public List<ColumnSort> getSortColumns() {
        return ImmutableList.copyOf(this.sortColumns);
    }

    public List<AbstractColumn> getColumns() {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)this.sortColumns.size());
        for (ColumnSort columnSort : this.sortColumns) {
            result.add(columnSort.getColumn());
        }
        return result;
    }

    public List<AggregationColumn> getAggregationColumns() {
        ArrayList result = Lists.newArrayList();
        for (ColumnSort columnSort : this.sortColumns) {
            AbstractColumn col = columnSort.getColumn();
            for (AggregationColumn innerCol : col.getAllAggregationColumns()) {
                if (result.contains(innerCol)) continue;
                result.add(innerCol);
            }
        }
        return result;
    }

    public List<ScalarFunctionColumn> getScalarFunctionColumns() {
        ArrayList result = Lists.newArrayList();
        for (ColumnSort columnSort : this.sortColumns) {
            AbstractColumn col = columnSort.getColumn();
            for (ScalarFunctionColumn innerCol : col.getAllScalarFunctionColumns()) {
                if (result.contains(innerCol)) continue;
                result.add(innerCol);
            }
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.sortColumns == null ? 0 : this.sortColumns.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QuerySort other = (QuerySort)obj;
        return !(this.sortColumns == null ? other.sortColumns != null : !this.sortColumns.equals(other.sortColumns));
    }

    public String toQueryString() {
        StrBuilder builder = new StrBuilder();
        ArrayList stringList = Lists.newArrayList();
        for (ColumnSort colSort : this.sortColumns) {
            stringList.add(colSort.toQueryString());
        }
        builder.appendWithSeparators((Collection)stringList, ", ");
        return builder.toString();
    }
}

