/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.query;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.visualization.datasource.base.InvalidQueryException;
import com.google.visualization.datasource.query.AbstractColumn;
import com.google.visualization.datasource.query.AggregationColumn;
import com.google.visualization.datasource.query.Query;
import com.google.visualization.datasource.query.ScalarFunctionColumn;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.text.StrBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueryFormat {
    private static final Log log = LogFactory.getLog((String)QueryFormat.class.getName());
    private Map<AbstractColumn, String> columnPatterns = Maps.newHashMap();

    public void addPattern(AbstractColumn column, String pattern) throws InvalidQueryException {
        if (this.columnPatterns.keySet().contains(column)) {
            String messageToLogAndUser = "Column [" + column.toString() + "] is specified more than once in FORMAT.";
            log.error((Object)messageToLogAndUser);
            throw new InvalidQueryException(messageToLogAndUser);
        }
        this.columnPatterns.put(column, pattern);
    }

    public String getPattern(AbstractColumn column) {
        return this.columnPatterns.get(column);
    }

    public Set<AbstractColumn> getColumns() {
        return ImmutableSet.copyOf(this.columnPatterns.keySet());
    }

    public List<ScalarFunctionColumn> getScalarFunctionColumns() {
        ArrayList result = Lists.newArrayList();
        for (AbstractColumn col : this.columnPatterns.keySet()) {
            for (ScalarFunctionColumn innerCol : col.getAllScalarFunctionColumns()) {
                if (result.contains(innerCol)) continue;
                result.add(innerCol);
            }
        }
        return result;
    }

    public List<AggregationColumn> getAggregationColumns() {
        ArrayList result = Lists.newArrayList();
        for (AbstractColumn col : this.columnPatterns.keySet()) {
            result.addAll(col.getAllAggregationColumns());
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.columnPatterns == null ? 0 : this.columnPatterns.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QueryFormat other = (QueryFormat)obj;
        return !(this.columnPatterns == null ? other.columnPatterns != null : !this.columnPatterns.equals(other.columnPatterns));
    }

    public String toQueryString() {
        StrBuilder builder = new StrBuilder();
        ArrayList stringList = Lists.newArrayList();
        for (AbstractColumn col : this.columnPatterns.keySet()) {
            String pattern = this.columnPatterns.get(col);
            stringList.add(col.toQueryString() + " " + Query.stringToQueryStringLiteral(pattern));
        }
        builder.appendWithSeparators((Collection)stringList, ", ");
        return builder.toString();
    }
}

