/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.query;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.visualization.datasource.datatable.DataTable;
import com.google.visualization.datasource.datatable.TableRow;
import com.google.visualization.datasource.query.AggregationColumn;
import com.google.visualization.datasource.query.QueryFilter;
import com.google.visualization.datasource.query.ScalarFunctionColumn;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.text.StrBuilder;

public class CompoundFilter
extends QueryFilter {
    private List<QueryFilter> subFilters;
    private LogicalOperator operator;

    public CompoundFilter(LogicalOperator operator, List<QueryFilter> subFilters) {
        this.subFilters = subFilters;
        this.operator = operator;
    }

    @Override
    public boolean isMatch(DataTable table, TableRow row) {
        if (this.subFilters.isEmpty()) {
            throw new RuntimeException("Compound filter with empty subFilters list");
        }
        for (QueryFilter subFilter : this.subFilters) {
            boolean result = subFilter.isMatch(table, row);
            if ((this.operator != LogicalOperator.AND || result) && (this.operator != LogicalOperator.OR || !result)) continue;
            return result;
        }
        return this.operator == LogicalOperator.AND;
    }

    @Override
    public Set<String> getAllColumnIds() {
        HashSet result = Sets.newHashSet();
        for (QueryFilter subFilter : this.subFilters) {
            result.addAll(subFilter.getAllColumnIds());
        }
        return result;
    }

    @Override
    public List<ScalarFunctionColumn> getScalarFunctionColumns() {
        ArrayList result = Lists.newArrayList();
        for (QueryFilter subFilter : this.subFilters) {
            result.addAll(subFilter.getScalarFunctionColumns());
        }
        return result;
    }

    @Override
    protected List<AggregationColumn> getAggregationColumns() {
        ArrayList result = Lists.newArrayList();
        for (QueryFilter subFilter : this.subFilters) {
            result.addAll(subFilter.getAggregationColumns());
        }
        return result;
    }

    public List<QueryFilter> getSubFilters() {
        return ImmutableList.copyOf(this.subFilters);
    }

    public LogicalOperator getOperator() {
        return this.operator;
    }

    @Override
    public String toQueryString() {
        ArrayList subFilterStrings = Lists.newArrayList();
        for (QueryFilter filter : this.subFilters) {
            subFilterStrings.add("(" + filter.toQueryString() + ")");
        }
        return new StrBuilder().appendWithSeparators((Collection)subFilterStrings, " " + this.operator.name() + " ").toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.operator == null ? 0 : this.operator.hashCode());
        result = 31 * result + (this.subFilters == null ? 0 : this.subFilters.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CompoundFilter other = (CompoundFilter)obj;
        if (this.operator == null ? other.operator != null : !this.operator.equals((Object)other.operator)) {
            return false;
        }
        return !(this.subFilters == null ? other.subFilters != null : !this.subFilters.equals(other.subFilters));
    }

    public static enum LogicalOperator {
        AND,
        OR;

    }
}

