/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.query;

import com.google.common.collect.Sets;
import com.google.visualization.datasource.datatable.DataTable;
import com.google.visualization.datasource.datatable.TableRow;
import com.google.visualization.datasource.query.AbstractColumn;
import com.google.visualization.datasource.query.AggregationColumn;
import com.google.visualization.datasource.query.DataTableColumnLookup;
import com.google.visualization.datasource.query.QueryFilter;
import com.google.visualization.datasource.query.ScalarFunctionColumn;
import java.util.List;
import java.util.Set;

public class ColumnIsNullFilter
extends QueryFilter {
    private AbstractColumn column;

    public ColumnIsNullFilter(AbstractColumn column) {
        this.column = column;
    }

    public AbstractColumn getColumn() {
        return this.column;
    }

    @Override
    public Set<String> getAllColumnIds() {
        return Sets.newHashSet(this.column.getAllSimpleColumnIds());
    }

    @Override
    public List<ScalarFunctionColumn> getScalarFunctionColumns() {
        return this.column.getAllScalarFunctionColumns();
    }

    @Override
    protected List<AggregationColumn> getAggregationColumns() {
        return this.column.getAllAggregationColumns();
    }

    @Override
    public boolean isMatch(DataTable table, TableRow row) {
        DataTableColumnLookup lookup = new DataTableColumnLookup(table);
        return this.column.getValue(lookup, row).isNull();
    }

    @Override
    public String toQueryString() {
        return this.column.toQueryString() + " IS NULL";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.column == null ? 0 : this.column.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ColumnIsNullFilter other = (ColumnIsNullFilter)obj;
        return !(this.column == null ? other.column != null : !this.column.equals(other.column));
    }
}

