/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.query;

import com.google.common.collect.Maps;
import java.util.Map;

public enum AggregationType {
    SUM("sum"),
    COUNT("count"),
    MIN("min"),
    MAX("max"),
    AVG("avg");

    private String code;
    private static Map<String, AggregationType> codeToAggregationType;

    private AggregationType(String code) {
        this.code = code.toUpperCase();
    }

    public String getCode() {
        return this.code;
    }

    public static AggregationType getByCode(String code) {
        AggregationType agg = codeToAggregationType.get(code);
        if (agg == null) {
            throw new RuntimeException("Illegal Aggregation Code (" + code + ")");
        }
        return agg;
    }

    static {
        codeToAggregationType = Maps.newHashMap();
        for (AggregationType type : AggregationType.values()) {
            codeToAggregationType.put(type.code, type);
        }
    }
}

