/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.datatable.value;

import com.google.common.collect.Maps;
import com.google.visualization.datasource.base.TypeMismatchException;
import com.google.visualization.datasource.datatable.value.BooleanValue;
import com.google.visualization.datasource.datatable.value.DateTimeValue;
import com.google.visualization.datasource.datatable.value.DateValue;
import com.google.visualization.datasource.datatable.value.NumberValue;
import com.google.visualization.datasource.datatable.value.TextValue;
import com.google.visualization.datasource.datatable.value.TimeOfDayValue;
import com.google.visualization.datasource.datatable.value.Value;
import com.ibm.icu.util.GregorianCalendar;
import java.util.Map;

public enum ValueType {
    BOOLEAN("BOOLEAN"),
    NUMBER("NUMBER"),
    TEXT("STRING"),
    DATE("DATE"),
    TIMEOFDAY("TIMEOFDAY"),
    DATETIME("DATETIME");

    private String typeCode;
    private static Map<String, ValueType> typeCodeToValueType;

    private ValueType(String typeCode) {
        this.typeCode = typeCode;
    }

    String getTypeCode() {
        return this.typeCode;
    }

    public String getTypeCodeLowerCase() {
        return this.typeCode.toLowerCase();
    }

    static ValueType getByTypeCode(String string) {
        return typeCodeToValueType.get(string);
    }

    public Value createValue(Object value) throws TypeMismatchException {
        Value ret = null;
        if (value == null) {
            ret = Value.getNullValueFromValueType(this);
        } else if (this == TEXT && (value instanceof String || value == null)) {
            ret = new TextValue((String)value);
        } else if (this == NUMBER && value instanceof Number) {
            ret = new NumberValue(((Number)value).doubleValue());
        } else if (this == BOOLEAN && value instanceof Boolean) {
            ret = (Boolean)value != false ? BooleanValue.TRUE : BooleanValue.FALSE;
        } else if (this == DATE && value instanceof GregorianCalendar) {
            ret = new DateValue((GregorianCalendar)value);
        } else if (this == DATETIME && value instanceof GregorianCalendar) {
            ret = new DateTimeValue((GregorianCalendar)value);
        } else if (this == TIMEOFDAY && value instanceof GregorianCalendar) {
            ret = new TimeOfDayValue((GregorianCalendar)value);
        }
        if (ret == null) {
            throw new TypeMismatchException("Value type mismatch.");
        }
        return ret;
    }

    static {
        typeCodeToValueType = Maps.newHashMap();
        for (ValueType type : ValueType.values()) {
            typeCodeToValueType.put(type.typeCode, type);
        }
    }
}

