/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.datatable.value;

import com.google.visualization.datasource.datatable.value.NullValueException;
import com.google.visualization.datasource.datatable.value.Value;
import com.google.visualization.datasource.datatable.value.ValueType;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.GregorianCalendar;
import com.ibm.icu.util.TimeZone;

public class TimeOfDayValue
extends Value {
    private static final TimeOfDayValue NULL_VALUE = new TimeOfDayValue();
    private int hours;
    private int minutes;
    private int seconds;
    private int milliseconds;
    private Integer hashCode = null;

    public static TimeOfDayValue getNullValue() {
        return NULL_VALUE;
    }

    private TimeOfDayValue() {
        this.hashCode = 0;
    }

    public TimeOfDayValue(int hours, int minutes, int seconds) {
        this(hours, minutes, seconds, 0);
    }

    public TimeOfDayValue(int hours, int minutes, int seconds, int milliseconds) {
        if (hours >= 24 || hours < 0) {
            throw new IllegalArgumentException("This hours value is invalid: " + hours);
        }
        if (minutes >= 60 || minutes < 0) {
            throw new IllegalArgumentException("This minutes value is invalid: " + minutes);
        }
        if (seconds >= 60 || seconds < 0) {
            throw new IllegalArgumentException("This seconds value is invalid: " + seconds);
        }
        if (milliseconds >= 1000 || milliseconds < 0) {
            throw new IllegalArgumentException("This milliseconds value is invalid: " + milliseconds);
        }
        this.hours = hours;
        this.minutes = minutes;
        this.seconds = seconds;
        this.milliseconds = milliseconds;
    }

    public TimeOfDayValue(GregorianCalendar calendar) {
        if (!calendar.getTimeZone().equals((Object)TimeZone.getTimeZone((String)"GMT"))) {
            throw new IllegalArgumentException("Can't create TimeOfDayValue from GregorianCalendar that is not GMT.");
        }
        this.hours = calendar.get(11);
        this.minutes = calendar.get(12);
        this.seconds = calendar.get(13);
        this.milliseconds = calendar.get(14);
    }

    @Override
    public ValueType getType() {
        return ValueType.TIMEOFDAY;
    }

    public String toString() {
        if (this == NULL_VALUE) {
            return "null";
        }
        String result = String.format("%1$02d:%2$02d:%3$02d", this.hours, this.minutes, this.seconds);
        if (this.milliseconds > 0) {
            result = result + "." + String.format("%1$3d", this.milliseconds);
        }
        return result;
    }

    @Override
    public boolean isNull() {
        return this == NULL_VALUE;
    }

    @Override
    public int compareTo(Value other) {
        if (this == other) {
            return 0;
        }
        TimeOfDayValue otherTimeOfDay = (TimeOfDayValue)other;
        if (this.isNull()) {
            return -1;
        }
        if (otherTimeOfDay.isNull()) {
            return 1;
        }
        if (this.hours > otherTimeOfDay.hours) {
            return 1;
        }
        if (this.hours < otherTimeOfDay.hours) {
            return -1;
        }
        if (this.minutes > otherTimeOfDay.minutes) {
            return 1;
        }
        if (this.minutes < otherTimeOfDay.minutes) {
            return -1;
        }
        if (this.seconds > otherTimeOfDay.seconds) {
            return 1;
        }
        if (this.seconds < otherTimeOfDay.seconds) {
            return -1;
        }
        if (this.milliseconds > otherTimeOfDay.milliseconds) {
            return 1;
        }
        if (this.milliseconds < otherTimeOfDay.milliseconds) {
            return -1;
        }
        return 0;
    }

    @Override
    public int hashCode() {
        if (null != this.hashCode) {
            return this.hashCode;
        }
        int hash = 1193;
        hash = hash * 13 + this.hours;
        hash = hash * 13 + this.minutes;
        hash = hash * 13 + this.seconds;
        hash = hash * 13 + this.milliseconds;
        this.hashCode = hash;
        return this.hashCode;
    }

    public Calendar getObjectToFormat() {
        if (this.isNull()) {
            return null;
        }
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone((String)"GMT"));
        cal.set(1, 1899);
        cal.set(2, 11);
        cal.set(5, 30);
        cal.set(11, this.hours);
        cal.set(12, this.minutes);
        cal.set(13, this.seconds);
        cal.set(14, this.milliseconds);
        return cal;
    }

    public int getHours() {
        if (this.isNull()) {
            throw new NullValueException("This object is null");
        }
        return this.hours;
    }

    public int getMinutes() {
        if (this.isNull()) {
            throw new NullValueException("This object is null");
        }
        return this.minutes;
    }

    public int getSeconds() {
        if (this.isNull()) {
            throw new NullValueException("This object is null");
        }
        return this.seconds;
    }

    public int getMilliseconds() {
        if (this.isNull()) {
            throw new NullValueException("This object is null");
        }
        return this.milliseconds;
    }

    @Override
    protected String innerToQueryString() {
        String s = "TIMEOFDAY '" + this.hours + ":" + this.minutes + ":" + this.seconds;
        if (this.milliseconds != 0) {
            s = s + "." + this.milliseconds;
        }
        s = s + "'";
        return s;
    }
}

