/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.datatable.value;

import com.google.visualization.datasource.datatable.value.NullValueException;
import com.google.visualization.datasource.datatable.value.Value;
import com.google.visualization.datasource.datatable.value.ValueType;

public class NumberValue
extends Value {
    private static final NumberValue NULL_VALUE = new NumberValue(-9999.0);
    private double value;

    public static NumberValue getNullValue() {
        return NULL_VALUE;
    }

    public NumberValue(double value) {
        this.value = value;
    }

    @Override
    public ValueType getType() {
        return ValueType.NUMBER;
    }

    public double getValue() {
        if (this == NULL_VALUE) {
            throw new NullValueException("This null number has no value");
        }
        return this.value;
    }

    public String toString() {
        if (this == NULL_VALUE) {
            return "null";
        }
        return Double.toString(this.value);
    }

    @Override
    public boolean isNull() {
        return this == NULL_VALUE;
    }

    @Override
    public int compareTo(Value other) {
        if (this == other) {
            return 0;
        }
        NumberValue otherNumber = (NumberValue)other;
        if (this.isNull()) {
            return -1;
        }
        if (otherNumber.isNull()) {
            return 1;
        }
        return Double.compare(this.value, otherNumber.value);
    }

    @Override
    public int hashCode() {
        if (this.isNull()) {
            return 0;
        }
        return new Double(this.value).hashCode();
    }

    @Override
    public Number getObjectToFormat() {
        if (this.isNull()) {
            return null;
        }
        return this.value;
    }

    @Override
    protected String innerToQueryString() {
        return Double.toString(this.value);
    }
}

