/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.datatable;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.visualization.datasource.datatable.TableCell;
import com.google.visualization.datasource.datatable.value.Value;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class TableRow {
    private List<TableCell> cells = Lists.newArrayList();
    private Map<String, String> customProperties = null;

    public void addCell(TableCell cell) {
        this.cells.add(cell);
    }

    public void addCell(Value value) {
        this.addCell(new TableCell(value));
    }

    public void addCell(double value) {
        this.addCell(new TableCell(value));
    }

    public void addCell(boolean value) {
        this.addCell(new TableCell(value));
    }

    public void addCell(String value) {
        this.addCell(new TableCell(value));
    }

    public List<TableCell> getCells() {
        return ImmutableList.copyOf(this.cells);
    }

    public TableCell getCell(int index) {
        return this.cells.get(index);
    }

    TableCell setCell(int index, TableCell cell) throws IndexOutOfBoundsException {
        return this.cells.set(index, cell);
    }

    public String getCustomProperty(String key) {
        if (this.customProperties == null) {
            return null;
        }
        if (key == null) {
            throw new RuntimeException("Null keys are not allowed.");
        }
        return this.customProperties.get(key);
    }

    public void setCustomProperty(String propertyKey, String propertyValue) {
        if (this.customProperties == null) {
            this.customProperties = Maps.newHashMap();
        }
        if (propertyKey == null || propertyValue == null) {
            throw new RuntimeException("Null keys/values are not allowed.");
        }
        this.customProperties.put(propertyKey, propertyValue);
    }

    public Map<String, String> getCustomProperties() {
        if (this.customProperties == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.customProperties);
    }

    public TableRow clone() {
        TableRow result = new TableRow();
        for (TableCell tableCell : this.cells) {
            result.addCell(tableCell.clone());
        }
        if (this.customProperties != null) {
            result.customProperties = Maps.newHashMap();
            for (Map.Entry entry : this.customProperties.entrySet()) {
                result.customProperties.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return result;
    }
}

