/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.datatable;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.visualization.datasource.base.TypeMismatchException;
import com.google.visualization.datasource.base.Warning;
import com.google.visualization.datasource.datatable.ColumnDescription;
import com.google.visualization.datasource.datatable.TableCell;
import com.google.visualization.datasource.datatable.TableRow;
import com.google.visualization.datasource.datatable.value.Value;
import com.google.visualization.datasource.datatable.value.ValueType;
import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeSet;

public class DataTable {
    private List<ColumnDescription> columns = Lists.newArrayList();
    private Map<String, Integer> columnIndexById = Maps.newHashMap();
    private List<TableRow> rows = Lists.newArrayList();
    private Map<String, String> customProperties = null;
    private List<Warning> warnings = Lists.newArrayList();
    private ULocale localeForUserMessages = null;

    public void addRow(TableRow row) throws TypeMismatchException {
        int i;
        List<TableCell> cells = row.getCells();
        if (cells.size() > this.columns.size()) {
            throw new TypeMismatchException("Row has too many cells. Should be at most of size: " + this.columns.size());
        }
        for (i = 0; i < cells.size(); ++i) {
            if (cells.get(i).getType() == this.columns.get(i).getType()) continue;
            throw new TypeMismatchException("Cell type does not match column type, at index: " + i + ". Should be of type: " + this.columns.get(i).getType().toString());
        }
        for (i = cells.size(); i < this.columns.size(); ++i) {
            row.addCell(new TableCell(Value.getNullValueFromValueType(this.columns.get(i).getType())));
        }
        this.rows.add(row);
    }

    public void addRowFromValues(Object ... values) throws TypeMismatchException {
        ListIterator<ColumnDescription> columnIt = this.columns.listIterator();
        TableRow row = new TableRow();
        for (int i = 0; i < values.length && columnIt.hasNext(); ++i) {
            ColumnDescription colDesc = (ColumnDescription)columnIt.next();
            row.addCell(colDesc.getType().createValue(values[i]));
        }
        this.addRow(row);
    }

    public void addRows(Collection<TableRow> rowsToAdd) throws TypeMismatchException {
        for (TableRow row : rowsToAdd) {
            this.addRow(row);
        }
    }

    public void setRows(Collection<TableRow> rows) throws TypeMismatchException {
        this.rows.clear();
        this.addRows(rows);
    }

    public List<TableRow> getRows() {
        return this.rows;
    }

    public TableRow getRow(int rowIndex) {
        return this.rows.get(rowIndex);
    }

    public int getNumberOfRows() {
        return this.rows.size();
    }

    public int getNumberOfColumns() {
        return this.columns.size();
    }

    public List<ColumnDescription> getColumnDescriptions() {
        return ImmutableList.copyOf(this.columns);
    }

    public ColumnDescription getColumnDescription(int colIndex) {
        return this.columns.get(colIndex);
    }

    public ColumnDescription getColumnDescription(String columnId) {
        return this.columns.get(this.getColumnIndex(columnId));
    }

    public List<TableCell> getColumnCells(int columnIndex) {
        ArrayList colCells = Lists.newArrayListWithCapacity((int)this.getNumberOfRows());
        for (TableRow row : this.getRows()) {
            colCells.add(row.getCell(columnIndex));
        }
        return colCells;
    }

    public void addColumn(ColumnDescription columnDescription) {
        String columnId = columnDescription.getId();
        if (this.columnIndexById.containsKey(columnId)) {
            throw new RuntimeException("Column Id [" + columnId + "] already in table description");
        }
        this.columnIndexById.put(columnId, this.columns.size());
        this.columns.add(columnDescription);
        for (TableRow row : this.rows) {
            row.addCell(new TableCell(Value.getNullValueFromValueType(columnDescription.getType())));
        }
    }

    public void addColumns(Collection<ColumnDescription> columnsToAdd) {
        for (ColumnDescription column : columnsToAdd) {
            this.addColumn(column);
        }
    }

    public int getColumnIndex(String columnId) {
        return this.columnIndexById.get(columnId);
    }

    public List<TableCell> getColumnCells(String columnId) {
        return this.getColumnCells(this.getColumnIndex(columnId));
    }

    public TableCell getCell(int rowIndex, int colIndex) {
        return this.getRow(rowIndex).getCell(colIndex);
    }

    public TableCell setCell(int rowIndex, int colIndex, TableCell cell) throws TypeMismatchException, IndexOutOfBoundsException {
        TableRow row = this.rows.get(rowIndex);
        if (!row.getCell(colIndex).getType().equals((Object)cell.getType())) {
            throw new TypeMismatchException("New cell value type does not match expected value type. Expected type: " + (Object)((Object)row.getCell(colIndex).getType()) + " but was: " + cell.getType().toString());
        }
        return row.setCell(colIndex, cell);
    }

    public Value getValue(int rowIndex, int colIndex) {
        return this.getCell(rowIndex, colIndex).getValue();
    }

    public List<Warning> getWarnings() {
        return ImmutableList.copyOf(this.warnings);
    }

    public List<TableCell> getColumnDistinctCellsSorted(int columnIndex, Comparator<TableCell> comparator) {
        TreeSet colCells = Sets.newTreeSet(comparator);
        for (TableCell cell : this.getColumnCells(columnIndex)) {
            colCells.add(cell);
        }
        return Ordering.from(comparator).sortedCopy((Iterable)colCells);
    }

    List<Value> getColumnDistinctValues(int columnIndex) {
        TreeSet values = Sets.newTreeSet();
        for (TableRow row : this.getRows()) {
            values.add(row.getCell(columnIndex).getValue());
        }
        return Lists.newArrayList((Iterable)values);
    }

    public void addWarning(Warning warning) {
        this.warnings.add(warning);
    }

    List<Value> getColumnDistinctValues(String columnId) {
        return this.getColumnDistinctValues(this.getColumnIndex(columnId));
    }

    public boolean containsColumn(String columnId) {
        return this.columnIndexById.containsKey(columnId);
    }

    public boolean containsAllColumnIds(Collection<String> colIds) {
        for (String id : colIds) {
            if (this.containsColumn(id)) continue;
            return false;
        }
        return true;
    }

    public static DataTable createSingleCellTable(String str) {
        DataTable dataTable = new DataTable();
        ColumnDescription colDesc = new ColumnDescription("SingleCellTable", ValueType.TEXT, "");
        dataTable.addColumn(colDesc);
        TableRow row = new TableRow();
        row.addCell(new TableCell(str));
        try {
            dataTable.addRow(row);
        }
        catch (TypeMismatchException typeMismatchException) {
            // empty catch block
        }
        return dataTable;
    }

    public DataTable clone() {
        DataTable result = new DataTable();
        for (ColumnDescription columnDescription : this.columns) {
            result.addColumn(columnDescription.clone());
        }
        try {
            for (TableRow tableRow : this.rows) {
                result.addRow(tableRow.clone());
            }
        }
        catch (TypeMismatchException typeMismatchException) {
            // empty catch block
        }
        if (this.customProperties != null) {
            result.customProperties = Maps.newHashMap();
            for (Map.Entry entry : this.customProperties.entrySet()) {
                result.customProperties.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        result.warnings = Lists.newArrayList();
        for (Warning warning : this.warnings) {
            result.warnings.add(warning);
        }
        result.setLocaleForUserMessages(this.localeForUserMessages);
        return result;
    }

    public String getCustomProperty(String key) {
        if (this.customProperties == null) {
            return null;
        }
        if (key == null) {
            throw new RuntimeException("Null keys are not allowed.");
        }
        return this.customProperties.get(key);
    }

    public void setCustomProperty(String propertyKey, String propertyValue) {
        if (this.customProperties == null) {
            this.customProperties = Maps.newHashMap();
        }
        if (propertyKey == null || propertyValue == null) {
            throw new RuntimeException("Null keys/values are not allowed.");
        }
        this.customProperties.put(propertyKey, propertyValue);
    }

    public Map<String, String> getCustomProperties() {
        if (this.customProperties == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.customProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int rowIndex = 0; rowIndex < this.rows.size(); ++rowIndex) {
            TableRow tableRow = this.rows.get(rowIndex);
            for (int cellIndex = 0; cellIndex < tableRow.getCells().size(); ++cellIndex) {
                TableCell tableCell = tableRow.getCells().get(cellIndex);
                sb.append(tableCell.toString());
                if (cellIndex >= tableRow.getCells().size() - 1) continue;
                sb.append(",");
            }
            if (rowIndex >= this.rows.size() - 1) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public void setLocaleForUserMessages(ULocale localeForUserMessges) {
        this.localeForUserMessages = localeForUserMessges;
    }

    public ULocale getLocaleForUserMessages() {
        return this.localeForUserMessages;
    }
}

