/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.base;

import com.google.visualization.datasource.base.DataSourceException;
import com.google.visualization.datasource.base.LocaleUtil;
import com.google.visualization.datasource.base.ReasonType;
import com.google.visualization.datasource.base.StatusType;

public class ResponseStatus {
    private StatusType statusType;
    private ReasonType reasonType;
    private String description;
    public static final String SIGN_IN_MESSAGE_KEY = "SIGN_IN";

    public ResponseStatus(StatusType statusType, ReasonType reasonType, String description) {
        this.statusType = statusType;
        this.reasonType = reasonType;
        this.description = description;
    }

    public static ResponseStatus createResponseStatus(DataSourceException dse) {
        return new ResponseStatus(StatusType.ERROR, dse.getReasonType(), dse.getMessageToUser());
    }

    public static ResponseStatus getModifiedResponseStatus(ResponseStatus responseStatus) {
        String msg;
        String signInString = LocaleUtil.getLocalizedMessageFromBundle("com.google.visualization.datasource.base.ErrorMessages", SIGN_IN_MESSAGE_KEY, null);
        if (responseStatus.getReasonType() == ReasonType.USER_NOT_AUTHENTICATED && !(msg = responseStatus.getDescription()).contains(" ") && (msg.startsWith("http://") || msg.startsWith("https://"))) {
            StringBuilder sb = new StringBuilder("<a target=\"_blank\" href=\"").append(msg).append("\">").append(signInString).append("</a>");
            responseStatus = new ResponseStatus(responseStatus.getStatusType(), responseStatus.getReasonType(), sb.toString());
        }
        return responseStatus;
    }

    public ResponseStatus(StatusType statusType) {
        this(statusType, null, null);
    }

    public StatusType getStatusType() {
        return this.statusType;
    }

    public ReasonType getReasonType() {
        return this.reasonType;
    }

    public String getDescription() {
        return this.description;
    }
}

