/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource;

import com.google.visualization.datasource.base.DataSourceParameters;
import com.google.visualization.datasource.base.OutputType;
import java.io.IOException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

public class ResponseWriter {
    private static final byte[] UTF_16LE_BOM = new byte[]{-1, -2};

    private ResponseWriter() {
    }

    public static void setServletResponse(String responseMessage, DataSourceParameters dataSourceParameters, HttpServletResponse res) throws IOException {
        OutputType type = dataSourceParameters.getOutputType();
        switch (type) {
            case CSV: {
                ResponseWriter.setServletResponseCSV(dataSourceParameters, res);
                ResponseWriter.writeServletResponse(responseMessage, res);
                break;
            }
            case TSV_EXCEL: {
                ResponseWriter.setServletResponseTSVExcel(dataSourceParameters, res);
                ResponseWriter.writeServletResponse(responseMessage, res, "UTF-16LE", UTF_16LE_BOM);
                break;
            }
            case HTML: {
                ResponseWriter.setServletResponseHTML(res);
                ResponseWriter.writeServletResponse(responseMessage, res);
                break;
            }
            case JSONP: {
                ResponseWriter.setServletResponseJSONP(res);
                ResponseWriter.writeServletResponse(responseMessage, res);
                break;
            }
            case JSON: {
                ResponseWriter.setServletResponseJSON(res);
                ResponseWriter.writeServletResponse(responseMessage, res);
                break;
            }
            default: {
                throw new RuntimeException("Unhandled output type.");
            }
        }
    }

    static void setServletResponseCSV(DataSourceParameters dataSourceParameters, HttpServletResponse res) {
        res.setContentType("text/csv; charset=UTF-8");
        String outFileName = dataSourceParameters.getOutFileName();
        if (!outFileName.toLowerCase().endsWith(".csv")) {
            outFileName = outFileName + ".csv";
        }
        res.setHeader("Content-Disposition", "attachment; filename=" + outFileName);
    }

    static void setServletResponseTSVExcel(DataSourceParameters dsParams, HttpServletResponse res) {
        res.setContentType("text/csv; charset=UTF-16LE");
        String outFileName = dsParams.getOutFileName();
        res.setHeader("Content-Disposition", "attachment; filename=" + outFileName);
    }

    static void setServletResponseHTML(HttpServletResponse res) {
        res.setContentType("text/html; charset=UTF-8");
    }

    static void setServletResponseJSONP(HttpServletResponse res) {
        res.setContentType("text/javascript; charset=UTF-8");
    }

    static void setServletResponseJSON(HttpServletResponse res) {
        res.setContentType("application/json; charset=UTF-8");
    }

    private static void writeServletResponse(CharSequence responseMessage, HttpServletResponse res) throws IOException {
        ResponseWriter.writeServletResponse(responseMessage, res, "UTF-8", null);
    }

    private static void writeServletResponse(CharSequence charSequence, HttpServletResponse res, String charset, byte[] byteOrderMark) throws IOException {
        ServletOutputStream outputStream = res.getOutputStream();
        if (byteOrderMark != null) {
            outputStream.write(byteOrderMark);
        }
        outputStream.write(charSequence.toString().getBytes(charset));
    }
}

