/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource;

import com.google.visualization.datasource.Capabilities;
import com.google.visualization.datasource.DataSourceRequest;
import com.google.visualization.datasource.DataTableGenerator;
import com.google.visualization.datasource.QueryPair;
import com.google.visualization.datasource.QuerySplitter;
import com.google.visualization.datasource.ResponseWriter;
import com.google.visualization.datasource.base.DataSourceException;
import com.google.visualization.datasource.base.DataSourceParameters;
import com.google.visualization.datasource.base.InvalidQueryException;
import com.google.visualization.datasource.base.LocaleUtil;
import com.google.visualization.datasource.base.MessagesEnum;
import com.google.visualization.datasource.base.OutputType;
import com.google.visualization.datasource.base.ReasonType;
import com.google.visualization.datasource.base.ResponseStatus;
import com.google.visualization.datasource.base.StatusType;
import com.google.visualization.datasource.datatable.DataTable;
import com.google.visualization.datasource.query.AggregationColumn;
import com.google.visualization.datasource.query.Query;
import com.google.visualization.datasource.query.ScalarFunctionColumn;
import com.google.visualization.datasource.query.engine.QueryEngine;
import com.google.visualization.datasource.query.parser.QueryBuilder;
import com.google.visualization.datasource.render.CsvRenderer;
import com.google.visualization.datasource.render.HtmlRenderer;
import com.google.visualization.datasource.render.JsonRenderer;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.util.Locale;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataSourceHelper {
    private static final Log log = LogFactory.getLog((String)DataSourceHelper.class.getName());
    static final String LOCALE_REQUEST_PARAMETER = "hl";

    private DataSourceHelper() {
    }

    public static void executeDataSourceServletFlow(HttpServletRequest req, HttpServletResponse resp, DataTableGenerator dtGenerator) throws IOException {
        DataSourceHelper.executeDataSourceServletFlow(req, resp, dtGenerator, true);
    }

    public static void executeDataSourceServletFlow(HttpServletRequest req, HttpServletResponse resp, DataTableGenerator dtGenerator, boolean isRestrictedAccessMode) throws IOException {
        DataSourceRequest dsRequest = null;
        try {
            dsRequest = new DataSourceRequest(req);
            if (isRestrictedAccessMode) {
                DataSourceHelper.verifyAccessApproved(dsRequest);
            }
            QueryPair query = DataSourceHelper.splitQuery(dsRequest.getQuery(), dtGenerator.getCapabilities());
            DataTable dataTable = dtGenerator.generateDataTable(query.getDataSourceQuery(), req);
            DataTable newDataTable = DataSourceHelper.applyQuery(query.getCompletionQuery(), dataTable, dsRequest.getUserLocale());
            DataSourceHelper.setServletResponse(newDataTable, dsRequest, resp);
        }
        catch (DataSourceException e) {
            if (dsRequest != null) {
                DataSourceHelper.setServletErrorResponse(e, dsRequest, resp);
            } else {
                DataSourceHelper.setServletErrorResponse(e, req, resp);
            }
        }
        catch (RuntimeException e) {
            log.error((Object)"A runtime exception has occured", (Throwable)e);
            ResponseStatus status = new ResponseStatus(StatusType.ERROR, ReasonType.INTERNAL_ERROR, e.getMessage());
            if (dsRequest == null) {
                dsRequest = DataSourceRequest.getDefaultDataSourceRequest(req);
            }
            DataSourceHelper.setServletErrorResponse(status, dsRequest, resp);
        }
    }

    public static void verifyAccessApproved(DataSourceRequest req) throws DataSourceException {
        OutputType outType = req.getDataSourceParameters().getOutputType();
        if (outType != OutputType.CSV && outType != OutputType.TSV_EXCEL && outType != OutputType.HTML && !req.isSameOrigin()) {
            throw new DataSourceException(ReasonType.ACCESS_DENIED, "Unauthorized request. Cross domain requests are not supported.");
        }
    }

    public static void setServletResponse(DataTable dataTable, DataSourceRequest dataSourceRequest, HttpServletResponse res) throws IOException {
        String responseMessage = DataSourceHelper.generateResponse(dataTable, dataSourceRequest);
        DataSourceHelper.setServletResponse(responseMessage, dataSourceRequest, res);
    }

    public static void setServletResponse(String responseMessage, DataSourceRequest dataSourceRequest, HttpServletResponse res) throws IOException {
        DataSourceParameters dataSourceParameters = dataSourceRequest.getDataSourceParameters();
        ResponseWriter.setServletResponse(responseMessage, dataSourceParameters, res);
    }

    public static void setServletErrorResponse(DataSourceException dataSourceException, DataSourceRequest dataSourceRequest, HttpServletResponse res) throws IOException {
        String responseMessage = DataSourceHelper.generateErrorResponse(dataSourceException, dataSourceRequest);
        DataSourceHelper.setServletResponse(responseMessage, dataSourceRequest, res);
    }

    public static void setServletErrorResponse(ResponseStatus responseStatus, DataSourceRequest dataSourceRequest, HttpServletResponse res) throws IOException {
        String responseMessage = DataSourceHelper.generateErrorResponse(responseStatus, dataSourceRequest);
        DataSourceHelper.setServletResponse(responseMessage, dataSourceRequest, res);
    }

    public static void setServletErrorResponse(DataSourceException dataSourceException, HttpServletRequest req, HttpServletResponse res) throws IOException {
        DataSourceRequest dataSourceRequest = DataSourceRequest.getDefaultDataSourceRequest(req);
        DataSourceHelper.setServletErrorResponse(dataSourceException, dataSourceRequest, res);
    }

    public static String generateResponse(DataTable dataTable, DataSourceRequest dataSourceRequest) {
        CharSequence response;
        ResponseStatus responseStatus = null;
        if (!dataTable.getWarnings().isEmpty()) {
            responseStatus = new ResponseStatus(StatusType.WARNING);
        }
        switch (dataSourceRequest.getDataSourceParameters().getOutputType()) {
            case CSV: {
                response = CsvRenderer.renderDataTable(dataTable, dataSourceRequest.getUserLocale(), ",");
                break;
            }
            case TSV_EXCEL: {
                response = CsvRenderer.renderDataTable(dataTable, dataSourceRequest.getUserLocale(), "\t");
                break;
            }
            case HTML: {
                response = HtmlRenderer.renderDataTable(dataTable, dataSourceRequest.getUserLocale());
                break;
            }
            case JSONP: {
                response = "// Data table response\n" + JsonRenderer.renderJsonResponse(dataSourceRequest.getDataSourceParameters(), responseStatus, dataTable);
                break;
            }
            case JSON: {
                response = JsonRenderer.renderJsonResponse(dataSourceRequest.getDataSourceParameters(), responseStatus, dataTable);
                break;
            }
            default: {
                throw new RuntimeException("Unhandled output type.");
            }
        }
        return response.toString();
    }

    public static String generateErrorResponse(DataSourceException dse, DataSourceRequest dsRequest) throws IOException {
        ResponseStatus responseStatus = ResponseStatus.createResponseStatus(dse);
        responseStatus = ResponseStatus.getModifiedResponseStatus(responseStatus);
        return DataSourceHelper.generateErrorResponse(responseStatus, dsRequest);
    }

    public static String generateErrorResponse(ResponseStatus responseStatus, DataSourceRequest dsRequest) throws IOException {
        CharSequence response;
        DataSourceParameters dsParameters = dsRequest.getDataSourceParameters();
        switch (dsParameters.getOutputType()) {
            case CSV: 
            case TSV_EXCEL: {
                response = CsvRenderer.renderCsvError(responseStatus);
                break;
            }
            case HTML: {
                response = HtmlRenderer.renderHtmlError(responseStatus);
                break;
            }
            case JSONP: {
                response = JsonRenderer.renderJsonResponse(dsParameters, responseStatus, null);
                break;
            }
            case JSON: {
                response = JsonRenderer.renderJsonResponse(dsParameters, responseStatus, null);
                break;
            }
            default: {
                throw new RuntimeException("Unhandled output type.");
            }
        }
        return response.toString();
    }

    public static Query parseQuery(String queryString) throws InvalidQueryException {
        return DataSourceHelper.parseQuery(queryString, null);
    }

    public static Query parseQuery(String queryString, ULocale userLocale) throws InvalidQueryException {
        QueryBuilder queryBuilder = QueryBuilder.getInstance();
        Query query = queryBuilder.parseQuery(queryString, userLocale);
        return query;
    }

    public static DataTable applyQuery(Query query, DataTable dataTable, ULocale locale) throws InvalidQueryException, DataSourceException {
        dataTable.setLocaleForUserMessages(locale);
        DataSourceHelper.validateQueryAgainstColumnStructure(query, dataTable);
        dataTable = QueryEngine.executeQuery(query, dataTable, locale);
        dataTable.setLocaleForUserMessages(locale);
        return dataTable;
    }

    public static QueryPair splitQuery(Query query, Capabilities capabilities) throws DataSourceException {
        return QuerySplitter.splitQuery(query, capabilities);
    }

    public static void validateQueryAgainstColumnStructure(Query query, DataTable dataTable) throws InvalidQueryException {
        Set<String> mentionedColumnIds = query.getAllColumnIds();
        for (String string : mentionedColumnIds) {
            if (dataTable.containsColumn(string)) continue;
            String messageToLogAndUser = MessagesEnum.NO_COLUMN.getMessageWithArgs(dataTable.getLocaleForUserMessages(), string);
            log.error((Object)messageToLogAndUser);
            throw new InvalidQueryException(messageToLogAndUser);
        }
        Set<AggregationColumn> mentionedAggregations = query.getAllAggregations();
        for (AggregationColumn agg : mentionedAggregations) {
            try {
                agg.validateColumn(dataTable);
            }
            catch (RuntimeException e) {
                log.error((Object)"A runtime exception has occured", (Throwable)e);
                throw new InvalidQueryException(e.getMessage());
            }
        }
        Set<ScalarFunctionColumn> set = query.getAllScalarFunctionsColumns();
        for (ScalarFunctionColumn col : set) {
            col.validateColumn(dataTable);
        }
    }

    public static ULocale getLocaleFromRequest(HttpServletRequest req) {
        String requestLocale = req.getParameter(LOCALE_REQUEST_PARAMETER);
        Locale locale = requestLocale != null ? LocaleUtil.getLocaleFromLocaleString(requestLocale) : req.getLocale();
        return ULocale.forLocale((Locale)locale);
    }
}

