/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.internal.support;

import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.util.LongSparseArray;
import androidx.core.app.NotificationCompat;
import androidx.core.content.ContextCompat;
import com.chuckerteam.chucker.R;
import com.chuckerteam.chucker.api.Chucker;
import com.chuckerteam.chucker.internal.data.entity.HttpTransaction;
import com.chuckerteam.chucker.internal.support.ClearDatabaseJobIntentServiceReceiver;
import com.chuckerteam.chucker.internal.ui.BaseChuckerActivity;
import java.util.HashSet;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u000e\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\u0006\u0010\u001a\u001a\u00020\u0012J\b\u0010\u001b\u001a\u00020\u001cH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001e"}, d2={"Lcom/chuckerteam/chucker/internal/support/NotificationHelper;", "", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "getContext", "()Landroid/content/Context;", "notificationManager", "Landroid/app/NotificationManager;", "transactionsScreenIntent", "Landroid/app/PendingIntent;", "kotlin.jvm.PlatformType", "getTransactionsScreenIntent", "()Landroid/app/PendingIntent;", "transactionsScreenIntent$delegate", "Lkotlin/Lazy;", "addToBuffer", "", "transaction", "Lcom/chuckerteam/chucker/internal/data/entity/HttpTransaction;", "canShowNotifications", "", "show", "createClearAction", "Landroidx/core/app/NotificationCompat$Action;", "dismissNotifications", "immutableFlag", "", "Companion", "com.github.ChuckerTeam.Chucker.library"})
public final class NotificationHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final NotificationManager notificationManager;
    @NotNull
    private final Lazy transactionsScreenIntent$delegate;
    @NotNull
    private static final String TRANSACTIONS_CHANNEL_ID = "chucker_transactions";
    private static final int TRANSACTION_NOTIFICATION_ID = 1138;
    private static final int BUFFER_SIZE = 10;
    private static final int INTENT_REQUEST_CODE = 11;
    @NotNull
    private static final LongSparseArray<HttpTransaction> transactionBuffer = new LongSparseArray();
    @NotNull
    private static final HashSet<Long> transactionIdsSet = new HashSet();

    public NotificationHelper(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        Object object = this.context.getSystemService("notification");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.NotificationManager");
        this.notificationManager = (NotificationManager)object;
        this.transactionsScreenIntent$delegate = LazyKt.lazy(() -> NotificationHelper.transactionsScreenIntent_delegate$lambda$0(this));
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationChannel transactionsChannel = new NotificationChannel(TRANSACTIONS_CHANNEL_ID, (CharSequence)this.context.getString(R.string.chucker_network_notification_category), 2);
            this.notificationManager.createNotificationChannels(CollectionsKt.listOf((Object)transactionsChannel));
        }
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    private final PendingIntent getTransactionsScreenIntent() {
        Lazy lazy = this.transactionsScreenIntent$delegate;
        return (PendingIntent)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addToBuffer(HttpTransaction transaction) {
        if (transaction.getId() == 0L) {
            return;
        }
        LongSparseArray<HttpTransaction> longSparseArray = transactionBuffer;
        synchronized (longSparseArray) {
            boolean bl = false;
            transactionIdsSet.add(transaction.getId());
            transactionBuffer.put(transaction.getId(), (Object)transaction);
            if (transactionBuffer.size() > 10) {
                transactionBuffer.removeAt(0);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final boolean canShowNotifications() {
        return Build.VERSION.SDK_INT >= 24 ? this.notificationManager.areNotificationsEnabled() : true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void show(@NotNull HttpTransaction transaction) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        this.addToBuffer(transaction);
        if (!BaseChuckerActivity.Companion.isInForeground() && this.canShowNotifications()) {
            NotificationCompat.Builder builder = new NotificationCompat.Builder(this.context, TRANSACTIONS_CHANNEL_ID).setContentIntent(this.getTransactionsScreenIntent()).setLocalOnly(true).setSmallIcon(R.drawable.chucker_ic_transaction_notification).setColor(ContextCompat.getColor((Context)this.context, (int)R.color.chucker_color_primary)).setContentTitle((CharSequence)this.context.getString(R.string.chucker_http_notification_title)).setAutoCancel(true).addAction(this.createClearAction());
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"addAction(...)");
            NotificationCompat.Builder builder2 = builder;
            NotificationCompat.InboxStyle inboxStyle = new NotificationCompat.InboxStyle();
            LongSparseArray<HttpTransaction> longSparseArray = transactionBuffer;
            synchronized (longSparseArray) {
                boolean bl = false;
                int count = 0;
                for (int i = transactionBuffer.size() - 1; -1 < i; --i) {
                    HttpTransaction bufferedTransaction = (HttpTransaction)transactionBuffer.valueAt(i);
                    if (bufferedTransaction != null && count < 10) {
                        if (count == 0) {
                            builder2.setContentText((CharSequence)bufferedTransaction.getNotificationText());
                        }
                        inboxStyle.addLine((CharSequence)bufferedTransaction.getNotificationText());
                    }
                    ++count;
                }
                builder2.setStyle((NotificationCompat.Style)inboxStyle);
                NotificationCompat.Builder builder3 = Build.VERSION.SDK_INT >= 24 ? builder2.setSubText((CharSequence)String.valueOf(transactionIdsSet.size())) : builder2.setNumber(transactionIdsSet.size());
            }
            this.notificationManager.notify(1138, builder2.build());
        }
    }

    private final NotificationCompat.Action createClearAction() {
        String string2 = this.context.getString(R.string.chucker_clear);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        String clearTitle = string2;
        Intent clearTransactionsBroadcastIntent = new Intent(this.context, ClearDatabaseJobIntentServiceReceiver.class);
        PendingIntent pendingBroadcastIntent = PendingIntent.getBroadcast((Context)this.context, (int)11, (Intent)clearTransactionsBroadcastIntent, (int)(0x40000000 | this.immutableFlag()));
        return new NotificationCompat.Action(R.drawable.chucker_ic_delete_white, (CharSequence)clearTitle, pendingBroadcastIntent);
    }

    public final void dismissNotifications() {
        this.notificationManager.cancel(1138);
    }

    private final int immutableFlag() {
        return Build.VERSION.SDK_INT >= 23 ? 0x4000000 : 0;
    }

    private static final PendingIntent transactionsScreenIntent_delegate$lambda$0(NotificationHelper this$0) {
        return PendingIntent.getActivity((Context)this$0.context, (int)1138, (Intent)Chucker.getLaunchIntent(this$0.context), (int)(0x8000000 | this$0.immutableFlag()));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/chuckerteam/chucker/internal/support/NotificationHelper$Companion;", "", "<init>", "()V", "TRANSACTIONS_CHANNEL_ID", "", "TRANSACTION_NOTIFICATION_ID", "", "BUFFER_SIZE", "INTENT_REQUEST_CODE", "transactionBuffer", "Landroid/util/LongSparseArray;", "Lcom/chuckerteam/chucker/internal/data/entity/HttpTransaction;", "transactionIdsSet", "Ljava/util/HashSet;", "", "clearBuffer", "", "com.github.ChuckerTeam.Chucker.library"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void clearBuffer() {
            LongSparseArray longSparseArray = transactionBuffer;
            synchronized (longSparseArray) {
                boolean bl = false;
                transactionBuffer.clear();
                transactionIdsSet.clear();
                Unit unit = Unit.INSTANCE;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

