/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.internal.ui.transaction;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.ParcelFileDescriptor;
import android.text.SpannableStringBuilder;
import android.text.style.StyleSpan;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.TextView;
import android.widget.Toast;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.appcompat.widget.LinearLayoutCompat;
import androidx.appcompat.widget.SearchView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import androidx.core.text.HtmlCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentViewModelLazyKt;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleDestroyedException;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LifecycleOwnerKt;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStore;
import androidx.lifecycle.WithLifecycleStateKt;
import androidx.lifecycle.viewmodel.CreationExtras;
import androidx.recyclerview.widget.RecyclerView;
import com.chuckerteam.chucker.R;
import com.chuckerteam.chucker.databinding.ChuckerFragmentTransactionPayloadBinding;
import com.chuckerteam.chucker.internal.data.entity.HttpTransaction;
import com.chuckerteam.chucker.internal.support.BitmapUtilsKt;
import com.chuckerteam.chucker.internal.support.LiveDataUtilsKt;
import com.chuckerteam.chucker.internal.support.Logger;
import com.chuckerteam.chucker.internal.support.ViewUtilsKt;
import com.chuckerteam.chucker.internal.ui.transaction.PayloadType;
import com.chuckerteam.chucker.internal.ui.transaction.TransactionBodyAdapter;
import com.chuckerteam.chucker.internal.ui.transaction.TransactionPayloadFragment;
import com.chuckerteam.chucker.internal.ui.transaction.TransactionPayloadItem;
import com.chuckerteam.chucker.internal.ui.transaction.TransactionViewModel;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Function;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\u0010\r\n\u0002\b\u0002\b\u0000\u0018\u0000 V2\u00020\u00012\u00020\u0002:\u0001VB\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010!\u001a\u00020\"H\u0002J\u0018\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00102\u0006\u0010&\u001a\u00020'H\u0002J\u0012\u0010(\u001a\u00020\"2\b\b\u0002\u0010)\u001a\u00020$H\u0002J\u0010\u0010*\u001a\u00020\"2\u0006\u0010+\u001a\u00020,H\u0016J\u0012\u0010-\u001a\u00020\"2\b\u0010.\u001a\u0004\u0018\u00010/H\u0016J\u0018\u00100\u001a\u00020\"2\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0017J$\u00105\u001a\u0002062\u0006\u00103\u001a\u0002072\b\u00108\u001a\u0004\u0018\u0001092\b\u0010.\u001a\u0004\u0018\u00010/H\u0016J\u0010\u0010:\u001a\u00020$2\u0006\u0010;\u001a\u00020\bH\u0016J\u0010\u0010<\u001a\u00020$2\u0006\u0010=\u001a\u00020\bH\u0016J\u0010\u0010>\u001a\u00020\"2\u0006\u0010?\u001a\u00020$H\u0002J\u001a\u0010@\u001a\u00020\"2\u0006\u0010A\u001a\u0002062\b\u0010.\u001a\u0004\u0018\u00010/H\u0016J/\u0010B\u001a\b\u0012\u0004\u0012\u00020D0C2\u0006\u0010%\u001a\u00020\u00102\u0006\u0010&\u001a\u00020'2\u0006\u0010E\u001a\u00020$H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010FJ)\u0010\u0015\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00102\u0006\u0010G\u001a\u00020H2\u0006\u0010&\u001a\u00020'H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010IJ\u0010\u0010J\u001a\u00020\"2\u0006\u0010K\u001a\u00020\u0005H\u0002J\u0012\u0010L\u001a\u00020$2\b\u0010&\u001a\u0004\u0018\u00010'H\u0002J\u0012\u0010M\u001a\u00020$2\b\u0010&\u001a\u0004\u0018\u00010'H\u0002J\b\u0010N\u001a\u00020\"H\u0002J\b\u0010O\u001a\u00020\"H\u0002J\u001a\u0010P\u001a\u00020\"2\u0006\u0010Q\u001a\u00020\u00052\b\b\u0002\u0010R\u001a\u00020\u0005H\u0002J\u0012\u0010S\u001a\b\u0012\u0004\u0012\u00020U0T*\u00020UH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000f\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0015\u001a\u0010\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\b0\b0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\u001a0\u0019j\b\u0012\u0004\u0012\u00020\u001a`\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001c\u001a\u00020\u001d8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010\u0014\u001a\u0004\b\u001e\u0010\u001f\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006W"}, d2={"Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionPayloadFragment;", "Landroidx/fragment/app/Fragment;", "Landroidx/appcompat/widget/SearchView$OnQueryTextListener;", "()V", "backgroundSpanColor", "", "backgroundSpanColorSearchItem", "currentSearchQuery", "", "currentSearchScrollIndex", "foregroundSpanColor", "payloadAdapter", "Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionBodyAdapter;", "payloadBinding", "Lcom/chuckerteam/chucker/databinding/ChuckerFragmentTransactionPayloadBinding;", "payloadType", "Lcom/chuckerteam/chucker/internal/ui/transaction/PayloadType;", "getPayloadType", "()Lcom/chuckerteam/chucker/internal/ui/transaction/PayloadType;", "payloadType$delegate", "Lkotlin/Lazy;", "saveToFile", "Landroidx/activity/result/ActivityResultLauncher;", "kotlin.jvm.PlatformType", "scrollableIndices", "Ljava/util/ArrayList;", "Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionBodyAdapter$SearchItemBodyLine;", "Lkotlin/collections/ArrayList;", "viewModel", "Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionViewModel;", "getViewModel", "()Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionViewModel;", "viewModel$delegate", "createFileToSaveBody", "", "isBodyEmpty", "", "type", "transaction", "Lcom/chuckerteam/chucker/internal/data/entity/HttpTransaction;", "makeToolbarSearchSummaryVisible", "visible", "onAttach", "context", "Landroid/content/Context;", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onCreateOptionsMenu", "menu", "Landroid/view/Menu;", "inflater", "Landroid/view/MenuInflater;", "onCreateView", "Landroid/view/View;", "Landroid/view/LayoutInflater;", "container", "Landroid/view/ViewGroup;", "onQueryTextChange", "newText", "onQueryTextSubmit", "query", "onSearchScrollerButtonClick", "goNext", "onViewCreated", "view", "processPayload", "", "Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionPayloadItem;", "formatRequestBody", "(Lcom/chuckerteam/chucker/internal/ui/transaction/PayloadType;Lcom/chuckerteam/chucker/internal/data/entity/HttpTransaction;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "uri", "Landroid/net/Uri;", "(Lcom/chuckerteam/chucker/internal/ui/transaction/PayloadType;Landroid/net/Uri;Lcom/chuckerteam/chucker/internal/data/entity/HttpTransaction;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "scrollToSearchedItemPosition", "positionOfScrollableIndices", "shouldShowSaveIcon", "shouldShowSearchIcon", "showEmptyState", "showPayloadState", "updateToolbarText", "searchResultsCount", "currentIndex", "lines", "", "", "Companion", "com.github.ChuckerTeam.Chucker.library"})
@SourceDebugExtension(value={"SMAP\nTransactionPayloadFragment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransactionPayloadFragment.kt\ncom/chuckerteam/chucker/internal/ui/transaction/TransactionPayloadFragment\n+ 2 FragmentViewModelLazy.kt\nandroidx/fragment/app/FragmentViewModelLazyKt\n+ 3 SpannableStringBuilder.kt\nandroidx/core/text/SpannableStringBuilderKt\n*L\n1#1,460:1\n172#2,9:461\n87#3:470\n74#3,4:471\n*S KotlinDebug\n*F\n+ 1 TransactionPayloadFragment.kt\ncom/chuckerteam/chucker/internal/ui/transaction/TransactionPayloadFragment\n*L\n48#1:461,9\n287#1:470\n287#1:471,4\n*E\n"})
public final class TransactionPayloadFragment
extends Fragment
implements SearchView.OnQueryTextListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy viewModel$delegate;
    @NotNull
    private final Lazy payloadType$delegate;
    @NotNull
    private final ActivityResultLauncher<String> saveToFile;
    private ChuckerFragmentTransactionPayloadBinding payloadBinding;
    @NotNull
    private final TransactionBodyAdapter payloadAdapter;
    private int backgroundSpanColor;
    private int foregroundSpanColor;
    private int backgroundSpanColorSearchItem;
    @NotNull
    private final ArrayList<TransactionBodyAdapter.SearchItemBodyLine> scrollableIndices;
    private int currentSearchScrollIndex;
    @NotNull
    private String currentSearchQuery;
    @NotNull
    private static final String ARG_TYPE = "type";
    @NotNull
    private static final String TRANSACTION_EXCEPTION = "Transaction not ready";
    private static final long DELAY_FOR_SEARCH_SCROLL = 600L;
    private static final int NUMBER_OF_IGNORED_SYMBOLS = 1;
    @NotNull
    public static final String DEFAULT_FILE_PREFIX = "chucker-export-";

    /*
     * WARNING - void declaration
     */
    public TransactionPayloadFragment() {
        void $this$activityViewModels_u24default$iv;
        Fragment fragment = this;
        Function0 factoryProducer$iv = viewModel.2.INSTANCE;
        Function0 extrasProducer$iv = null;
        boolean $i$f$activityViewModels = false;
        KClass kClass = Reflection.getOrCreateKotlinClass(TransactionViewModel.class);
        Function0 function0 = (Function0)new Function0<ViewModelStore>((Fragment)$this$activityViewModels_u24default$iv){
            final /* synthetic */ Fragment $this_activityViewModels;
            {
                this.$this_activityViewModels = $receiver;
                super(0);
            }

            @NotNull
            public final ViewModelStore invoke() {
                ViewModelStore viewModelStore = this.$this_activityViewModels.requireActivity().getViewModelStore();
                Intrinsics.checkNotNullExpressionValue((Object)viewModelStore, (String)"requireActivity().viewModelStore");
                return viewModelStore;
            }
        };
        Function0 function02 = (Function0)new Function0<CreationExtras>(extrasProducer$iv, (Fragment)$this$activityViewModels_u24default$iv){
            final /* synthetic */ Function0 $extrasProducer;
            final /* synthetic */ Fragment $this_activityViewModels;
            {
                this.$extrasProducer = $extrasProducer;
                this.$this_activityViewModels = $receiver;
                super(0);
            }

            @NotNull
            public final CreationExtras invoke() {
                Function0 function0 = this.$extrasProducer;
                if (function0 == null || (function0 = (CreationExtras)function0.invoke()) == null) {
                    CreationExtras creationExtras = this.$this_activityViewModels.requireActivity().getDefaultViewModelCreationExtras();
                    function0 = creationExtras;
                    Intrinsics.checkNotNullExpressionValue((Object)creationExtras, (String)"requireActivity().defaultViewModelCreationExtras");
                }
                return function0;
            }
        };
        Function0 function03 = factoryProducer$iv;
        if (function03 == null) {
            function03 = (Function0)new Function0<ViewModelProvider.Factory>((Fragment)$this$activityViewModels_u24default$iv){
                final /* synthetic */ Fragment $this_activityViewModels;
                {
                    this.$this_activityViewModels = $receiver;
                    super(0);
                }

                @NotNull
                public final ViewModelProvider.Factory invoke() {
                    ViewModelProvider.Factory factory = this.$this_activityViewModels.requireActivity().getDefaultViewModelProviderFactory();
                    Intrinsics.checkNotNullExpressionValue((Object)factory, (String)"requireActivity().defaultViewModelProviderFactory");
                    return factory;
                }
            };
        }
        this.viewModel$delegate = FragmentViewModelLazyKt.createViewModelLazy((Fragment)$this$activityViewModels_u24default$iv, (KClass)kClass, (Function0)function0, (Function0)function02, (Function0)function03);
        this.payloadType$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<PayloadType>(this){
            final /* synthetic */ TransactionPayloadFragment this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final PayloadType invoke() {
                Bundle bundle = this.this$0.getArguments();
                Serializable serializable = bundle != null ? bundle.getSerializable("type") : null;
                Intrinsics.checkNotNull((Object)serializable, (String)"null cannot be cast to non-null type com.chuckerteam.chucker.internal.ui.transaction.PayloadType");
                return (PayloadType)((Object)serializable);
            }
        }));
        ActivityResultLauncher activityResultLauncher = this.registerForActivityResult((ActivityResultContract)new ActivityResultContracts.CreateDocument(), arg_0 -> TransactionPayloadFragment.saveToFile$lambda$0(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)activityResultLauncher, (String)"registerForActivityResul\u2026)\n            }\n        }");
        this.saveToFile = activityResultLauncher;
        this.payloadAdapter = new TransactionBodyAdapter();
        this.backgroundSpanColor = -256;
        this.foregroundSpanColor = -65536;
        this.backgroundSpanColorSearchItem = -16711936;
        this.scrollableIndices = new ArrayList();
        this.currentSearchScrollIndex = -1;
        this.currentSearchQuery = "";
    }

    private final TransactionViewModel getViewModel() {
        Lazy lazy = this.viewModel$delegate;
        return (TransactionViewModel)((Object)lazy.getValue());
    }

    private final PayloadType getPayloadType() {
        Lazy lazy = this.payloadType$delegate;
        return (PayloadType)((Object)lazy.getValue());
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setHasOptionsMenu(true);
    }

    @NotNull
    public View onCreateView(@NotNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)inflater, (String)"inflater");
        ChuckerFragmentTransactionPayloadBinding chuckerFragmentTransactionPayloadBinding = ChuckerFragmentTransactionPayloadBinding.inflate(inflater, container, false);
        Intrinsics.checkNotNullExpressionValue((Object)chuckerFragmentTransactionPayloadBinding, (String)"inflate(\n            inf\u2026          false\n        )");
        this.payloadBinding = chuckerFragmentTransactionPayloadBinding;
        ChuckerFragmentTransactionPayloadBinding chuckerFragmentTransactionPayloadBinding2 = this.payloadBinding;
        if (chuckerFragmentTransactionPayloadBinding2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"payloadBinding");
            chuckerFragmentTransactionPayloadBinding2 = null;
        }
        ConstraintLayout constraintLayout = chuckerFragmentTransactionPayloadBinding2.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"payloadBinding.root");
        return (View)constraintLayout;
    }

    public void onViewCreated(@NotNull View view, @Nullable Bundle savedInstanceState) {
        RecyclerView recyclerView;
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        super.onViewCreated(view, savedInstanceState);
        ChuckerFragmentTransactionPayloadBinding chuckerFragmentTransactionPayloadBinding = this.payloadBinding;
        if (chuckerFragmentTransactionPayloadBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"payloadBinding");
            chuckerFragmentTransactionPayloadBinding = null;
        }
        RecyclerView $this$onViewCreated_u24lambda_u241 = recyclerView = chuckerFragmentTransactionPayloadBinding.payloadRecyclerView;
        boolean bl = false;
        $this$onViewCreated_u24lambda_u241.setHasFixedSize(true);
        $this$onViewCreated_u24lambda_u241.setAdapter((RecyclerView.Adapter)this.payloadAdapter);
        LiveDataUtilsKt.combineLatest(this.getViewModel().getTransaction(), this.getViewModel().getFormatRequestBody()).observe(this.getViewLifecycleOwner(), arg_0 -> TransactionPayloadFragment.onViewCreated$lambda$2(this, arg_0));
        ChuckerFragmentTransactionPayloadBinding chuckerFragmentTransactionPayloadBinding2 = this.payloadBinding;
        if (chuckerFragmentTransactionPayloadBinding2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"payloadBinding");
            chuckerFragmentTransactionPayloadBinding2 = null;
        }
        chuckerFragmentTransactionPayloadBinding2.searchNavButton.setOnClickListener(arg_0 -> TransactionPayloadFragment.onViewCreated$lambda$3(this, arg_0));
        ChuckerFragmentTransactionPayloadBinding chuckerFragmentTransactionPayloadBinding3 = this.payloadBinding;
        if (chuckerFragmentTransactionPayloadBinding3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"payloadBinding");
            chuckerFragmentTransactionPayloadBinding3 = null;
        }
        chuckerFragmentTransactionPayloadBinding3.searchNavButtonUp.setOnClickListener(arg_0 -> TransactionPayloadFragment.onViewCreated$lambda$4(this, arg_0));
    }

    private final void onSearchScrollerButtonClick(boolean goNext) {
        FragmentActivity fragmentActivity = this.getActivity();
        Object object = fragmentActivity != null ? fragmentActivity.getSystemService("input_method") : null;
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.view.inputmethod.InputMethodManager");
        InputMethodManager inputMethodManager = (InputMethodManager)object;
        if (inputMethodManager.isAcceptingText()) {
            FragmentActivity fragmentActivity2 = this.getActivity();
            if (fragmentActivity2 != null && (fragmentActivity2 = fragmentActivity2.getCurrentFocus()) != null) {
                fragmentActivity2.clearFocus();
            }
            View view = this.getView();
            inputMethodManager.hideSoftInputFromWindow((IBinder)(view != null ? view.getWindowToken() : null), 0);
        }
        if (!((Collection)this.scrollableIndices).isEmpty()) {
            int scrollToIndex = goNext ? (this.currentSearchScrollIndex + 1) % this.scrollableIndices.size() : Math.abs(this.currentSearchScrollIndex - 1 + this.scrollableIndices.size()) % this.scrollableIndices.size();
            this.scrollToSearchedItemPosition(scrollToIndex);
        }
    }

    private final void showEmptyState() {
        ChuckerFragmentTransactionPayloadBinding chuckerFragmentTransactionPayloadBinding;
        ChuckerFragmentTransactionPayloadBinding chuckerFragmentTransactionPayloadBinding2 = this.payloadBinding;
        if (chuckerFragmentTransactionPayloadBinding2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"payloadBinding");
            chuckerFragmentTransactionPayloadBinding2 = null;
        }
        ChuckerFragmentTransactionPayloadBinding $this$showEmptyState_u24lambda_u245 = chuckerFragmentTransactionPayloadBinding = chuckerFragmentTransactionPayloadBinding2;
        boolean bl = false;
        $this$showEmptyState_u24lambda_u245.emptyPayloadTextView.setText(this.getPayloadType() == PayloadType.RESPONSE ? (CharSequence)this.getString(R.string.chucker_response_is_empty) : (CharSequence)this.getString(R.string.chucker_request_is_empty));
        $this$showEmptyState_u24lambda_u245.emptyStateGroup.setVisibility(0);
        $this$showEmptyState_u24lambda_u245.payloadRecyclerView.setVisibility(8);
    }

    private final void showPayloadState() {
        ChuckerFragmentTransactionPayloadBinding chuckerFragmentTransactionPayloadBinding;
        ChuckerFragmentTransactionPayloadBinding chuckerFragmentTransactionPayloadBinding2 = this.payloadBinding;
        if (chuckerFragmentTransactionPayloadBinding2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"payloadBinding");
            chuckerFragmentTransactionPayloadBinding2 = null;
        }
        ChuckerFragmentTransactionPayloadBinding $this$showPayloadState_u24lambda_u246 = chuckerFragmentTransactionPayloadBinding = chuckerFragmentTransactionPayloadBinding2;
        boolean bl = false;
        $this$showPayloadState_u24lambda_u246.emptyStateGroup.setVisibility(8);
        $this$showPayloadState_u24lambda_u246.payloadRecyclerView.setVisibility(0);
    }

    @SuppressLint(value={"NewApi"})
    public void onCreateOptionsMenu(@NotNull Menu menu2, @NotNull MenuInflater inflater) {
        MenuItem menuItem;
        Intrinsics.checkNotNullParameter((Object)menu2, (String)"menu");
        Intrinsics.checkNotNullParameter((Object)inflater, (String)"inflater");
        HttpTransaction transaction = (HttpTransaction)this.getViewModel().getTransaction().getValue();
        if (this.shouldShowSearchIcon(transaction)) {
            MenuItem searchMenuItem = menu2.findItem(R.id.search);
            searchMenuItem.setVisible(true);
            View view = searchMenuItem.getActionView();
            Intrinsics.checkNotNull((Object)view, (String)"null cannot be cast to non-null type androidx.appcompat.widget.SearchView");
            SearchView searchView = (SearchView)view;
            searchView.setOnQueryTextListener((SearchView.OnQueryTextListener)this);
            searchView.setIconifiedByDefault(true);
        }
        if (this.shouldShowSaveIcon(transaction)) {
            MenuItem $this$onCreateOptionsMenu_u24lambda_u248 = menuItem = menu2.findItem(R.id.save_body);
            boolean bl = false;
            $this$onCreateOptionsMenu_u24lambda_u248.setVisible(true);
            $this$onCreateOptionsMenu_u24lambda_u248.setOnMenuItemClickListener(arg_0 -> TransactionPayloadFragment.onCreateOptionsMenu$lambda$8$lambda$7(this, arg_0));
        }
        if (this.getPayloadType() == PayloadType.REQUEST) {
            menuItem = (Function1)new Function1<Boolean, Unit>(menu2){
                final /* synthetic */ Menu $menu;
                {
                    this.$menu = $menu;
                    super(1);
                }

                public final void invoke(Boolean it) {
                    MenuItem menuItem = this.$menu.findItem(R.id.encode_url);
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    menuItem.setVisible(it.booleanValue());
                }
            };
            this.getViewModel().getDoesRequestBodyRequireEncoding().observe(this.getViewLifecycleOwner(), new Observer((Function1)menuItem){
                private final /* synthetic */ Function1 function;
                {
                    Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                    this.function = function;
                }

                public final /* synthetic */ void onChanged(Object value) {
                    this.function.invoke(value);
                }

                @NotNull
                public final Function<?> getFunctionDelegate() {
                    return (Function)this.function;
                }

                public final boolean equals(@Nullable Object other) {
                    return other instanceof Observer ? (other instanceof FunctionAdapter ? Intrinsics.areEqual(this.getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
                }

                public final int hashCode() {
                    return this.getFunctionDelegate().hashCode();
                }
            });
        } else {
            menu2.findItem(R.id.encode_url).setVisible(false);
        }
        super.onCreateOptionsMenu(menu2, inflater);
    }

    private final boolean shouldShowSaveIcon(HttpTransaction transaction) {
        boolean bl;
        if (this.getPayloadType() == PayloadType.REQUEST) {
            boolean bl2;
            if (transaction != null) {
                Long l = transaction.getRequestPayloadSize();
                bl2 = l != null && 0L == l;
            } else {
                bl2 = false;
            }
            bl = !bl2;
        } else if (this.getPayloadType() == PayloadType.RESPONSE) {
            boolean bl3;
            if (transaction != null) {
                Long l = transaction.getResponsePayloadSize();
                bl3 = l != null && 0L == l;
            } else {
                bl3 = false;
            }
            bl = !bl3;
        } else {
            bl = true;
        }
        return bl;
    }

    private final boolean shouldShowSearchIcon(HttpTransaction transaction) {
        boolean bl;
        switch (WhenMappings.$EnumSwitchMapping$0[this.getPayloadType().ordinal()]) {
            case 1: {
                boolean bl2 = transaction != null ? !transaction.isRequestBodyEncoded() : false;
                if (bl2) {
                    Long l = transaction.getRequestPayloadSize();
                    if (l == null || 0L != l) {
                        bl = true;
                        break;
                    }
                }
                bl = false;
                break;
            }
            case 2: {
                boolean bl3 = transaction != null ? !transaction.isResponseBodyEncoded() : false;
                if (bl3) {
                    Long l = transaction.getResponsePayloadSize();
                    if (l == null || 0L != l) {
                        bl = true;
                        break;
                    }
                }
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    public void onAttach(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super.onAttach(context);
        this.backgroundSpanColor = ContextCompat.getColor((Context)context, (int)R.color.chucker_background_span_color);
        this.foregroundSpanColor = ContextCompat.getColor((Context)context, (int)R.color.chucker_foreground_span_color);
    }

    private final void createFileToSaveBody() {
        HttpTransaction transaction = (HttpTransaction)this.getViewModel().getTransaction().getValue();
        if (transaction != null && this.isBodyEmpty(this.getPayloadType(), transaction)) {
            Toast.makeText((Context)((Context)this.getActivity()), (int)R.string.chucker_file_not_saved_body_is_empty, (int)0).show();
        } else {
            this.saveToFile.launch((Object)(DEFAULT_FILE_PREFIX + System.currentTimeMillis()));
        }
    }

    public boolean onQueryTextSubmit(@NotNull String query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        return false;
    }

    public boolean onQueryTextChange(@NotNull String newText) {
        Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
        this.scrollableIndices.clear();
        this.currentSearchQuery = newText;
        this.currentSearchScrollIndex = -1;
        if (!StringsKt.isBlank((CharSequence)newText) && newText.length() > 1) {
            this.scrollableIndices.addAll((Collection<TransactionBodyAdapter.SearchItemBodyLine>)this.payloadAdapter.highlightQueryWithColors$com_github_ChuckerTeam_Chucker_library(newText, this.backgroundSpanColor, this.foregroundSpanColor));
        } else {
            this.payloadAdapter.resetHighlight$com_github_ChuckerTeam_Chucker_library();
            this.makeToolbarSearchSummaryVisible(false);
        }
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)LifecycleOwnerKt.getLifecycleScope((LifecycleOwner)((LifecycleOwner)this))), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ TransactionPayloadFragment this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var11_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = DelayKt.delay((long)600L, (Continuation)((Continuation)this));
                        if (v0 == var11_2) {
                            return var11_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        v1 = this.this$0.getLifecycle();
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"lifecycle");
                        var2_3 = v1;
                        var3_4 = this.this$0;
                        $i$f$withResumed = false;
                        $this$withStateAtLeastUnchecked$iv$iv = $this$withResumed$iv;
                        state$iv$iv = Lifecycle.State.RESUMED;
                        $i$f$withStateAtLeastUnchecked = false;
                        lifecycleDispatcher$iv$iv = Dispatchers.getMain().getImmediate();
                        dispatchNeeded$iv$iv = lifecycleDispatcher$iv$iv.isDispatchNeeded(this.getContext());
                        if (dispatchNeeded$iv$iv) ** GOTO lbl-1000
                        if ($this$withStateAtLeastUnchecked$iv$iv.getCurrentState() == Lifecycle.State.DESTROYED) {
                            throw new LifecycleDestroyedException();
                        }
                        if ($this$withStateAtLeastUnchecked$iv$iv.getCurrentState().compareTo((Enum)state$iv$iv) >= 0) {
                            $i$a$-withResumed-TransactionPayloadFragment$onQueryTextChange$1$1 = false;
                            if (((Collection)TransactionPayloadFragment.access$getScrollableIndices$p(var3_4)).isEmpty() == false) {
                                TransactionPayloadFragment.access$scrollToSearchedItemPosition(var3_4, 0);
                            } else {
                                TransactionPayloadFragment.access$setCurrentSearchScrollIndex$p(var3_4, -1);
                            }
                            v2 = Unit.INSTANCE;
                        } else lbl-1000:
                        // 2 sources

                        {
                            this.label = 2;
                            v2 = WithLifecycleStateKt.suspendWithStateAtLeastUnchecked((Lifecycle)$this$withStateAtLeastUnchecked$iv$iv, (Lifecycle.State)state$iv$iv, (boolean)(dispatchNeeded$iv$iv != false), (CoroutineDispatcher)((CoroutineDispatcher)lifecycleDispatcher$iv$iv), (Function0)((Function0)new Function0<Unit>(var3_4){
                                final /* synthetic */ TransactionPayloadFragment this$0;
                                {
                                    this.this$0 = transactionPayloadFragment;
                                    super(0);
                                }

                                public final Unit invoke() {
                                    boolean bl = false;
                                    if (!((Collection)TransactionPayloadFragment.access$getScrollableIndices$p(this.this$0)).isEmpty()) {
                                        TransactionPayloadFragment.access$scrollToSearchedItemPosition(this.this$0, 0);
                                    } else {
                                        TransactionPayloadFragment.access$setCurrentSearchScrollIndex$p(this.this$0, -1);
                                    }
                                    return Unit.INSTANCE;
                                }
                            }), (Continuation)((Continuation)this));
                            if (v2 == var11_2) {
                                return var11_2;
                            }
                        }
                        ** GOTO lbl47
                    }
                    case 2: {
                        $i$f$withResumed = false;
                        $i$f$withStateAtLeastUnchecked = false;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl47:
                        // 3 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        return true;
    }

    private final void makeToolbarSearchSummaryVisible(boolean visible) {
        ChuckerFragmentTransactionPayloadBinding chuckerFragmentTransactionPayloadBinding = this.payloadBinding;
        if (chuckerFragmentTransactionPayloadBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"payloadBinding");
            chuckerFragmentTransactionPayloadBinding = null;
        }
        LinearLayoutCompat $this$makeToolbarSearchSummaryVisible_u24lambda_u249 = chuckerFragmentTransactionPayloadBinding.rootSearchSummary;
        boolean bl = false;
        if (visible) {
            Intrinsics.checkNotNullExpressionValue((Object)$this$makeToolbarSearchSummaryVisible_u24lambda_u249, (String)"makeToolbarSearchSummaryVisible$lambda$9");
            ViewUtilsKt.visible((View)$this$makeToolbarSearchSummaryVisible_u24lambda_u249);
        } else {
            Intrinsics.checkNotNullExpressionValue((Object)$this$makeToolbarSearchSummaryVisible_u24lambda_u249, (String)"makeToolbarSearchSummaryVisible$lambda$9");
            ViewUtilsKt.gone((View)$this$makeToolbarSearchSummaryVisible_u24lambda_u249);
        }
    }

    static /* synthetic */ void makeToolbarSearchSummaryVisible$default(TransactionPayloadFragment transactionPayloadFragment, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        transactionPayloadFragment.makeToolbarSearchSummaryVisible(bl);
    }

    /*
     * WARNING - void declaration
     */
    private final void updateToolbarText(int searchResultsCount, int currentIndex) {
        void $this$inSpans$iv$iv;
        void $this$updateToolbarText_u24lambda_u2411;
        SpannableStringBuilder spannableStringBuilder;
        ChuckerFragmentTransactionPayloadBinding chuckerFragmentTransactionPayloadBinding = this.payloadBinding;
        if (chuckerFragmentTransactionPayloadBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"payloadBinding");
            chuckerFragmentTransactionPayloadBinding = null;
        }
        SpannableStringBuilder spannableStringBuilder2 = spannableStringBuilder = new SpannableStringBuilder();
        TextView textView = chuckerFragmentTransactionPayloadBinding.searchSummary;
        boolean bl = false;
        void $this$bold$iv = $this$updateToolbarText_u24lambda_u2411;
        boolean $i$f$bold = false;
        void var8_9 = $this$bold$iv;
        StyleSpan span$iv$iv = new StyleSpan(1);
        boolean $i$f$inSpans = false;
        int start$iv$iv = $this$inSpans$iv$iv.length();
        void $this$updateToolbarText_u24lambda_u2411_u24lambda_u2410 = $this$inSpans$iv$iv;
        boolean bl2 = false;
        $this$updateToolbarText_u24lambda_u2411_u24lambda_u2410.append((CharSequence)(currentIndex + " / " + searchResultsCount));
        $this$inSpans$iv$iv.setSpan((Object)span$iv$iv, start$iv$iv, $this$inSpans$iv$iv.length(), 17);
        textView.setText((CharSequence)spannableStringBuilder);
    }

    static /* synthetic */ void updateToolbarText$default(TransactionPayloadFragment transactionPayloadFragment, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = 1;
        }
        transactionPayloadFragment.updateToolbarText(n, n2);
    }

    private final void scrollToSearchedItemPosition(int positionOfScrollableIndices) {
        TransactionBodyAdapter.SearchItemBodyLine searchItemBodyLine = (TransactionBodyAdapter.SearchItemBodyLine)CollectionsKt.getOrNull((List)this.scrollableIndices, (int)this.currentSearchScrollIndex);
        if (searchItemBodyLine != null) {
            TransactionBodyAdapter.SearchItemBodyLine it = searchItemBodyLine;
            boolean bl = false;
            this.payloadAdapter.highlightItemWithColorOnPosition$com_github_ChuckerTeam_Chucker_library(it.getIndexBodyLine(), it.getIndexStartOfQuerySubString(), this.currentSearchQuery, this.backgroundSpanColor, this.foregroundSpanColor);
        }
        this.currentSearchScrollIndex = positionOfScrollableIndices;
        TransactionBodyAdapter.SearchItemBodyLine scrollTo = (TransactionBodyAdapter.SearchItemBodyLine)CollectionsKt.getOrNull((List)this.scrollableIndices, (int)positionOfScrollableIndices);
        if (scrollTo != null) {
            this.payloadAdapter.highlightItemWithColorOnPosition$com_github_ChuckerTeam_Chucker_library(scrollTo.getIndexBodyLine(), scrollTo.getIndexStartOfQuerySubString(), this.currentSearchQuery, this.backgroundSpanColorSearchItem, this.foregroundSpanColor);
            this.updateToolbarText(this.scrollableIndices.size(), positionOfScrollableIndices + 1);
            TransactionPayloadFragment.makeToolbarSearchSummaryVisible$default(this, false, 1, null);
            ChuckerFragmentTransactionPayloadBinding chuckerFragmentTransactionPayloadBinding = this.payloadBinding;
            if (chuckerFragmentTransactionPayloadBinding == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"payloadBinding");
                chuckerFragmentTransactionPayloadBinding = null;
            }
            chuckerFragmentTransactionPayloadBinding.payloadRecyclerView.smoothScrollToPosition(scrollTo.getIndexBodyLine());
            this.currentSearchScrollIndex = positionOfScrollableIndices;
        }
    }

    private final Object processPayload(PayloadType type, HttpTransaction transaction, boolean formatRequestBody2, Continuation<? super List<TransactionPayloadItem>> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<TransactionPayloadItem>>, Object>(type, transaction, formatRequestBody2, this, null){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ PayloadType $type;
            final /* synthetic */ HttpTransaction $transaction;
            final /* synthetic */ boolean $formatRequestBody;
            final /* synthetic */ TransactionPayloadFragment this$0;
            {
                this.$type = $type;
                this.$transaction = $transaction;
                this.$formatRequestBody = $formatRequestBody;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var13_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        result = new ArrayList<E>();
                        var5_4 = null;
                        if (this.$type == PayloadType.REQUEST) {
                            headersString = this.$transaction.getRequestHeadersString(true);
                            isBodyEncoded = this.$transaction.isRequestBodyEncoded();
                            if (this.$formatRequestBody) {
                                v0 = this.$transaction.getSpannedRequestBody(this.this$0.getContext());
                            } else {
                                v1 = this.$transaction.getRequestBody();
                                if (v1 == null) {
                                    v1 = "";
                                }
                                v0 = v1;
                            }
                            var5_4 = v0;
                        } else {
                            headersString = this.$transaction.getResponseHeadersString(true);
                            isBodyEncoded = this.$transaction.isResponseBodyEncoded();
                            bodyString = this.$transaction.getSpannedResponseBody(this.this$0.getContext());
                        }
                        if (StringsKt.isBlank((CharSequence)headersString) == false) {
                            v2 = HtmlCompat.fromHtml((String)var3_5, (int)0);
                            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"fromHtml(\n              \u2026                        )");
                            result.add(new TransactionPayloadItem.HeaderItem(v2));
                        }
                        responseBitmap = this.$transaction.getResponseImageBitmap();
                        if (this.$type != PayloadType.RESPONSE || responseBitmap == null) break;
                        this.L$0 = result;
                        this.L$1 = responseBitmap;
                        this.label = 1;
                        v3 = BitmapUtilsKt.calculateLuminance(responseBitmap, (Continuation<? super Double>)((Continuation)this));
                        if (v3 == var13_2) {
                            return var13_2;
                        }
                        ** GOTO lbl41
                    }
                    case 1: {
                        responseBitmap = (Bitmap)this.L$1;
                        result = (List)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl41:
                        // 2 sources

                        bitmapLuminance = (Double)v3;
                        result.add(new TransactionPayloadItem.ImageItem(responseBitmap, bitmapLuminance));
                        return result;
                    }
                }
                if (isBodyEncoded) {
                    v4 = this.this$0.requireContext().getString(R.string.chucker_body_omitted);
                    Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"requireContext().getStri\u2026ing.chucker_body_omitted)");
                    text = v4;
                    v5 = SpannableStringBuilder.valueOf((CharSequence)text);
                    Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"valueOf(text)");
                    result.add(new TransactionPayloadItem.BodyLineItem(v5));
                } else if (StringsKt.isBlank((CharSequence)bodyString)) {
                    v6 = this.this$0.requireContext().getString(R.string.chucker_body_empty);
                    Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"requireContext().getStri\u2026tring.chucker_body_empty)");
                    text = v6;
                    v7 = SpannableStringBuilder.valueOf((CharSequence)text);
                    Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"valueOf(text)");
                    result.add(new TransactionPayloadItem.BodyLineItem(v7));
                } else {
                    $this$forEach$iv = TransactionPayloadFragment.access$lines(this.this$0, bodyString);
                    $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        it = (CharSequence)element$iv;
                        $i$a$-forEach-TransactionPayloadFragment$processPayload$2$1 = false;
                        v8 = it instanceof SpannableStringBuilder != false ? (SpannableStringBuilder)it : SpannableStringBuilder.valueOf((CharSequence)it);
                        Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"if (it is SpannableStrin\u2026                        }");
                        result.add(new TransactionPayloadItem.BodyLineItem(v8));
                    }
                }
                return result;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super List<TransactionPayloadItem>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    private final Object saveToFile(PayloadType type, Uri uri, HttpTransaction transaction, Continuation<? super Boolean> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(this, uri, type, transaction, null){
            int label;
            final /* synthetic */ TransactionPayloadFragment this$0;
            final /* synthetic */ Uri $uri;
            final /* synthetic */ PayloadType $type;
            final /* synthetic */ HttpTransaction $transaction;
            {
                this.this$0 = $receiver;
                this.$uri = $uri;
                this.$type = $type;
                this.$transaction = $transaction;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        try {
                            ParcelFileDescriptor parcelFileDescriptor = this.this$0.requireContext().getContentResolver().openFileDescriptor(this.$uri, "w");
                            if (parcelFileDescriptor == null) return Boxing.boxBoolean((boolean)true);
                            Closeable closeable = (Closeable)parcelFileDescriptor;
                            PayloadType payloadType2 = this.$type;
                            HttpTransaction httpTransaction = this.$transaction;
                            Throwable throwable = null;
                            try {
                                long l;
                                ParcelFileDescriptor it = (ParcelFileDescriptor)closeable;
                                boolean bl = false;
                                Closeable closeable2 = new FileOutputStream(it.getFileDescriptor());
                                Throwable throwable2 = null;
                                try {
                                    long l2;
                                    FileOutputStream fos = (FileOutputStream)closeable2;
                                    boolean bl2 = false;
                                    switch (saveToFile.WhenMappings.$EnumSwitchMapping$0[payloadType2.ordinal()]) {
                                        case 1: {
                                            String string2 = httpTransaction.getRequestBody();
                                            if (string2 == null) throw new IOException("Transaction not ready");
                                            String string3 = string2;
                                            Charset charset = Charsets.UTF_8;
                                            byte[] byArray = string3.getBytes(charset);
                                            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                                            l2 = ByteStreamsKt.copyTo$default((InputStream)new ByteArrayInputStream(byArray), (OutputStream)fos, (int)0, (int)2, null);
                                            break;
                                        }
                                        case 2: {
                                            String string4 = httpTransaction.getResponseBody();
                                            if (string4 == null) throw new IOException("Transaction not ready");
                                            String string5 = string4;
                                            Charset charset = Charsets.UTF_8;
                                            byte[] byArray = string5.getBytes(charset);
                                            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                                            l2 = ByteStreamsKt.copyTo$default((InputStream)new ByteArrayInputStream(byArray), (OutputStream)fos, (int)0, (int)2, null);
                                            break;
                                        }
                                        default: {
                                            throw new NoWhenBranchMatchedException();
                                        }
                                    }
                                    l = l2;
                                }
                                catch (Throwable throwable3) {
                                    throwable2 = throwable3;
                                    throw throwable3;
                                }
                                finally {
                                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                                }
                                Long l3 = Boxing.boxLong((long)l);
                                return Boxing.boxBoolean((boolean)true);
                            }
                            catch (Throwable throwable4) {
                                throwable = throwable4;
                                throw throwable4;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                            }
                        }
                        catch (IOException e) {
                            Logger.Companion.error("Failed to save transaction to a file", e);
                            return Boxing.boxBoolean((boolean)false);
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Boolean> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    private final boolean isBodyEmpty(PayloadType type, HttpTransaction transaction) {
        return type == PayloadType.REQUEST && transaction.getRequestBody() == null ? true : type == PayloadType.RESPONSE && transaction.getResponseBody() == null;
    }

    private final List<CharSequence> lines(CharSequence $this$lines) {
        List linesList = SequencesKt.toList((Sequence)StringsKt.lineSequence((CharSequence)$this$lines));
        List result = new ArrayList();
        int lineIndex = 0;
        int n = linesList.size();
        for (int index = 0; index < n; ++index) {
            result.add($this$lines.subSequence(lineIndex, lineIndex + ((String)linesList.get(index)).length()));
            lineIndex += ((String)linesList.get(index)).length() + 1;
        }
        if (result.isEmpty()) {
            result.add($this$lines.subSequence(0, $this$lines.length()));
        }
        return result;
    }

    private static final void saveToFile$lambda$0(TransactionPayloadFragment this$0, Uri uri) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        HttpTransaction transaction = (HttpTransaction)this$0.getViewModel().getTransaction().getValue();
        Context applicationContext = this$0.requireContext().getApplicationContext();
        if (uri != null && transaction != null) {
            BuildersKt.launch$default((CoroutineScope)((CoroutineScope)LifecycleOwnerKt.getLifecycleScope((LifecycleOwner)((LifecycleOwner)this$0))), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, uri, transaction, applicationContext, null){
                int label;
                final /* synthetic */ TransactionPayloadFragment this$0;
                final /* synthetic */ Uri $uri;
                final /* synthetic */ HttpTransaction $transaction;
                final /* synthetic */ Context $applicationContext;
                {
                    this.this$0 = $receiver;
                    this.$uri = $uri;
                    this.$transaction = $transaction;
                    this.$applicationContext = $applicationContext;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            this.label = 1;
                            v0 = TransactionPayloadFragment.access$saveToFile(this.this$0, TransactionPayloadFragment.access$getPayloadType(this.this$0), this.$uri, this.$transaction, (Continuation)this);
                            if (v0 == var4_2) {
                                return var4_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            toastMessageId = (result = ((Boolean)v0).booleanValue()) != false ? R.string.chucker_file_saved : R.string.chucker_file_not_saved;
                            Toast.makeText((Context)this.$applicationContext, (int)toastMessageId, (int)0).show();
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        } else {
            Toast.makeText((Context)applicationContext, (int)R.string.chucker_save_failed_to_open_document, (int)0).show();
        }
    }

    private static final void onViewCreated$lambda$2(TransactionPayloadFragment this$0, Pair pair) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        HttpTransaction transaction = (HttpTransaction)pair.component1();
        boolean formatRequestBody2 = (Boolean)pair.component2();
        if (transaction == null) {
            return;
        }
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)LifecycleOwnerKt.getLifecycleScope((LifecycleOwner)((LifecycleOwner)this$0))), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, transaction, formatRequestBody2, null){
            int label;
            final /* synthetic */ TransactionPayloadFragment this$0;
            final /* synthetic */ HttpTransaction $transaction;
            final /* synthetic */ boolean $formatRequestBody;
            {
                this.this$0 = $receiver;
                this.$transaction = $transaction;
                this.$formatRequestBody = $formatRequestBody;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        v0 = TransactionPayloadFragment.access$getPayloadBinding$p(this.this$0);
                        if (v0 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"payloadBinding");
                            v0 = null;
                        }
                        v0.loadingProgress.setVisibility(0);
                        this.label = 1;
                        v1 = TransactionPayloadFragment.access$processPayload(this.this$0, TransactionPayloadFragment.access$getPayloadType(this.this$0), this.$transaction, this.$formatRequestBody, (Continuation)this);
                        if (v1 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl18
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl18:
                        // 2 sources

                        if ((result = (List)v1).isEmpty()) {
                            TransactionPayloadFragment.access$showEmptyState(this.this$0);
                        } else {
                            TransactionPayloadFragment.access$getPayloadAdapter$p(this.this$0).setItems(result);
                            TransactionPayloadFragment.access$showPayloadState(this.this$0);
                        }
                        this.this$0.requireActivity().invalidateOptionsMenu();
                        v2 = TransactionPayloadFragment.access$getPayloadBinding$p(this.this$0);
                        if (v2 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"payloadBinding");
                            v2 = null;
                        }
                        v2.loadingProgress.setVisibility(8);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private static final void onViewCreated$lambda$3(TransactionPayloadFragment this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.onSearchScrollerButtonClick(true);
    }

    private static final void onViewCreated$lambda$4(TransactionPayloadFragment this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.onSearchScrollerButtonClick(false);
    }

    private static final boolean onCreateOptionsMenu$lambda$8$lambda$7(TransactionPayloadFragment this$0, MenuItem it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.createFileToSaveBody();
        return true;
    }

    public static final /* synthetic */ ArrayList access$getScrollableIndices$p(TransactionPayloadFragment $this) {
        return $this.scrollableIndices;
    }

    public static final /* synthetic */ void access$scrollToSearchedItemPosition(TransactionPayloadFragment $this, int positionOfScrollableIndices) {
        $this.scrollToSearchedItemPosition(positionOfScrollableIndices);
    }

    public static final /* synthetic */ void access$setCurrentSearchScrollIndex$p(TransactionPayloadFragment $this, int n) {
        $this.currentSearchScrollIndex = n;
    }

    public static final /* synthetic */ Object access$processPayload(TransactionPayloadFragment $this, PayloadType type, HttpTransaction transaction, boolean formatRequestBody2, Continuation $completion) {
        return $this.processPayload(type, transaction, formatRequestBody2, (Continuation<? super List<TransactionPayloadItem>>)$completion);
    }

    public static final /* synthetic */ List access$lines(TransactionPayloadFragment $this, CharSequence $receiver) {
        return $this.lines($receiver);
    }

    public static final /* synthetic */ Object access$saveToFile(TransactionPayloadFragment $this, PayloadType type, Uri uri, HttpTransaction transaction, Continuation $completion) {
        return $this.saveToFile(type, uri, transaction, (Continuation<? super Boolean>)$completion);
    }

    public static final /* synthetic */ PayloadType access$getPayloadType(TransactionPayloadFragment $this) {
        return $this.getPayloadType();
    }

    public static final /* synthetic */ ChuckerFragmentTransactionPayloadBinding access$getPayloadBinding$p(TransactionPayloadFragment $this) {
        return $this.payloadBinding;
    }

    public static final /* synthetic */ void access$showEmptyState(TransactionPayloadFragment $this) {
        $this.showEmptyState();
    }

    public static final /* synthetic */ TransactionBodyAdapter access$getPayloadAdapter$p(TransactionPayloadFragment $this) {
        return $this.payloadAdapter;
    }

    public static final /* synthetic */ void access$showPayloadState(TransactionPayloadFragment $this) {
        $this.showPayloadState();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionPayloadFragment$Companion;", "", "()V", "ARG_TYPE", "", "DEFAULT_FILE_PREFIX", "DELAY_FOR_SEARCH_SCROLL", "", "NUMBER_OF_IGNORED_SYMBOLS", "", "TRANSACTION_EXCEPTION", "newInstance", "Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionPayloadFragment;", "type", "Lcom/chuckerteam/chucker/internal/ui/transaction/PayloadType;", "com.github.ChuckerTeam.Chucker.library"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final TransactionPayloadFragment newInstance(@NotNull PayloadType type) {
            void $this$newInstance_u24lambda_u241_u24lambda_u240;
            Bundle bundle;
            TransactionPayloadFragment transactionPayloadFragment;
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)TransactionPayloadFragment.ARG_TYPE);
            TransactionPayloadFragment $this$newInstance_u24lambda_u241 = transactionPayloadFragment = new TransactionPayloadFragment();
            boolean bl = false;
            Bundle bundle2 = bundle = new Bundle();
            TransactionPayloadFragment transactionPayloadFragment2 = $this$newInstance_u24lambda_u241;
            boolean bl2 = false;
            $this$newInstance_u24lambda_u241_u24lambda_u240.putSerializable(TransactionPayloadFragment.ARG_TYPE, (Serializable)((Object)type));
            transactionPayloadFragment2.setArguments(bundle);
            return transactionPayloadFragment;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PayloadType.values().length];
            try {
                nArray[PayloadType.REQUEST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PayloadType.RESPONSE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

