/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.internal.ui;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.text.method.LinkMovementMethod;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import androidx.activity.ComponentActivity;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.annotation.RequiresApi;
import androidx.annotation.StringRes;
import androidx.appcompat.widget.SearchView;
import androidx.appcompat.widget.Toolbar;
import androidx.constraintlayout.widget.Group;
import androidx.core.content.ContextCompat;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LifecycleOwnerKt;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModelLazy;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStore;
import androidx.lifecycle.viewmodel.CreationExtras;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.RecyclerView;
import com.chuckerteam.chucker.R;
import com.chuckerteam.chucker.databinding.ChuckerActivityMainBinding;
import com.chuckerteam.chucker.internal.data.entity.HttpTransaction;
import com.chuckerteam.chucker.internal.data.entity.HttpTransactionTuple;
import com.chuckerteam.chucker.internal.data.model.DialogData;
import com.chuckerteam.chucker.internal.support.ContextExtKt;
import com.chuckerteam.chucker.internal.support.HarUtils;
import com.chuckerteam.chucker.internal.support.Logger;
import com.chuckerteam.chucker.internal.support.Sharable;
import com.chuckerteam.chucker.internal.support.SharableKt;
import com.chuckerteam.chucker.internal.support.TransactionDetailsHarSharable;
import com.chuckerteam.chucker.internal.support.TransactionListDetailsSharable;
import com.chuckerteam.chucker.internal.ui.BaseChuckerActivity;
import com.chuckerteam.chucker.internal.ui.MainViewModel;
import com.chuckerteam.chucker.internal.ui.transaction.TransactionActivity;
import com.chuckerteam.chucker.internal.ui.transaction.TransactionAdapter;
import com.google.android.material.snackbar.Snackbar;
import java.util.List;
import kotlin.Function;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 62\u00020\u00012\u00020\u0002:\u00016B\u0005\u00a2\u0006\u0002\u0010\u0003JB\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\f2(\u0010\u0019\u001a$\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d\u0012\u0006\u0012\u0004\u0018\u00010\u001f0\u001aH\u0002\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010 J\b\u0010!\u001a\u00020\"H\u0002J\u0012\u0010#\u001a\u00020\"2\b\b\u0001\u0010$\u001a\u00020%H\u0002J\b\u0010&\u001a\u00020\u0017H\u0003J\u0012\u0010'\u001a\u00020\u00172\b\u0010(\u001a\u0004\u0018\u00010)H\u0014J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020+2\u0006\u0010/\u001a\u000200H\u0016J\u0010\u00101\u001a\u00020+2\u0006\u00102\u001a\u00020\fH\u0016J\u0010\u00103\u001a\u00020+2\u0006\u00104\u001a\u00020\fH\u0016J\u0010\u00105\u001a\u00020\u00172\u0006\u0010,\u001a\u00020-H\u0002R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0010\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0010\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00067"}, d2={"Lcom/chuckerteam/chucker/internal/ui/MainActivity;", "Lcom/chuckerteam/chucker/internal/ui/BaseChuckerActivity;", "Landroidx/appcompat/widget/SearchView$OnQueryTextListener;", "()V", "applicationName", "", "getApplicationName", "()Ljava/lang/CharSequence;", "mainBinding", "Lcom/chuckerteam/chucker/databinding/ChuckerActivityMainBinding;", "permissionRequest", "Landroidx/activity/result/ActivityResultLauncher;", "", "kotlin.jvm.PlatformType", "transactionsAdapter", "Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionAdapter;", "viewModel", "Lcom/chuckerteam/chucker/internal/ui/MainViewModel;", "getViewModel", "()Lcom/chuckerteam/chucker/internal/ui/MainViewModel;", "viewModel$delegate", "Lkotlin/Lazy;", "exportTransactions", "", "fileName", "block", "Lkotlin/Function2;", "", "Lcom/chuckerteam/chucker/internal/data/entity/HttpTransaction;", "Lkotlin/coroutines/Continuation;", "Lcom/chuckerteam/chucker/internal/support/Sharable;", "", "(Ljava/lang/String;Lkotlin/jvm/functions/Function2;)V", "getClearDialogData", "Lcom/chuckerteam/chucker/internal/data/model/DialogData;", "getExportDialogData", "dialogMessage", "", "handleNotificationsPermission", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onCreateOptionsMenu", "", "menu", "Landroid/view/Menu;", "onOptionsItemSelected", "item", "Landroid/view/MenuItem;", "onQueryTextChange", "newText", "onQueryTextSubmit", "query", "setUpSearch", "Companion", "com.github.ChuckerTeam.Chucker.library"})
@SourceDebugExtension(value={"SMAP\nMainActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MainActivity.kt\ncom/chuckerteam/chucker/internal/ui/MainActivity\n+ 2 ActivityViewModelLazy.kt\nandroidx/activity/ActivityViewModelLazyKt\n*L\n1#1,249:1\n75#2,13:250\n*S KotlinDebug\n*F\n+ 1 MainActivity.kt\ncom/chuckerteam/chucker/internal/ui/MainActivity\n*L\n45#1:250,13\n*E\n"})
public final class MainActivity
extends BaseChuckerActivity
implements SearchView.OnQueryTextListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy viewModel$delegate;
    private ChuckerActivityMainBinding mainBinding;
    private TransactionAdapter transactionsAdapter;
    @NotNull
    private final ActivityResultLauncher<String> permissionRequest;
    @NotNull
    private static final String EXPORT_TXT_FILE_NAME = "transactions.txt";
    @NotNull
    private static final String EXPORT_HAR_FILE_NAME = "transactions.har";

    public MainActivity() {
        ComponentActivity $this$viewModels_u24default$iv = (ComponentActivity)this;
        Function0 extrasProducer$iv = null;
        Object factoryProducer$iv = null;
        boolean $i$f$viewModels = false;
        Function0 factoryPromise$iv = (Function0)new Function0<ViewModelProvider.Factory>($this$viewModels_u24default$iv){
            final /* synthetic */ ComponentActivity $this_viewModels;
            {
                this.$this_viewModels = $receiver;
                super(0);
            }

            @NotNull
            public final ViewModelProvider.Factory invoke() {
                ViewModelProvider.Factory factory = this.$this_viewModels.getDefaultViewModelProviderFactory();
                Intrinsics.checkNotNullExpressionValue((Object)factory, (String)"defaultViewModelProviderFactory");
                return factory;
            }
        };
        this.viewModel$delegate = (Lazy)new ViewModelLazy(Reflection.getOrCreateKotlinClass(MainViewModel.class), (Function0)new Function0<ViewModelStore>($this$viewModels_u24default$iv){
            final /* synthetic */ ComponentActivity $this_viewModels;
            {
                this.$this_viewModels = $receiver;
                super(0);
            }

            @NotNull
            public final ViewModelStore invoke() {
                ViewModelStore viewModelStore = this.$this_viewModels.getViewModelStore();
                Intrinsics.checkNotNullExpressionValue((Object)viewModelStore, (String)"viewModelStore");
                return viewModelStore;
            }
        }, factoryPromise$iv, (Function0)new Function0<CreationExtras>(extrasProducer$iv, $this$viewModels_u24default$iv){
            final /* synthetic */ Function0 $extrasProducer;
            final /* synthetic */ ComponentActivity $this_viewModels;
            {
                this.$extrasProducer = $extrasProducer;
                this.$this_viewModels = $receiver;
                super(0);
            }

            @NotNull
            public final CreationExtras invoke() {
                Function0 function0 = this.$extrasProducer;
                if (function0 == null || (function0 = (CreationExtras)function0.invoke()) == null) {
                    CreationExtras creationExtras = this.$this_viewModels.getDefaultViewModelCreationExtras();
                    function0 = creationExtras;
                    Intrinsics.checkNotNullExpressionValue((Object)creationExtras, (String)"this.defaultViewModelCreationExtras");
                }
                return function0;
            }
        });
        ActivityResultLauncher activityResultLauncher = this.registerForActivityResult((ActivityResultContract)new ActivityResultContracts.RequestPermission(), arg_0 -> MainActivity.permissionRequest$lambda$0(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)activityResultLauncher, (String)"registerForActivityResul\u2026ns info\")\n        }\n    }");
        this.permissionRequest = activityResultLauncher;
    }

    private final MainViewModel getViewModel() {
        Lazy lazy = this.viewModel$delegate;
        return (MainViewModel)((Object)lazy.getValue());
    }

    private final CharSequence getApplicationName() {
        CharSequence charSequence = this.getApplicationInfo().loadLabel(this.getPackageManager());
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"applicationInfo.loadLabel(packageManager)");
        return charSequence;
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        RecyclerView recyclerView;
        super.onCreate(savedInstanceState);
        ChuckerActivityMainBinding chuckerActivityMainBinding = ChuckerActivityMainBinding.inflate(this.getLayoutInflater());
        Intrinsics.checkNotNullExpressionValue((Object)chuckerActivityMainBinding, (String)"inflate(layoutInflater)");
        this.mainBinding = chuckerActivityMainBinding;
        this.transactionsAdapter = new TransactionAdapter((Context)this, (Function1<? super Long, Unit>)((Function1)new Function1<Long, Unit>(this){
            final /* synthetic */ MainActivity this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(long transactionId) {
                TransactionActivity.Companion.start((Context)this.this$0, transactionId);
            }
        }));
        ChuckerActivityMainBinding chuckerActivityMainBinding2 = this.mainBinding;
        if (chuckerActivityMainBinding2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainBinding");
            chuckerActivityMainBinding2 = null;
        }
        ChuckerActivityMainBinding $this$onCreate_u24lambda_u242 = chuckerActivityMainBinding2;
        boolean bl = false;
        this.setContentView((View)$this$onCreate_u24lambda_u242.getRoot());
        this.setSupportActionBar((Toolbar)$this$onCreate_u24lambda_u242.toolbar);
        $this$onCreate_u24lambda_u242.toolbar.setSubtitle(this.getApplicationName());
        $this$onCreate_u24lambda_u242.tutorialLink.setMovementMethod(LinkMovementMethod.getInstance());
        RecyclerView $this$onCreate_u24lambda_u242_u24lambda_u241 = recyclerView = $this$onCreate_u24lambda_u242.transactionsRecyclerView;
        boolean bl2 = false;
        $this$onCreate_u24lambda_u242_u24lambda_u241.setHasFixedSize(true);
        $this$onCreate_u24lambda_u242_u24lambda_u241.addItemDecoration((RecyclerView.ItemDecoration)new DividerItemDecoration((Context)this, 1));
        TransactionAdapter transactionAdapter = this.transactionsAdapter;
        if (transactionAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"transactionsAdapter");
            transactionAdapter = null;
        }
        $this$onCreate_u24lambda_u242_u24lambda_u241.setAdapter((RecyclerView.Adapter)transactionAdapter);
        Function1 function1 = (Function1)new Function1<List<? extends HttpTransactionTuple>, Unit>(this){
            final /* synthetic */ MainActivity this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(List<HttpTransactionTuple> transactionTuples) {
                void $this$isVisible$iv;
                TransactionAdapter transactionAdapter = MainActivity.access$getTransactionsAdapter$p(this.this$0);
                if (transactionAdapter == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"transactionsAdapter");
                    transactionAdapter = null;
                }
                transactionAdapter.submitList(transactionTuples);
                ChuckerActivityMainBinding chuckerActivityMainBinding = MainActivity.access$getMainBinding$p(this.this$0);
                if (chuckerActivityMainBinding == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mainBinding");
                    chuckerActivityMainBinding = null;
                }
                Group group = chuckerActivityMainBinding.tutorialGroup;
                Intrinsics.checkNotNullExpressionValue((Object)group, (String)"mainBinding.tutorialGroup");
                View view = (View)group;
                boolean value$iv = transactionTuples.isEmpty();
                boolean $i$f$setVisible = false;
                $this$isVisible$iv.setVisibility(value$iv ? 0 : 8);
            }
        };
        this.getViewModel().getTransactions().observe((LifecycleOwner)this, new Observer(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ void onChanged(Object value) {
                this.function.invoke(value);
            }

            @NotNull
            public final Function<?> getFunctionDelegate() {
                return (Function)this.function;
            }

            public final boolean equals(@Nullable Object other) {
                return other instanceof Observer ? (other instanceof FunctionAdapter ? Intrinsics.areEqual(this.getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return this.getFunctionDelegate().hashCode();
            }
        });
        if (Build.VERSION.SDK_INT >= 33) {
            this.handleNotificationsPermission();
        }
    }

    @RequiresApi(value=33)
    private final void handleNotificationsPermission() {
        if (ContextCompat.checkSelfPermission((Context)((Context)this), (String)"android.permission.POST_NOTIFICATIONS") != 0) {
            if (this.shouldShowRequestPermissionRationale("android.permission.POST_NOTIFICATIONS")) {
                ChuckerActivityMainBinding chuckerActivityMainBinding = this.mainBinding;
                if (chuckerActivityMainBinding == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mainBinding");
                    chuckerActivityMainBinding = null;
                }
                Snackbar.make((View)((View)chuckerActivityMainBinding.getRoot()), (CharSequence)this.getApplicationContext().getString(R.string.chucker_notifications_permission_not_granted), (int)0).setAction((CharSequence)this.getApplicationContext().getString(R.string.chucker_change), arg_0 -> MainActivity.handleNotificationsPermission$lambda$5(this, arg_0)).show();
            } else {
                this.permissionRequest.launch((Object)"android.permission.POST_NOTIFICATIONS");
            }
        }
    }

    public boolean onCreateOptionsMenu(@NotNull Menu menu2) {
        Intrinsics.checkNotNullParameter((Object)menu2, (String)"menu");
        this.getMenuInflater().inflate(R.menu.chucker_transactions_list, menu2);
        this.setUpSearch(menu2);
        return super.onCreateOptionsMenu(menu2);
    }

    private final void setUpSearch(Menu menu2) {
        MenuItem searchMenuItem = menu2.findItem(R.id.search);
        View view = searchMenuItem.getActionView();
        Intrinsics.checkNotNull((Object)view, (String)"null cannot be cast to non-null type androidx.appcompat.widget.SearchView");
        SearchView searchView = (SearchView)view;
        searchView.setOnQueryTextListener((SearchView.OnQueryTextListener)this);
        searchView.setIconifiedByDefault(true);
    }

    public boolean onOptionsItemSelected(@NotNull MenuItem item) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        int n = item.getItemId();
        if (n == R.id.clear) {
            ContextExtKt.showDialog((Context)this, this.getClearDialogData(), (Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ MainActivity this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    MainActivity.access$getViewModel(this.this$0).clearTransactions();
                }
            }), null);
            bl = true;
        } else if (n == R.id.share_text) {
            ContextExtKt.showDialog((Context)this, this.getExportDialogData(R.string.chucker_export_text_http_confirmation), (Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ MainActivity this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    MainActivity.access$exportTransactions(this.this$0, "transactions.txt", (Function2)new Function2<List<? extends HttpTransaction>, Continuation<? super Sharable>, Object>(null){
                        int label;
                        /* synthetic */ Object L$0;

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    List transactions2 = (List)this.L$0;
                                    return new TransactionListDetailsSharable(transactions2, false);
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            var var3_3 = new /* invalid duplicate definition of identical inner class */;
                            var3_3.L$0 = value;
                            return (Continuation)var3_3;
                        }

                        @Nullable
                        public final Object invoke(@NotNull List<HttpTransaction> p1, @Nullable Continuation<? super Sharable> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    });
                }
            }), null);
            bl = true;
        } else if (n == R.id.share_har) {
            ContextExtKt.showDialog((Context)this, this.getExportDialogData(R.string.chucker_export_har_http_confirmation), (Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ MainActivity this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    MainActivity.access$exportTransactions(this.this$0, "transactions.har", (Function2)new Function2<List<? extends HttpTransaction>, Continuation<? super Sharable>, Object>(this.this$0, null){
                        int label;
                        /* synthetic */ Object L$0;
                        final /* synthetic */ MainActivity this$0;
                        {
                            this.this$0 = $receiver;
                            super(2, $completion);
                        }

                        /*
                         * Unable to fully structure code
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object var1_1) {
                            var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)var1_1);
                                    transactions = (List)this.L$0;
                                    v0 = this.this$0.getString(R.string.chucker_name);
                                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getString(R.string.chucker_name)");
                                    v1 = this.this$0.getString(R.string.chucker_version);
                                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getString(R.string.chucker_version)");
                                    this.label = 1;
                                    v2 = HarUtils.INSTANCE.harStringFromTransactions((List<HttpTransaction>)var2_3, v0, v1, (Continuation<? super String>)((Continuation)this));
                                    if (v2 == var4_2) {
                                        return var4_2;
                                    }
                                    ** GOTO lbl18
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v2 = $result;
lbl18:
                                    // 2 sources

                                    var3_4 = (String)v2;
                                    return new TransactionDetailsHarSharable(var3_4);
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            var var3_3 = new /* invalid duplicate definition of identical inner class */;
                            var3_3.L$0 = value;
                            return (Continuation)var3_3;
                        }

                        @Nullable
                        public final Object invoke(@NotNull List<HttpTransaction> p1, @Nullable Continuation<? super Sharable> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    });
                }
            }), null);
            bl = true;
        } else {
            bl = super.onOptionsItemSelected(item);
        }
        return bl;
    }

    public boolean onQueryTextSubmit(@NotNull String query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        return true;
    }

    public boolean onQueryTextChange(@NotNull String newText) {
        Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
        this.getViewModel().updateItemsFilter(newText);
        return true;
    }

    private final void exportTransactions(String fileName, Function2<? super List<HttpTransaction>, ? super Continuation<? super Sharable>, ? extends Object> block) {
        Context applicationContext = this.getApplicationContext();
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)LifecycleOwnerKt.getLifecycleScope((LifecycleOwner)((LifecycleOwner)this))), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, applicationContext, block, fileName, null){
            int label;
            final /* synthetic */ MainActivity this$0;
            final /* synthetic */ Context $applicationContext;
            final /* synthetic */ Function2<List<HttpTransaction>, Continuation<? super Sharable>, Object> $block;
            final /* synthetic */ String $fileName;
            {
                this.this$0 = $receiver;
                this.$applicationContext = $applicationContext;
                this.$block = $block;
                this.$fileName = $fileName;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = MainActivity.access$getViewModel(this.this$0).getAllTransactions((Continuation<? super List<HttpTransaction>>)((Continuation)this));
                        if (v0 == var5_2) {
                            return var5_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        if ((transactions = (List)v0).isEmpty()) {
                            v1 = this.this$0;
                            v2 = this.$applicationContext.getString(R.string.chucker_export_empty_text);
                            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"applicationContext.getSt\u2026hucker_export_empty_text)");
                            BaseChuckerActivity.showToast$default(v1, v2, 0, 2, null);
                            return Unit.INSTANCE;
                        }
                        this.label = 2;
                        v3 = this.$block.invoke((Object)transactions, (Object)this);
                        if (v3 == var5_2) {
                            return var5_2;
                        }
                        ** GOTO lbl27
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl27:
                        // 2 sources

                        sharableTransactions = (Sharable)v3;
                        this.label = 3;
                        v4 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Intent>, Object>(sharableTransactions, this.this$0, this.$fileName, null){
                            int label;
                            final /* synthetic */ Sharable $sharableTransactions;
                            final /* synthetic */ MainActivity this$0;
                            final /* synthetic */ String $fileName;
                            {
                                this.$sharableTransactions = $sharableTransactions;
                                this.this$0 = $receiver;
                                this.$fileName = $fileName;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        Activity activity = (Activity)this.this$0;
                                        String string2 = this.this$0.getString(R.string.chucker_share_all_transactions_title);
                                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(R.string.chuck\u2026e_all_transactions_title)");
                                        String string3 = this.this$0.getString(R.string.chucker_share_all_transactions_subject);
                                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(R.string.chuck\u2026all_transactions_subject)");
                                        return SharableKt.shareAsFile(this.$sharableTransactions, activity, this.$fileName, string2, string3, "transactions");
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Intent> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (v4 == var5_2) {
                            return var5_2;
                        }
                        ** GOTO lbl36
                    }
                    case 3: {
                        ResultKt.throwOnFailure((Object)$result);
                        v4 = $result;
lbl36:
                        // 2 sources

                        if ((shareIntent = (Intent)v4) != null) {
                            this.this$0.startActivity(shareIntent);
                        } else {
                            v5 = this.this$0;
                            v6 = this.$applicationContext.getString(R.string.chucker_export_no_file);
                            Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"applicationContext.getSt\u2026g.chucker_export_no_file)");
                            BaseChuckerActivity.showToast$default(v5, v6, 0, 2, null);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final DialogData getClearDialogData() {
        String string2 = this.getString(R.string.chucker_clear);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(R.string.chucker_clear)");
        String string3 = this.getString(R.string.chucker_clear_http_confirmation);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(R.string.chuck\u2026_clear_http_confirmation)");
        return new DialogData(string2, string3, this.getString(R.string.chucker_clear), this.getString(R.string.chucker_cancel));
    }

    private final DialogData getExportDialogData(@StringRes int dialogMessage) {
        String string2 = this.getString(R.string.chucker_export);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(R.string.chucker_export)");
        String string3 = this.getString(dialogMessage);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(dialogMessage)");
        return new DialogData(string2, string3, this.getString(R.string.chucker_export), this.getString(R.string.chucker_cancel));
    }

    private static final void permissionRequest$lambda$0(MainActivity this$0, boolean isPermissionGranted) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (!isPermissionGranted) {
            String string2 = this$0.getApplicationContext().getString(R.string.chucker_notifications_permission_not_granted);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"applicationContext.getSt\u2026s_permission_not_granted)");
            this$0.showToast(string2, 1);
            Logger.DefaultImpls.error$default(Logger.Companion, "Notification permission denied. Can't show transactions info", null, 2, null);
        }
    }

    private static final void handleNotificationsPermission$lambda$5(MainActivity this$0, View it) {
        Intent intent;
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intent $this$handleNotificationsPermission_u24lambda_u245_u24lambda_u243 = intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        boolean bl = false;
        $this$handleNotificationsPermission_u24lambda_u245_u24lambda_u243.addFlags(0x10000000);
        $this$handleNotificationsPermission_u24lambda_u245_u24lambda_u243.setData(Uri.fromParts((String)"package", (String)this$0.getPackageName(), null));
        Intent intent2 = intent;
        boolean bl2 = false;
        this$0.startActivity(intent2);
    }

    public static final /* synthetic */ TransactionAdapter access$getTransactionsAdapter$p(MainActivity $this) {
        return $this.transactionsAdapter;
    }

    public static final /* synthetic */ ChuckerActivityMainBinding access$getMainBinding$p(MainActivity $this) {
        return $this.mainBinding;
    }

    public static final /* synthetic */ MainViewModel access$getViewModel(MainActivity $this) {
        return $this.getViewModel();
    }

    public static final /* synthetic */ void access$exportTransactions(MainActivity $this, String fileName, Function2 block) {
        $this.exportTransactions(fileName, (Function2<? super List<HttpTransaction>, ? super Continuation<? super Sharable>, ? extends Object>)block);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/chuckerteam/chucker/internal/ui/MainActivity$Companion;", "", "()V", "EXPORT_HAR_FILE_NAME", "", "EXPORT_TXT_FILE_NAME", "com.github.ChuckerTeam.Chucker.library"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

