/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.internal.data.room;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.room.DatabaseConfiguration;
import androidx.room.InvalidationTracker;
import androidx.room.RoomDatabase;
import androidx.room.RoomOpenHelper;
import androidx.room.migration.AutoMigrationSpec;
import androidx.room.migration.Migration;
import androidx.room.util.DBUtil;
import androidx.room.util.TableInfo;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import com.chuckerteam.chucker.internal.data.room.ChuckerDatabase;
import com.chuckerteam.chucker.internal.data.room.HttpTransactionDao;
import com.chuckerteam.chucker.internal.data.room.HttpTransactionDao_Impl;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ChuckerDatabase_Impl
extends ChuckerDatabase {
    private volatile HttpTransactionDao _httpTransactionDao;

    protected SupportSQLiteOpenHelper createOpenHelper(DatabaseConfiguration configuration) {
        RoomOpenHelper _openCallback = new RoomOpenHelper(configuration, new RoomOpenHelper.Delegate(9){

            public void createAllTables(SupportSQLiteDatabase _db) {
                _db.execSQL("CREATE TABLE IF NOT EXISTS `transactions` (`id` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `requestDate` INTEGER, `responseDate` INTEGER, `tookMs` INTEGER, `protocol` TEXT, `method` TEXT, `url` TEXT, `host` TEXT, `path` TEXT, `scheme` TEXT, `responseTlsVersion` TEXT, `responseCipherSuite` TEXT, `requestPayloadSize` INTEGER, `requestContentType` TEXT, `requestHeaders` TEXT, `requestHeadersSize` INTEGER, `requestBody` TEXT, `isRequestBodyEncoded` INTEGER NOT NULL, `responseCode` INTEGER, `responseMessage` TEXT, `error` TEXT, `responsePayloadSize` INTEGER, `responseContentType` TEXT, `responseHeaders` TEXT, `responseHeadersSize` INTEGER, `responseBody` TEXT, `isResponseBodyEncoded` INTEGER NOT NULL, `responseImageData` BLOB, `graphQlDetected` INTEGER NOT NULL, `graphQlOperationName` TEXT)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS room_master_table (id INTEGER PRIMARY KEY,identity_hash TEXT)");
                _db.execSQL("INSERT OR REPLACE INTO room_master_table (id,identity_hash) VALUES(42, 'ac72c06b37efb89e6417a7707016d4f5')");
            }

            public void dropAllTables(SupportSQLiteDatabase _db) {
                _db.execSQL("DROP TABLE IF EXISTS `transactions`");
                if (ChuckerDatabase_Impl.this.mCallbacks != null) {
                    int _size = ChuckerDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)ChuckerDatabase_Impl.this.mCallbacks.get(_i)).onDestructiveMigration(_db);
                    }
                }
            }

            public void onCreate(SupportSQLiteDatabase _db) {
                if (ChuckerDatabase_Impl.this.mCallbacks != null) {
                    int _size = ChuckerDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)ChuckerDatabase_Impl.this.mCallbacks.get(_i)).onCreate(_db);
                    }
                }
            }

            public void onOpen(SupportSQLiteDatabase _db) {
                ChuckerDatabase_Impl.this.mDatabase = _db;
                ChuckerDatabase_Impl.this.internalInitInvalidationTracker(_db);
                if (ChuckerDatabase_Impl.this.mCallbacks != null) {
                    int _size = ChuckerDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)ChuckerDatabase_Impl.this.mCallbacks.get(_i)).onOpen(_db);
                    }
                }
            }

            public void onPreMigrate(SupportSQLiteDatabase _db) {
                DBUtil.dropFtsSyncTriggers((SupportSQLiteDatabase)_db);
            }

            public void onPostMigrate(SupportSQLiteDatabase _db) {
            }

            public RoomOpenHelper.ValidationResult onValidateSchema(SupportSQLiteDatabase _db) {
                HashMap<String, TableInfo.Column> _columnsTransactions = new HashMap<String, TableInfo.Column>(30);
                _columnsTransactions.put("id", new TableInfo.Column("id", "INTEGER", true, 1, null, 1));
                _columnsTransactions.put("requestDate", new TableInfo.Column("requestDate", "INTEGER", false, 0, null, 1));
                _columnsTransactions.put("responseDate", new TableInfo.Column("responseDate", "INTEGER", false, 0, null, 1));
                _columnsTransactions.put("tookMs", new TableInfo.Column("tookMs", "INTEGER", false, 0, null, 1));
                _columnsTransactions.put("protocol", new TableInfo.Column("protocol", "TEXT", false, 0, null, 1));
                _columnsTransactions.put("method", new TableInfo.Column("method", "TEXT", false, 0, null, 1));
                _columnsTransactions.put("url", new TableInfo.Column("url", "TEXT", false, 0, null, 1));
                _columnsTransactions.put("host", new TableInfo.Column("host", "TEXT", false, 0, null, 1));
                _columnsTransactions.put("path", new TableInfo.Column("path", "TEXT", false, 0, null, 1));
                _columnsTransactions.put("scheme", new TableInfo.Column("scheme", "TEXT", false, 0, null, 1));
                _columnsTransactions.put("responseTlsVersion", new TableInfo.Column("responseTlsVersion", "TEXT", false, 0, null, 1));
                _columnsTransactions.put("responseCipherSuite", new TableInfo.Column("responseCipherSuite", "TEXT", false, 0, null, 1));
                _columnsTransactions.put("requestPayloadSize", new TableInfo.Column("requestPayloadSize", "INTEGER", false, 0, null, 1));
                _columnsTransactions.put("requestContentType", new TableInfo.Column("requestContentType", "TEXT", false, 0, null, 1));
                _columnsTransactions.put("requestHeaders", new TableInfo.Column("requestHeaders", "TEXT", false, 0, null, 1));
                _columnsTransactions.put("requestHeadersSize", new TableInfo.Column("requestHeadersSize", "INTEGER", false, 0, null, 1));
                _columnsTransactions.put("requestBody", new TableInfo.Column("requestBody", "TEXT", false, 0, null, 1));
                _columnsTransactions.put("isRequestBodyEncoded", new TableInfo.Column("isRequestBodyEncoded", "INTEGER", true, 0, null, 1));
                _columnsTransactions.put("responseCode", new TableInfo.Column("responseCode", "INTEGER", false, 0, null, 1));
                _columnsTransactions.put("responseMessage", new TableInfo.Column("responseMessage", "TEXT", false, 0, null, 1));
                _columnsTransactions.put("error", new TableInfo.Column("error", "TEXT", false, 0, null, 1));
                _columnsTransactions.put("responsePayloadSize", new TableInfo.Column("responsePayloadSize", "INTEGER", false, 0, null, 1));
                _columnsTransactions.put("responseContentType", new TableInfo.Column("responseContentType", "TEXT", false, 0, null, 1));
                _columnsTransactions.put("responseHeaders", new TableInfo.Column("responseHeaders", "TEXT", false, 0, null, 1));
                _columnsTransactions.put("responseHeadersSize", new TableInfo.Column("responseHeadersSize", "INTEGER", false, 0, null, 1));
                _columnsTransactions.put("responseBody", new TableInfo.Column("responseBody", "TEXT", false, 0, null, 1));
                _columnsTransactions.put("isResponseBodyEncoded", new TableInfo.Column("isResponseBodyEncoded", "INTEGER", true, 0, null, 1));
                _columnsTransactions.put("responseImageData", new TableInfo.Column("responseImageData", "BLOB", false, 0, null, 1));
                _columnsTransactions.put("graphQlDetected", new TableInfo.Column("graphQlDetected", "INTEGER", true, 0, null, 1));
                _columnsTransactions.put("graphQlOperationName", new TableInfo.Column("graphQlOperationName", "TEXT", false, 0, null, 1));
                HashSet _foreignKeysTransactions = new HashSet(0);
                HashSet _indicesTransactions = new HashSet(0);
                TableInfo _infoTransactions = new TableInfo("transactions", _columnsTransactions, _foreignKeysTransactions, _indicesTransactions);
                TableInfo _existingTransactions = TableInfo.read((SupportSQLiteDatabase)_db, (String)"transactions");
                if (!_infoTransactions.equals((Object)_existingTransactions)) {
                    return new RoomOpenHelper.ValidationResult(false, "transactions(com.chuckerteam.chucker.internal.data.entity.HttpTransaction).\n Expected:\n" + _infoTransactions + "\n Found:\n" + _existingTransactions);
                }
                return new RoomOpenHelper.ValidationResult(true, null);
            }
        }, "ac72c06b37efb89e6417a7707016d4f5", "a70b1841a05694f746087779f5a5c887");
        SupportSQLiteOpenHelper.Configuration _sqliteConfig = SupportSQLiteOpenHelper.Configuration.builder((Context)configuration.context).name(configuration.name).callback((SupportSQLiteOpenHelper.Callback)_openCallback).build();
        SupportSQLiteOpenHelper _helper = configuration.sqliteOpenHelperFactory.create(_sqliteConfig);
        return _helper;
    }

    protected InvalidationTracker createInvalidationTracker() {
        HashMap _shadowTablesMap = new HashMap(0);
        HashMap _viewTables = new HashMap(0);
        return new InvalidationTracker((RoomDatabase)this, _shadowTablesMap, _viewTables, new String[]{"transactions"});
    }

    public void clearAllTables() {
        super.assertNotMainThread();
        SupportSQLiteDatabase _db = super.getOpenHelper().getWritableDatabase();
        try {
            super.beginTransaction();
            _db.execSQL("DELETE FROM `transactions`");
            super.setTransactionSuccessful();
        }
        finally {
            super.endTransaction();
            _db.query("PRAGMA wal_checkpoint(FULL)").close();
            if (!_db.inTransaction()) {
                _db.execSQL("VACUUM");
            }
        }
    }

    protected Map<Class<?>, List<Class<?>>> getRequiredTypeConverters() {
        HashMap _typeConvertersMap = new HashMap();
        _typeConvertersMap.put(HttpTransactionDao.class, HttpTransactionDao_Impl.getRequiredConverters());
        return _typeConvertersMap;
    }

    public Set<Class<? extends AutoMigrationSpec>> getRequiredAutoMigrationSpecs() {
        HashSet<Class<? extends AutoMigrationSpec>> _autoMigrationSpecsSet = new HashSet<Class<? extends AutoMigrationSpec>>();
        return _autoMigrationSpecsSet;
    }

    public List<Migration> getAutoMigrations(@NonNull Map<Class<? extends AutoMigrationSpec>, AutoMigrationSpec> autoMigrationSpecsMap) {
        return Arrays.asList(new Migration[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpTransactionDao transactionDao() {
        if (this._httpTransactionDao != null) {
            return this._httpTransactionDao;
        }
        ChuckerDatabase_Impl chuckerDatabase_Impl = this;
        synchronized (chuckerDatabase_Impl) {
            if (this._httpTransactionDao == null) {
                this._httpTransactionDao = new HttpTransactionDao_Impl(this);
            }
            return this._httpTransactionDao;
        }
    }
}

