/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.internal.support;

import android.content.Context;
import com.chuckerteam.chucker.R;
import com.chuckerteam.chucker.internal.data.entity.HttpTransaction;
import com.chuckerteam.chucker.internal.support.FormatUtils;
import com.chuckerteam.chucker.internal.support.Sharable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okio.Buffer;
import okio.Source;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/chuckerteam/chucker/internal/support/TransactionDetailsSharable;", "Lcom/chuckerteam/chucker/internal/support/Sharable;", "transaction", "Lcom/chuckerteam/chucker/internal/data/entity/HttpTransaction;", "encodeUrls", "", "(Lcom/chuckerteam/chucker/internal/data/entity/HttpTransaction;Z)V", "toSharableContent", "Lokio/Source;", "context", "Landroid/content/Context;", "com.github.ChuckerTeam.Chucker.library"})
public final class TransactionDetailsSharable
implements Sharable {
    @NotNull
    private final HttpTransaction transaction;
    private final boolean encodeUrls;

    public TransactionDetailsSharable(@NotNull HttpTransaction transaction, boolean encodeUrls) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        this.transaction = transaction;
        this.encodeUrls = encodeUrls;
    }

    @Override
    @NotNull
    public Source toSharableContent(@NotNull Context context) {
        String string2;
        String string3;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Buffer buffer = new Buffer();
        boolean bl2 = false;
        boolean bl3 = false;
        Buffer $this$toSharableContent_u24lambda_u2d0 = buffer;
        boolean bl4 = false;
        $this$toSharableContent_u24lambda_u2d0.writeUtf8(context.getString(R.string.chucker_url) + ": " + this.transaction.getFormattedUrl(this.encodeUrls) + '\n');
        $this$toSharableContent_u24lambda_u2d0.writeUtf8(context.getString(R.string.chucker_method) + ": " + this.transaction.getMethod() + '\n');
        $this$toSharableContent_u24lambda_u2d0.writeUtf8(context.getString(R.string.chucker_protocol) + ": " + this.transaction.getProtocol() + '\n');
        $this$toSharableContent_u24lambda_u2d0.writeUtf8(context.getString(R.string.chucker_status) + ": " + (Object)((Object)this.transaction.getStatus()) + '\n');
        $this$toSharableContent_u24lambda_u2d0.writeUtf8(context.getString(R.string.chucker_response) + ": " + this.transaction.getResponseSummaryText() + '\n');
        int isSsl = this.transaction.isSsl() ? R.string.chucker_yes : R.string.chucker_no;
        $this$toSharableContent_u24lambda_u2d0.writeUtf8(context.getString(R.string.chucker_ssl) + ": " + context.getString(isSsl) + '\n');
        $this$toSharableContent_u24lambda_u2d0.writeUtf8("\n");
        $this$toSharableContent_u24lambda_u2d0.writeUtf8(context.getString(R.string.chucker_request_time) + ": " + this.transaction.getRequestDateString() + '\n');
        $this$toSharableContent_u24lambda_u2d0.writeUtf8(context.getString(R.string.chucker_response_time) + ": " + this.transaction.getResponseDateString() + '\n');
        $this$toSharableContent_u24lambda_u2d0.writeUtf8(context.getString(R.string.chucker_duration) + ": " + this.transaction.getDurationString() + '\n');
        $this$toSharableContent_u24lambda_u2d0.writeUtf8("\n");
        $this$toSharableContent_u24lambda_u2d0.writeUtf8(context.getString(R.string.chucker_request_size) + ": " + this.transaction.getRequestSizeString() + '\n');
        $this$toSharableContent_u24lambda_u2d0.writeUtf8(context.getString(R.string.chucker_response_size) + ": " + this.transaction.getResponseSizeString() + '\n');
        $this$toSharableContent_u24lambda_u2d0.writeUtf8(context.getString(R.string.chucker_total_size) + ": " + this.transaction.getTotalSizeString() + '\n');
        $this$toSharableContent_u24lambda_u2d0.writeUtf8("\n");
        $this$toSharableContent_u24lambda_u2d0.writeUtf8("---------- " + context.getString(R.string.chucker_request) + " ----------\n\n");
        String headers = FormatUtils.INSTANCE.formatHeaders(this.transaction.getParsedRequestHeaders(), false);
        CharSequence charSequence = headers;
        boolean bl5 = false;
        if (!StringsKt.isBlank((CharSequence)charSequence)) {
            $this$toSharableContent_u24lambda_u2d0.writeUtf8(headers);
            $this$toSharableContent_u24lambda_u2d0.writeUtf8("\n");
        }
        if (this.transaction.isRequestBodyPlainText()) {
            charSequence = this.transaction.getRequestBody();
            bl5 = false;
            bl = false;
            string3 = charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? context.getString(R.string.chucker_body_empty) : this.transaction.getFormattedRequestBody();
        } else {
            string3 = context.getString(R.string.chucker_body_omitted);
        }
        $this$toSharableContent_u24lambda_u2d0.writeUtf8(string3);
        $this$toSharableContent_u24lambda_u2d0.writeUtf8("\n\n");
        $this$toSharableContent_u24lambda_u2d0.writeUtf8("---------- " + context.getString(R.string.chucker_response) + " ----------\n\n");
        headers = FormatUtils.INSTANCE.formatHeaders(this.transaction.getParsedResponseHeaders(), false);
        charSequence = headers;
        bl5 = false;
        if (!StringsKt.isBlank((CharSequence)charSequence)) {
            $this$toSharableContent_u24lambda_u2d0.writeUtf8(headers);
            $this$toSharableContent_u24lambda_u2d0.writeUtf8("\n");
        }
        if (this.transaction.isResponseBodyPlainText()) {
            charSequence = this.transaction.getResponseBody();
            bl5 = false;
            bl = false;
            string2 = charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? context.getString(R.string.chucker_body_empty) : this.transaction.getFormattedResponseBody();
        } else {
            string2 = context.getString(R.string.chucker_body_omitted);
        }
        $this$toSharableContent_u24lambda_u2d0.writeUtf8(string2);
        return (Source)buffer;
    }
}

