/*
 * Decompiled with CFR 0.152.
 */
package com.github.chuanzh.util;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassHelperUtils {
    private static Logger logger = LoggerFactory.getLogger((String)ClassHelperUtils.class.getName());
    private static String[] BASE_TYPE_ARR = new String[]{"boolean", "char", "byte", "short", "int", "long", "float", "double", "Boolean", "Char", "Byte", "Short", "Integer", "Long", "Float", "Double", "String", "BigDecimal", "Date"};
    private static HashSet BASE_TYPE = new HashSet();
    private static HashSet FILTER_FIELDS = new HashSet();

    public static ArrayList<Field> findClassAllField(Class clazz) {
        ArrayList<Field> list = new ArrayList<Field>();
        try {
            ArrayList clazzList = new ArrayList();
            while (!"java.lang.Object".equals(clazz.getName())) {
                clazzList.add(clazz);
                if ((clazz = clazz.getSuperclass()) != null) continue;
            }
            Collections.reverse(clazzList);
            for (int i = 0; i < clazzList.size(); ++i) {
                Field[] fs;
                for (Field f : fs = ((Class)clazzList.get(i)).getDeclaredFields()) {
                    list.add(f);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u7c7b\u53d8\u91cf\u5931\u8d25" + clazz.getName(), (Throwable)e);
        }
        return list;
    }

    public static boolean isFilterField(String field) {
        return FILTER_FIELDS.contains(field);
    }

    public static boolean isBaseType(Type type) {
        String simpleName = type.getTypeName().substring(type.getTypeName().lastIndexOf(".") + 1);
        return ClassHelperUtils.isBaseTypeName(simpleName);
    }

    public static boolean isListTypeName(String simpleName) {
        return "java.util.List".equals(simpleName);
    }

    public static boolean isListBaseType(Type type) {
        String simpleName = type.getTypeName();
        String subSimpleName = "Long";
        if (type.getTypeName().indexOf("<") != -1) {
            simpleName = type.getTypeName().substring(0, type.getTypeName().lastIndexOf("<"));
            subSimpleName = type.getTypeName().substring(type.getTypeName().lastIndexOf(".") + 1, type.getTypeName().lastIndexOf(">"));
        }
        return "java.util.List".equals(simpleName) && ClassHelperUtils.isBaseTypeName(subSimpleName);
    }

    public static boolean isBaseTypeName(String simpleName) {
        return BASE_TYPE.contains(simpleName);
    }

    public static String getGenericTypeName(Field field) {
        String genericType = field.getGenericType().getTypeName();
        if (genericType.indexOf("<") != -1) {
            String simpleType = field.getType().getSimpleName();
            String simpleSubName = genericType.substring(genericType.lastIndexOf(".") + 1);
            return simpleType + "<" + simpleSubName;
        }
        String typeName = genericType.substring(genericType.lastIndexOf(".") + 1);
        if (typeName.equals("T")) {
            return "Object";
        }
        return typeName;
    }

    public static String subClass(Type type) {
        String typeName;
        String subTypeName = typeName = type.getTypeName();
        String simpleName = null;
        if (typeName.indexOf("<") != -1) {
            subTypeName = typeName.substring(typeName.lastIndexOf("<") + 1, typeName.indexOf(">"));
            simpleName = subTypeName.substring(subTypeName.lastIndexOf(".") + 1);
        }
        if (simpleName != null && BASE_TYPE.contains(simpleName)) {
            return null;
        }
        return subTypeName;
    }

    public static void mkdirs(String dirPath) {
        boolean result;
        File dir = new File(dirPath);
        if (!dir.exists() && (result = dir.mkdirs())) {
            logger.debug("\u521b\u5efa\u76ee\u5f55\uff1a [" + dirPath + "]");
        }
    }

    public static void open(String dirPath) {
        try {
            String osName = System.getProperty("os.name");
            if (osName != null) {
                if (osName.contains("Mac")) {
                    Runtime.getRuntime().exec("open " + dirPath);
                } else if (osName.contains("Windows")) {
                    Runtime.getRuntime().exec("cmd /c start " + dirPath);
                } else {
                    logger.debug("\u6587\u4ef6\u8f93\u51fa\u76ee\u5f55:" + dirPath);
                }
            }
        }
        catch (IOException e) {
            logger.error("\u6253\u5f00\u76ee\u5f55\u5931\u8d25", (Throwable)e);
        }
    }

    static {
        for (String s : BASE_TYPE_ARR) {
            BASE_TYPE.add(s);
        }
        FILTER_FIELDS.add("serialVersionUID");
    }
}

