/*
 * Decompiled with CFR 0.152.
 */
package uk.co.senab.bitmapcache;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.util.AttributeSet;
import android.widget.ImageView;
import uk.co.senab.bitmapcache.CacheableBitmapDrawable;

public class CacheableImageView
extends ImageView {
    private static void onDrawableSet(Drawable drawable) {
        if (drawable instanceof CacheableBitmapDrawable) {
            ((CacheableBitmapDrawable)drawable).setBeingUsed(true);
        }
    }

    private static void onDrawableUnset(Drawable drawable) {
        if (drawable instanceof CacheableBitmapDrawable) {
            ((CacheableBitmapDrawable)drawable).setBeingUsed(false);
        }
    }

    public CacheableImageView(Context context) {
        super(context);
    }

    public CacheableImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public CacheableImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public void setImageDrawable(Drawable drawable) {
        Drawable previousDrawable = this.getDrawable();
        super.setImageDrawable(drawable);
        if (drawable != previousDrawable) {
            CacheableImageView.onDrawableSet(drawable);
            CacheableImageView.onDrawableUnset(previousDrawable);
        }
    }

    public void setImageResource(int resId) {
        Drawable previousDrawable = this.getDrawable();
        super.setImageResource(resId);
        CacheableImageView.onDrawableUnset(previousDrawable);
    }

    public void setImageURI(Uri uri) {
        Drawable previousDrawable = this.getDrawable();
        super.setImageURI(uri);
        CacheableImageView.onDrawableUnset(previousDrawable);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.setImageDrawable(null);
    }
}

