/*
 * Decompiled with CFR 0.152.
 */
package com.techies.googledictionary;

import android.app.Dialog;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.design.widget.BottomSheetBehavior;
import android.support.design.widget.BottomSheetDialogFragment;
import android.support.design.widget.CoordinatorLayout;
import android.support.v7.widget.Toolbar;
import android.view.View;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.techies.googledictionary.R;
import java.net.MalformedURLException;
import java.net.URL;

public class MyBSDF
extends BottomSheetDialogFragment {
    TextView textView;
    ProgressBar progressBar;
    CoordinatorLayout.LayoutParams params;
    CoordinatorLayout.Behavior behavior;
    static final String GOOGLE_EEARCH_BASE_URL = "https://www.google.com/search";
    static final String PARAM_QUERY = "q";
    WebView webView;
    private BottomSheetBehavior.BottomSheetCallback mBottomSheetBehaviorCallback = new BottomSheetBehavior.BottomSheetCallback(){

        public void onStateChanged(@NonNull View bottomSheet, int newState) {
            if (newState == 5) {
                MyBSDF.this.dismiss();
            }
        }

        public void onSlide(@NonNull View bottomSheet, float slideOffset) {
        }
    };

    public void setupDialog(Dialog dialog, int style) {
        super.setupDialog(dialog, style);
        Bundle args = this.getArguments();
        String text = args.getString("TEXT");
        URL searchURL = MyBSDF.buildUrl("define " + text);
        View contentView = View.inflate((Context)this.getContext(), (int)R.layout.fragment_bottom_sheet, null);
        this.textView = (TextView)contentView.findViewById(R.id.toolbar_title);
        this.webView = (WebView)contentView.findViewById(R.id.webview);
        this.textView.setText((CharSequence)text);
        Toolbar toolbar = (Toolbar)contentView.findViewById(R.id.toolbar);
        toolbar.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ((BottomSheetBehavior)MyBSDF.this.behavior).setState(3);
            }
        });
        this.progressBar = (ProgressBar)contentView.findViewById(R.id.progress_bar);
        this.progressBar.setMax(100);
        this.progressBar.setProgress(0);
        this.getActivity().getWindow().setFeatureInt(2, -1);
        this.webView.setWebChromeClient((WebChromeClient)new MyWebViewClient());
        this.webView.getSettings().setJavaScriptEnabled(true);
        this.webView.setScrollBarStyle(0);
        this.webView.loadUrl(searchURL.toString());
        dialog.setContentView(contentView);
        this.params = (CoordinatorLayout.LayoutParams)((View)contentView.getParent()).getLayoutParams();
        this.behavior = this.params.getBehavior();
        if (this.behavior != null && this.behavior instanceof BottomSheetBehavior) {
            ((BottomSheetBehavior)this.behavior).setPeekHeight(168);
            ((BottomSheetBehavior)this.behavior).setBottomSheetCallback(this.mBottomSheetBehaviorCallback);
        }
    }

    public void setValue(int progress) {
        this.progressBar.setProgress(progress);
    }

    public static URL buildUrl(String searchQuery) {
        Uri builtUri = Uri.parse((String)GOOGLE_EEARCH_BASE_URL).buildUpon().appendQueryParameter(PARAM_QUERY, searchQuery).build();
        URL url = null;
        try {
            url = new URL(builtUri.toString());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return url;
    }

    private class MyWebViewClient
    extends WebChromeClient {
        private MyWebViewClient() {
        }

        public void onProgressChanged(WebView view, int newProgress) {
            MyBSDF.this.setValue(newProgress);
            if (newProgress == 100) {
                MyBSDF.this.progressBar.setVisibility(8);
            }
            super.onProgressChanged(view, newProgress);
        }
    }
}

