/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.ausbc;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.hardware.usb.UsbDevice;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.view.Surface;
import com.jiangdg.ausbc.MultiCameraClient;
import com.jiangdg.ausbc.callback.ICameraStateCallBack;
import com.jiangdg.ausbc.callback.ICaptureCallBack;
import com.jiangdg.ausbc.callback.IDeviceConnectCallBack;
import com.jiangdg.ausbc.callback.IEncodeDataCallBack;
import com.jiangdg.ausbc.callback.IPlayCallBack;
import com.jiangdg.ausbc.callback.IPreviewDataCallBack;
import com.jiangdg.ausbc.camera.bean.CameraRequest;
import com.jiangdg.ausbc.camera.bean.PreviewSize;
import com.jiangdg.ausbc.encode.AACEncodeProcessor;
import com.jiangdg.ausbc.encode.AbstractProcessor;
import com.jiangdg.ausbc.encode.H264EncodeProcessor;
import com.jiangdg.ausbc.encode.audio.AudioStrategySystem;
import com.jiangdg.ausbc.encode.audio.AudioStrategyUAC;
import com.jiangdg.ausbc.encode.audio.IAudioStrategy;
import com.jiangdg.ausbc.encode.bean.RawData;
import com.jiangdg.ausbc.encode.muxer.Mp4Muxer;
import com.jiangdg.ausbc.render.RenderManager;
import com.jiangdg.ausbc.render.effect.AbstractEffect;
import com.jiangdg.ausbc.render.env.RotateType;
import com.jiangdg.ausbc.utils.CameraUtils;
import com.jiangdg.ausbc.utils.Logger;
import com.jiangdg.ausbc.utils.OpenGLUtils;
import com.jiangdg.ausbc.utils.SettableFuture;
import com.jiangdg.ausbc.utils.Utils;
import com.jiangdg.ausbc.widget.IAspectRatio;
import com.jiangdg.usb.DeviceFilter;
import com.jiangdg.usb.USBMonitor;
import com.jiangdg.uvc.UVCCamera;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\u0018\u0000 #2\u00020\u0001:\u0002#$B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012J\u0006\u0010\u0014\u001a\u00020\u0010J \u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u00162\u0010\b\u0002\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0012J\u0017\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0017\u00a2\u0006\u0002\u0010\u001bJ\b\u0010\u001c\u001a\u00020\u0019H\u0002J\u000e\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u0019J\u0006\u0010\u001f\u001a\u00020\u0010J\u0014\u0010 \u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012J\u0010\u0010!\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0017J\u0006\u0010\"\u001a\u00020\u0010R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/jiangdg/ausbc/MultiCameraClient;", "", "ctx", "Landroid/content/Context;", "callback", "Lcom/jiangdg/ausbc/callback/IDeviceConnectCallBack;", "(Landroid/content/Context;Lcom/jiangdg/ausbc/callback/IDeviceConnectCallBack;)V", "mMainHandler", "Landroid/os/Handler;", "getMMainHandler", "()Landroid/os/Handler;", "mMainHandler$delegate", "Lkotlin/Lazy;", "mUsbMonitor", "Lcom/jiangdg/usb/USBMonitor;", "addDeviceFilters", "", "list", "", "Lcom/jiangdg/usb/DeviceFilter;", "destroy", "getDeviceList", "", "Landroid/hardware/usb/UsbDevice;", "hasPermission", "", "device", "(Landroid/hardware/usb/UsbDevice;)Ljava/lang/Boolean;", "isMonitorRegistered", "openDebug", "debug", "register", "removeDeviceFilters", "requestPermission", "unRegister", "Companion", "ICamera", "libausbc_release"})
public final class MultiCameraClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private USBMonitor mUsbMonitor;
    @NotNull
    private final Lazy mMainHandler$delegate;
    @NotNull
    private static final String TAG = "MultiCameraClient";
    private static final int MSG_START_PREVIEW = 1;
    private static final int MSG_STOP_PREVIEW = 2;
    private static final int MSG_CAPTURE_IMAGE = 3;
    private static final int MSG_CAPTURE_VIDEO_START = 4;
    private static final int MSG_CAPTURE_VIDEO_STOP = 5;
    private static final int MSG_CAPTURE_STREAM_START = 6;
    private static final int MSG_CAPTURE_STREAM_STOP = 7;
    private static final int DEFAULT_PREVIEW_WIDTH = 640;
    private static final int DEFAULT_PREVIEW_HEIGHT = 480;
    public static final int MAX_NV21_DATA = 5;
    public static final long CAPTURE_TIMES_OUT_SEC = 3L;

    public MultiCameraClient(final @NotNull Context ctx, final @Nullable IDeviceConnectCallBack callback) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.mMainHandler$delegate = LazyKt.lazy((Function0)mMainHandler.2.INSTANCE);
        this.mUsbMonitor = new USBMonitor(ctx, new USBMonitor.OnDeviceConnectListener(){

            public void onAttach(@Nullable UsbDevice device) {
                UsbDevice usbDevice;
                if (Utils.INSTANCE.getDebugCamera()) {
                    StringBuilder stringBuilder = new StringBuilder().append("attach device name/pid/vid:").append((Object)((usbDevice = device) == null ? null : usbDevice.getDeviceName())).append('&');
                    usbDevice = device;
                    StringBuilder stringBuilder2 = stringBuilder.append(usbDevice == null ? null : Integer.valueOf(usbDevice.getProductId())).append('&');
                    usbDevice = device;
                    Logger.INSTANCE.i(MultiCameraClient.TAG, stringBuilder2.append(usbDevice == null ? null : Integer.valueOf(usbDevice.getVendorId())).append(' ').toString());
                }
                if ((usbDevice = device) == null) {
                    return;
                }
                if (!CameraUtils.INSTANCE.isUsbCamera(device) && !CameraUtils.INSTANCE.isFilterDevice(ctx, device)) {
                    return;
                }
                this.getMMainHandler().post(() -> 1.onAttach$lambda-0(callback, device));
            }

            public void onDetach(@Nullable UsbDevice device) {
                UsbDevice usbDevice;
                if (Utils.INSTANCE.getDebugCamera()) {
                    StringBuilder stringBuilder = new StringBuilder().append("detach device name/pid/vid:").append((Object)((usbDevice = device) == null ? null : usbDevice.getDeviceName())).append('&');
                    usbDevice = device;
                    StringBuilder stringBuilder2 = stringBuilder.append(usbDevice == null ? null : Integer.valueOf(usbDevice.getProductId())).append('&');
                    usbDevice = device;
                    Logger.INSTANCE.i(MultiCameraClient.TAG, stringBuilder2.append(usbDevice == null ? null : Integer.valueOf(usbDevice.getVendorId())).append(' ').toString());
                }
                if ((usbDevice = device) == null) {
                    return;
                }
                if (!CameraUtils.INSTANCE.isUsbCamera(device) && !CameraUtils.INSTANCE.isFilterDevice(ctx, device)) {
                    return;
                }
                this.getMMainHandler().post(() -> 1.onDetach$lambda-1(callback, device));
            }

            public void onConnect(@Nullable UsbDevice device, @Nullable USBMonitor.UsbControlBlock ctrlBlock, boolean createNew) {
                UsbDevice usbDevice;
                if (Utils.INSTANCE.getDebugCamera()) {
                    StringBuilder stringBuilder = new StringBuilder().append("connect device name/pid/vid:").append((Object)((usbDevice = device) == null ? null : usbDevice.getDeviceName())).append('&');
                    usbDevice = device;
                    StringBuilder stringBuilder2 = stringBuilder.append(usbDevice == null ? null : Integer.valueOf(usbDevice.getProductId())).append('&');
                    usbDevice = device;
                    Logger.INSTANCE.i(MultiCameraClient.TAG, stringBuilder2.append(usbDevice == null ? null : Integer.valueOf(usbDevice.getVendorId())).append(' ').toString());
                }
                if ((usbDevice = device) == null) {
                    return;
                }
                if (!CameraUtils.INSTANCE.isUsbCamera(device) && !CameraUtils.INSTANCE.isFilterDevice(ctx, device)) {
                    return;
                }
                this.getMMainHandler().post(() -> 1.onConnect$lambda-2(callback, device, ctrlBlock));
            }

            public void onDisconnect(@Nullable UsbDevice device, @Nullable USBMonitor.UsbControlBlock ctrlBlock) {
                UsbDevice usbDevice;
                if (Utils.INSTANCE.getDebugCamera()) {
                    StringBuilder stringBuilder = new StringBuilder().append("disconnect device name/pid/vid:").append((Object)((usbDevice = device) == null ? null : usbDevice.getDeviceName())).append('&');
                    usbDevice = device;
                    StringBuilder stringBuilder2 = stringBuilder.append(usbDevice == null ? null : Integer.valueOf(usbDevice.getProductId())).append('&');
                    usbDevice = device;
                    Logger.INSTANCE.i(MultiCameraClient.TAG, stringBuilder2.append(usbDevice == null ? null : Integer.valueOf(usbDevice.getVendorId())).append(' ').toString());
                }
                if ((usbDevice = device) == null) {
                    return;
                }
                if (!CameraUtils.INSTANCE.isUsbCamera(device) && !CameraUtils.INSTANCE.isFilterDevice(ctx, device)) {
                    return;
                }
                this.getMMainHandler().post(() -> 1.onDisconnect$lambda-3(callback, device, ctrlBlock));
            }

            public void onCancel(@Nullable UsbDevice device) {
                UsbDevice usbDevice;
                if (Utils.INSTANCE.getDebugCamera()) {
                    StringBuilder stringBuilder = new StringBuilder().append("cancel device name/pid/vid:").append((Object)((usbDevice = device) == null ? null : usbDevice.getDeviceName())).append('&');
                    usbDevice = device;
                    StringBuilder stringBuilder2 = stringBuilder.append(usbDevice == null ? null : Integer.valueOf(usbDevice.getProductId())).append('&');
                    usbDevice = device;
                    Logger.INSTANCE.i(MultiCameraClient.TAG, stringBuilder2.append(usbDevice == null ? null : Integer.valueOf(usbDevice.getVendorId())).append(' ').toString());
                }
                if ((usbDevice = device) == null) {
                    return;
                }
                if (!CameraUtils.INSTANCE.isUsbCamera(device) && !CameraUtils.INSTANCE.isFilterDevice(ctx, device)) {
                    return;
                }
                this.getMMainHandler().post(() -> 1.onCancel$lambda-4(callback, device));
            }

            private static final void onAttach$lambda-0(IDeviceConnectCallBack $callback, UsbDevice $device) {
                IDeviceConnectCallBack iDeviceConnectCallBack = $callback;
                if (iDeviceConnectCallBack != null) {
                    iDeviceConnectCallBack.onAttachDev($device);
                }
            }

            private static final void onDetach$lambda-1(IDeviceConnectCallBack $callback, UsbDevice $device) {
                IDeviceConnectCallBack iDeviceConnectCallBack = $callback;
                if (iDeviceConnectCallBack != null) {
                    iDeviceConnectCallBack.onDetachDec($device);
                }
            }

            private static final void onConnect$lambda-2(IDeviceConnectCallBack $callback, UsbDevice $device, USBMonitor.UsbControlBlock $ctrlBlock) {
                IDeviceConnectCallBack iDeviceConnectCallBack = $callback;
                if (iDeviceConnectCallBack != null) {
                    iDeviceConnectCallBack.onConnectDev($device, $ctrlBlock);
                }
            }

            private static final void onDisconnect$lambda-3(IDeviceConnectCallBack $callback, UsbDevice $device, USBMonitor.UsbControlBlock $ctrlBlock) {
                IDeviceConnectCallBack iDeviceConnectCallBack = $callback;
                if (iDeviceConnectCallBack != null) {
                    iDeviceConnectCallBack.onDisConnectDec($device, $ctrlBlock);
                }
            }

            private static final void onCancel$lambda-4(IDeviceConnectCallBack $callback, UsbDevice $device) {
                IDeviceConnectCallBack iDeviceConnectCallBack = $callback;
                if (iDeviceConnectCallBack != null) {
                    iDeviceConnectCallBack.onCancelDev($device);
                }
            }
        });
    }

    private final Handler getMMainHandler() {
        Lazy lazy = this.mMainHandler$delegate;
        boolean bl = false;
        return (Handler)lazy.getValue();
    }

    public final void register() {
        USBMonitor uSBMonitor;
        if (this.isMonitorRegistered()) {
            return;
        }
        if (Utils.INSTANCE.getDebugCamera()) {
            Logger.INSTANCE.i(TAG, "register...");
        }
        if ((uSBMonitor = this.mUsbMonitor) != null) {
            uSBMonitor.register();
        }
    }

    public final void unRegister() {
        USBMonitor uSBMonitor;
        if (!this.isMonitorRegistered()) {
            return;
        }
        if (Utils.INSTANCE.getDebugCamera()) {
            Logger.INSTANCE.i(TAG, "unRegister...");
        }
        if ((uSBMonitor = this.mUsbMonitor) != null) {
            uSBMonitor.unregister();
        }
    }

    public final boolean requestPermission(@Nullable UsbDevice device) {
        if (!this.isMonitorRegistered()) {
            Logger.INSTANCE.w(TAG, "Usb monitor haven't been registered.");
            return false;
        }
        USBMonitor uSBMonitor = this.mUsbMonitor;
        if (uSBMonitor != null) {
            uSBMonitor.requestPermission(device);
        }
        return true;
    }

    @Nullable
    public final Boolean hasPermission(@Nullable UsbDevice device) {
        USBMonitor uSBMonitor = this.mUsbMonitor;
        return uSBMonitor == null ? null : Boolean.valueOf(uSBMonitor.hasPermission(device));
    }

    @Nullable
    public final List<UsbDevice> getDeviceList(@Nullable List<DeviceFilter> list) {
        USBMonitor uSBMonitor = list;
        if (uSBMonitor != null) {
            USBMonitor uSBMonitor2 = uSBMonitor;
            boolean bl = false;
            boolean bl2 = false;
            USBMonitor it = uSBMonitor2;
            boolean bl3 = false;
            this.addDeviceFilters((List<DeviceFilter>)it);
        }
        uSBMonitor = this.mUsbMonitor;
        return uSBMonitor == null ? null : uSBMonitor.getDeviceList();
    }

    public static /* synthetic */ List getDeviceList$default(MultiCameraClient multiCameraClient, List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = null;
        }
        return multiCameraClient.getDeviceList(list);
    }

    public final void addDeviceFilters(@NotNull List<DeviceFilter> list) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        USBMonitor uSBMonitor = this.mUsbMonitor;
        if (uSBMonitor != null) {
            uSBMonitor.addDeviceFilter(list);
        }
    }

    public final void removeDeviceFilters(@NotNull List<DeviceFilter> list) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        USBMonitor uSBMonitor = this.mUsbMonitor;
        if (uSBMonitor != null) {
            uSBMonitor.removeDeviceFilter(list);
        }
    }

    public final void destroy() {
        USBMonitor uSBMonitor = this.mUsbMonitor;
        if (uSBMonitor != null) {
            uSBMonitor.destroy();
        }
    }

    public final void openDebug(boolean debug) {
        Utils.INSTANCE.setDebugCamera(debug);
        USBMonitor.DEBUG = debug;
        UVCCamera.DEBUG = debug;
    }

    private final boolean isMonitorRegistered() {
        USBMonitor uSBMonitor = this.mUsbMonitor;
        return uSBMonitor == null ? false : uSBMonitor.isRegistered();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0094\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010d\u001a\u00020e2\u0006\u0010f\u001a\u00020SJ\u000e\u0010g\u001a\u00020e2\u0006\u0010h\u001a\u00020\u0018J\u001a\u0010i\u001a\u00020e2\u0006\u0010f\u001a\u00020j2\n\b\u0002\u0010k\u001a\u0004\u0018\u00010\u001fJ\u0006\u0010l\u001a\u00020eJ\u001a\u0010m\u001a\u00020e2\u0006\u0010f\u001a\u00020j2\n\b\u0002\u0010n\u001a\u0004\u0018\u00010\u001fJ\u001a\u0010o\u001a\u00020e2\b\u0010p\u001a\u0004\u0018\u00010\u001f2\u0006\u0010q\u001a\u00020jH$J\u0006\u0010r\u001a\u00020eJ\b\u0010s\u001a\u00020eH\u0002J\u0006\u0010t\u001a\u00020eJ\b\u0010u\u001a\u00020eH\u0002J$\u0010v\u001a\u00020e2\u0006\u0010f\u001a\u00020j2\n\b\u0002\u0010n\u001a\u0004\u0018\u00010\u001f2\b\b\u0002\u0010w\u001a\u00020xJ\"\u0010y\u001a\u00020e2\b\u0010n\u001a\u0004\u0018\u00010\u001f2\u0006\u0010w\u001a\u00020x2\u0006\u0010f\u001a\u00020jH\u0002J\u0006\u0010z\u001a\u00020eJ\b\u0010{\u001a\u00020eH\u0002J\u0006\u0010|\u001a\u00020eJ\b\u0010}\u001a\u00020eH$J#\u0010~\u001a\t\u0012\u0005\u0012\u00030\u0080\u00010\u007f2\f\b\u0002\u0010\u0081\u0001\u001a\u0005\u0018\u00010\u0082\u0001H&\u00a2\u0006\u0003\u0010\u0083\u0001J\f\u0010\u0084\u0001\u001a\u0005\u0018\u00010\u0085\u0001H\u0014J\t\u0010\u0086\u0001\u001a\u0004\u0018\u00010*J\t\u0010\u0087\u0001\u001a\u00020*H\u0002J\t\u0010\u0088\u0001\u001a\u0004\u0018\u00010\u0018J\u001a\u0010\u0089\u0001\u001a\u00030\u0080\u00012\u0007\u0010\u008a\u0001\u001a\u00020b2\u0007\u0010\u008b\u0001\u001a\u00020bJ\u0007\u0010\u008c\u0001\u001a\u00020\u0006J\u0013\u0010\u008d\u0001\u001a\u00020\r2\b\u0010\u008e\u0001\u001a\u00030\u008f\u0001H\u0016J\u001b\u0010\u0090\u0001\u001a\u00020e2\u0007\u0010\u0091\u0001\u001a\u00020b2\u0007\u0010\u0092\u0001\u001a\u00020bH\u0004J\u0007\u0010\u0093\u0001\u001a\u00020\rJ\t\u0010\u0094\u0001\u001a\u00020\rH\u0002J\u0012\u0010\u0095\u0001\u001a\u00020\r2\u0007\u0010\u0096\u0001\u001a\u00020\rH\u0002J\u0011\u0010\u0097\u0001\u001a\u00020\r2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\u0011\u0010\u0098\u0001\u001a\u00020\r2\b\u0010\u0099\u0001\u001a\u00030\u0080\u0001J\u0007\u0010\u009a\u0001\u001a\u00020\rJ\u0007\u0010\u009b\u0001\u001a\u00020\rJ\u0015\u0010\u009c\u0001\u001a\u00020e2\n\u0010\u009d\u0001\u001a\u0005\u0018\u00010\u009e\u0001H\u0016J/\u0010\u009f\u0001\u001a\u00020e\"\u0005\b\u0000\u0010\u00a0\u00012\f\b\u0002\u0010\u00a1\u0001\u001a\u0005\u0018\u0001H\u00a0\u00012\u000b\b\u0002\u0010\u00a2\u0001\u001a\u0004\u0018\u00010*\u00a2\u0006\u0003\u0010\u00a3\u0001J \u0010\u00a4\u0001\u001a\u00020e\"\u0005\b\u0000\u0010\u00a0\u00012\b\u0010\u00a1\u0001\u001a\u0003H\u00a0\u0001H$\u00a2\u0006\u0003\u0010\u00a5\u0001J \u0010\u00a6\u0001\u001a\u00020e2\b\u0010\u00a7\u0001\u001a\u00030\u00a8\u00012\u000b\b\u0002\u0010\u008e\u0001\u001a\u0004\u0018\u00010\u001fH\u0004J\u0012\u0010\u00a9\u0001\u001a\u00020e2\u0007\u0010\u00aa\u0001\u001a\u00020MH\u0004J\t\u0010\u00ab\u0001\u001a\u00020eH\u0004J\u000f\u0010\u00ac\u0001\u001a\u00020e2\u0006\u0010f\u001a\u00020SJ\u000f\u0010\u00ad\u0001\u001a\u00020e2\u0006\u0010h\u001a\u00020\u0018J\u0011\u0010\u00ae\u0001\u001a\u00020e2\b\u0010q\u001a\u0004\u0018\u000100J\u0011\u0010\u00af\u0001\u001a\u00020e2\b\u0010f\u001a\u0004\u0018\u00010EJ\u0019\u0010\u00b0\u0001\u001a\u00020e2\u0007\u0010\u00b1\u0001\u001a\u00020b2\u0007\u0010\u00b2\u0001\u001a\u00020bJ\u0013\u0010\u00b3\u0001\u001a\u00020e2\n\u0010\u00b4\u0001\u001a\u0005\u0018\u00010\u00b5\u0001J\u0012\u0010\u00b6\u0001\u001a\u00020e2\t\u0010\u00b7\u0001\u001a\u0004\u0018\u00010:J\u0012\u0010\u00b8\u0001\u001a\u00020e2\t\u0010f\u001a\u0005\u0018\u00010\u00b9\u0001J\u0007\u0010\u00ba\u0001\u001a\u00020eJ\u001a\u0010\u00bb\u0001\u001a\u00020e2\u0007\u0010\u00bc\u0001\u001a\u00020b2\b\u0010h\u001a\u0004\u0018\u00010\u0018J\u0019\u0010\u00bd\u0001\u001a\u00020e2\u0007\u0010\u00b1\u0001\u001a\u00020b2\u0007\u0010\u00b2\u0001\u001a\u00020bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\rX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\rX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000f\"\u0004\b\u0013\u0010\u0011R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R+\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u00180\u0017j\b\u0012\u0004\u0012\u00020\u0018`\u00198BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001a\u0010\u001bR\u001b\u0010\u001e\u001a\u00020\u001f8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010\u001d\u001a\u0004\b \u0010!R\u001c\u0010#\u001a\u0004\u0018\u00010$X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001c\u0010)\u001a\u0004\u0018\u00010*X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u0010\u0010/\u001a\u0004\u0018\u000100X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00101\u001a\u0004\u0018\u000102X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00103\u001a\u0004\u0018\u000104X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00105\u001a\u00020\u0004X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010\t\"\u0004\b7\u00108R\u001c\u00109\u001a\u0004\u0018\u00010:X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>R\u001b\u0010?\u001a\u00020@8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\bC\u0010\u001d\u001a\u0004\bA\u0010BR\u0010\u0010D\u001a\u0004\u0018\u00010EX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010F\u001a\u00020$8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\bH\u0010\u001d\u001a\u0004\bG\u0010&R\u0010\u0010I\u001a\u0004\u0018\u00010JX\u0082\u000e\u00a2\u0006\u0002\n\u0000R!\u0010K\u001a\b\u0012\u0004\u0012\u00020M0L8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\bP\u0010\u001d\u001a\u0004\bN\u0010OR \u0010Q\u001a\b\u0012\u0004\u0012\u00020S0RX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bT\u0010U\"\u0004\bV\u0010WR\u0010\u0010X\u001a\u0004\u0018\u00010YX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010Z\u001a\u00020[8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b^\u0010\u001d\u001a\u0004\b\\\u0010]R\"\u0010_\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020b\u0012\u0004\u0012\u00020b0a\u0018\u00010`X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010c\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00be\u0001"}, d2={"Lcom/jiangdg/ausbc/MultiCameraClient$ICamera;", "Landroid/os/Handler$Callback;", "Lcom/jiangdg/ausbc/encode/H264EncodeProcessor$OnEncodeReadyListener;", "ctx", "Landroid/content/Context;", "device", "Landroid/hardware/usb/UsbDevice;", "(Landroid/content/Context;Landroid/hardware/usb/UsbDevice;)V", "getCtx", "()Landroid/content/Context;", "getDevice", "()Landroid/hardware/usb/UsbDevice;", "isCaptureStream", "", "isNeedGLESRender", "()Z", "setNeedGLESRender", "(Z)V", "isPreviewed", "setPreviewed", "mAudioProcess", "Lcom/jiangdg/ausbc/encode/AbstractProcessor;", "mCacheEffectList", "Ljava/util/ArrayList;", "Lcom/jiangdg/ausbc/render/effect/AbstractEffect;", "Lkotlin/collections/ArrayList;", "getMCacheEffectList", "()Ljava/util/ArrayList;", "mCacheEffectList$delegate", "Lkotlin/Lazy;", "mCameraDir", "", "getMCameraDir", "()Ljava/lang/String;", "mCameraDir$delegate", "mCameraHandler", "Landroid/os/Handler;", "getMCameraHandler", "()Landroid/os/Handler;", "setMCameraHandler", "(Landroid/os/Handler;)V", "mCameraRequest", "Lcom/jiangdg/ausbc/camera/bean/CameraRequest;", "getMCameraRequest", "()Lcom/jiangdg/ausbc/camera/bean/CameraRequest;", "setMCameraRequest", "(Lcom/jiangdg/ausbc/camera/bean/CameraRequest;)V", "mCameraStateCallback", "Lcom/jiangdg/ausbc/callback/ICameraStateCallBack;", "mCameraThread", "Landroid/os/HandlerThread;", "mCameraView", "", "mContext", "getMContext", "setMContext", "(Landroid/content/Context;)V", "mCtrlBlock", "Lcom/jiangdg/usb/USBMonitor$UsbControlBlock;", "getMCtrlBlock", "()Lcom/jiangdg/usb/USBMonitor$UsbControlBlock;", "setMCtrlBlock", "(Lcom/jiangdg/usb/USBMonitor$UsbControlBlock;)V", "mDateFormat", "Ljava/text/SimpleDateFormat;", "getMDateFormat", "()Ljava/text/SimpleDateFormat;", "mDateFormat$delegate", "mEncodeDataCallBack", "Lcom/jiangdg/ausbc/callback/IEncodeDataCallBack;", "mMainHandler", "getMMainHandler", "mMainHandler$delegate", "mMediaMuxer", "Lcom/jiangdg/ausbc/encode/muxer/Mp4Muxer;", "mNV21DataQueue", "Ljava/util/concurrent/LinkedBlockingDeque;", "", "getMNV21DataQueue", "()Ljava/util/concurrent/LinkedBlockingDeque;", "mNV21DataQueue$delegate", "mPreviewDataCbList", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/jiangdg/ausbc/callback/IPreviewDataCallBack;", "getMPreviewDataCbList", "()Ljava/util/concurrent/CopyOnWriteArrayList;", "setMPreviewDataCbList", "(Ljava/util/concurrent/CopyOnWriteArrayList;)V", "mRenderManager", "Lcom/jiangdg/ausbc/render/RenderManager;", "mSaveImageExecutor", "Ljava/util/concurrent/ExecutorService;", "getMSaveImageExecutor", "()Ljava/util/concurrent/ExecutorService;", "mSaveImageExecutor$delegate", "mSizeChangedFuture", "Lcom/jiangdg/ausbc/utils/SettableFuture;", "Lkotlin/Pair;", "", "mVideoProcess", "addPreviewDataCallBack", "", "callBack", "addRenderEffect", "effect", "captureAudioStart", "Lcom/jiangdg/ausbc/callback/ICaptureCallBack;", "mp3Path", "captureAudioStop", "captureImage", "path", "captureImageInternal", "savePath", "callback", "captureStreamStart", "captureStreamStartInternal", "captureStreamStop", "captureStreamStopInternal", "captureVideoStart", "durationInSec", "", "captureVideoStartInternal", "captureVideoStop", "captureVideoStopInternal", "closeCamera", "closeCameraInternal", "getAllPreviewSizes", "", "Lcom/jiangdg/ausbc/camera/bean/PreviewSize;", "aspectRatio", "", "(Ljava/lang/Double;)Ljava/util/List;", "getAudioStrategy", "Lcom/jiangdg/ausbc/encode/audio/IAudioStrategy;", "getCameraRequest", "getDefaultCameraRequest", "getDefaultEffect", "getSuitableSize", "maxWidth", "maxHeight", "getUsbDevice", "handleMessage", "msg", "Landroid/os/Message;", "initEncodeProcessor", "previewWidth", "previewHeight", "isCameraOpened", "isEncoding", "isGLESRender", "isGlesRenderOpen", "isMicSupported", "isPreviewSizeSupported", "previewSize", "isRecording", "isStreaming", "onReady", "surface", "Landroid/view/Surface;", "openCamera", "T", "cameraView", "cameraRequest", "(Ljava/lang/Object;Lcom/jiangdg/ausbc/camera/bean/CameraRequest;)V", "openCameraInternal", "(Ljava/lang/Object;)V", "postStateEvent", "state", "Lcom/jiangdg/ausbc/callback/ICameraStateCallBack$State;", "putVideoData", "data", "releaseEncodeProcessor", "removePreviewDataCallBack", "removeRenderEffect", "setCameraStateCallBack", "setEncodeDataCallBack", "setRenderSize", "width", "height", "setRotateType", "type", "Lcom/jiangdg/ausbc/render/env/RotateType;", "setUsbControlBlock", "ctrlBlock", "startPlayMic", "Lcom/jiangdg/ausbc/callback/IPlayCallBack;", "stopPlayMic", "updateRenderEffect", "classifyId", "updateResolution", "libausbc_release"})
    public static abstract class ICamera
    implements Handler.Callback,
    H264EncodeProcessor.OnEncodeReadyListener {
        @NotNull
        private final Context ctx;
        @NotNull
        private final UsbDevice device;
        private boolean isCaptureStream;
        @Nullable
        private Mp4Muxer mMediaMuxer;
        @Nullable
        private IEncodeDataCallBack mEncodeDataCallBack;
        @Nullable
        private HandlerThread mCameraThread;
        @Nullable
        private AbstractProcessor mAudioProcess;
        @Nullable
        private AbstractProcessor mVideoProcess;
        @Nullable
        private RenderManager mRenderManager;
        @Nullable
        private Object mCameraView;
        @Nullable
        private ICameraStateCallBack mCameraStateCallback;
        @Nullable
        private SettableFuture<Pair<Integer, Integer>> mSizeChangedFuture;
        @NotNull
        private Context mContext;
        @Nullable
        private CameraRequest mCameraRequest;
        @Nullable
        private Handler mCameraHandler;
        private boolean isPreviewed;
        private boolean isNeedGLESRender;
        @Nullable
        private USBMonitor.UsbControlBlock mCtrlBlock;
        @NotNull
        private CopyOnWriteArrayList<IPreviewDataCallBack> mPreviewDataCbList;
        @NotNull
        private final Lazy mCacheEffectList$delegate;
        @NotNull
        private final Lazy mMainHandler$delegate;
        @NotNull
        private final Lazy mNV21DataQueue$delegate;
        @NotNull
        private final Lazy mSaveImageExecutor$delegate;
        @NotNull
        private final Lazy mDateFormat$delegate;
        @NotNull
        private final Lazy mCameraDir$delegate;

        public ICamera(@NotNull Context ctx, @NotNull UsbDevice device) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Intrinsics.checkNotNullParameter((Object)device, (String)"device");
            this.ctx = ctx;
            this.device = device;
            this.mContext = this.ctx;
            this.mPreviewDataCbList = new CopyOnWriteArrayList();
            this.mCacheEffectList$delegate = LazyKt.lazy((Function0)mCacheEffectList.2.INSTANCE);
            this.mMainHandler$delegate = LazyKt.lazy((Function0)mMainHandler.2.INSTANCE);
            this.mNV21DataQueue$delegate = LazyKt.lazy((Function0)mNV21DataQueue.2.INSTANCE);
            this.mSaveImageExecutor$delegate = LazyKt.lazy((Function0)mSaveImageExecutor.2.INSTANCE);
            this.mDateFormat$delegate = LazyKt.lazy((Function0)mDateFormat.2.INSTANCE);
            this.mCameraDir$delegate = LazyKt.lazy((Function0)mCameraDir.2.INSTANCE);
        }

        @NotNull
        public final Context getCtx() {
            return this.ctx;
        }

        @NotNull
        public final UsbDevice getDevice() {
            return this.device;
        }

        @NotNull
        protected final Context getMContext() {
            return this.mContext;
        }

        protected final void setMContext(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"<set-?>");
            this.mContext = context;
        }

        @Nullable
        protected final CameraRequest getMCameraRequest() {
            return this.mCameraRequest;
        }

        protected final void setMCameraRequest(@Nullable CameraRequest cameraRequest) {
            this.mCameraRequest = cameraRequest;
        }

        @Nullable
        protected final Handler getMCameraHandler() {
            return this.mCameraHandler;
        }

        protected final void setMCameraHandler(@Nullable Handler handler) {
            this.mCameraHandler = handler;
        }

        protected final boolean isPreviewed() {
            return this.isPreviewed;
        }

        protected final void setPreviewed(boolean bl) {
            this.isPreviewed = bl;
        }

        protected final boolean isNeedGLESRender() {
            return this.isNeedGLESRender;
        }

        protected final void setNeedGLESRender(boolean bl) {
            this.isNeedGLESRender = bl;
        }

        @Nullable
        protected final USBMonitor.UsbControlBlock getMCtrlBlock() {
            return this.mCtrlBlock;
        }

        protected final void setMCtrlBlock(@Nullable USBMonitor.UsbControlBlock usbControlBlock) {
            this.mCtrlBlock = usbControlBlock;
        }

        @NotNull
        protected final CopyOnWriteArrayList<IPreviewDataCallBack> getMPreviewDataCbList() {
            return this.mPreviewDataCbList;
        }

        protected final void setMPreviewDataCbList(@NotNull CopyOnWriteArrayList<IPreviewDataCallBack> copyOnWriteArrayList) {
            Intrinsics.checkNotNullParameter(copyOnWriteArrayList, (String)"<set-?>");
            this.mPreviewDataCbList = copyOnWriteArrayList;
        }

        private final ArrayList<AbstractEffect> getMCacheEffectList() {
            Lazy lazy = this.mCacheEffectList$delegate;
            boolean bl = false;
            return (ArrayList)lazy.getValue();
        }

        @NotNull
        protected final Handler getMMainHandler() {
            Lazy lazy = this.mMainHandler$delegate;
            boolean bl = false;
            return (Handler)lazy.getValue();
        }

        @NotNull
        protected final LinkedBlockingDeque<byte[]> getMNV21DataQueue() {
            Lazy lazy = this.mNV21DataQueue$delegate;
            boolean bl = false;
            return (LinkedBlockingDeque)lazy.getValue();
        }

        @NotNull
        protected final ExecutorService getMSaveImageExecutor() {
            Lazy lazy = this.mSaveImageExecutor$delegate;
            boolean bl = false;
            Object object = lazy.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-mSaveImageExecutor>(...)");
            return (ExecutorService)object;
        }

        @NotNull
        protected final SimpleDateFormat getMDateFormat() {
            Lazy lazy = this.mDateFormat$delegate;
            boolean bl = false;
            return (SimpleDateFormat)lazy.getValue();
        }

        @NotNull
        protected final String getMCameraDir() {
            Lazy lazy = this.mCameraDir$delegate;
            boolean bl = false;
            return (String)lazy.getValue();
        }

        public boolean handleMessage(@NotNull Message msg) {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            int n = msg.what;
            switch (n) {
                case 1: {
                    AbstractEffect abstractEffect;
                    int n2;
                    int n3;
                    Object object;
                    IAspectRatio iAspectRatio;
                    CameraRequest cameraRequest = this.mCameraRequest;
                    Intrinsics.checkNotNull((Object)cameraRequest);
                    int previewWidth = cameraRequest.getPreviewWidth();
                    CameraRequest cameraRequest2 = this.mCameraRequest;
                    Intrinsics.checkNotNull((Object)cameraRequest2);
                    int previewHeight = cameraRequest2.getPreviewHeight();
                    CameraRequest cameraRequest3 = this.mCameraRequest;
                    Intrinsics.checkNotNull((Object)cameraRequest3);
                    CameraRequest.RenderMode renderMode = cameraRequest3.getRenderMode();
                    CameraRequest cameraRequest4 = this.mCameraRequest;
                    Intrinsics.checkNotNull((Object)cameraRequest4);
                    boolean isRawPreviewData = cameraRequest4.isRawPreviewData();
                    Object cameraView = this.mCameraView;
                    if (cameraView instanceof IAspectRatio) {
                        CameraRequest cameraRequest5 = this.mCameraRequest;
                        Intrinsics.checkNotNull((Object)cameraRequest5);
                        if (cameraRequest5.isAspectRatioShow()) {
                            ((IAspectRatio)cameraView).setAspectRatio(previewWidth, previewHeight);
                        }
                        iAspectRatio = (IAspectRatio)cameraView;
                    } else {
                        iAspectRatio = null;
                    }
                    cameraView = iAspectRatio;
                    boolean bl = false;
                    boolean bl2 = false;
                    Object view = cameraView;
                    boolean bl3 = false;
                    this.setNeedGLESRender(this.isGLESRender(renderMode == CameraRequest.RenderMode.OPENGL));
                    if (!this.isNeedGLESRender() && view != null) {
                        this.openCameraInternal(view);
                        return true;
                    }
                    try {
                        this.mSizeChangedFuture = new SettableFuture();
                        object = this.mSizeChangedFuture;
                        object = object == null ? null : (Pair)((SettableFuture)object).get(2000L, TimeUnit.MILLISECONDS);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        object = null;
                    }
                    Pair measureSize = object;
                    Logger.INSTANCE.i(MultiCameraClient.TAG, Intrinsics.stringPlus((String)"surface measure size ", (Object)measureSize));
                    CameraRequest cameraRequest6 = this.getMCameraRequest();
                    Intrinsics.checkNotNull((Object)cameraRequest6);
                    cameraRequest6.setRenderMode(CameraRequest.RenderMode.OPENGL);
                    Object e = view;
                    int screenWidth = e == null ? previewWidth : (n3 = e.getSurfaceWidth());
                    Object object2 = view;
                    int screenHeight = object2 == null ? previewHeight : (n2 = object2.getSurfaceHeight());
                    Object object3 = view;
                    Surface surface = object3 == null ? null : object3.getSurface();
                    CopyOnWriteArrayList<IPreviewDataCallBack> previewCb = isRawPreviewData ? (CopyOnWriteArrayList<IPreviewDataCallBack>)null : this.getMPreviewDataCbList();
                    this.mRenderManager = new RenderManager(this.getCtx(), previewWidth, previewHeight, previewCb);
                    Object object4 = this.mRenderManager;
                    if (object4 != null) {
                        ((RenderManager)object4).startRenderScreen(screenWidth, screenHeight, surface, new RenderManager.CameraSurfaceTextureListener(this){
                            final /* synthetic */ ICamera this$0;
                            {
                                this.this$0 = $receiver;
                            }

                            public void onSurfaceTextureAvailable(@Nullable SurfaceTexture surfaceTexture) {
                                if (surfaceTexture == null) {
                                    this.this$0.closeCamera();
                                    this.this$0.postStateEvent(ICameraStateCallBack.State.ERROR, "create camera surface failed");
                                    return;
                                }
                                this.this$0.openCameraInternal(surfaceTexture);
                            }
                        });
                    }
                    object4 = this.mRenderManager;
                    if (object4 != null) {
                        CameraRequest cameraRequest7 = this.getMCameraRequest();
                        Intrinsics.checkNotNull((Object)cameraRequest7);
                        ((RenderManager)object4).setRotateType(cameraRequest7.getDefaultRotateType());
                    }
                    object4 = this.getMCacheEffectList();
                    boolean bl4 = false;
                    if (!object4.isEmpty()) {
                        Iterable $this$forEach$iv = this.getMCacheEffectList();
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            AbstractEffect effect = (AbstractEffect)element$iv;
                            boolean bl5 = false;
                            RenderManager renderManager = this.mRenderManager;
                            if (renderManager == null) continue;
                            renderManager.addRenderEffect(effect);
                        }
                        break;
                    }
                    object4 = this.getMCameraRequest();
                    if (object4 == null || (abstractEffect = ((CameraRequest)object4).getDefaultEffect()) == null) break;
                    AbstractEffect abstractEffect2 = abstractEffect;
                    boolean bl6 = false;
                    boolean bl7 = false;
                    AbstractEffect $this$handleMessage_u24lambda_u2d2_u24lambda_u2d1 = abstractEffect2;
                    boolean bl8 = false;
                    RenderManager renderManager = this.mRenderManager;
                    if (renderManager == null) break;
                    renderManager.addRenderEffect($this$handleMessage_u24lambda_u2d2_u24lambda_u2d1);
                    break;
                }
                case 2: {
                    ArrayList<AbstractEffect> arrayList;
                    try {
                        SettableFuture<Pair<Integer, Integer>> previewWidth = this.mSizeChangedFuture;
                        if (previewWidth != null) {
                            previewWidth.cancel(true);
                        }
                        this.mSizeChangedFuture = null;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    this.closeCameraInternal();
                    RenderManager renderManager = this.mRenderManager;
                    if (renderManager != null && (arrayList = renderManager.getCacheEffectList()) != null) {
                        ArrayList<AbstractEffect> arrayList2 = arrayList;
                        boolean isRawPreviewData = false;
                        boolean cameraView = false;
                        ArrayList<AbstractEffect> $this$handleMessage_u24lambda_u2d3 = arrayList2;
                        boolean bl = false;
                        this.getMCacheEffectList().clear();
                        this.getMCacheEffectList().addAll((Collection<AbstractEffect>)$this$handleMessage_u24lambda_u2d3);
                    }
                    if ((renderManager = this.mRenderManager) != null) {
                        renderManager.stopRenderScreen();
                    }
                    this.mRenderManager = null;
                    break;
                }
                case 3: {
                    Object object = msg.obj;
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Pair<*, *>");
                    }
                    object = (Pair)object;
                    boolean bl = false;
                    boolean bl9 = false;
                    Object $this$handleMessage_u24lambda_u2d4 = object;
                    boolean bl10 = false;
                    Object $this$handleMessage_u24lambda_u2d3 = $this$handleMessage_u24lambda_u2d4.getFirst();
                    String path = $this$handleMessage_u24lambda_u2d3 instanceof String ? (String)$this$handleMessage_u24lambda_u2d3 : null;
                    Object object5 = $this$handleMessage_u24lambda_u2d4.getSecond();
                    if (object5 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.jiangdg.ausbc.callback.ICaptureCallBack");
                    }
                    ICaptureCallBack cb = (ICaptureCallBack)object5;
                    if (this.isNeedGLESRender()) {
                        CameraRequest cameraRequest = this.getMCameraRequest();
                        Intrinsics.checkNotNull((Object)cameraRequest);
                        if (!cameraRequest.isCaptureRawImage()) {
                            object5 = this.mRenderManager;
                            if (object5 == null) break;
                            ((RenderManager)object5).saveImage(cb, path);
                            break;
                        }
                    }
                    if ((object5 = $this$handleMessage_u24lambda_u2d4.getSecond()) == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.jiangdg.ausbc.callback.ICaptureCallBack");
                    }
                    this.captureImageInternal(path, (ICaptureCallBack)object5);
                    break;
                }
                case 4: {
                    Object object = msg.obj;
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Triple<*, *, *>");
                    }
                    object = (Triple)object;
                    boolean bl = false;
                    boolean bl11 = false;
                    Object $this$handleMessage_u24lambda_u2d5 = object;
                    boolean bl12 = false;
                    Object object6 = $this$handleMessage_u24lambda_u2d5.getFirst();
                    String string = object6 instanceof String ? (String)object6 : null;
                    object6 = $this$handleMessage_u24lambda_u2d5.getSecond();
                    if (object6 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                    }
                    long l = (Long)object6;
                    object6 = $this$handleMessage_u24lambda_u2d5.getThird();
                    if (object6 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.jiangdg.ausbc.callback.ICaptureCallBack");
                    }
                    this.captureVideoStartInternal(string, l, (ICaptureCallBack)object6);
                    break;
                }
                case 5: {
                    this.captureVideoStopInternal();
                    break;
                }
                case 6: {
                    this.isCaptureStream = true;
                    this.captureStreamStartInternal();
                    break;
                }
                case 7: {
                    this.isCaptureStream = false;
                    if (this.isRecording()) {
                        return true;
                    }
                    this.captureStreamStopInternal();
                }
            }
            return true;
        }

        protected abstract <T> void openCameraInternal(T var1);

        protected abstract void closeCameraInternal();

        protected abstract void captureImageInternal(@Nullable String var1, @NotNull ICaptureCallBack var2);

        @Nullable
        protected IAudioStrategy getAudioStrategy() {
            IAudioStrategy iAudioStrategy;
            CameraRequest cameraRequest = this.mCameraRequest;
            CameraRequest.AudioSource audioSource = cameraRequest == null ? null : cameraRequest.getAudioSource();
            int n = audioSource == null ? -1 : WhenMappings.$EnumSwitchMapping$0[audioSource.ordinal()];
            switch (n) {
                case 1: {
                    if (this.isMicSupported(this.device) && this.mCtrlBlock != null) {
                        if (Utils.INSTANCE.getDebugCamera()) {
                            Logger.INSTANCE.i(MultiCameraClient.TAG, "Audio record by using device internal mic");
                        }
                        USBMonitor.UsbControlBlock usbControlBlock = this.mCtrlBlock;
                        Intrinsics.checkNotNull((Object)usbControlBlock);
                        iAudioStrategy = new AudioStrategyUAC(usbControlBlock);
                        break;
                    }
                    if (Utils.INSTANCE.getDebugCamera()) {
                        Logger.INSTANCE.i(MultiCameraClient.TAG, "Audio record by using system mic");
                    }
                    iAudioStrategy = new AudioStrategySystem();
                    break;
                }
                case 2: {
                    if (this.isMicSupported(this.device) && this.mCtrlBlock != null) {
                        if (Utils.INSTANCE.getDebugCamera()) {
                            Logger.INSTANCE.i(MultiCameraClient.TAG, "Audio record by using device internal mic");
                        }
                        USBMonitor.UsbControlBlock usbControlBlock = this.mCtrlBlock;
                        Intrinsics.checkNotNull((Object)usbControlBlock);
                        return new AudioStrategyUAC(usbControlBlock);
                    }
                    return null;
                }
                case 3: {
                    if (Utils.INSTANCE.getDebugCamera()) {
                        Logger.INSTANCE.i(MultiCameraClient.TAG, "Audio record by using system mic");
                    }
                    iAudioStrategy = new AudioStrategySystem();
                    break;
                }
                default: {
                    iAudioStrategy = null;
                }
            }
            return iAudioStrategy;
        }

        private final boolean isGLESRender(boolean isGlesRenderOpen) {
            return isGlesRenderOpen && OpenGLUtils.INSTANCE.isGlEsSupported(this.ctx);
        }

        protected final void initEncodeProcessor(int previewWidth, int previewHeight) {
            this.releaseEncodeProcessor();
            IAudioStrategy iAudioStrategy = this.getAudioStrategy();
            if (iAudioStrategy != null) {
                Object bl6 = iAudioStrategy;
                boolean bl = false;
                boolean bl2 = false;
                IAudioStrategy audio = bl6;
                boolean bl3 = false;
                AACEncodeProcessor bl5 = new AACEncodeProcessor(audio);
                bl6 = bl5;
                bl = false;
                bl2 = false;
                Object processor = bl6;
                boolean bl4 = false;
                this.mAudioProcess = (AbstractProcessor)processor;
            }
            int bl = this.mContext.getResources().getConfiguration().orientation;
            boolean bl3 = false;
            boolean bl4 = false;
            int orientation = bl;
            boolean bl7 = false;
            boolean bl5 = orientation == 1;
            bl3 = false;
            bl4 = false;
            boolean isPortrait = bl5;
            boolean bl8 = false;
            this.mVideoProcess = new H264EncodeProcessor(previewWidth, previewHeight, this.isNeedGLESRender(), isPortrait);
        }

        protected final void releaseEncodeProcessor() {
            Object object;
            try {
                object = this.mMediaMuxer;
                if (object != null) {
                    ((Mp4Muxer)object).release();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Logger.INSTANCE.e(MultiCameraClient.TAG, Intrinsics.stringPlus((String)"release muxer failed, err is ", (Object)e.getLocalizedMessage()));
            }
            object = this.mVideoProcess;
            if (object != null) {
                ((AbstractProcessor)object).stopEncode();
            }
            object = this.mAudioProcess;
            if (object != null) {
                ((AbstractProcessor)object).stopEncode();
            }
            this.mVideoProcess = null;
            this.mMediaMuxer = null;
            this.mAudioProcess = null;
            this.isCaptureStream = false;
        }

        protected final void putVideoData(@NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            AbstractProcessor abstractProcessor = this.mVideoProcess;
            if (abstractProcessor != null) {
                abstractProcessor.putRawData(new RawData(data, data.length));
            }
        }

        public final void captureAudioStart(@NotNull ICaptureCallBack callBack, @Nullable String mp3Path) {
            Intrinsics.checkNotNullParameter((Object)callBack, (String)"callBack");
            if (!CameraUtils.INSTANCE.hasAudioPermission(this.mContext)) {
                callBack.onError("Has no audio permission");
                return;
            }
            if (!CameraUtils.INSTANCE.hasStoragePermission(this.mContext)) {
                callBack.onError("Has no storage permission");
                return;
            }
            Object object = mp3Path;
            boolean bl = false;
            boolean bl2 = false;
            String path = object == null || object.length() == 0 ? ((object = this.mContext.getExternalFilesDir(null)) == null ? null : ((File)object).getPath()) + '/' + System.currentTimeMillis() + ".mp3" : mp3Path;
            AbstractProcessor abstractProcessor = this.mAudioProcess;
            Object object2 = object = abstractProcessor instanceof AACEncodeProcessor ? (AACEncodeProcessor)abstractProcessor : null;
            if (object != null) {
                ((AACEncodeProcessor)object).recordMp3Start(path, callBack);
            }
        }

        public static /* synthetic */ void captureAudioStart$default(ICamera iCamera, ICaptureCallBack iCaptureCallBack, String string, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: captureAudioStart");
            }
            if ((n & 2) != 0) {
                string = null;
            }
            iCamera.captureAudioStart(iCaptureCallBack, string);
        }

        public final void captureAudioStop() {
            AACEncodeProcessor aACEncodeProcessor;
            AbstractProcessor abstractProcessor = this.mAudioProcess;
            AACEncodeProcessor aACEncodeProcessor2 = aACEncodeProcessor = abstractProcessor instanceof AACEncodeProcessor ? (AACEncodeProcessor)abstractProcessor : null;
            if (aACEncodeProcessor != null) {
                aACEncodeProcessor.recordMp3Stop();
            }
        }

        public final void startPlayMic(@Nullable IPlayCallBack callBack) {
            AACEncodeProcessor aACEncodeProcessor;
            if (!CameraUtils.INSTANCE.hasAudioPermission(this.mContext)) {
                IPlayCallBack iPlayCallBack = callBack;
                if (iPlayCallBack != null) {
                    iPlayCallBack.onError("Has no audio permission");
                }
                return;
            }
            AbstractProcessor abstractProcessor = this.mAudioProcess;
            AACEncodeProcessor aACEncodeProcessor2 = aACEncodeProcessor = abstractProcessor instanceof AACEncodeProcessor ? (AACEncodeProcessor)abstractProcessor : null;
            if (aACEncodeProcessor != null) {
                aACEncodeProcessor.playAudioStart(callBack);
            }
        }

        public final void stopPlayMic() {
            AACEncodeProcessor aACEncodeProcessor;
            AbstractProcessor abstractProcessor = this.mAudioProcess;
            AACEncodeProcessor aACEncodeProcessor2 = aACEncodeProcessor = abstractProcessor instanceof AACEncodeProcessor ? (AACEncodeProcessor)abstractProcessor : null;
            if (aACEncodeProcessor != null) {
                aACEncodeProcessor.playAudioStop();
            }
        }

        public final void setRotateType(@Nullable RotateType type) {
            RenderManager renderManager = this.mRenderManager;
            if (renderManager != null) {
                renderManager.setRotateType(type);
            }
        }

        public final void setRenderSize(int width, int height) {
            SettableFuture<Pair<Integer, Integer>> settableFuture = this.mSizeChangedFuture;
            if (settableFuture != null) {
                settableFuture.set((Pair<Integer, Integer>)new Pair((Object)width, (Object)height));
            }
        }

        public final void addRenderEffect(@NotNull AbstractEffect effect) {
            Intrinsics.checkNotNullParameter((Object)effect, (String)"effect");
            RenderManager renderManager = this.mRenderManager;
            if (renderManager != null) {
                renderManager.addRenderEffect(effect);
            }
        }

        public final void removeRenderEffect(@NotNull AbstractEffect effect) {
            AbstractEffect abstractEffect;
            Intrinsics.checkNotNullParameter((Object)effect, (String)"effect");
            Object object = this.mCameraRequest;
            Integer defaultId = object == null ? null : ((abstractEffect = ((CameraRequest)object).getDefaultEffect()) == null ? null : Integer.valueOf(abstractEffect.getId()));
            Integer n = defaultId;
            if (n != null && effect.getId() == n.intValue() && (object = this.mCameraRequest) != null) {
                ((CameraRequest)object).setDefaultEffect(null);
            }
            if ((object = this.mRenderManager) != null) {
                ((RenderManager)object).removeRenderEffect(effect);
            }
        }

        @Nullable
        public final AbstractEffect getDefaultEffect() {
            CameraRequest cameraRequest = this.mCameraRequest;
            return cameraRequest == null ? null : cameraRequest.getDefaultEffect();
        }

        public final void updateRenderEffect(int classifyId, @Nullable AbstractEffect effect) {
            ArrayList<AbstractEffect> arrayList;
            Object object = this.mRenderManager;
            if (object != null && (arrayList = ((RenderManager)object).getCacheEffectList()) != null) {
                Object v0;
                boolean bl;
                Object object2;
                block4: {
                    object2 = arrayList;
                    bl = false;
                    Iterable iterable = object2;
                    boolean bl2 = false;
                    for (Object t : iterable) {
                        AbstractEffect it = (AbstractEffect)t;
                        boolean bl3 = false;
                        if (!(it.getClassifyId() == classifyId)) continue;
                        v0 = t;
                        break block4;
                    }
                    v0 = null;
                }
                AbstractEffect abstractEffect = v0;
                if (abstractEffect != null) {
                    object2 = abstractEffect;
                    bl = false;
                    boolean bl4 = false;
                    Object it = object2;
                    boolean bl5 = false;
                    this.removeRenderEffect((AbstractEffect)it);
                }
            }
            if ((object = effect) == null) {
                return;
            }
            this.addRenderEffect(effect);
        }

        protected final void postStateEvent(@NotNull ICameraStateCallBack.State state, @Nullable String msg) {
            Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
            this.getMMainHandler().post(() -> ICamera.postStateEvent$lambda-12(this, state, msg));
        }

        public static /* synthetic */ void postStateEvent$default(ICamera iCamera, ICameraStateCallBack.State state, String string, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: postStateEvent");
            }
            if ((n & 2) != 0) {
                string = null;
            }
            iCamera.postStateEvent(state, string);
        }

        public final void setUsbControlBlock(@Nullable USBMonitor.UsbControlBlock ctrlBlock) {
            this.mCtrlBlock = ctrlBlock;
        }

        @NotNull
        public final UsbDevice getUsbDevice() {
            return this.device;
        }

        public final boolean isMicSupported(@Nullable UsbDevice device) {
            return CameraUtils.INSTANCE.isCameraContainsMic(device);
        }

        @NotNull
        public abstract List<PreviewSize> getAllPreviewSizes(@Nullable Double var1);

        public static /* synthetic */ List getAllPreviewSizes$default(ICamera iCamera, Double d, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getAllPreviewSizes");
            }
            if ((n & 1) != 0) {
                d = null;
            }
            return iCamera.getAllPreviewSizes(d);
        }

        public final <T> void openCamera(@Nullable T cameraView, @Nullable CameraRequest cameraRequest) {
            Message message;
            Object object = cameraView;
            this.mCameraView = object == null ? this.mCameraView : object;
            object = cameraRequest;
            this.mCameraRequest = object == null ? this.getDefaultCameraRequest() : object;
            object = new HandlerThread(Intrinsics.stringPlus((String)"camera-", (Object)System.currentTimeMillis()));
            boolean bl = false;
            boolean bl2 = false;
            Object $this$openCamera_u24lambda_u2d13 = object;
            boolean bl3 = false;
            $this$openCamera_u24lambda_u2d13.start();
            bl = false;
            bl2 = false;
            Object thread = object;
            boolean bl4 = false;
            this.mCameraThread = thread;
            object = thread;
            bl = false;
            bl2 = false;
            Object it = object;
            boolean bl5 = false;
            this.setMCameraHandler(new Handler(it.getLooper(), (Handler.Callback)this));
            Handler handler = this.getMCameraHandler();
            if (handler != null && (message = handler.obtainMessage(1)) != null) {
                message.sendToTarget();
            }
        }

        public static /* synthetic */ void openCamera$default(ICamera iCamera, Object object, CameraRequest cameraRequest, int n, Object object2) {
            if (object2 != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: openCamera");
            }
            if ((n & 1) != 0) {
                object = null;
            }
            if ((n & 2) != 0) {
                cameraRequest = null;
            }
            iCamera.openCamera(object, cameraRequest);
        }

        public final void closeCamera() {
            Message message;
            Handler handler = this.mCameraHandler;
            if (handler != null && (message = handler.obtainMessage(2)) != null) {
                message.sendToTarget();
            }
            if ((handler = this.mCameraThread) != null) {
                handler.quitSafely();
            }
            this.mCameraThread = null;
            this.mCameraHandler = null;
        }

        public final boolean isCameraOpened() {
            return this.isPreviewed;
        }

        @Nullable
        public final CameraRequest getCameraRequest() {
            return this.mCameraRequest;
        }

        public final void captureImage(@NotNull ICaptureCallBack callBack, @Nullable String path) {
            Message message;
            Intrinsics.checkNotNullParameter((Object)callBack, (String)"callBack");
            Pair pair = new Pair((Object)path, (Object)callBack);
            boolean bl = false;
            boolean bl2 = false;
            Pair $this$captureImage_u24lambda_u2d16 = pair;
            boolean bl3 = false;
            Handler handler = this.getMCameraHandler();
            if (handler != null && (message = handler.obtainMessage(3, (Object)$this$captureImage_u24lambda_u2d16)) != null) {
                message.sendToTarget();
            }
        }

        public static /* synthetic */ void captureImage$default(ICamera iCamera, ICaptureCallBack iCaptureCallBack, String string, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: captureImage");
            }
            if ((n & 2) != 0) {
                string = null;
            }
            iCamera.captureImage(iCaptureCallBack, string);
        }

        public final void captureVideoStart(@NotNull ICaptureCallBack callBack, @Nullable String path, long durationInSec) {
            Message message;
            Intrinsics.checkNotNullParameter((Object)callBack, (String)"callBack");
            Triple triple = new Triple((Object)path, (Object)durationInSec, (Object)callBack);
            boolean bl = false;
            boolean bl2 = false;
            Triple $this$captureVideoStart_u24lambda_u2d17 = triple;
            boolean bl3 = false;
            Handler handler = this.getMCameraHandler();
            if (handler != null && (message = handler.obtainMessage(4, (Object)$this$captureVideoStart_u24lambda_u2d17)) != null) {
                message.sendToTarget();
            }
        }

        public static /* synthetic */ void captureVideoStart$default(ICamera iCamera, ICaptureCallBack iCaptureCallBack, String string, long l, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: captureVideoStart");
            }
            if ((n & 2) != 0) {
                string = null;
            }
            if ((n & 4) != 0) {
                l = 0L;
            }
            iCamera.captureVideoStart(iCaptureCallBack, string, l);
        }

        public final void captureVideoStop() {
            Message message;
            Handler handler = this.mCameraHandler;
            if (handler != null && (message = handler.obtainMessage(5)) != null) {
                message.sendToTarget();
            }
        }

        public final void captureStreamStart() {
            Message message;
            Handler handler = this.mCameraHandler;
            if (handler != null && (message = handler.obtainMessage(6)) != null) {
                message.sendToTarget();
            }
        }

        public final void captureStreamStop() {
            Message message;
            Handler handler = this.mCameraHandler;
            if (handler != null && (message = handler.obtainMessage(7)) != null) {
                message.sendToTarget();
            }
        }

        public final void updateResolution(int width, int height) {
            if (this.mCameraRequest == null) {
                Logger.INSTANCE.w(MultiCameraClient.TAG, "updateResolution failed, please open camera first.");
                return;
            }
            if (this.isStreaming() || this.isRecording()) {
                Logger.INSTANCE.e(MultiCameraClient.TAG, "updateResolution failed, video recording...");
                return;
            }
            CameraRequest cameraRequest = this.mCameraRequest;
            if (cameraRequest != null) {
                CameraRequest cameraRequest2 = cameraRequest;
                boolean bl = false;
                boolean bl2 = false;
                CameraRequest $this$updateResolution_u24lambda_u2d19 = cameraRequest2;
                boolean bl3 = false;
                if ($this$updateResolution_u24lambda_u2d19.getPreviewWidth() != width || $this$updateResolution_u24lambda_u2d19.getPreviewHeight() != height) {
                    Logger.INSTANCE.i(MultiCameraClient.TAG, "updateResolution: width = " + width + ", height = " + height);
                    this.closeCamera();
                    this.getMMainHandler().postDelayed(() -> ICamera.updateResolution$lambda-19$lambda-18($this$updateResolution_u24lambda_u2d19, width, height, this), 1000L);
                }
            }
        }

        public final void setCameraStateCallBack(@Nullable ICameraStateCallBack callback) {
            this.mCameraStateCallback = callback;
        }

        public final void setEncodeDataCallBack(@Nullable IEncodeDataCallBack callBack) {
            this.mEncodeDataCallBack = callBack;
        }

        public final void addPreviewDataCallBack(@NotNull IPreviewDataCallBack callBack) {
            Intrinsics.checkNotNullParameter((Object)callBack, (String)"callBack");
            if (this.mPreviewDataCbList.contains(callBack)) {
                return;
            }
            this.mPreviewDataCbList.add(callBack);
        }

        public final void removePreviewDataCallBack(@NotNull IPreviewDataCallBack callBack) {
            Intrinsics.checkNotNullParameter((Object)callBack, (String)"callBack");
            if (!this.mPreviewDataCbList.contains(callBack)) {
                return;
            }
            this.mPreviewDataCbList.remove(callBack);
        }

        @NotNull
        public final PreviewSize getSuitableSize(int maxWidth, int maxHeight) {
            Object v2;
            boolean bl;
            Iterable iterable;
            PreviewSize closetSize;
            block10: {
                PreviewSize previewSize;
                int h;
                int w;
                Iterable iterable2;
                boolean bl2;
                PreviewSize it;
                List sizeList;
                block9: {
                    Object v0;
                    Object object2;
                    boolean bl3;
                    Iterable iterable3;
                    block8: {
                        sizeList = ICamera.getAllPreviewSizes$default(this, null, 1, null);
                        iterable3 = sizeList;
                        bl3 = false;
                        boolean bl4 = false;
                        if (iterable3 == null || iterable3.isEmpty()) {
                            return new PreviewSize(640, 480);
                        }
                        iterable3 = sizeList;
                        bl3 = false;
                        Iterable iterable4 = iterable3;
                        boolean bl5 = false;
                        for (Object object2 : iterable4) {
                            it = (PreviewSize)object2;
                            boolean bl6 = false;
                            if (!(it.getWidth() == maxWidth && it.getHeight() == maxHeight)) continue;
                            v0 = object2;
                            break block8;
                        }
                        v0 = null;
                    }
                    iterable3 = v0;
                    bl3 = false;
                    bl2 = false;
                    Object size = (PreviewSize)((Object)iterable3);
                    boolean bl7 = false;
                    object2 = size;
                    if (object2 != null) {
                        return size;
                    }
                    float aspectRatio = (float)maxWidth / (float)maxHeight;
                    iterable2 = sizeList;
                    bl2 = false;
                    size = iterable2;
                    bl7 = false;
                    object2 = size.iterator();
                    while (object2.hasNext()) {
                        PreviewSize it2 = it = object2.next();
                        boolean bl8 = false;
                        w = it2.getWidth();
                        float ratio = (float)w / (float)(h = it2.getHeight());
                        if (!(ratio == aspectRatio && w <= maxWidth && h <= maxHeight)) continue;
                        previewSize = it;
                        break block9;
                    }
                    previewSize = null;
                }
                iterable2 = previewSize;
                bl2 = false;
                boolean size = false;
                PreviewSize size2 = (PreviewSize)((Object)iterable2);
                boolean bl9 = false;
                it = size2;
                if (it != null) {
                    return size2;
                }
                int minDistance = 0;
                minDistance = maxWidth;
                closetSize = null;
                closetSize = (PreviewSize)sizeList.get(0);
                Iterable $this$forEach$iv = sizeList;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    PreviewSize size3 = (PreviewSize)element$iv;
                    boolean bl10 = false;
                    w = maxWidth - size3.getWidth();
                    h = 0;
                    if (minDistance < Math.abs(w)) continue;
                    w = maxWidth - size3.getWidth();
                    h = 0;
                    minDistance = Math.abs(w);
                    closetSize = size3;
                }
                iterable = sizeList;
                bl = false;
                Iterable iterable5 = iterable;
                boolean element$iv = false;
                Iterator size3 = iterable5.iterator();
                while (size3.hasNext()) {
                    Object t = size3.next();
                    PreviewSize it3 = (PreviewSize)t;
                    boolean bl11 = false;
                    if (!(it3.getWidth() == 640 || it3.getHeight() == 480)) continue;
                    v2 = t;
                    break block10;
                }
                v2 = null;
            }
            iterable = v2;
            bl = false;
            boolean bl12 = false;
            PreviewSize size = (PreviewSize)((Object)iterable);
            boolean bl13 = false;
            PreviewSize previewSize = size;
            if (previewSize != null) {
                return size;
            }
            return closetSize;
        }

        public final boolean isPreviewSizeSupported(@NotNull PreviewSize previewSize) {
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter((Object)previewSize, (String)"previewSize");
                Iterable iterable = ICamera.getAllPreviewSizes$default(this, null, 1, null);
                boolean bl = false;
                Iterable iterable2 = iterable;
                boolean bl2 = false;
                for (Object t : iterable2) {
                    PreviewSize it = (PreviewSize)t;
                    boolean bl3 = false;
                    if (!(it.getWidth() == previewSize.getWidth() && it.getHeight() == previewSize.getHeight())) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            return v0 != null;
        }

        public final boolean isRecording() {
            Mp4Muxer mp4Muxer = this.mMediaMuxer;
            return mp4Muxer == null ? false : mp4Muxer.isMuxerStarter();
        }

        public final boolean isStreaming() {
            return this.isEncoding() && this.isCaptureStream;
        }

        private final boolean isEncoding() {
            AbstractProcessor abstractProcessor = this.mVideoProcess;
            return abstractProcessor == null ? false : abstractProcessor.isEncoding();
        }

        private final void captureVideoStartInternal(String path, long durationInSec, ICaptureCallBack callBack) {
            if (!this.isCameraOpened()) {
                Logger.INSTANCE.e(MultiCameraClient.TAG, "capture video failed, camera not opened");
                return;
            }
            if (this.isRecording()) {
                Logger.INSTANCE.w(MultiCameraClient.TAG, "capturing video already running");
                return;
            }
            this.captureStreamStartInternal();
            Mp4Muxer mp4Muxer = new Mp4Muxer(this.mContext, callBack, path, durationInSec, this.mAudioProcess == null);
            boolean bl = false;
            boolean bl2 = false;
            Mp4Muxer $this$captureVideoStartInternal_u24lambda_u2d28 = mp4Muxer;
            boolean bl3 = false;
            AbstractProcessor abstractProcessor = this.mVideoProcess;
            if (abstractProcessor != null) {
                abstractProcessor.setMp4Muxer($this$captureVideoStartInternal_u24lambda_u2d28);
            }
            abstractProcessor = this.mAudioProcess;
            if (abstractProcessor != null) {
                abstractProcessor.setMp4Muxer($this$captureVideoStartInternal_u24lambda_u2d28);
            }
            bl = false;
            bl2 = false;
            Mp4Muxer muxer = mp4Muxer;
            boolean bl4 = false;
            this.mMediaMuxer = muxer;
            Logger.INSTANCE.i(MultiCameraClient.TAG, "capturing video start");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void captureVideoStopInternal() {
            if (!this.isStreaming()) {
                this.captureStreamStopInternal();
            }
            try {
                Mp4Muxer mp4Muxer = this.mMediaMuxer;
                if (mp4Muxer == null) {
                } else {
                    mp4Muxer.release();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Logger.INSTANCE.e(MultiCameraClient.TAG, Intrinsics.stringPlus((String)"release muxer failed, err is ", (Object)e.getLocalizedMessage()));
            }
            finally {
                this.mMediaMuxer = null;
            }
            Logger.INSTANCE.i(MultiCameraClient.TAG, "capturing video stop");
        }

        private final void captureStreamStartInternal() {
            AbstractProcessor abstractProcessor;
            boolean bl;
            boolean bl2;
            AbstractProcessor abstractProcessor2;
            if (!this.isCameraOpened()) {
                Logger.INSTANCE.e(MultiCameraClient.TAG, "capture stream failed, camera not opened");
                return;
            }
            if (this.isEncoding()) {
                Logger.INSTANCE.w(MultiCameraClient.TAG, "capturing stream canceled, already running");
                return;
            }
            AbstractProcessor abstractProcessor3 = this.mVideoProcess;
            H264EncodeProcessor h264EncodeProcessor = abstractProcessor2 = abstractProcessor3 instanceof H264EncodeProcessor ? (H264EncodeProcessor)abstractProcessor3 : null;
            if (abstractProcessor2 != null) {
                abstractProcessor3 = abstractProcessor2;
                bl2 = false;
                bl = false;
                AbstractProcessor $this$captureStreamStartInternal_u24lambda_u2d30 = abstractProcessor3;
                boolean bl3 = false;
                abstractProcessor = this.mVideoProcess;
                if (!(abstractProcessor == null ? false : abstractProcessor.isEncoding())) {
                    $this$captureStreamStartInternal_u24lambda_u2d30.startEncode();
                    $this$captureStreamStartInternal_u24lambda_u2d30.setEncodeDataCallBack(this.mEncodeDataCallBack);
                    ((H264EncodeProcessor)$this$captureStreamStartInternal_u24lambda_u2d30).setOnEncodeReadyListener(this);
                }
            }
            abstractProcessor3 = this.mAudioProcess;
            AbstractProcessor abstractProcessor4 = abstractProcessor2 = abstractProcessor3 instanceof AACEncodeProcessor ? (AACEncodeProcessor)abstractProcessor3 : null;
            if (abstractProcessor2 != null) {
                abstractProcessor3 = abstractProcessor2;
                bl2 = false;
                bl = false;
                AbstractProcessor $this$captureStreamStartInternal_u24lambda_u2d31 = abstractProcessor3;
                boolean bl4 = false;
                abstractProcessor = this.mAudioProcess;
                if (!(abstractProcessor == null ? false : abstractProcessor.isEncoding())) {
                    $this$captureStreamStartInternal_u24lambda_u2d31.startEncode();
                    $this$captureStreamStartInternal_u24lambda_u2d31.setEncodeDataCallBack(this.mEncodeDataCallBack);
                }
            }
            Logger.INSTANCE.i(MultiCameraClient.TAG, "capturing stream start");
        }

        private final void captureStreamStopInternal() {
            boolean bl;
            boolean bl2;
            Object object = this.mRenderManager;
            if (object != null) {
                ((RenderManager)object).stopRenderCodec();
            }
            Object object2 = this.mVideoProcess;
            Object object3 = object = object2 instanceof H264EncodeProcessor ? (H264EncodeProcessor)object2 : null;
            if (object != null) {
                object2 = object;
                bl2 = false;
                bl = false;
                Object $this$captureStreamStopInternal_u24lambda_u2d32 = object2;
                boolean bl3 = false;
                if (((AbstractProcessor)$this$captureStreamStopInternal_u24lambda_u2d32).isEncoding()) {
                    ((AbstractProcessor)$this$captureStreamStopInternal_u24lambda_u2d32).stopEncode();
                    ((AbstractProcessor)$this$captureStreamStopInternal_u24lambda_u2d32).setEncodeDataCallBack(null);
                }
            }
            object2 = this.mAudioProcess;
            Object object4 = object = object2 instanceof AACEncodeProcessor ? (AACEncodeProcessor)object2 : null;
            if (object != null) {
                object2 = object;
                bl2 = false;
                bl = false;
                Object $this$captureStreamStopInternal_u24lambda_u2d33 = object2;
                boolean bl4 = false;
                if (((AbstractProcessor)$this$captureStreamStopInternal_u24lambda_u2d33).isEncoding()) {
                    ((AbstractProcessor)$this$captureStreamStopInternal_u24lambda_u2d33).stopEncode();
                    ((AbstractProcessor)$this$captureStreamStopInternal_u24lambda_u2d33).setEncodeDataCallBack(null);
                }
            }
            Logger.INSTANCE.i(MultiCameraClient.TAG, "capturing stream stop");
        }

        @Override
        public void onReady(@Nullable Surface surface) {
            if (surface == null) {
                Logger.INSTANCE.e(MultiCameraClient.TAG, "start encode failed, input surface is null");
                return;
            }
            CameraRequest cameraRequest = this.mCameraRequest;
            if (cameraRequest != null) {
                CameraRequest cameraRequest2 = cameraRequest;
                boolean bl = false;
                boolean bl2 = false;
                CameraRequest $this$onReady_u24lambda_u2d34 = cameraRequest2;
                boolean bl3 = false;
                RenderManager renderManager = this.mRenderManager;
                if (renderManager != null) {
                    renderManager.startRenderCodec(surface, $this$onReady_u24lambda_u2d34.getPreviewWidth(), $this$onReady_u24lambda_u2d34.getPreviewHeight());
                }
            }
        }

        private final CameraRequest getDefaultCameraRequest() {
            return new CameraRequest.Builder().setPreviewWidth(1280).setPreviewHeight(720).create();
        }

        private static final void postStateEvent$lambda-12(ICamera this$0, ICameraStateCallBack.State $state, String $msg) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)((Object)$state), (String)"$state");
            ICameraStateCallBack iCameraStateCallBack = this$0.mCameraStateCallback;
            if (iCameraStateCallBack != null) {
                iCameraStateCallBack.onCameraState(this$0, $state, $msg);
            }
        }

        private static final void updateResolution$lambda-19$lambda-18(CameraRequest $this_apply, int $width, int $height, ICamera this$0) {
            Intrinsics.checkNotNullParameter((Object)$this_apply, (String)"$this_apply");
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            $this_apply.setPreviewWidth($width);
            $this_apply.setPreviewHeight($height);
            this$0.openCamera(this$0.mCameraView, this$0.getMCameraRequest());
        }

        @Metadata(mv={1, 5, 1}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[CameraRequest.AudioSource.values().length];
                nArray[CameraRequest.AudioSource.SOURCE_AUTO.ordinal()] = 1;
                nArray[CameraRequest.AudioSource.SOURCE_DEV_MIC.ordinal()] = 2;
                nArray[CameraRequest.AudioSource.SOURCE_SYS_MIC.ordinal()] = 3;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jiangdg/ausbc/MultiCameraClient$Companion;", "", "()V", "CAPTURE_TIMES_OUT_SEC", "", "DEFAULT_PREVIEW_HEIGHT", "", "DEFAULT_PREVIEW_WIDTH", "MAX_NV21_DATA", "MSG_CAPTURE_IMAGE", "MSG_CAPTURE_STREAM_START", "MSG_CAPTURE_STREAM_STOP", "MSG_CAPTURE_VIDEO_START", "MSG_CAPTURE_VIDEO_STOP", "MSG_START_PREVIEW", "MSG_STOP_PREVIEW", "TAG", "", "libausbc_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

