/*
 * Decompiled with CFR 0.152.
 */
package org.jaxws.stub2html.service;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.jws.WebMethod;
import org.jaxws.stub2html.model.WebServiceStubSet;
import org.jaxws.stub2html.service.WebMethodStubSetFactory;

public class WebServiceStubSetFactory {
    public static WebServiceStubSet createWebServiceStubSet(Class<?> webServiceClass) {
        List<Method> methods = WebServiceStubSetFactory.getWebMethods(webServiceClass);
        WebServiceStubSet serviceStubs = new WebServiceStubSet();
        serviceStubs.setWebServiceClass(webServiceClass);
        for (Method method : methods) {
            serviceStubs.addMethodStub(WebMethodStubSetFactory.createWebMethodStubSet(method));
        }
        return serviceStubs;
    }

    private static List<Method> getWebMethods(Class<?> webServiceClass) {
        ArrayList<Method> webMethods = new ArrayList<Method>();
        for (Method method : webServiceClass.getMethods()) {
            if (!method.isAnnotationPresent(WebMethod.class)) continue;
            webMethods.add(method);
        }
        return webMethods;
    }
}

