/*
 * Decompiled with CFR 0.152.
 */
package org.jaxws.stub2html.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class Stub {
    private String stubName;
    private Class<?> type;
    private boolean required;
    private boolean multiOccurs;
    private boolean header;
    private List<Stub> childStubs = new ArrayList<Stub>();
    private Stub parentStub;
    private Class<?> subTypeOfParentStub;

    public Stub getParentStub() {
        return this.parentStub;
    }

    public Stub getFirstAncestorWithType(Class<?> t) {
        for (Stub s = this.getParentStub(); s != null; s = s.getParentStub()) {
            if (!t.equals(s.getType())) continue;
            return s;
        }
        return null;
    }

    public List<String> getNamePathFromMeToRootAncestor() {
        ArrayList<String> list = new ArrayList<String>();
        for (Stub s = this; s != null; s = s.getParentStub()) {
            list.add(s.getStubName());
        }
        return list;
    }

    public boolean isSameTypeWithSomeAncestor() {
        Stub ancestor = this.getFirstAncestorWithType(this.type);
        return ancestor != null;
    }

    public void setParentStubRelation(Stub parentStub) {
        if (parentStub == null) {
            return;
        }
        this.parentStub = parentStub;
        parentStub.childStubs.add(this);
    }

    public String getStubName() {
        return this.stubName;
    }

    public void setStubName(String stubName) {
        this.stubName = stubName;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public List<Stub> getChildStubs() {
        return this.childStubs;
    }

    public boolean isHeader() {
        return this.header;
    }

    public void setHeader(boolean header) {
        this.header = header;
    }

    public Class<?> getType() {
        return this.type;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public Class<?> getSubTypeOfParentStub() {
        return this.subTypeOfParentStub;
    }

    public void setSubTypeOfParentStub(Class<?> subTypeOfDeclaringStub) {
        this.subTypeOfParentStub = subTypeOfDeclaringStub;
    }

    public boolean isMultiOccurs() {
        return this.multiOccurs;
    }

    public void setMultiOccurs(boolean multiOccurs) {
        this.multiOccurs = multiOccurs;
    }

    public String getDescription() {
        if (this.header) {
            return "In header";
        }
        return null;
    }

    public String toString() {
        String path = StringUtils.join(this.getNamePathFromMeToRootAncestor(), (String)"<==");
        return "[Stub: " + this.type.getSimpleName() + "," + path + "]";
    }
}

