/*
 * Decompiled with CFR 0.152.
 */
package com.github.chenglei1986.statusbar;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.github.chenglei1986.statusbar.BrandUtil;
import com.github.chenglei1986.statusbar.ColorUtil;
import com.github.chenglei1986.statusbar.ScrimUtil;
import com.github.chenglei1986.statusbar.StatusBarUtil;

public class StatusBarColorManager {
    private StatusBarColorManagerImpl mStatusBarColorManagerImpl;

    public StatusBarColorManager(@NonNull Activity activity) {
        this.mStatusBarColorManagerImpl = Build.VERSION.SDK_INT >= 23 ? new StatusBarColorManagerImplApi23(activity) : (Build.VERSION.SDK_INT >= 21 ? new StatusBarColorManagerImplApi21(activity) : (Build.VERSION.SDK_INT >= 19 ? new StatusBarColorManagerImplApi19(activity) : new StatusBarColorManagerBase()));
    }

    public void setStatusBarColor(@ColorInt int color, boolean layoutFullscreen, boolean withActionBar) {
        this.mStatusBarColorManagerImpl.setStatusBarColor(color, layoutFullscreen, withActionBar);
    }

    @RequiresApi(api=23)
    private static class StatusBarColorManagerImplApi23
    extends StatusBarColorManagerImplApi21 {
        public StatusBarColorManagerImplApi23(@NonNull Activity activity) {
            super(activity);
        }

        @Override
        public void setStatusBarColor(@ColorInt int color, boolean layoutFullscreen, boolean withActionBar) {
            this.mStatusBarBackground.removeAllViews();
            if (ColorUtil.isLightColor(color)) {
                this.setStatusBarColorLight(color, layoutFullscreen, withActionBar);
                this.mDecorView.setSystemUiVisibility(this.mDecorView.getSystemUiVisibility() | 0x2000);
            } else {
                this.setStatusBarColorDark(color, layoutFullscreen, withActionBar);
                this.mDecorView.setSystemUiVisibility(this.mDecorView.getSystemUiVisibility() & 0xFFFFDFFF);
            }
        }
    }

    @RequiresApi(api=21)
    private static class StatusBarColorManagerImplApi21
    extends StatusBarColorManagerImplApi19 {
        public StatusBarColorManagerImplApi21(@NonNull Activity activity) {
            super(activity);
        }

        @Override
        public void setStatusBarColor(@ColorInt int color, boolean layoutFullscreen, boolean withActionBar) {
            this.mStatusBarBackground.removeAllViews();
            if (ColorUtil.isLightColor(color)) {
                this.setStatusBarColorLight(color, layoutFullscreen, withActionBar);
                View scrimView = new View((Context)this.mActivity);
                scrimView.setBackground(ScrimUtil.makeCubicGradientScrimDrawable(-16777216, 8, 48));
                this.mStatusBarBackground.addView(scrimView);
            } else {
                this.setStatusBarColorDark(color, layoutFullscreen, withActionBar);
            }
        }
    }

    @RequiresApi(api=21)
    private static class StatusBarColorManagerImplApi19
    extends StatusBarColorManagerBase {
        protected Activity mActivity;
        protected ViewGroup mDecorView;
        protected FrameLayout mStatusBarBackground;
        protected int mStatusBarHeight;
        protected int mActionBarHeight;
        protected ViewGroup mContentView;

        public StatusBarColorManagerImplApi19(@NonNull Activity activity) {
            this.mActivity = activity;
            StatusBarUtil.setTranslucentStatus(this.mActivity);
            this.mDecorView = (ViewGroup)activity.getWindow().getDecorView();
            this.mContentView = (ViewGroup)((ViewGroup)this.mDecorView.findViewById(0x1020002)).getChildAt(0);
            this.mStatusBarHeight = StatusBarUtil.getStatusHeight(activity);
            this.mActionBarHeight = StatusBarUtil.getActionBarHeight((Context)activity);
            if (null == this.mStatusBarBackground) {
                this.mStatusBarBackground = new FrameLayout((Context)activity);
                this.mDecorView.addView((View)this.mStatusBarBackground, -1, this.mStatusBarHeight);
            }
        }

        protected void setStatusBarColorLight(@ColorInt int color, boolean layoutFullscreen, boolean withActionBar) {
            this.setColorAndContentPadding(color, layoutFullscreen, withActionBar, true);
        }

        protected void setStatusBarColorDark(@ColorInt int color, boolean layoutFullscreen, boolean withActionBar) {
            this.setColorAndContentPadding(color, layoutFullscreen, withActionBar, false);
        }

        private void setColorAndContentPadding(@ColorInt int color, boolean layoutFullscreen, boolean withActionBar, boolean light) {
            if (BrandUtil.checkBrand(BrandUtil.BRAND.XIAOMI)) {
                StatusBarUtil.setMiuiStatusBarIconDarkMode(this.mActivity, light);
            } else if (BrandUtil.checkBrand(BrandUtil.BRAND.MEIZU)) {
                StatusBarUtil.setFlymeStatusBarIconDarkMode(this.mActivity, light);
            }
            int contentViewPaddingTop = (layoutFullscreen ? 0 : this.mStatusBarHeight) + (withActionBar ? this.mActionBarHeight : 0);
            this.mContentView.setPadding(this.mContentView.getPaddingLeft(), contentViewPaddingTop, this.mContentView.getPaddingRight(), this.mContentView.getPaddingBottom());
            this.mStatusBarBackground.setBackgroundColor(layoutFullscreen ? 0 : color);
        }

        @Override
        public void setStatusBarColor(@ColorInt int color, boolean layoutFullscreen, boolean withActionBar) {
            if (ColorUtil.isLightColor(color)) {
                this.setStatusBarColorLight(color, layoutFullscreen, withActionBar);
            } else {
                this.setStatusBarColorDark(color, layoutFullscreen, withActionBar);
            }
        }
    }

    private static class StatusBarColorManagerBase
    implements StatusBarColorManagerImpl {
        private StatusBarColorManagerBase() {
        }

        @Override
        public void setStatusBarColor(@ColorInt int color, boolean layoutFullscreen, boolean withActionBar) {
        }
    }

    private static interface StatusBarColorManagerImpl {
        public void setStatusBarColor(@ColorInt int var1, boolean var2, boolean var3);
    }
}

