/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.embeddings;

import com.github.chen0040.embeddings.utils.HttpClient;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GloVeModel {
    private static final String url = "http://nlp.stanford.edu/data/glove.6B.zip";
    private Map<String, float[]> word2em = new HashMap<String, float[]>();
    private static final Logger logger = LoggerFactory.getLogger(GloVeModel.class);
    private int dimension = -1;

    public static List<Integer> getAvailableDimensionList() {
        return Arrays.asList(50, 100, 200, 300);
    }

    private static final String getGloVeTextFileName(int dimension) {
        return "glove.6B." + dimension + "d.txt";
    }

    public Map<String, float[]> load100() {
        return this.load(100);
    }

    public Map<String, float[]> load50() {
        return this.load(50);
    }

    public Map<String, float[]> load200() {
        return this.load(200);
    }

    public Map<String, float[]> load300() {
        return this.load(300);
    }

    public Map<String, float[]> load(int dimension) {
        return this.load("/tmp", dimension);
    }

    public float[] encodeWord(String word) {
        if (this.word2em.containsKey(word = word.toLowerCase())) {
            return this.word2em.get(word);
        }
        return null;
    }

    public float[] encodeDocument(String sentence) {
        sentence = this.filter(sentence);
        String[] words = sentence.split(" ");
        float[] vec = new float[this.dimension];
        for (String word : words) {
            float[] word2vec;
            String w = word.trim();
            if (w.equals("") || (word2vec = this.encodeWord(w)) == null) continue;
            for (int i = 0; i < this.dimension; ++i) {
                int n = i;
                vec[n] = vec[n] + word2vec[i];
            }
        }
        return vec;
    }

    private String filter(String sent) {
        String[] punctuations;
        sent = sent.toLowerCase();
        for (String punt : punctuations = new String[]{",", ".", ";", ":", "?", "!", "\"", "'"}) {
            sent = sent.replace(punt, " " + punt);
        }
        return sent;
    }

    public int size() {
        return this.word2em.size();
    }

    public int getWordVecDimension() {
        return this.dimension;
    }

    public Map<String, float[]> load(String dirPath, int dimension) {
        this.dimension = -1;
        this.word2em.clear();
        String sourceFile100 = GloVeModel.getGloVeTextFileName(dimension);
        String filePath = dirPath + "/" + sourceFile100;
        File file = new File(filePath);
        if (!file.exists()) {
            String zipFilePath = dirPath + "/glove.6B.zip";
            if (!new File(zipFilePath).exists()) {
                logger.info("{} not found on local machine, downloading it from {}", (Object)zipFilePath, (Object)url);
                if (!HttpClient.downloadFile(url, zipFilePath)) {
                    return this.word2em;
                }
                logger.info("{} is downloaded", (Object)zipFilePath);
            }
            if (!this.unZip(zipFilePath, dirPath)) {
                return this.word2em;
            }
        }
        logger.info("loading {} into word2em", (Object)filePath);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(new File(filePath))));){
            String line;
            while ((line = reader.readLine()) != null) {
                String[] parts = line.split(" ");
                String word = parts[0];
                float[] vec = new float[dimension];
                for (int i = 1; i <= dimension; ++i) {
                    vec[i - 1] = Float.parseFloat(parts[i]);
                }
                this.word2em.put(word, vec);
            }
        }
        catch (IOException e) {
            logger.error("Failed to read file " + filePath, (Throwable)e);
            this.word2em.clear();
            return new HashMap<String, float[]>();
        }
        this.dimension = dimension;
        return this.word2em;
    }

    private boolean unZip(String zipFilePath, String dirPath) {
        logger.info("unzipping {} to {}", (Object)zipFilePath, (Object)dirPath);
        try {
            ZipFile zipFile = new ZipFile(zipFilePath);
            zipFile.extractAll(dirPath);
            return true;
        }
        catch (ZipException e) {
            logger.error("Failed to unzip " + zipFilePath, (Throwable)e);
            return false;
        }
    }

    public double distance(String word1, String word2) {
        float[] vec1 = this.encodeWord(word1);
        float[] vec2 = this.encodeWord(word2);
        if (vec1 == null || vec2 == null) {
            return -1.0;
        }
        float result = 0.0f;
        for (int i = 0; i < this.dimension; ++i) {
            float v1 = vec1[i];
            float v2 = vec2[i];
            result += (v1 - v2) * (v1 - v2);
        }
        return Math.sqrt(result);
    }
}

