/*
 * Decompiled with CFR 0.152.
 */
package com.checkout.validation.validator;

import com.checkout.base.model.CardScheme;
import com.checkout.validation.error.ValidationError;
import com.checkout.validation.model.CardNumberValidationRequest;
import com.checkout.validation.model.ValidationResult;
import com.checkout.validation.validator.contract.Checker;
import com.checkout.validation.validator.contract.Validator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0006H\u0002J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0006H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/checkout/validation/validator/CardNumberValidator;", "Lcom/checkout/validation/validator/contract/Validator;", "Lcom/checkout/validation/model/CardNumberValidationRequest;", "Lcom/checkout/base/model/CardScheme;", "checker", "Lcom/checkout/validation/validator/contract/Checker;", "", "(Lcom/checkout/validation/validator/contract/Checker;)V", "provideCardScheme", "cardNumber", "isEager", "", "validate", "Lcom/checkout/validation/model/ValidationResult;", "data", "validateEager", "checkout_release"})
@SourceDebugExtension(value={"SMAP\nCardNumberValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CardNumberValidator.kt\ncom/checkout/validation/validator/CardNumberValidator\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,88:1\n1083#2,2:89\n13309#3,2:91\n*S KotlinDebug\n*F\n+ 1 CardNumberValidator.kt\ncom/checkout/validation/validator/CardNumberValidator\n*L\n73#1:89,2\n80#1:91,2\n*E\n"})
public final class CardNumberValidator
implements Validator<CardNumberValidationRequest, CardScheme> {
    @NotNull
    private final Checker<String> checker;

    public CardNumberValidator(@NotNull Checker<String> checker) {
        Intrinsics.checkNotNullParameter(checker, (String)"checker");
        this.checker = checker;
    }

    @Override
    @NotNull
    public ValidationResult<CardScheme> validate(@NotNull CardNumberValidationRequest data) {
        ValidationResult validationResult;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        try {
            Regex whitespacesRegex = new Regex("\\s");
            CharSequence charSequence = data.getCardNumber();
            String string = "";
            String cardNumber = whitespacesRegex.replace(charSequence, string);
            CardScheme cardScheme = data.isEagerValidation() ? this.validateEager(cardNumber) : this.validate(cardNumber);
            validationResult = new ValidationResult.Success<CardScheme>(cardScheme);
        }
        catch (ValidationError e) {
            validationResult = new ValidationResult.Failure(e);
        }
        return validationResult;
    }

    private final CardScheme validate(String cardNumber) throws ValidationError {
        CardScheme cardScheme = this.provideCardScheme(cardNumber, false);
        if (cardScheme == CardScheme.UNKNOWN) {
            throw new ValidationError("ValidationError:1024", "Card scheme not recognized", null, 4, null);
        }
        if (!this.checker.check(cardNumber)) {
            throw new ValidationError("ValidationError:1023", "Card number Luhn check error", null, 4, null);
        }
        return cardScheme;
    }

    private final CardScheme validateEager(String cardNumber) throws ValidationError {
        return this.provideCardScheme(cardNumber, true);
    }

    private final CardScheme provideCardScheme(String cardNumber, boolean isEager) throws ValidationError {
        boolean bl;
        int n;
        block3: {
            CharSequence $this$any$iv = cardNumber;
            boolean $i$f$any = false;
            for (n = 0; n < $this$any$iv.length(); ++n) {
                char element$iv;
                char it = element$iv = $this$any$iv.charAt(n);
                boolean bl2 = false;
                boolean bl3 = !Character.isDigit(it);
                if (!bl3) continue;
                bl = true;
                break block3;
            }
            bl = false;
        }
        if (bl) {
            throw new ValidationError("ValidationError:1001", "Card number should contain only digits", null, 4, null);
        }
        CardScheme[] $this$forEach$iv = CardScheme.values();
        boolean $i$f$forEach = false;
        int n2 = $this$forEach$iv.length;
        for (n = 0; n < n2; ++n) {
            Regex regex;
            CardScheme element$iv;
            CardScheme it = element$iv = $this$forEach$iv[n];
            boolean bl4 = false;
            Regex regex2 = regex = isEager ? it.getEagerRegex$checkout_release() : it.getRegex$checkout_release();
            if (!regex.matches((CharSequence)cardNumber)) continue;
            return it;
        }
        return CardScheme.UNKNOWN;
    }
}

