/*
 * Decompiled with CFR 0.152.
 */
package com.checkout.tokenization.mapper;

import com.checkout.base.error.CheckoutError;
import com.checkout.network.error.NetworkError;
import com.checkout.network.response.ErrorResponse;
import com.checkout.network.response.NetworkApiResponse;
import com.checkout.tokenization.error.TokenizationError;
import com.checkout.tokenization.model.TokenResult;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b \u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00052\n\u0010\u0006\u001a\u00060\u0007j\u0002`\bH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001f\u0010\r\u001a\u00028\u0000\"\b\b\u0001\u0010\u000e*\u00020\u00022\u0006\u0010\u000f\u001a\u0002H\u000eH$\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J%\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\"\b\b\u0001\u0010\u000e*\u00020\u00022\u0006\u0010\u000f\u001a\u0002H\u000eH\u0002\u00a2\u0006\u0002\u0010\u0018J$\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\"\b\b\u0001\u0010\u000e*\u00020\u00022\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u001bJ\u0014\u0010\u001c\u001a\u00020\u001d*\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001dH\u0002\u00a8\u0006\u001f"}, d2={"Lcom/checkout/tokenization/mapper/TokenizationNetworkDataMapper;", "S", "", "()V", "createExceptionErrorResult", "Lcom/checkout/tokenization/model/TokenResult;", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "createInternalErrorResult", "Lcom/checkout/tokenization/model/TokenResult$Failure;", "internalError", "Lcom/checkout/network/response/NetworkApiResponse$InternalError;", "createMappedResult", "T", "resultBody", "(Ljava/lang/Object;)Ljava/lang/Object;", "createNetworkErrorResult", "networkError", "Lcom/checkout/network/response/NetworkApiResponse$NetworkError;", "createServerErrorResult", "serverError", "Lcom/checkout/network/response/NetworkApiResponse$ServerError;", "createSuccessResult", "(Ljava/lang/Object;)Lcom/checkout/tokenization/model/TokenResult;", "toTokenResult", "result", "Lcom/checkout/network/response/NetworkApiResponse;", "toErrorMessage", "", "errorMessage", "checkout_release"})
public abstract class TokenizationNetworkDataMapper<S> {
    @NotNull
    public final <T> TokenResult<S> toTokenResult(@NotNull NetworkApiResponse<? extends T> result) {
        TokenResult tokenResult;
        Intrinsics.checkNotNullParameter(result, (String)"result");
        try {
            TokenResult tokenResult2;
            tokenResult = result;
            if (tokenResult instanceof NetworkApiResponse.Success) {
                tokenResult2 = this.createSuccessResult(((NetworkApiResponse.Success)result).getBody());
            } else if (tokenResult instanceof NetworkApiResponse.ServerError) {
                tokenResult2 = this.createServerErrorResult((NetworkApiResponse.ServerError)result);
            } else if (tokenResult instanceof NetworkApiResponse.NetworkError) {
                tokenResult2 = this.createNetworkErrorResult((NetworkApiResponse.NetworkError)result);
            } else if (tokenResult instanceof NetworkApiResponse.InternalError) {
                tokenResult2 = this.createInternalErrorResult((NetworkApiResponse.InternalError)result);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            tokenResult = tokenResult2;
        }
        catch (Exception exception) {
            tokenResult = this.createExceptionErrorResult(exception);
        }
        return tokenResult;
    }

    @NotNull
    protected abstract <T> S createMappedResult(@NotNull T var1);

    private final TokenResult<S> createExceptionErrorResult(Exception exception) {
        CheckoutError tokenError = exception instanceof CheckoutError ? (CheckoutError)exception : new CheckoutError("TokenizationError.Server:3003", exception.getMessage(), exception);
        return new TokenResult.Failure(tokenError);
    }

    private final <T> TokenResult<S> createSuccessResult(T resultBody) {
        return new TokenResult.Success<S>(this.createMappedResult(resultBody));
    }

    private final TokenResult<S> createServerErrorResult(NetworkApiResponse.ServerError serverError) {
        TokenizationError error = serverError.getCode() == 401 ? new TokenizationError("TokenizationError.Server:3002", this.toErrorMessage(serverError, "Invalid key"), null, 4, null) : new TokenizationError("TokenizationError.Server:3000", this.toErrorMessage(serverError, "Token request failed"), null, 4, null);
        return new TokenResult.Failure(error);
    }

    private final TokenResult.Failure createNetworkErrorResult(NetworkApiResponse.NetworkError networkError) {
        CheckoutError tokenError = networkError.getThrowable() instanceof CheckoutError ? (CheckoutError)networkError.getThrowable() : (CheckoutError)new NetworkError("NetworkError:2001", networkError.getThrowable().getMessage(), networkError.getThrowable());
        return new TokenResult.Failure(tokenError);
    }

    private final TokenResult.Failure createInternalErrorResult(NetworkApiResponse.InternalError internalError) {
        CheckoutError internalTokenError = internalError.getThrowable() instanceof CheckoutError ? (CheckoutError)internalError.getThrowable() : (CheckoutError)new TokenizationError("TokenizationError.Server:3005", internalError.getThrowable().getMessage(), internalError.getThrowable());
        return new TokenResult.Failure(internalTokenError);
    }

    private final String toErrorMessage(NetworkApiResponse.ServerError $this$toErrorMessage, String errorMessage) {
        Object object;
        block3: {
            block2: {
                object = $this$toErrorMessage.getBody();
                if (object == null || (object = ((ErrorResponse)object).getErrorType()) == null) break block2;
                Object it = object;
                boolean bl = false;
                String string = errorMessage + " - " + (String)it + " (HttpStatus: " + $this$toErrorMessage.getCode() + ")";
                object = string;
                if (string != null) break block3;
            }
            object = errorMessage + " - (HttpStatus: " + $this$toErrorMessage.getCode() + ")";
        }
        return object;
    }
}

