/*
 * Decompiled with CFR 0.152.
 */
package com.checkout.threedsecure;

import android.content.Context;
import android.view.View;
import android.webkit.WebView;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import com.checkout.base.usecase.UseCase;
import com.checkout.threedsecure.Executor;
import com.checkout.threedsecure.error.ThreeDSError;
import com.checkout.threedsecure.logging.ThreeDSLogger;
import com.checkout.threedsecure.model.ProcessThreeDSRequest;
import com.checkout.threedsecure.model.ThreeDSRequest;
import com.checkout.threedsecure.model.ThreeDSResult;
import com.checkout.threedsecure.webview.ThreeDSWebView;
import com.checkout.threedsecure.webview.ThreeDSWebViewClient;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B#\u0012\u0014\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0016J7\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2%\u0010\u0010\u001a!\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\u000b0\u0011j\u0002`\u0015H\u0007JI\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00192%\u0010\u0010\u001a!\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\u000b0\u0011j\u0002`\u0015H\u0007J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\f\u001a\u00020\u0002H\u0007R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/checkout/threedsecure/ThreeDSExecutor;", "Lcom/checkout/threedsecure/Executor;", "Lcom/checkout/threedsecure/model/ThreeDSRequest;", "processResultUseCase", "Lcom/checkout/base/usecase/UseCase;", "Lcom/checkout/threedsecure/model/ProcessThreeDSRequest;", "Lcom/checkout/threedsecure/model/ThreeDSResult;", "logger", "Lcom/checkout/threedsecure/logging/ThreeDSLogger;", "(Lcom/checkout/base/usecase/UseCase;Lcom/checkout/threedsecure/logging/ThreeDSLogger;)V", "execute", "", "request", "handleError", "error", "Lcom/checkout/threedsecure/error/ThreeDSError;", "resultHandler", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "result", "Lcom/checkout/threedsecure/model/ThreeDSResultHandler;", "handleResult", "", "url", "", "successUrl", "failureUrl", "provideWebView", "Landroid/webkit/WebView;", "checkout_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class ThreeDSExecutor
implements Executor<ThreeDSRequest> {
    @NotNull
    private final UseCase<ProcessThreeDSRequest, ThreeDSResult> processResultUseCase;
    @NotNull
    private final ThreeDSLogger logger;

    public ThreeDSExecutor(@NotNull UseCase<ProcessThreeDSRequest, ThreeDSResult> processResultUseCase, @NotNull ThreeDSLogger logger) {
        Intrinsics.checkNotNullParameter(processResultUseCase, (String)"processResultUseCase");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.processResultUseCase = processResultUseCase;
        this.logger = logger;
    }

    @Override
    public void execute(@NotNull ThreeDSRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        request.getContainer().addView((View)this.provideWebView(request));
    }

    @VisibleForTesting
    @NotNull
    public final WebView provideWebView(@NotNull ThreeDSRequest request) {
        ThreeDSWebView threeDSWebView;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        ThreeDSRequest $this$provideWebView_u24lambda_u241 = request;
        boolean bl = false;
        Context context = $this$provideWebView_u24lambda_u241.getContainer().getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        ThreeDSWebView $this$provideWebView_u24lambda_u241_u24lambda_u240 = threeDSWebView = new ThreeDSWebView(context);
        boolean bl2 = false;
        $this$provideWebView_u24lambda_u241_u24lambda_u240.setWebViewClient(new ThreeDSWebViewClient((Function1<? super String, Boolean>)((Function1)new Function1<String, Boolean>(this, $this$provideWebView_u24lambda_u241){
            final /* synthetic */ ThreeDSExecutor this$0;
            final /* synthetic */ ThreeDSRequest $this_with;
            {
                this.this$0 = $receiver;
                this.$this_with = $receiver2;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@Nullable String it) {
                return this.this$0.handleResult(it, this.$this_with.getSuccessUrl(), this.$this_with.getFailureUrl(), this.$this_with.getResultHandler());
            }
        }), (Function1<? super ThreeDSError, Unit>)((Function1)new Function1<ThreeDSError, Unit>(this, $this$provideWebView_u24lambda_u241){
            final /* synthetic */ ThreeDSExecutor this$0;
            final /* synthetic */ ThreeDSRequest $this_with;
            {
                this.this$0 = $receiver;
                this.$this_with = $receiver2;
                super(1);
            }

            public final void invoke(@NotNull ThreeDSError it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.this$0.handleError(it, this.$this_with.getResultHandler());
            }
        }), this.logger));
        $this$provideWebView_u24lambda_u241_u24lambda_u240.loadUrl(request.getChallengeUrl());
        return threeDSWebView;
    }

    @VisibleForTesting
    public final boolean handleResult(@Nullable String url, @NotNull String successUrl, @NotNull String failureUrl, @NotNull Function1<? super ThreeDSResult, Unit> resultHandler) {
        Intrinsics.checkNotNullParameter((Object)successUrl, (String)"successUrl");
        Intrinsics.checkNotNullParameter((Object)failureUrl, (String)"failureUrl");
        Intrinsics.checkNotNullParameter(resultHandler, (String)"resultHandler");
        ThreeDSResult threeDSResult = this.processResultUseCase.execute(new ProcessThreeDSRequest(url, successUrl, failureUrl));
        if (threeDSResult != null) {
            ThreeDSResult it = threeDSResult;
            boolean bl = false;
            ThreeDSResult.Success success = it instanceof ThreeDSResult.Success ? (ThreeDSResult.Success)it : null;
            ThreeDSResult.Error error = it instanceof ThreeDSResult.Error ? (ThreeDSResult.Error)it : null;
            this.logger.logCompletedEvent(it instanceof ThreeDSResult.Success, success != null ? success.getToken() : null, error != null ? error.getError() : null);
            resultHandler.invoke((Object)it);
            return true;
        }
        return false;
    }

    @VisibleForTesting
    public final void handleError(@NotNull ThreeDSError error, @NotNull Function1<? super ThreeDSResult, Unit> resultHandler) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        Intrinsics.checkNotNullParameter(resultHandler, (String)"resultHandler");
        this.logger.logLoadedEvent(false, error);
        resultHandler.invoke((Object)new ThreeDSResult.Error(error));
    }
}

