/*
 * Decompiled with CFR 0.152.
 */
package com.checkout.validation.validator;

import com.checkout.tokenization.model.ExpiryDate;
import com.checkout.validation.error.ValidationError;
import com.checkout.validation.model.ExpiryDateValidationRequest;
import com.checkout.validation.model.ValidationResult;
import com.checkout.validation.validator.contract.Validator;
import java.util.Calendar;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00122\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u001a\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0013"}, d2={"Lcom/checkout/validation/validator/ExpiryDateValidator;", "Lcom/checkout/validation/validator/contract/Validator;", "Lcom/checkout/validation/model/ExpiryDateValidationRequest;", "Lcom/checkout/tokenization/model/ExpiryDate;", "()V", "provideValidated4DigitYear", "", "value", "", "date", "Ljava/util/Date;", "provideValidatedMonth", "validate", "Lcom/checkout/validation/model/ValidationResult;", "data", "validateExpiryDate", "", "expiryDate", "Companion", "checkout_release"})
public final class ExpiryDateValidator
implements Validator<ExpiryDateValidationRequest, ExpiryDate> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @Deprecated
    public static final int YEAR_SHORT_FORMAT = 2;
    @Deprecated
    public static final int YEAR_LONG_FORMAT = 4;
    @Deprecated
    public static final int YEAR_LONG_DELTA = 2000;
    @Deprecated
    @NotNull
    private static final IntRange MONTH_RANGE = new IntRange(1, 12);

    @Override
    @NotNull
    public ValidationResult<ExpiryDate> validate(@NotNull ExpiryDateValidationRequest data) {
        ValidationResult validationResult;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        try {
            ExpiryDate expiryDate = new ExpiryDate(this.provideValidatedMonth(data.getExpiryMonth()), ExpiryDateValidator.provideValidated4DigitYear$default(this, data.getExpiryYear(), null, 2, null));
            ExpiryDateValidator.validateExpiryDate$default(this, expiryDate, null, 2, null);
            validationResult = new ValidationResult.Success<ExpiryDate>(expiryDate);
        }
        catch (ValidationError e) {
            validationResult = new ValidationResult.Failure(e);
        }
        return validationResult;
    }

    private final int provideValidatedMonth(String value) throws ValidationError {
        Integer month = StringsKt.toIntOrNull((String)value);
        if (month == null) {
            throw new ValidationError("ValidationError:1005", "Invalid value provided for month: " + month, null, 4, null);
        }
        if (!MONTH_RANGE.contains(month.intValue())) {
            throw new ValidationError("ValidationError:1007", "Month must be >= " + MONTH_RANGE.getFirst() + " && <= " + MONTH_RANGE.getLast(), null, 4, null);
        }
        return month;
    }

    private final int provideValidated4DigitYear(String value, Date date) throws ValidationError {
        int n;
        Calendar calendar;
        Calendar $this$provideValidated4DigitYear_u24lambda_u2d0 = calendar = Calendar.getInstance();
        boolean bl = false;
        $this$provideValidated4DigitYear_u24lambda_u2d0.setTime(date);
        Calendar utcCalendar = calendar;
        String referenceYear = StringsKt.takeLast((String)String.valueOf(utcCalendar.get(1)), (int)2);
        Integer year = StringsKt.toIntOrNull((String)value);
        if (year == null) {
            throw new ValidationError("ValidationError:1006", "Invalid value provided for year: " + value, null, 4, null);
        }
        if (year < 0) {
            throw new ValidationError("ValidationError:1008", "Year cannot be a negative value: " + value, null, 4, null);
        }
        if (value.length() == 1 && Intrinsics.compare((int)StringsKt.first((CharSequence)value), (int)StringsKt.first((CharSequence)referenceYear)) < 0 || value.length() == 2) {
            n = year + 2000;
        } else if (value.length() == 4) {
            n = year;
        } else {
            throw new ValidationError("ValidationError:1008", "Unexpected year value detected: " + value, null, 4, null);
        }
        return n;
    }

    static /* synthetic */ int provideValidated4DigitYear$default(ExpiryDateValidator expiryDateValidator, String string, Date date, int n, Object object) throws ValidationError {
        if ((n & 2) != 0) {
            date = new Date();
        }
        return expiryDateValidator.provideValidated4DigitYear(string, date);
    }

    private final void validateExpiryDate(ExpiryDate expiryDate, Date date) throws ValidationError {
        Calendar calendar;
        int month = expiryDate.component1();
        int year = expiryDate.component2();
        Calendar $this$validateExpiryDate_u24lambda_u2d1 = calendar = Calendar.getInstance();
        boolean bl = false;
        $this$validateExpiryDate_u24lambda_u2d1.setTime(date);
        Calendar utcCalendar = calendar;
        int referenceYear = utcCalendar.get(1);
        int referenceMonth = utcCalendar.get(2) + 1;
        if (year < referenceYear || year == referenceYear && month < referenceMonth) {
            throw new ValidationError("ValidationError:1011", "Expiry month " + month + " & year " + year + " should be in the future", null, 4, null);
        }
    }

    static /* synthetic */ void validateExpiryDate$default(ExpiryDateValidator expiryDateValidator, ExpiryDate expiryDate, Date date, int n, Object object) throws ValidationError {
        if ((n & 2) != 0) {
            date = new Date();
        }
        expiryDateValidator.validateExpiryDate(expiryDate, date);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/checkout/validation/validator/ExpiryDateValidator$Companion;", "", "()V", "MONTH_RANGE", "Lkotlin/ranges/IntRange;", "getMONTH_RANGE", "()Lkotlin/ranges/IntRange;", "YEAR_LONG_DELTA", "", "YEAR_LONG_FORMAT", "YEAR_SHORT_FORMAT", "checkout_release"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IntRange getMONTH_RANGE() {
            return MONTH_RANGE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

