/*
 * Decompiled with CFR 0.152.
 */
package com.checkout.tokenization.repository;

import androidx.annotation.VisibleForTesting;
import com.checkout.base.mapper.Mapper;
import com.checkout.base.usecase.UseCase;
import com.checkout.network.response.NetworkApiResponse;
import com.checkout.tokenization.NetworkApiClient;
import com.checkout.tokenization.entity.GooglePayEntity;
import com.checkout.tokenization.error.TokenizationError;
import com.checkout.tokenization.logging.TokenizationLogger;
import com.checkout.tokenization.mapper.TokenizationNetworkDataMapper;
import com.checkout.tokenization.model.Card;
import com.checkout.tokenization.model.CardTokenRequest;
import com.checkout.tokenization.model.GooglePayTokenRequest;
import com.checkout.tokenization.model.TokenDetails;
import com.checkout.tokenization.model.TokenResult;
import com.checkout.tokenization.repository.TokenRepository;
import com.checkout.tokenization.request.GooglePayTokenNetworkRequest;
import com.checkout.tokenization.request.TokenRequest;
import com.checkout.tokenization.response.TokenDetailsResponse;
import com.checkout.validation.model.ValidationResult;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.NonCancellable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001BY\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0018\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\f\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0012H\u0007J\\\u0010\u001f\u001a\u00020\u000e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\n0!2!\u0010\"\u001a\u001d\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b(&\u0012\u0004\u0012\u00020\u000e0#2!\u0010'\u001a\u001d\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b((\u0012\u0004\u0012\u00020\u000e0#H\u0002J\u001e\u0010)\u001a\u00020\u000e2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+2\u0006\u0010-\u001a\u00020\u0012H\u0002J\u0010\u0010.\u001a\u00020\u000e2\u0006\u0010/\u001a\u000200H\u0016J\u0010\u00101\u001a\u00020\u000e2\u0006\u00102\u001a\u000203H\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0014\u001a\u00020\u00158\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/checkout/tokenization/repository/TokenRepositoryImpl;", "Lcom/checkout/tokenization/repository/TokenRepository;", "networkApiClient", "Lcom/checkout/tokenization/NetworkApiClient;", "cardToTokenRequestMapper", "Lcom/checkout/base/mapper/Mapper;", "Lcom/checkout/tokenization/model/Card;", "Lcom/checkout/tokenization/request/TokenRequest;", "cardTokenizationNetworkDataMapper", "Lcom/checkout/tokenization/mapper/TokenizationNetworkDataMapper;", "Lcom/checkout/tokenization/model/TokenDetails;", "validateTokenizationDataUseCase", "Lcom/checkout/base/usecase/UseCase;", "Lcom/checkout/validation/model/ValidationResult;", "", "logger", "Lcom/checkout/tokenization/logging/TokenizationLogger;", "publicKey", "", "(Lcom/checkout/tokenization/NetworkApiClient;Lcom/checkout/base/mapper/Mapper;Lcom/checkout/tokenization/mapper/TokenizationNetworkDataMapper;Lcom/checkout/base/usecase/UseCase;Lcom/checkout/tokenization/logging/TokenizationLogger;Ljava/lang/String;)V", "networkCoroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "getNetworkCoroutineScope$annotations", "()V", "getNetworkCoroutineScope", "()Lkotlinx/coroutines/CoroutineScope;", "setNetworkCoroutineScope", "(Lkotlinx/coroutines/CoroutineScope;)V", "creatingTokenData", "Lcom/checkout/tokenization/entity/GooglePayEntity;", "tokenJsonPayload", "handleResponse", "tokenResult", "Lcom/checkout/tokenization/model/TokenResult;", "success", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "tokenDetails", "failure", "errorMessage", "logResponse", "response", "Lcom/checkout/network/response/NetworkApiResponse;", "Lcom/checkout/tokenization/response/TokenDetailsResponse;", "tokenType", "sendCardTokenRequest", "cardTokenRequest", "Lcom/checkout/tokenization/model/CardTokenRequest;", "sendGooglePayTokenRequest", "googlePayTokenRequest", "Lcom/checkout/tokenization/model/GooglePayTokenRequest;", "checkout_release"})
public final class TokenRepositoryImpl
implements TokenRepository {
    @NotNull
    private final NetworkApiClient networkApiClient;
    @NotNull
    private final Mapper<Card, TokenRequest> cardToTokenRequestMapper;
    @NotNull
    private final TokenizationNetworkDataMapper<TokenDetails> cardTokenizationNetworkDataMapper;
    @NotNull
    private final UseCase<Card, ValidationResult<Unit>> validateTokenizationDataUseCase;
    @NotNull
    private final TokenizationLogger logger;
    @NotNull
    private final String publicKey;
    @NotNull
    private CoroutineScope networkCoroutineScope;

    public TokenRepositoryImpl(@NotNull NetworkApiClient networkApiClient, @NotNull Mapper<Card, TokenRequest> cardToTokenRequestMapper, @NotNull TokenizationNetworkDataMapper<TokenDetails> cardTokenizationNetworkDataMapper, @NotNull UseCase<Card, ValidationResult<Unit>> validateTokenizationDataUseCase, @NotNull TokenizationLogger logger, @NotNull String publicKey) {
        Intrinsics.checkNotNullParameter((Object)networkApiClient, (String)"networkApiClient");
        Intrinsics.checkNotNullParameter(cardToTokenRequestMapper, (String)"cardToTokenRequestMapper");
        Intrinsics.checkNotNullParameter(cardTokenizationNetworkDataMapper, (String)"cardTokenizationNetworkDataMapper");
        Intrinsics.checkNotNullParameter(validateTokenizationDataUseCase, (String)"validateTokenizationDataUseCase");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        this.networkApiClient = networkApiClient;
        this.cardToTokenRequestMapper = cardToTokenRequestMapper;
        this.cardTokenizationNetworkDataMapper = cardTokenizationNetworkDataMapper;
        this.validateTokenizationDataUseCase = validateTokenizationDataUseCase;
        this.logger = logger;
        this.publicKey = publicKey;
        this.networkCoroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)new CoroutineName("com.checkout.checkout-android").plus((CoroutineContext)Dispatchers.getIO()).plus((CoroutineContext)NonCancellable.INSTANCE));
    }

    @NotNull
    public final CoroutineScope getNetworkCoroutineScope() {
        return this.networkCoroutineScope;
    }

    public final void setNetworkCoroutineScope(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"<set-?>");
        this.networkCoroutineScope = coroutineScope;
    }

    @VisibleForTesting
    public static /* synthetic */ void getNetworkCoroutineScope$annotations() {
    }

    @Override
    public void sendCardTokenRequest(@NotNull CardTokenRequest cardTokenRequest) {
        Intrinsics.checkNotNullParameter((Object)cardTokenRequest, (String)"cardTokenRequest");
        Ref.ObjectRef response = new Ref.ObjectRef();
        BuildersKt.launch$default((CoroutineScope)this.networkCoroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, cardTokenRequest, (Ref.ObjectRef<NetworkApiResponse<TokenDetailsResponse>>)response, null){
            Object L$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ TokenRepositoryImpl this$0;
            final /* synthetic */ CardTokenRequest $cardTokenRequest;
            final /* synthetic */ Ref.ObjectRef<NetworkApiResponse<TokenDetailsResponse>> $response;
            {
                this.this$0 = $receiver;
                this.$cardTokenRequest = $cardTokenRequest;
                this.$response = $response;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                block5: {
                    var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            $this$launch = (CoroutineScope)this.L$0;
                            var4_5 = validationTokenizationDataResult = (ValidationResult)TokenRepositoryImpl.access$getValidateTokenizationDataUseCase$p(this.this$0).execute(this.$cardTokenRequest.getCard());
                            if (!(var4_5 instanceof ValidationResult.Failure)) ** GOTO lbl10
                            this.$response.element = new NetworkApiResponse.InternalError(((ValidationResult.Failure)validationTokenizationDataResult).getError());
                            break block5;
lbl10:
                            // 1 sources

                            if (!(var4_5 instanceof ValidationResult.Success)) break;
                            TokenRepositoryImpl.access$getLogger$p(this.this$0).logTokenRequestEvent("card", TokenRepositoryImpl.access$getPublicKey$p(this.this$0));
                            var5_6 = this.$response;
                            this.L$0 = $this$launch;
                            this.L$1 = var5_6;
                            this.label = 1;
                            v0 = TokenRepositoryImpl.access$getNetworkApiClient$p(this.this$0).sendCardTokenRequest((TokenRequest)TokenRepositoryImpl.access$getCardToTokenRequestMapper$p(this.this$0).map(this.$cardTokenRequest.getCard()), (Continuation<? super NetworkApiResponse<TokenDetailsResponse>>)((Continuation)this));
                            if (v0 == var6_2) {
                                return var6_2;
                            }
                            ** GOTO lbl25
                        }
                        case 1: {
                            var5_6 = (Ref.ObjectRef<NetworkApiResponse<TokenDetailsResponse>>)this.L$1;
                            $this$launch = (CoroutineScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl25:
                            // 2 sources

                            var5_6.element = v0;
                            TokenRepositoryImpl.access$logResponse(this.this$0, (NetworkApiResponse)this.$response.element, "card");
                            TokenRepositoryImpl.access$getLogger$p(this.this$0).resetSession();
                            break block5;
                        }
                    }
                    throw new NoWhenBranchMatchedException();
                }
                tokenResult = TokenRepositoryImpl.access$getCardTokenizationNetworkDataMapper$p(this.this$0).toTokenResult((NetworkApiResponse)this.$response.element);
                BuildersKt.launch$default((CoroutineScope)$this$launch, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, tokenResult, this.$cardTokenRequest, null){
                    int label;
                    final /* synthetic */ TokenRepositoryImpl this$0;
                    final /* synthetic */ TokenResult<TokenDetails> $tokenResult;
                    final /* synthetic */ CardTokenRequest $cardTokenRequest;
                    {
                        this.this$0 = $receiver;
                        this.$tokenResult = $tokenResult;
                        this.$cardTokenRequest = $cardTokenRequest;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                TokenRepositoryImpl.access$handleResponse(this.this$0, this.$tokenResult, this.$cardTokenRequest.getOnSuccess(), this.$cardTokenRequest.getOnFailure());
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Override
    public void sendGooglePayTokenRequest(@NotNull GooglePayTokenRequest googlePayTokenRequest) {
        Intrinsics.checkNotNullParameter((Object)googlePayTokenRequest, (String)"googlePayTokenRequest");
        Ref.ObjectRef response = new Ref.ObjectRef();
        BuildersKt.launch$default((CoroutineScope)this.networkCoroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, googlePayTokenRequest, (Ref.ObjectRef<NetworkApiResponse<TokenDetailsResponse>>)response, null){
            Object L$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ TokenRepositoryImpl this$0;
            final /* synthetic */ GooglePayTokenRequest $googlePayTokenRequest;
            final /* synthetic */ Ref.ObjectRef<NetworkApiResponse<TokenDetailsResponse>> $response;
            {
                this.this$0 = $receiver;
                this.$googlePayTokenRequest = $googlePayTokenRequest;
                this.$response = $response;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$launch = (CoroutineScope)this.L$0;
                        request = new GooglePayTokenNetworkRequest("googlepay", this.this$0.creatingTokenData(this.$googlePayTokenRequest.getTokenJsonPayload()));
                        TokenRepositoryImpl.access$getLogger$p(this.this$0).logTokenRequestEvent("googlepay", TokenRepositoryImpl.access$getPublicKey$p(this.this$0));
                        var5_6 = this.$response;
                        this.L$0 = $this$launch;
                        this.L$1 = var5_6;
                        this.label = 1;
                        v0 = TokenRepositoryImpl.access$getNetworkApiClient$p(this.this$0).sendGooglePayTokenRequest(request, (Continuation<? super NetworkApiResponse<TokenDetailsResponse>>)((Continuation)this));
                        ** if (v0 != var6_2) goto lbl17
lbl16:
                        // 1 sources

                        return var6_2;
lbl17:
                        // 1 sources

                        ** GOTO lbl25
                    }
                    case 1: {
                        var5_6 = (Ref.ObjectRef<NetworkApiResponse<TokenDetailsResponse>>)this.L$1;
                        $this$launch = (CoroutineScope)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl25:
                            // 2 sources

                            var5_6.element = v0;
                            TokenRepositoryImpl.access$logResponse(this.this$0, (NetworkApiResponse)this.$response.element, "googlepay");
                            TokenRepositoryImpl.access$getLogger$p(this.this$0).resetSession();
                        }
                        catch (Exception exception) {
                            error = new TokenizationError("TokenizationError.Server:3005", exception.getMessage(), exception.getCause());
                            this.$response.element = new NetworkApiResponse.InternalError(error);
                            TokenRepositoryImpl.access$getLogger$p(this.this$0).logErrorOnTokenRequestedEvent("googlepay", TokenRepositoryImpl.access$getPublicKey$p(this.this$0), error);
                        }
                        tokenResult = TokenRepositoryImpl.access$getCardTokenizationNetworkDataMapper$p(this.this$0).toTokenResult((NetworkApiResponse)this.$response.element);
                        BuildersKt.launch$default((CoroutineScope)$this$launch, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, tokenResult, this.$googlePayTokenRequest, null){
                            int label;
                            final /* synthetic */ TokenRepositoryImpl this$0;
                            final /* synthetic */ TokenResult<TokenDetails> $tokenResult;
                            final /* synthetic */ GooglePayTokenRequest $googlePayTokenRequest;
                            {
                                this.this$0 = $receiver;
                                this.$tokenResult = $tokenResult;
                                this.$googlePayTokenRequest = $googlePayTokenRequest;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        TokenRepositoryImpl.access$handleResponse(this.this$0, this.$tokenResult, this.$googlePayTokenRequest.getOnSuccess(), this.$googlePayTokenRequest.getOnFailure());
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)2, null);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @VisibleForTesting
    @NotNull
    public final GooglePayEntity creatingTokenData(@NotNull String tokenJsonPayload) throws JSONException {
        Intrinsics.checkNotNullParameter((Object)tokenJsonPayload, (String)"tokenJsonPayload");
        JSONObject tokenDataJsonObject = new JSONObject(tokenJsonPayload);
        return new GooglePayEntity(tokenDataJsonObject.getString("signature"), tokenDataJsonObject.getString("protocolVersion"), tokenDataJsonObject.getString("signedMessage"));
    }

    private final void handleResponse(TokenResult<TokenDetails> tokenResult, Function1<? super TokenDetails, Unit> success, Function1<? super String, Unit> failure) {
        block2: {
            TokenResult<TokenDetails> tokenResult2;
            block1: {
                tokenResult2 = tokenResult;
                if (!(tokenResult2 instanceof TokenResult.Success)) break block1;
                success.invoke(((TokenResult.Success)tokenResult).getResult());
                break block2;
            }
            if (!(tokenResult2 instanceof TokenResult.Failure)) break block2;
            String string = ((TokenResult.Failure)tokenResult).getError().getMessage();
            if (string != null) {
                String it = string;
                boolean bl = false;
                failure.invoke((Object)it);
            }
        }
    }

    private final void logResponse(NetworkApiResponse<TokenDetailsResponse> response, String tokenType) {
        NetworkApiResponse<TokenDetailsResponse> networkApiResponse = response;
        if (networkApiResponse instanceof NetworkApiResponse.ServerError) {
            this.logger.logTokenResponseEvent(tokenType, this.publicKey, null, ((NetworkApiResponse.ServerError)response).getCode(), ((NetworkApiResponse.ServerError)response).getBody());
        } else if (networkApiResponse instanceof NetworkApiResponse.Success) {
            TokenizationLogger.DefaultImpls.logTokenResponseEvent$default(this.logger, tokenType, this.publicKey, (TokenDetailsResponse)((NetworkApiResponse.Success)response).getBody(), null, null, 24, null);
        }
    }

    public static final /* synthetic */ UseCase access$getValidateTokenizationDataUseCase$p(TokenRepositoryImpl $this) {
        return $this.validateTokenizationDataUseCase;
    }

    public static final /* synthetic */ TokenizationLogger access$getLogger$p(TokenRepositoryImpl $this) {
        return $this.logger;
    }

    public static final /* synthetic */ String access$getPublicKey$p(TokenRepositoryImpl $this) {
        return $this.publicKey;
    }

    public static final /* synthetic */ NetworkApiClient access$getNetworkApiClient$p(TokenRepositoryImpl $this) {
        return $this.networkApiClient;
    }

    public static final /* synthetic */ Mapper access$getCardToTokenRequestMapper$p(TokenRepositoryImpl $this) {
        return $this.cardToTokenRequestMapper;
    }

    public static final /* synthetic */ void access$logResponse(TokenRepositoryImpl $this, NetworkApiResponse response, String tokenType) {
        $this.logResponse(response, tokenType);
    }

    public static final /* synthetic */ TokenizationNetworkDataMapper access$getCardTokenizationNetworkDataMapper$p(TokenRepositoryImpl $this) {
        return $this.cardTokenizationNetworkDataMapper;
    }

    public static final /* synthetic */ void access$handleResponse(TokenRepositoryImpl $this, TokenResult tokenResult, Function1 success, Function1 failure) {
        $this.handleResponse(tokenResult, (Function1<? super TokenDetails, Unit>)success, (Function1<? super String, Unit>)failure);
    }
}

