/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.sdk.service;

import com.checkmarx.sdk.config.CxProperties;
import com.checkmarx.sdk.dto.CxUser;
import com.checkmarx.sdk.exception.CheckmarxException;
import com.checkmarx.sdk.service.CxAuthService;
import com.checkmarx.sdk.service.CxLegacyService;
import com.checkmarx.sdk.service.CxUserClient;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CxUserService
implements CxUserClient {
    private static final Logger log = LoggerFactory.getLogger(CxUserService.class);
    private final CxAuthService authClient;
    private final CxLegacyService cxLegacyService;
    private final CxProperties cxProperties;

    public CxUserService(CxAuthService authClient, CxLegacyService cxLegacyService, CxProperties cxProperties) {
        this.authClient = authClient;
        this.cxLegacyService = cxLegacyService;
        this.cxProperties = cxProperties;
    }

    @Override
    public List<CxUser> getUsers() throws CheckmarxException {
        if (this.cxProperties.getVersion() < 9.0) {
            String session = this.authClient.getLegacySession();
            return this.cxLegacyService.getUsers(session);
        }
        log.warn("getUsers for 9.0 has not been implemented");
        throw new CheckmarxException("Operation not supported in 9.x");
    }

    @Override
    public CxUser getUser(Integer id) throws CheckmarxException {
        if (this.cxProperties.getVersion() < 9.0) {
            String session = this.authClient.getLegacySession();
            return this.cxLegacyService.getUser(session, id);
        }
        log.warn("getUser for 9.0 has not been implemented");
        throw new CheckmarxException("Operation not supported in 9.x");
    }

    @Override
    public void updateUser(CxUser user) throws CheckmarxException {
        if (!(this.cxProperties.getVersion() < 9.0)) {
            log.warn("getUser for 9.0 has not been implemented");
            throw new CheckmarxException("Operation not supported in 9.x");
        }
        String session = this.authClient.getLegacySession();
        this.cxLegacyService.updateUser(session, user);
    }

    @Override
    public void deleteUser(Integer id) throws CheckmarxException {
        if (!(this.cxProperties.getVersion() < 9.0)) {
            log.warn("deleteUser for 9.0 has not been implemented");
            throw new CheckmarxException("Operation not supported in 9.x");
        }
        String session = this.authClient.getLegacySession();
        this.cxLegacyService.deleteUser(session, id);
    }

    @Override
    public void addUser(CxUser user) throws CheckmarxException {
        if (!(this.cxProperties.getVersion() < 9.0)) {
            log.warn("getUsers for 9.0 has not been implemented");
            throw new CheckmarxException("Operation not supported in 9.x");
        }
        String session = this.authClient.getLegacySession();
        this.cxLegacyService.addUser(session, user);
    }

    public String getCompanyId(String company) throws CheckmarxException {
        if (this.cxProperties.getVersion() < 9.0) {
            String session = this.authClient.getLegacySession();
            return this.cxLegacyService.getCompany(session, company);
        }
        log.warn("getUsers for 9.0 has not been implemented");
        throw new CheckmarxException("Operation not supported in 9.x");
    }
}

