/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.sdk.config;

import com.checkmarx.sdk.config.CxProperties;
import java.nio.charset.Charset;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.Unmarshaller;
import org.springframework.oxm.jaxb.Jaxb2Marshaller;
import org.springframework.web.client.RestTemplate;
import org.springframework.ws.client.core.WebServiceTemplate;

@Configuration
public class CxConfig {
    private final CxProperties properties;

    public CxConfig(CxProperties properties) {
        this.properties = properties;
    }

    @Bean(name={"cxRestTemplate"})
    public RestTemplate getRestTemplate() {
        RestTemplate restTemplate = new RestTemplate();
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory((HttpClient)HttpClientBuilder.create().useSystemProperties().build());
        requestFactory.setConnectTimeout(this.properties.getHttpConnectionTimeout().intValue());
        requestFactory.setReadTimeout(this.properties.getHttpReadTimeout().intValue());
        restTemplate.setRequestFactory((ClientHttpRequestFactory)requestFactory);
        restTemplate.getMessageConverters().add(0, new StringHttpMessageConverter(Charset.forName("UTF-8")));
        return restTemplate;
    }

    @Bean
    public Jaxb2Marshaller marshaller() {
        Jaxb2Marshaller marshaller = new Jaxb2Marshaller();
        if (this.properties != null && this.properties.getPortalPackage() != null && !this.properties.getPortalPackage().isEmpty()) {
            marshaller.setContextPaths(new String[]{this.properties.getPortalPackage()});
        }
        return marshaller;
    }

    @Bean
    public WebServiceTemplate webServiceTemplate(Jaxb2Marshaller marshaller) {
        WebServiceTemplate ws = new WebServiceTemplate();
        if (this.properties != null && this.properties.getPortalUrl() != null && !this.properties.getPortalUrl().isEmpty()) {
            ws.setDefaultUri(this.properties.getPortalUrl());
        }
        if (marshaller != null) {
            ws.setMarshaller((Marshaller)marshaller);
            ws.setUnmarshaller((Unmarshaller)marshaller);
        }
        return ws;
    }
}

