/*
 * Decompiled with CFR 0.152.
 */
package com.chartbeat.androidsdk;

import com.chartbeat.androidsdk.ViewContent;
import com.chartbeat.androidsdk.ViewDimension;
import com.chartbeat.androidsdk.ViewInfo;
import java.util.LinkedHashMap;
import java.util.Locale;

final class ViewTracker {
    private static final String TAG = ViewTracker.class.getSimpleName();
    private static final double SECOND_IN_DOUBLE = 1000.0;
    private final long viewInitTime;
    private ViewInfo viewInfo;
    private ViewDimension dimension;
    private ViewContent content;
    private String subdomain;
    private String domain;

    ViewTracker(String viewId, String viewTitle, String domain, String subdomain, String internalReferrer, String externalReferrer, String token, ViewDimension dimension) {
        this.viewInfo = new ViewInfo(viewId, viewTitle, internalReferrer, externalReferrer, token);
        this.domain = domain;
        this.subdomain = subdomain;
        this.viewInitTime = System.currentTimeMillis();
        this.dimension = dimension == null ? new ViewDimension() : dimension;
        this.content = new ViewContent();
    }

    boolean isSameView(String viewId) {
        String currentViewId = this.viewInfo.getViewId();
        return currentViewId != null && currentViewId.equals(viewId);
    }

    boolean wasReferredFromAnotherView() {
        return this.viewInfo.getInternalReferrer() != null;
    }

    String getViewId() {
        if (this.viewInfo != null) {
            return this.viewInfo.getViewId();
        }
        return null;
    }

    String getViewTitle() {
        if (this.viewInfo != null) {
            return this.viewInfo.getViewTitle();
        }
        return null;
    }

    String getSubdomain() {
        return this.subdomain;
    }

    String getDomain() {
        return this.domain;
    }

    String getInternalReferrer() {
        if (this.viewInfo != null) {
            return this.viewInfo.getInternalReferrer();
        }
        return null;
    }

    String getExternalReferrer() {
        if (this.viewInfo != null) {
            return this.viewInfo.getExternalReferrer();
        }
        return null;
    }

    String getToken() {
        if (this.viewInfo != null) {
            return this.viewInfo.getToken();
        }
        return null;
    }

    double getViewingTimeInMinutes() {
        long timeInView = System.currentTimeMillis() - this.viewInitTime;
        if (timeInView < 0L) {
            timeInView = 0L;
        }
        double secondsInView = (double)timeInView / 1000.0;
        double minutesInView = secondsInView / 60.0;
        return minutesInView;
    }

    String getMinutesInView() {
        double minutesInView = this.getViewingTimeInMinutes();
        return String.format(Locale.US, "%.2f", minutesInView);
    }

    LinkedHashMap<String, String> getDimensionParams() {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        if (this.dimension != null) {
            params.putAll(this.dimension.toPingParams());
        }
        return params;
    }

    LinkedHashMap<String, String> getContentParams() {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        if (this.content != null) {
            params.putAll(this.content.toPingParams());
        }
        return params;
    }

    void updateDimension(int scrollPositionTop, int scrollWindowHeight, int totalContentHeight, int fullyRenderedDocWidth) {
        int currentMaxDepth = this.dimension.getMaxScrollDepth();
        this.dimension = new ViewDimension(scrollPositionTop, scrollWindowHeight, totalContentHeight, fullyRenderedDocWidth, Math.max(currentMaxDepth, scrollPositionTop));
    }

    void updateSubdomain(String subdomain) {
        this.subdomain = subdomain != null && !subdomain.isEmpty() ? subdomain : null;
    }

    void updateDomain(String domain) {
        this.domain = domain != null && !domain.isEmpty() ? domain : null;
    }

    void updateInternalReferrer(String internalReferrer) {
        this.viewInfo = new ViewInfo(this.viewInfo.getViewId(), this.viewInfo.getViewTitle(), internalReferrer, this.viewInfo.getExternalReferrer(), this.viewInfo.getToken());
    }

    void updateExternalReferrer(String externalReferrer) {
        this.viewInfo = new ViewInfo(this.viewInfo.getViewId(), this.viewInfo.getViewTitle(), this.viewInfo.getInternalReferrer(), externalReferrer, this.viewInfo.getToken());
    }

    void updateSections(String sections) {
        this.content = new ViewContent(sections, this.content.getAuthors(), this.content.getZones(), this.content.getPageLoadTime());
    }

    void updateAuthors(String authors) {
        this.content = new ViewContent(this.content.getSections(), authors, this.content.getZones(), this.content.getPageLoadTime());
    }

    void updateZones(String zones) {
        this.content = new ViewContent(this.content.getSections(), this.content.getAuthors(), zones, this.content.getPageLoadTime());
    }

    void updatePageLoadingTime(float pageLoadTime) {
        this.content = new ViewContent(this.content.getSections(), this.content.getAuthors(), this.content.getZones(), pageLoadTime);
    }
}

