/*
 * Decompiled with CFR 0.152.
 */
package com.chartbeat.androidsdk;

import java.util.LinkedHashMap;

final class ViewDimension {
    private int scrollPositionTop = -1;
    private int totalContentHeight = -1;
    private int scrollWindowHeight = -1;
    private int fullyRenderedDocWidth = -1;
    private int maxScrollDepth = -1;

    ViewDimension() {
    }

    ViewDimension(int scrollPositionTop, int scrollWindowHeight, int totalContentHeight, int fullyRenderedDocWidth, int maxScrollDepth) {
        this.scrollPositionTop = scrollPositionTop;
        this.totalContentHeight = totalContentHeight;
        this.scrollWindowHeight = scrollWindowHeight;
        this.fullyRenderedDocWidth = fullyRenderedDocWidth;
        this.maxScrollDepth = maxScrollDepth;
    }

    int getMaxScrollDepth() {
        return this.maxScrollDepth;
    }

    LinkedHashMap<String, String> toPingParams() {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        if (this.scrollPositionTop != -1) {
            params.put("x", String.valueOf(this.scrollPositionTop));
        }
        if (this.maxScrollDepth != -1) {
            params.put("m", String.valueOf(this.maxScrollDepth));
        }
        if (this.totalContentHeight != -1) {
            params.put("y", String.valueOf(this.totalContentHeight));
        }
        if (this.fullyRenderedDocWidth != -1) {
            params.put("o", String.valueOf(this.fullyRenderedDocWidth));
        }
        if (this.scrollWindowHeight != -1) {
            params.put("w", String.valueOf(this.scrollWindowHeight));
        }
        return params;
    }
}

