/*
 * Decompiled with CFR 0.152.
 */
package com.chartbeat.androidsdk;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Point;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import android.webkit.WebSettings;

final class SystemUtils {
    private static final String GENERIC_ANDROID_MOBILE_USER_AGENT = "Mozilla/5.0 (Android 6.0.1; Mobile; rv:50.0) Gecko/50.0 Firefox/50.0";
    private static final String GENERIC_ANDROID_TABLET_USER_AGENT = "Mozilla/5.0 (Linux; Android 7.0; Pixel C Build/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/52.0.2743.98 Safari/537.36";
    private static final String USER_AGENT_SUFFIX = "/cbua/App";
    private static final String STATIC_MOBILE_USER_AGENT = "Mozilla/5.0 (Android 6.0.1; Mobile; rv:50.0) Gecko/50.0 Firefox/50.0/cbua/App";
    private static final String STATIC_TABLET_USER_AGENT = "Mozilla/5.0 (Linux; Android 7.0; Pixel C Build/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/52.0.2743.98 Safari/537.36/cbua/App";
    private static final String TAG = SystemUtils.class.getSimpleName();

    SystemUtils() {
    }

    static boolean isNetworkAvailable(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        if (cm == null) {
            return false;
        }
        NetworkInfo netInfo = cm.getActiveNetworkInfo();
        return netInfo != null && netInfo.isConnectedOrConnecting();
    }

    private static boolean checkIsTablet(Context context) {
        boolean isTablet = false;
        try {
            Display display = ((WindowManager)context.getSystemService("window")).getDefaultDisplay();
            DisplayMetrics metrics = new DisplayMetrics();
            display.getMetrics(metrics);
            float widthInches = (float)metrics.widthPixels / metrics.xdpi;
            float heightInches = (float)metrics.heightPixels / metrics.ydpi;
            double diagonalInches = Math.sqrt(Math.pow(widthInches, 2.0) + Math.pow(heightInches, 2.0));
            if (diagonalInches >= 7.0) {
                isTablet = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isTablet;
    }

    static String getSystemUserAgent(Context context) {
        boolean isTablet = SystemUtils.checkIsTablet(context);
        return isTablet ? STATIC_TABLET_USER_AGENT : STATIC_MOBILE_USER_AGENT;
    }

    static Point getScreenSize(Context context) {
        WindowManager wm = (WindowManager)context.getSystemService("window");
        Display display = wm.getDefaultDisplay();
        Point size = new Point();
        float density = context.getResources().getDisplayMetrics().density;
        if (Build.VERSION.SDK_INT >= 17) {
            display.getRealSize(size);
        } else if (Build.VERSION.SDK_INT >= 13) {
            display.getSize(size);
        } else {
            size.x = display.getWidth();
            size.y = display.getHeight();
        }
        int width = (int)((float)size.x / density);
        int height = (int)((float)size.y / density);
        Point densityIndependentSize = new Point(width, height);
        return densityIndependentSize;
    }

    @TargetApi(value=17)
    private static class NewApiWrapper {
        private NewApiWrapper() {
        }

        static String getDefaultUserAgent(Context context) {
            return WebSettings.getDefaultUserAgent((Context)context);
        }
    }
}

