/*
 * Decompiled with CFR 0.152.
 */
package com.chartbeat.androidsdk;

import android.content.Context;
import android.content.SharedPreferences;
import com.chartbeat.androidsdk.SecurityUtils;
import java.util.Date;

final class SiteVisitTracker {
    private static final String TAG = "Chartbeat SiteVisitTracker";
    private static final int MINUTES_TO_TRACK_SITE_VISIT = 30;
    private static final int SITE_VISIT_ID_CHAR_LENGTH = 28;
    private static final String KEY_LAST_SITE_VISIT_ID = "site-visit-uid-";
    private static final String KEY_LAST_SITE_VISIT_REFRESH_TIME = "site-visit-refresh_time-";
    private static final String KEY_LAST_SITE_VISIT_DEPTH = "site-visit-depth-";
    private static final String KEY_LAST_SITE_VISIT_REFERRER = "site-visit-referrer-";
    protected SharedPreferences prefs;

    SiteVisitTracker(Context context) {
        if (context == null) {
            throw new NullPointerException("Activity or application context cannot be null");
        }
        this.prefs = context.getSharedPreferences("com.chartbeat.androidsdk.user", 0);
    }

    public String getSiteVisitId() {
        return this.prefs.getString(KEY_LAST_SITE_VISIT_ID, null);
    }

    public void storeSiteVisitId(String siteVisitID) {
        SharedPreferences.Editor editor = this.prefs.edit();
        editor.putString(KEY_LAST_SITE_VISIT_ID, siteVisitID);
        editor.apply();
    }

    public int getSiteVisitDepth() {
        return this.prefs.getInt(KEY_LAST_SITE_VISIT_DEPTH, 0);
    }

    public void visited() {
        this.storeSiteVisitRefreshTime(new Date());
    }

    public String getSiteVisitReferrer() {
        return this.prefs.getString(KEY_LAST_SITE_VISIT_REFERRER, null);
    }

    public void trackSiteVisit(String newSiteReferrer) {
        String siteVisitReferrer;
        Boolean shouldResetSiteVisit;
        if (newSiteReferrer == null) {
            newSiteReferrer = new String();
        }
        if (!(shouldResetSiteVisit = Boolean.valueOf((siteVisitReferrer = this.getSiteVisitReferrer()) != null && newSiteReferrer.length() > 0 && !siteVisitReferrer.equals(newSiteReferrer) || this.hasSiteVisitExpired() != false || siteVisitReferrer == null && newSiteReferrer.length() > 0)).booleanValue()) {
            this.storeSiteVisitDepth(this.getSiteVisitDepth() + 1);
        } else {
            this.storeSiteVisitDepth(1);
            this.storeSiteVisitReferrer(newSiteReferrer);
            this.storeSiteVisitId(SecurityUtils.randomChars(28));
            this.storeSiteVisitRefreshTime(new Date());
        }
    }

    void storeSiteVisitDepth(int siteVisitDepth) {
        SharedPreferences.Editor editor = this.prefs.edit();
        editor.putInt(KEY_LAST_SITE_VISIT_DEPTH, siteVisitDepth);
        editor.apply();
    }

    void storeSiteVisitReferrer(String siteVisitReferrer) {
        SharedPreferences.Editor editor = this.prefs.edit();
        editor.putString(KEY_LAST_SITE_VISIT_REFERRER, siteVisitReferrer);
        editor.apply();
    }

    Date getSiteVisitRefreshTime() {
        Long dateLong = this.prefs.getLong(KEY_LAST_SITE_VISIT_REFRESH_TIME, 0L);
        if (dateLong != 0L) {
            return new Date(dateLong);
        }
        return null;
    }

    void storeSiteVisitRefreshTime(Date siteVisitRefreshTime) {
        SharedPreferences.Editor editor = this.prefs.edit();
        editor.putLong(KEY_LAST_SITE_VISIT_REFRESH_TIME, siteVisitRefreshTime.getTime());
        editor.apply();
    }

    Boolean hasSiteVisitExpired() {
        Date rightNow = new Date();
        Date siteVisitExpirationTime = this.getSiteVisitRefreshTime();
        if (siteVisitExpirationTime == null) {
            return true;
        }
        siteVisitExpirationTime.setMinutes(siteVisitExpirationTime.getMinutes() + 30);
        return siteVisitExpirationTime.before(rightNow);
    }
}

