/*
 * Decompiled with CFR 0.152.
 */
package com.chartbeat.androidsdk;

import com.chartbeat.androidsdk.PingMode;
import java.util.LinkedHashSet;
import java.util.Set;

final class PingParams {
    private static final String TAG = PingParams.class.getSimpleName();
    Set<String> oneTimeKeys = new LinkedHashSet<String>();
    PingMode pingMode = PingMode.FIRST_PING;

    PingParams() {
    }

    void addOneTimeParameter(String k) {
        this.oneTimeKeys.add(k);
    }

    void newView() {
        this.pingMode = PingMode.FULL_PING;
    }

    boolean includeParameter(String parameter) {
        return this.oneTimeKeys.contains(parameter) || this.pingMode.includeParameter(parameter);
    }

    void pingComplete(int code) {
        if (code == 500) {
            this.pingMode = PingMode.REPEAT_PING_AFTER_CODE_500;
        } else if (code == 400) {
            this.pingMode = PingMode.FULL_PING;
        } else {
            this.pingMode = this.pingMode.next();
            this.oneTimeKeys.clear();
        }
    }

    void pingError() {
        this.pingMode = PingMode.FULL_PING;
    }

    void pingReset() {
        this.oneTimeKeys.clear();
        this.pingMode = PingMode.FULL_PING;
    }
}

