/*
 * Decompiled with CFR 0.152.
 */
package com.chartbeat.androidsdk;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.chartbeat.androidsdk.AwsLogger;
import com.chartbeat.androidsdk.ChartBeatTracker;
import com.chartbeat.androidsdk.Logger;
import com.chartbeat.androidsdk.SubscriptionState;
import java.lang.ref.WeakReference;

final class ChartbeatServiceHandler
extends Handler {
    private static final String TAG = ChartbeatServiceHandler.class.getSimpleName();
    private static final String KEY_LAST_USED_ACCOUNT_ID = "KEY_LAST_USED_ACCOUNT_ID";
    private static final String KEY_LAST_USED_DOMAIN = "KEY_LAST_USED_DOMAIN";
    private WeakReference<Context> context;
    private static ChartBeatTracker singleton;
    private static String userAgent;

    public ChartbeatServiceHandler(WeakReference<Context> context, Looper looper, String systemUserAgent) {
        super(looper);
        this.context = context;
        userAgent = systemUserAgent;
    }

    public void handleMessage(Message msg) {
        try {
            Bundle bundle = msg.getData();
            this.processMessage(bundle);
        }
        catch (Exception e) {
            AwsLogger.getInstance().logError(e);
        }
    }

    private void processMessage(Bundle bundle) {
        try {
            String actionType = bundle.getString("KEY_SDK_ACTION_TYPE");
            if (actionType.equals("ACTION_INIT_TRACKER")) {
                this.handleSDKInit(bundle);
            }
            if (!ChartbeatServiceHandler.isSDKInitialized()) {
                this.reInitSDKFromBackground();
            }
            this.handleMessageType(actionType, bundle);
        }
        catch (Exception e) {
            AwsLogger.getInstance().logError(e);
        }
    }

    private static boolean isSDKInitialized() {
        return singleton != null && singleton.isClientPaused() == false;
    }

    private void reInitSDKFromBackground() {
        try {
            SharedPreferences prefs = ((Context)this.context.get()).getSharedPreferences("com.chartbeat.androidsdk.user", 0);
            String accountID = prefs.getString(KEY_LAST_USED_ACCOUNT_ID, null);
            if (accountID != null) {
                String domain = prefs.getString(KEY_LAST_USED_DOMAIN, null);
                this.initSDK(accountID, domain);
            }
        }
        catch (Exception e) {
            AwsLogger.getInstance().logError(e);
        }
    }

    private void initSDK(String accountID, String domain) {
        try {
            singleton = new ChartBeatTracker(this.context, accountID, domain, userAgent, this.getLooper());
        }
        catch (Exception e) {
            AwsLogger.getInstance().logError(e);
        }
    }

    private void handleMessageType(String actionType, Bundle bundle) {
        try {
            if (!ChartbeatServiceHandler.isSDKInitialized()) {
                Logger.e(TAG, "Chartbeat SDK has not been initialized");
                return;
            }
            switch (actionType) {
                case "ACTION_SET_APP_REFERRER": {
                    this.setAppReferrer(bundle);
                    break;
                }
                case "ACTION_STOP_TRACKER": {
                    this.stopTracker();
                    break;
                }
                case "ACTION_TRACK_VIEW": {
                    this.trackView(bundle);
                    break;
                }
                case "ACTION_LEFT_VIEW": {
                    ChartbeatServiceHandler.userLeftView(bundle);
                    break;
                }
                case "ACTION_USER_INTERACTED": {
                    ChartbeatServiceHandler.userInteracted();
                    break;
                }
                case "ACTION_USER_TYPED": {
                    ChartbeatServiceHandler.userTyped();
                    break;
                }
                case "ACTION_SET_SUBDOMAIN": {
                    ChartbeatServiceHandler.setSubdomain(bundle);
                    break;
                }
                case "ACTION_SET_DOMAIN": {
                    ChartbeatServiceHandler.setDomain(bundle);
                    break;
                }
                case "ACTION_SET_ZONES": {
                    ChartbeatServiceHandler.setZones(bundle);
                    break;
                }
                case "ACTION_SET_AUTHORS": {
                    ChartbeatServiceHandler.setAuthors(bundle);
                    break;
                }
                case "ACTION_SET_SUBSCRIPTION_STATE": {
                    ChartbeatServiceHandler.setSubscriptionState(bundle);
                    break;
                }
                case "ACTION_SET_SECTIONS": {
                    ChartbeatServiceHandler.setSections(bundle);
                    break;
                }
                case "ACTION_SET_VIEW_LOADING_TIME": {
                    ChartbeatServiceHandler.setViewLoadTime(bundle);
                    break;
                }
                case "ACTION_SET_POSITION": {
                    ChartbeatServiceHandler.setPosition(bundle);
                    break;
                }
                case "ACTION_PAUSE_TRACKER": {
                    this.pauseTracker();
                    break;
                }
                case "ACTION_RESTART_PING_SERVICE": {
                    singleton.restartPinger();
                    break;
                }
                case "ACTION_BACKGROUND_TRACKER": {
                    this.backgroundTracker();
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (Exception e) {
            AwsLogger.getInstance().logError(e);
        }
    }

    private void handleSDKInit(Bundle bundle) {
        if (!ChartbeatServiceHandler.isSDKInitialized()) {
            String accountID = bundle.getString("KEY_ACCOUNT_ID");
            String domain = bundle.getString("KEY_DOMAIN");
            this.initSDK(accountID, domain);
            this.cacheSDKDetailForReinit(accountID, domain);
        }
    }

    private void cacheSDKDetailForReinit(String accountID, String domain) {
        SharedPreferences prefs = ((Context)this.context.get()).getSharedPreferences("com.chartbeat.androidsdk.user", 0);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putString(KEY_LAST_USED_ACCOUNT_ID, accountID);
        editor.putString(KEY_LAST_USED_DOMAIN, domain);
        editor.commit();
    }

    public void setAppReferrer(Bundle bundle) {
        if (!ChartbeatServiceHandler.isSDKInitialized()) {
            return;
        }
        String appReferrer = bundle.getString("KEY_APP_REFERRER");
        singleton.setExternalReferrer(appReferrer);
    }

    public void stopTracker() {
        if (!ChartbeatServiceHandler.isSDKInitialized()) {
            return;
        }
        singleton.stopTracker();
        this.clearCachedSDKDetail();
        singleton = null;
    }

    public void pauseTracker() {
        if (!ChartbeatServiceHandler.isSDKInitialized()) {
            return;
        }
        singleton.stopTracker();
    }

    public void backgroundTracker() {
        if (!ChartbeatServiceHandler.isSDKInitialized()) {
            return;
        }
        singleton.backgroundTracker();
    }

    private void clearCachedSDKDetail() {
        SharedPreferences prefs = ((Context)this.context.get()).getSharedPreferences("com.chartbeat.androidsdk.user", 0);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putString(KEY_LAST_USED_ACCOUNT_ID, null);
        editor.putString(KEY_LAST_USED_DOMAIN, null);
        editor.commit();
    }

    public void trackView(Bundle bundle) {
        if (!ChartbeatServiceHandler.isSDKInitialized()) {
            return;
        }
        String viewId = bundle.getString("KEY_VIEW_ID");
        String viewTitle = bundle.getString("KEY_VIEW_TITLE");
        int scrollPositionTop = bundle.getInt("KEY_POSITION_TOP", -1);
        int scrollWindowHeight = bundle.getInt("KEY_WINDOW_HEIGHT", -1);
        int totalContentHeight = bundle.getInt("KEY_CONTENT_HEIGHT", -1);
        int fullyRenderedDocWidth = bundle.getInt("KEY_DOC_WIDTH", -1);
        singleton.trackViewImpl(viewId, viewTitle, scrollPositionTop, scrollWindowHeight, totalContentHeight, fullyRenderedDocWidth);
    }

    public static void userLeftView(Bundle bundle) {
        if (!ChartbeatServiceHandler.isSDKInitialized()) {
            return;
        }
        String viewId = bundle.getString("KEY_VIEW_ID");
        singleton.userLeftViewImpl(viewId);
    }

    public static void userInteracted() {
        if (!ChartbeatServiceHandler.isSDKInitialized()) {
            return;
        }
        singleton.userInteractedImpl();
    }

    public static void userTyped() {
        if (!ChartbeatServiceHandler.isSDKInitialized()) {
            return;
        }
        singleton.userTypedImpl();
    }

    public static void setDomain(Bundle bundle) {
        if (!ChartbeatServiceHandler.isSDKInitialized()) {
            return;
        }
        if (singleton.isNotTrackingAnyView()) {
            Logger.e(TAG, "View tracking hasn't started, please call Tracker.trackView() first");
            return;
        }
        String domain = bundle.getString("KEY_DOMAIN");
        singleton.updateDomain(domain);
    }

    public static void setSubdomain(Bundle bundle) {
        if (!ChartbeatServiceHandler.isSDKInitialized()) {
            return;
        }
        if (singleton.isNotTrackingAnyView()) {
            Logger.e(TAG, "View tracking hasn't started, please call Tracker.trackView() first");
            return;
        }
        String subdomain = bundle.getString("KEY_SUBDOMAIN");
        singleton.updateSubdomain(subdomain);
    }

    public static void setZones(Bundle bundle) {
        if (!ChartbeatServiceHandler.isSDKInitialized()) {
            return;
        }
        if (singleton.isNotTrackingAnyView()) {
            Logger.e(TAG, "View tracking hasn't started, please call Tracker.trackView() first");
            return;
        }
        String zones = bundle.getString("KEY_ZONES");
        singleton.updateZones(zones);
    }

    public static void setSubscriptionState(Bundle bundle) {
        if (!ChartbeatServiceHandler.isSDKInitialized()) {
            return;
        }
        SubscriptionState subState = (SubscriptionState)((Object)bundle.get("KEY_SUBSCRIPTION_STATE"));
        singleton.updateSubscriptionState(subState);
    }

    public static void setAuthors(Bundle bundle) {
        if (!ChartbeatServiceHandler.isSDKInitialized()) {
            return;
        }
        if (singleton.isNotTrackingAnyView()) {
            Logger.e(TAG, "View tracking hasn't started, please call Tracker.trackView() first");
            return;
        }
        String authors = bundle.getString("KEY_AUTHORS");
        singleton.updateAuthors(authors);
    }

    public static void setSections(Bundle bundle) {
        if (!ChartbeatServiceHandler.isSDKInitialized()) {
            return;
        }
        if (singleton.isNotTrackingAnyView()) {
            Logger.e(TAG, "View tracking hasn't started, please call Tracker.trackView() first");
            return;
        }
        String sections = bundle.getString("KEY_SECTIONS");
        singleton.updateSections(sections);
    }

    public static void setViewLoadTime(Bundle bundle) {
        if (!ChartbeatServiceHandler.isSDKInitialized()) {
            return;
        }
        if (singleton.isNotTrackingAnyView()) {
            Logger.e(TAG, "View tracking hasn't started, please call Tracker.trackView() first");
            return;
        }
        float viewLoadTime = bundle.getFloat("KEY_VIEW_LOADING_TIME", 0.0f);
        singleton.updatePageLoadingTime(viewLoadTime);
    }

    public static void setPosition(Bundle bundle) {
        if (!ChartbeatServiceHandler.isSDKInitialized()) {
            Logger.e(TAG, "Chartbeat SDK has not been initialized");
            return;
        }
        int scrollPositionTop = bundle.getInt("KEY_POSITION_TOP", -1);
        int scrollWindowHeight = bundle.getInt("KEY_WINDOW_HEIGHT", -1);
        int totalContentHeight = bundle.getInt("KEY_CONTENT_HEIGHT", -1);
        int fullyRenderedDocWidth = bundle.getInt("KEY_DOC_WIDTH", -1);
        singleton.updateViewDimensions(scrollPositionTop, scrollWindowHeight, totalContentHeight, fullyRenderedDocWidth);
    }
}

