/*
 * Decompiled with CFR 0.152.
 */
package com.chartbeat.androidsdk;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Message;
import com.chartbeat.androidsdk.AwsLogger;
import com.chartbeat.androidsdk.ChartbeatServiceHandler;
import com.chartbeat.androidsdk.SystemUtils;
import java.lang.ref.WeakReference;

public class ChartbeatService
extends Service {
    private static final String TAG = ChartbeatService.class.getSimpleName();
    private static final String TRACKER_THREAD = "TRACKER_THREAD";
    private HandlerThread bgThread;
    private ChartbeatServiceHandler handler;

    public IBinder onBind(Intent intent) {
        return null;
    }

    public void onCreate() {
        this.init();
    }

    private void init() {
        try {
            if (this.bgThread == null || !this.bgThread.isAlive()) {
                this.bgThread = new HandlerThread(TRACKER_THREAD, 10);
                this.bgThread.start();
            }
            String userAgent = SystemUtils.getSystemUserAgent((Context)this);
            if (this.handler == null) {
                this.handler = new ChartbeatServiceHandler(new WeakReference<ChartbeatService>(this), this.bgThread.getLooper(), userAgent);
            }
        }
        catch (Exception e) {
            AwsLogger.getInstance().logError(e);
        }
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        try {
            if (intent != null) {
                Message msg = this.handler.obtainMessage();
                msg.arg1 = startId;
                msg.setData(intent.getExtras());
                this.handler.sendMessage(msg);
            }
        }
        catch (Exception e) {
            AwsLogger.getInstance().logError(e);
        }
        return 2;
    }

    public void onDestroy() {
        try {
            this.handler.removeCallbacksAndMessages(null);
            this.handler.pauseTracker();
            if (Build.VERSION.SDK_INT >= 18) {
                if (this.bgThread.getLooper() != null) {
                    this.bgThread.getLooper().quitSafely();
                }
                this.bgThread.quitSafely();
            } else {
                if (this.bgThread.getLooper() != null) {
                    this.bgThread.getLooper().quit();
                }
                this.bgThread.quit();
            }
            this.bgThread = null;
        }
        catch (Exception e) {
            AwsLogger.getInstance().logError(e);
        }
    }
}

